/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.parser.CollectionEncodingException;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.util.ArgumentChecker;

public class SgfFormatter {
    private static final Log log_s_ = LogFactory.getLog(SgfFormatter.class);
    private boolean writeRegularId_ = false;

    public ByteBuffer format(Collection collection) throws CollectionEncodingException {
        ArgumentChecker.throwIfNull((Object)collection);
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(collection.size());
        int n = 0;
        HashMap<Charset, CharsetEncoder> hashMap = new HashMap<Charset, CharsetEncoder>();
        for (int i = 0; i < collection.size(); ++i) {
            Charset charset;
            StringWriter stringWriter = new StringWriter();
            RootGameTree object = collection.get(i);
            if (0 == object.getSequence().size()) continue;
            SgfCharset sgfCharset = object.getSgfCharset();
            if (sgfCharset == null) {
                sgfCharset = new SgfCharset(object.getActualCharset());
            }
            if (!(charset = sgfCharset.getCharset()).canEncode()) {
                sgfCharset = new SgfCharset(Charset.defaultCharset());
            }
            object.setCharset(sgfCharset);
            this.format(object, stringWriter);
            stringWriter.flush();
            charset = sgfCharset.getCharset();
            CharsetEncoder charsetEncoder = (CharsetEncoder)hashMap.get(charset);
            if (charsetEncoder == null) {
                charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                hashMap.put(charset, charsetEncoder);
            }
            charsetEncoder.reset();
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(stringWriter.toString()));
                arrayList.add(byteBuffer);
                n += byteBuffer.limit();
                continue;
            }
            catch (Exception exception) {
                log_s_.debug("Encoding error:", exception);
                throw new CollectionEncodingException(collection, i, null, exception);
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (ByteBuffer byteBuffer2 : arrayList) {
            byteBuffer.put(byteBuffer2);
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public String formatAsString(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < collection.size(); ++i) {
            RootGameTree rootGameTree = collection.get(i);
            if (0 == rootGameTree.getSequence().size()) continue;
            this.format(rootGameTree, stringWriter);
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    private void format(GameTree gameTree, StringWriter stringWriter) {
        stringWriter.write(gameTree.getOpenUtr());
        stringWriter.write(40);
        Node[] nodeArray = gameTree.getSequence().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            this.format(nodeArray[i], stringWriter);
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        for (int i = 0; i < gameTreeArray.length; ++i) {
            this.format(gameTreeArray[i], stringWriter);
        }
        stringWriter.write(41);
        stringWriter.write(gameTree.getCloseUtr());
    }

    private void format(Node node, StringWriter stringWriter) {
        stringWriter.write(node.getOpenUtr());
        stringWriter.write(59);
        Property[] propertyArray = node.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.format(propertyArray[i], stringWriter);
        }
    }

    private void format(Property property, StringWriter stringWriter) {
        stringWriter.write(property.getOpenUtr());
        stringWriter.write(this.writeRegularId_ ? property.getId() : property.getEntireId());
        Value[] valueArray = property.getValues();
        if (property.sgfId().equals(SgfId.INPUT_FILES)) {
            for (int i = 0; i < valueArray.length; ++i) {
                stringWriter.write(valueArray[i].getOpenUtr());
                stringWriter.write(91);
                stringWriter.write(Sgfs.escapeIfForStore(valueArray[i].getString()));
                stringWriter.write(93);
            }
        } else {
            for (int i = 0; i < valueArray.length; ++i) {
                stringWriter.write(valueArray[i].getOpenUtr());
                stringWriter.write(91);
                stringWriter.write(Sgfs.escapeForStore(valueArray[i].getString()));
                stringWriter.write(93);
            }
        }
        stringWriter.write(property.getCloseUtr());
    }
}

