/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.parser.SgfParserCore;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.sgf.util.filter.PackRootPropertyFilter;
import org.unitarou.util.ArgumentChecker;

public class SgfParser {
    private static final Log log_s_ = LogFactory.getLog(SgfParser.class);
    private static final Message SP_DEFAULT_DECODE_CHARSET = new Message(SgfParser.class, "spDefaultDecodeCharset");
    public static final Charset DEFAULT_DECODE_CHARSET;
    private static final Message NT_INPUT_TERMINATED;
    private final SgfParserCore sgfParserBase_ = new SgfParserCore();
    private Charset defaultCharset_ = DEFAULT_DECODE_CHARSET;

    public void setDefaultCharset(Charset charset) {
        ArgumentChecker.throwIfNull((Object)charset);
        this.defaultCharset_ = charset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset_;
    }

    @Deprecated
    public Collection parse(Reader reader) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)reader);
        this.sgfParserBase_.setParserLogger(new SgfParserLogger());
        this.sgfParserBase_.setReader(reader);
        try {
            this.sgfParserBase_.setInputTerminated(false);
            Collection collection = new Collection();
            while (this.sgfParserBase_.parseCollection(collection)) {
            }
            if (this.sgfParserBase_.isInputTerminated()) {
                this.sgfParserBase_.writeWarningLog(NT_INPUT_TERMINATED, new Object());
            }
            collection.setParserLog(this.sgfParserBase_.getParserLogger());
            return collection;
        }
        catch (IOException iOException) {
            throw new SgfParserException(iOException);
        }
    }

    public Collection parse(String string) throws SgfParserException {
        return this.parse(string, this.defaultCharset_);
    }

    public Collection parse(String string, Charset charset) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)string, (Object)charset);
        this.sgfParserBase_.setParserLogger(new SgfParserLogger());
        ByteBuffer byteBuffer = charset.canEncode() ? charset.encode(string) : ByteBuffer.wrap(string.getBytes());
        return this.parseImpl(byteBuffer, charset);
    }

    public Collection parse(File file) throws SgfParserException {
        ArgumentChecker.throwIfNull((Object)file);
        this.sgfParserBase_.setParserLogger(new SgfParserLogger());
        return this.parseImpl(file);
    }

    private Collection parseImpl(File file) throws SgfParserException {
        Collection collection;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            if (Integer.MAX_VALUE < fileChannel.size()) {
                throw new SgfParserException("Can't open file because of large size.");
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(byteBuffer);
            Collection collection2 = this.parseImpl(byteBuffer, this.defaultCharset_);
            collection2.setFile(file);
            collection = collection2;
        }
        catch (IOException iOException) {
            try {
                throw new SgfParserException(iOException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileInputStream);
        return collection;
    }

    private Collection parseImpl(ByteBuffer byteBuffer, Charset charset) throws SgfParserException {
        this.sgfParserBase_.setByteBuffer(byteBuffer, charset);
        try {
            this.sgfParserBase_.setInputTerminated(false);
            Collection collection = new Collection();
            while (this.sgfParserBase_.parseCollection(collection)) {
            }
            if (this.sgfParserBase_.isInputTerminated()) {
                this.sgfParserBase_.writeWarningLog(NT_INPUT_TERMINATED, new Object());
            }
            PackRootPropertyFilter packRootPropertyFilter = new PackRootPropertyFilter();
            packRootPropertyFilter.setLogger(this.sgfParserBase_.getParserLogger());
            collection = packRootPropertyFilter.filter(collection);
            collection.setParserLog(this.sgfParserBase_.getParserLogger());
            return collection;
        }
        catch (IOException iOException) {
            throw new SgfParserException(iOException);
        }
    }

    static {
        NT_INPUT_TERMINATED = new Message(SgfParser.class, "ntInputTerminated");
        Charset charset = null;
        try {
            charset = Charset.forName(SP_DEFAULT_DECODE_CHARSET.get());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log_s_.warn("Unknown charset:" + SP_DEFAULT_DECODE_CHARSET.get());
            charset = Charset.defaultCharset();
        }
        DEFAULT_DECODE_CHARSET = charset;
    }
}

