/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SgfCharset
implements TypedString<SgfCharset> {
    private static final Log log_s_ = LogFactory.getLog(SgfCharset.class);
    private final Charset charset_;

    public static SgfCharset parse(String string) {
        return new SgfCharset(string);
    }

    public SgfCharset(Charset charset) {
        ArgumentChecker.throwIfNull((Object)charset);
        this.charset_ = charset;
    }

    private SgfCharset(String string) {
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            charset = Charset.defaultCharset();
            log_s_.warn(string + " is not a valid charset name. Use default chaset:" + charset, illegalArgumentException);
        }
        this.charset_ = charset;
    }

    public Charset getCharset() {
        return this.charset_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.CHARSET);
    }

    @Override
    public String getString() {
        return this.charset_.name();
    }

    @Override
    public int compareTo(SgfCharset sgfCharset) {
        return this.charset_.compareTo(sgfCharset.charset_);
    }
}

