/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import org.unitarou.ml.NamedEnumByMessages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class Style
extends NamedEnumByMessages
implements TypedString {
    public static final int BF_VARIATIONS = 1;
    public static final int BF_MARKUP = 2;
    public static final Style CHILDREN_SHOW_VAL = new Style(0);
    public static final Style SIBLINGS_SHOW_VAL = new Style(1);
    public static final Style CHILDREN_HIDE_VAL = new Style(2);
    public static final Style SIBLINGS_HIDE_VAL = new Style(3);
    public static final Style DEFAULT = CHILDREN_SHOW_VAL;
    private final int value_;

    public static Style parse(String string) {
        try {
            Integer n = Integer.decode(string);
            return (Style)Style.find(Style.class, n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Style(int n) {
        super(new Integer(n));
        this.value_ = n;
    }

    public boolean isChildrenStyle() {
        return (this.value_ & 1) == 0;
    }

    public boolean isBoardMarkup() {
        return (this.value_ & 2) == 0;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.STYLE);
    }

    public String getString() {
        return this.typeName().toString();
    }
}

