/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;

public class SgfPointSet {
    private final Set<SgfPoint> pointSet_ = new HashSet<SgfPoint>();

    public void add(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        this.pointSet_.add(sgfPoint);
    }

    public void add(SgfPoint[] sgfPointArray) {
        ArgumentChecker.throwIfNull(sgfPointArray);
        for (int i = 0; i < sgfPointArray.length; ++i) {
            this.pointSet_.add(sgfPointArray[i]);
        }
    }

    public void remove(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        this.pointSet_.remove(sgfPoint);
    }

    public void remove(SgfPoint[] sgfPointArray) {
        ArgumentChecker.throwIfNull(sgfPointArray);
        for (int i = 0; i < sgfPointArray.length; ++i) {
            this.pointSet_.remove(sgfPointArray[i]);
        }
    }

    public boolean contains(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.pointSet_.contains(sgfPoint);
    }

    public boolean isEmpty() {
        return this.pointSet_.isEmpty();
    }

    public void clear() {
        this.pointSet_.clear();
    }

    public SgfRectangle calcInclusiveRectangle() {
        SgfRectangle sgfRectangle = new SgfRectangle();
        Iterator<SgfPoint> iterator = this.pointSet_.iterator();
        while (iterator.hasNext()) {
            sgfRectangle.intersect(iterator.next());
        }
        return sgfRectangle;
    }

    public SgfRectangle[] getRegularRectangles() {
        ArrayList<SgfRectangle> arrayList = new ArrayList<SgfRectangle>();
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>(this.pointSet_);
        while (!treeSet.isEmpty()) {
            SgfPoint sgfPoint = (SgfPoint)treeSet.iterator().next();
            if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
                treeSet.remove(sgfPoint);
                continue;
            }
            SgfRectangle sgfRectangle = this.findBestRectangle(treeSet, sgfPoint);
            arrayList.add(sgfRectangle);
            for (int i = sgfRectangle.getStart().x(); i <= sgfRectangle.getEnd().x(); ++i) {
                for (int j = sgfRectangle.getStart().y(); j <= sgfRectangle.getEnd().y(); ++j) {
                    treeSet.remove(SgfPoint.create(sgfPoint.size(), i, j));
                }
            }
        }
        return arrayList.toArray(new SgfRectangle[arrayList.size()]);
    }

    private SgfRectangle findBestRectangle(Set set, SgfPoint sgfPoint) {
        Object object;
        int n;
        int n2;
        int n3;
        SgfPoint sgfPoint2;
        SgfPoint sgfPoint3;
        int n4 = sgfPoint.x();
        int n5 = sgfPoint.x() + 1;
        while (n5 <= sgfPoint.size().width() && set.contains(sgfPoint3 = SgfPoint.create(sgfPoint.size(), n5, sgfPoint.y()))) {
            n4 = n5++;
        }
        n5 = sgfPoint.y();
        int n6 = sgfPoint.y() + 1;
        while (n6 <= sgfPoint.size().height() && set.contains(sgfPoint2 = SgfPoint.create(sgfPoint.size(), sgfPoint.x(), n6))) {
            n5 = n6++;
        }
        int[] nArray = new int[n5 - sgfPoint.y() + 1];
        nArray[0] = n4 - sgfPoint.x() + 1;
        for (n3 = sgfPoint.y() + 1; n3 <= n5; ++n3) {
            n2 = sgfPoint.x();
            n = sgfPoint.x() + 1;
            while (n <= n4) {
                object = SgfPoint.create(sgfPoint.size(), n, n3);
                if (!set.contains(object)) {
                    n4 = n2;
                    break;
                }
                n2 = n++;
            }
            nArray[n3 - sgfPoint.y()] = (n3 - sgfPoint.y() + 1) * (n4 - sgfPoint.x() + 1);
        }
        n3 = 0;
        n2 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (n2 >= nArray[n]) continue;
            n2 = nArray[n];
            n3 = n;
        }
        n = n2 / ++n3;
        object = new SgfRectangle();
        ((SgfRectangle)object).set(sgfPoint, SgfPoint.create(sgfPoint.size(), sgfPoint.x() + n - 1, sgfPoint.y() + n3 - 1));
        return object;
    }
}

