/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.filter.ReflectionFilter;
import org.unitarou.sgf.util.filter.Rotate180Filter;
import org.unitarou.sgf.util.filter.Rotate270Filter;
import org.unitarou.sgf.util.filter.Rotate90Filter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;
import org.unitarou.util.NullFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFilter {
    private static final List<Filter<SgfPoint>> coordinateFilters_s_;

    public static void mirrorRotate(RootGameTree rootGameTree, int n) throws FilterException {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (n < 0 || coordinateFilters_s_.size() <= n) {
            throw new IllegalArgumentException("Bad type: " + n);
        }
        Filter<SgfPoint> filter = coordinateFilters_s_.get(n);
        BasicFilter.mirrorRotateImpl(rootGameTree, rootGameTree.getSize(), filter);
    }

    private static void mirrorRotateImpl(GameTree gameTree, SgfSize sgfSize, Filter<SgfPoint> filter) throws FilterException {
        for (Node node : gameTree.getSequence()) {
            for (Property property : node.getProperties()) {
                node.removeProperty(property.getId());
                node.addProperty(BasicFilter.mirrorRotateImpl(property, sgfSize, filter));
            }
        }
        for (int i = 0; i < gameTree.getChildrenSize(); ++i) {
            BasicFilter.mirrorRotateImpl(gameTree.getChild(i), sgfSize, filter);
        }
    }

    private static Property mirrorRotateImpl(Property property, SgfSize sgfSize, Filter<SgfPoint> filter) throws FilterException {
        ValueType valueType = property.sgfId().valueType();
        if (valueType.equals((Object)ValueType.MOVE) || valueType.equals((Object)ValueType.POINT) || valueType.equals((Object)ValueType.CPOINT)) {
            String[] stringArray = property.getStrings();
            SgfPoint[] sgfPointArray = SgfPoint.parse(sgfSize, stringArray);
            Property property2 = new Property();
            property2.setId(property.getId());
            for (int i = 0; i < sgfPointArray.length; ++i) {
                sgfPointArray[i] = filter.filter(sgfPointArray[i]);
            }
            SgfRectangle[] sgfRectangleArray = SgfRectangle.createRegularRectangles(sgfPointArray);
            if (sgfRectangleArray.length == 0) {
                for (SgfPoint sgfPoint : sgfPointArray) {
                    property2.addValue(new Value(sgfPoint.getString()));
                }
            } else {
                for (SgfRectangle sgfRectangle : sgfRectangleArray) {
                    property2.addValue(new Value(sgfRectangle.getValue()));
                }
            }
            return property2;
        }
        if (property.sgfId().equals(SgfId.LABEL)) {
            Property property3 = new Property();
            property3.setId(property.getId());
            String[] stringArray = property.getStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                Label label = Label.parseQuietly(sgfSize, stringArray[i]);
                if (label == null) continue;
                label = new Label(filter.filter(label.getPoint()), label.getLabel());
                property3.addValue(new Value(label.getString()));
            }
            return property3;
        }
        return property;
    }

    protected BasicFilter() {
    }

    static {
        ArrayList<NestedFilter> arrayList = new ArrayList<NestedFilter>(8);
        arrayList.add(new NullFilter());
        arrayList.add(new Rotate90Filter());
        arrayList.add(new Rotate180Filter());
        arrayList.add(new Rotate270Filter());
        arrayList.add(new ReflectionFilter());
        arrayList.add(new Rotate90Filter(new ReflectionFilter()));
        arrayList.add(new Rotate180Filter(new ReflectionFilter()));
        arrayList.add(new Rotate270Filter(new ReflectionFilter()));
        coordinateFilters_s_ = Collections.unmodifiableList(arrayList);
    }
}

