/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;

public class InternetStyleProvider
implements CoordinatesLabelProvider {
    private static final Message LB_DISPLAY_NAME = new Message(InternetStyleProvider.class, "lbDisplayName");
    private static final String[] xLabels_s_ = new String[52];

    public String getXLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return xLabels_s_[sgfPoint.x() - 1];
    }

    public String getYLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return String.valueOf(sgfPoint.size().height() - sgfPoint.y() + 1);
    }

    public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (sgfPoint.condition().equals((Object)SgfPointType.PASS)) {
            return CoordinatesLabelProvider.LB_PASS.get();
        }
        return this.getXLabel(sgfPoint) + this.getYLabel(sgfPoint);
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    static {
        int n = 0;
        int n2 = 0;
        while (n2 < 26) {
            if (n2 == 8) {
                n2 = (char)(n2 + 1);
            }
            InternetStyleProvider.xLabels_s_[n] = String.valueOf((char)(65 + n2));
            n2 = (char)(n2 + 1);
            ++n;
        }
        n2 = 26;
        while (n2 < 52) {
            if (n2 == 34) {
                n2 = (char)(n2 + 1);
            }
            InternetStyleProvider.xLabels_s_[n] = String.valueOf((char)(97 + n2 - 26));
            n2 = (char)(n2 + 1);
            ++n;
        }
        InternetStyleProvider.xLabels_s_[50] = String.valueOf('\u03b1');
        InternetStyleProvider.xLabels_s_[51] = String.valueOf('\u03b2');
    }
}

