/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.unitarou.util.ArgumentChecker;

public class ScrollableMouseWheelHandler {
    private static final Log log_s_ = LogFactory.getLog(ScrollableMouseWheelHandler.class);
    private final EventListener eventListener_ = new EventListener();
    private Scrollable scrollable_ = null;
    private final Set<Control> listenedSet_ = new HashSet<Control>();
    private int step_ = 10;

    public void setScrollable(Scrollable scrollable) {
        ArgumentChecker.throwIfNull((Object)scrollable);
        this.removeListeners();
        this.scrollable_ = scrollable;
        ScrollBar scrollBar = this.scrollable_.getVerticalBar();
        scrollBar.setIncrement(10);
        scrollBar.setPageIncrement(50);
        scrollBar.setThumb(100);
    }

    public void addListeners() {
        this.removeListeners();
        if (this.scrollable_ != null) {
            this.addListenersImpl(this.scrollable_);
        }
    }

    private void addListenersImpl(Control control) {
        control.addListener(37, this.eventListener_);
        control.addMouseTrackListener(this.eventListener_);
        this.listenedSet_.add(control);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            for (Control control2 : composite.getChildren()) {
                this.addListenersImpl(control2);
            }
        }
    }

    public void removeListeners() {
        for (Control control : this.listenedSet_) {
            if (control.isDisposed()) continue;
            control.removeListener(37, this.eventListener_);
            control.removeMouseTrackListener(this.eventListener_);
        }
        this.listenedSet_.clear();
    }

    public int getStep() {
        return this.step_;
    }

    public void setStep(int n) {
        this.step_ = n;
    }

    private class EventListener
    extends MouseTrackAdapter
    implements Listener {
        private EventListener() {
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            if (!(mouseEvent.widget instanceof Control)) {
                return;
            }
            Control control = (Control)mouseEvent.widget;
            Display display = Display.getCurrent();
            if (control.getShell() == display.getActiveShell()) {
                control.setFocus();
            }
        }

        public void handleEvent(Event event) {
            if (ScrollableMouseWheelHandler.this.scrollable_ == null || ScrollableMouseWheelHandler.this.scrollable_.isDisposed()) {
                return;
            }
            ScrollBar scrollBar = ScrollableMouseWheelHandler.this.scrollable_.getVerticalBar();
            if (scrollBar == null) {
                log_s_.warn("ScrollBar is not found in " + ScrollableMouseWheelHandler.this.scrollable_);
                return;
            }
            int n = scrollBar.getSelection();
            if (0 < event.count) {
                if ((n -= event.count * ScrollableMouseWheelHandler.this.step_) < scrollBar.getMinimum()) {
                    n = scrollBar.getMinimum();
                }
            } else if (event.count < 0 && scrollBar.getMaximum() < (n -= event.count * ScrollableMouseWheelHandler.this.step_)) {
                n = scrollBar.getMaximum();
            }
            if (scrollBar.getSelection() != n) {
                ScrollableMouseWheelHandler.this.scrollable_.forceFocus();
                scrollBar.setSelection(n);
            }
        }
    }
}

