/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.text.StringCharacterIterator;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

public class Swts {
    private static final String ELLIPSIS = "...";
    private static int DRAW_FLAGS = 15;

    public static void disposeQuietly(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public static void disposeQuietly(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public static Point topLeft(Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        return Geometry.getLocation(rectangle);
    }

    public static Point bottomRight(Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)rectangle);
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static String toWidgetText(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isISOControl(c) || Character.isWhitespace(c)) {
                if (c == '\r') {
                    if (stringCharacterIterator.next() != '\n') {
                        stringCharacterIterator.previous();
                    }
                    stringBuilder.append(Strings.LINE_SEPARATOR);
                } else if (c == '\n') {
                    stringBuilder.append(Strings.LINE_SEPARATOR);
                } else {
                    stringBuilder.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static Point add(Point point, Point point2, int n) {
        Point point3 = new Point(0, 0);
        point3.x = (n & 0x100) != 0 ? point.x + point2.x : Math.max(point.x, point2.x);
        point3.y = (n & 0x200) != 0 ? point.y + point2.y : Math.max(point.y, point2.y);
        return point3;
    }

    public static String shortenText(GC gC, String string, int n) {
        int n2;
        ArgumentChecker.throwIfNull((Object)gC, (Object)string);
        int n3 = gC.textExtent((String)ELLIPSIS, (int)Swts.DRAW_FLAGS).x;
        int n4 = string.length();
        int n5 = n2 = n4 / 2;
        for (int i = n2 + 1; n5 >= 0 && i < n4; --n5, ++i) {
            String string2 = string.substring(0, n5);
            String string3 = string.substring(i, n4);
            int n6 = gC.textExtent((String)string2, (int)Swts.DRAW_FLAGS).x;
            int n7 = gC.textExtent((String)string3, (int)Swts.DRAW_FLAGS).x;
            if (n6 + n3 + n7 >= n) continue;
            string = string2 + ELLIPSIS + string3;
            break;
        }
        return string;
    }

    protected Swts() {
    }
}

