/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.util.Collection;
import org.unitarou.lang.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentChecker {
    public static void throwIfNull(Object object) {
        if (object == null) {
            throw new NullArgumentException(object);
        }
    }

    public static void throwIfNull(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullArgumentException(object, object2);
        }
    }

    public static void throwIfNull(Object object, Object object2, Object object3) {
        if (object == null || object2 == null || object3 == null) {
            throw new NullArgumentException(object, object2, object3);
        }
    }

    public static void throwIfNull(Object object, Object object2, Object object3, Object object4) {
        if (object == null || object2 == null || object3 == null || object4 == null) {
            throw new NullArgumentException(object, object2, object3, object4);
        }
    }

    public static void throwIfNull(Object ... objectArray) {
        if (objectArray == null) {
            throw new NullArgumentException("Argument array must not be null.");
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new NullArgumentException(objectArray);
        }
    }

    public static void throwIfZeroOrLess(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must not be One or more. Parameter is " + n);
        }
    }

    public static void throwIfNegative(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must not be minus value. Parameter is " + n);
        }
    }

    public static void throwsIfOutOfBounds(int n, Collection<?> collection) {
        ArgumentChecker.throwIfNull((Object)new Integer(n), collection);
        if (n < 0 || collection.size() <= n) {
            throw new IllegalArgumentException();
        }
    }

    protected ArgumentChecker() {
    }
}

