/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.parser.CollectionEncodingException;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sql.CheckerMessage;
import org.unitarou.sql.CheckerResult;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.context.BooleanContextValue;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.hsql.HsqlDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileManager
implements Closeable {
    public static final BooleanContextValue ENABLE_DB = new BooleanContextValue(FileManager.class, "enableDb", true);
    private static final Log log_s_ = LogFactory.getLog(FileManager.class);
    private static final Message MSG_FILE_IO_ERROR = new Message(FileManager.class, "msgFileIoError");
    private static final Message MSG_ERROR_ON_WRITE = new Message(FileManager.class, "msgErrorOnWrite");
    private static final Message NT_FILE_READ_FAILURE = new Message(FileManager.class, "ntFileReadFailure");
    private static final Message MSG_GAME_NOT_FOUND = new Message(FileManager.class, "msgGameNotFound");
    private static final Message NT_CANT_OVERWRITE = new Message(FileManager.class, "ntCantOverwrite");
    private static final Message MSG_READ_ONLY_FILE = new Message(FileManager.class, "msgReadOnlyFile");
    private static final Message MSG_ALREADY_UPDATED = new Message(FileManager.class, "msgAlreadyUpdated");
    private static final Message NT_ENCODE_FAILURE = new Message(FileManager.class, "ntEncodeFailure");
    private static final Message MSG_CONFIRM_CHANGE_CHARSET = new Message(FileManager.class, "msgConfirmChangeCharset");
    private static final File trashCan_s_ = new File("./trushCan.sgf");
    private static final String CONNECTION_URL = "jdbc:hsqldb:file:./db/yukinoshita";
    private static final FileManager instance_s_ = new FileManager();
    private final Map<File, Collection> fileMap_ = new HashMap<File, Collection>();
    private Database database_ = Database.NULL_OBJECT;
    private Listener listener_ = new Listener();

    public static FileManager instance() {
        return instance_s_;
    }

    private FileManager() {
        Yukinoshita.context().addListener(this.listener_);
    }

    public void startup() {
        this.database_ = Yukinoshita.context(null).getBoolean(ENABLE_DB) ? this.startupDatabase() : Database.NULL_OBJECT;
    }

    private Database startupDatabase() {
        Application application = Yukinoshita.application();
        HsqlDatabase hsqlDatabase = new HsqlDatabase();
        hsqlDatabase.setup(CONNECTION_URL);
        Exception exception = hsqlDatabase.getExceptionAtSetup();
        if (exception != null) {
            return this.handleDbException(exception);
        }
        StringBuilder stringBuilder = new StringBuilder();
        CheckerMessage[] checkerMessageArray = hsqlDatabase.selfCheck();
        boolean bl = false;
        for (CheckerMessage checkerMessage : checkerMessageArray) {
            if (CheckerResult.OK == checkerMessage.getResult()) continue;
            bl = true;
            stringBuilder.append(checkerMessage.getMessage()).append('\n');
        }
        if (!bl) {
            return hsqlDatabase;
        }
        boolean bl2 = application.openMessageDialog(Application.MessageLevel.CONFIRM, Database.NT_CANT_START_DB.get(), Database.MSG_RECREATE_DB.get((Object)stringBuilder));
        try {
            if (bl2) {
                hsqlDatabase.create();
            } else {
                hsqlDatabase.close();
                application.openMessageDialog(Application.MessageLevel.INFORMATION, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED.get());
            }
            return hsqlDatabase;
        }
        catch (DatabaseException databaseException) {
            return this.handleDbException(databaseException);
        }
    }

    private Database handleDbException(Exception exception) {
        log_s_.warn("Can't initialize DB", exception);
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED_BY_INIT_ERROR.get((Object)exception.getLocalizedMessage()));
        return Database.NULL_OBJECT;
    }

    @Override
    public void close() {
        Ios.closeQuietly(this.database_);
    }

    public Collection open(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        Collection collection = this.openImpl(file);
        if (collection.size() != 0) {
            try {
                this.database_.refreshFileIndex(collection);
            }
            catch (DatabaseException databaseException) {
                log_s_.warn("Cannot refresh DB", databaseException);
            }
            return collection;
        }
        String string = MSG_GAME_NOT_FOUND.get((Object)file);
        log_s_.info(string);
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_FILE_READ_FAILURE.get(), string);
        return null;
    }

    private Collection openImpl(File file) {
        String string;
        ProblemProperties problemProperties;
        Collection collection = this.fileMap_.get(file);
        if (collection != null) {
            return collection;
        }
        collection = CollectionRepository.instance().load(file);
        if (collection.size() == 0) {
            return collection;
        }
        RootGameTree rootGameTree = collection.get(0);
        if (GameType.DRILL.equals(rootGameTree.getGameType()) && (problemProperties = ProblemProperties.parsePpQuietly(string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES))) != null) {
            Yukinoshita.context(collection).setInteger(Context.PROBLEM_PROPERTIES.id(), problemProperties.getIntValue());
        }
        return collection;
    }

    public void close(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() != null) {
            this.fileMap_.remove(collection.getFile());
        }
    }

    public EnumSet<SaveResult> save(Collection collection) throws YukinoshitaException {
        return this.saveAs(collection, collection.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumSet<SaveResult> saveAs(Collection collection, File file) throws YukinoshitaException {
        ArgumentChecker.throwIfNull((Object)collection, (Object)file);
        try {
            if (!GameType.DRILL.equals(collection.get(0).getGameType())) {
                EnumSet<SaveResult> enumSet = this.saveImpl(collection, file);
                return enumSet;
            }
            Collection collection2 = new Collection(collection);
            while (1 < collection2.size()) {
                collection2.remove(1);
            }
            EnumSet<SaveResult> enumSet = this.saveImpl(collection2, file);
            return enumSet;
        }
        finally {
            collection.setFile(file);
            try {
                this.database_.refreshFileIndex(collection);
            }
            catch (DatabaseException databaseException) {
                log_s_.warn("Cannot refresh DB", databaseException);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EnumSet<SaveResult> saveImpl(Collection collection, File file) throws YukinoshitaException {
        EnumSet<SaveResult> enumSet;
        EnumSet<SaveResult> enumSet2 = EnumSet.noneOf(SaveResult.class);
        SgfFormatter sgfFormatter = new SgfFormatter();
        FileOutputStream fileOutputStream = null;
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = sgfFormatter.format(collection);
        }
        catch (CollectionEncodingException collectionEncodingException) {
            boolean bl = Yukinoshita.application().openMessageDialog(Application.MessageLevel.CONFIRM, NT_ENCODE_FAILURE.get(), MSG_CONFIRM_CHANGE_CHARSET.get(new Integer(collectionEncodingException.getRgtIndex() + 1), collectionEncodingException.getNewCharset().displayName()));
            if (!bl) {
                return enumSet2;
            }
            try {
                collection.get(collectionEncodingException.getRgtIndex()).setCharset(new SgfCharset(collectionEncodingException.getNewCharset()));
                byteBuffer = sgfFormatter.format(collection);
                enumSet2.add(SaveResult.CHANGE_CHARSET);
            }
            catch (CollectionEncodingException collectionEncodingException2) {
                throw new YukinoshitaException(MSG_ERROR_ON_WRITE.get((Object)collectionEncodingException2.getLocalizedMessage()), collectionEncodingException2);
            }
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().write(byteBuffer);
            fileOutputStream.flush();
            enumSet2.add(SaveResult.SAVE_OK);
            enumSet = enumSet2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new YukinoshitaException(MSG_ERROR_ON_WRITE.get((Object)fileNotFoundException.getLocalizedMessage()), fileNotFoundException);
                catch (IOException iOException) {
                    throw new YukinoshitaException(MSG_FILE_IO_ERROR.get((Object)iOException.getLocalizedMessage()), iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileOutputStream);
        return enumSet;
    }

    public void refreshIndex(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        Collection collection = this.openImpl(file);
        if (collection.size() != 0) {
            try {
                this.database_.refreshFileIndex(collection);
            }
            catch (DatabaseException databaseException) {
                log_s_.warn("Cannot refresh DB", databaseException);
            }
        }
        this.close(collection);
    }

    public void registerProblemResult(RootGameTree rootGameTree, ProblemStatus problemStatus, int n) {
        if (!Yukinoshita.context(null).getBoolean(Context.SAVE_PROBLEM_RESULT)) {
            return;
        }
        ProblemProperties problemProperties = new ProblemProperties(Yukinoshita.context(rootGameTree).getInteger(Context.PROBLEM_PROPERTIES));
        try {
            this.database_.insertScore(rootGameTree, problemStatus, problemProperties, n);
        }
        catch (DatabaseException databaseException) {
            log_s_.warn("Failure to save score", databaseException);
        }
    }

    public Score[] selectScore(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        try {
            return this.database_.selectScores(rootGameTree);
        }
        catch (DatabaseException databaseException) {
            log_s_.warn("Failure to select score", databaseException);
            return new Score[0];
        }
    }

    public FileSearched[] search(String string, EnumSet<GameType> enumSet) {
        try {
            return this.database_.selectFile(enumSet, string);
        }
        catch (DatabaseException databaseException) {
            log_s_.warn("Failure to select ", databaseException);
            return new FileSearched[0];
        }
    }

    public boolean deleteFileIndex(int n) {
        try {
            return this.database_.deleteFileIndex(n);
        }
        catch (DatabaseException databaseException) {
            log_s_.warn("Failure to delete ", databaseException);
            return false;
        }
    }

    public int deleteNotFoundFileIndex() {
        try {
            return this.database_.deleteNotFoundFileIndex();
        }
        catch (DatabaseException databaseException) {
            log_s_.warn("Failure to delete ", databaseException);
            return 0;
        }
    }

    public DatabaseStatistics getDatabaseStatistics() {
        try {
            return this.database_.selectStatistics();
        }
        catch (DatabaseException databaseException) {
            log_s_.warn("Failure to select ", databaseException);
            return new DatabaseStatistics();
        }
    }

    public boolean checkOverwritable(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        File file = collection.getFile();
        if (file == null) {
            return false;
        }
        FileSnapshot fileSnapshot = new FileSnapshot(file);
        FileSnapshot fileSnapshot2 = collection.getFileSnapshot();
        if (fileSnapshot.equals(fileSnapshot2) && file.canWrite()) {
            return true;
        }
        String string = !file.canWrite() ? MSG_READ_ONLY_FILE.get((Object)file.getAbsolutePath()) : MSG_ALREADY_UPDATED.get(file.getAbsolutePath(), new Date(fileSnapshot2.lastModified()), new Long(fileSnapshot2.length()), new Date(fileSnapshot.lastModified()), new Long(fileSnapshot.length()));
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CANT_OVERWRITE.get(), string);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            collection.addLast(rootGameTree);
            this.save(collection);
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootGameTree pickUp(int n) {
        RootGameTree rootGameTree = null;
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            if (n < 0 || collection.size() <= n) {
                throw new IllegalArgumentException("Bad index (out of range):" + n);
            }
            rootGameTree = collection.remove(n);
            this.save(collection);
            RootGameTree rootGameTree2 = rootGameTree;
            return rootGameTree2;
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
            RootGameTree rootGameTree3 = rootGameTree;
            return rootGameTree3;
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTrashCan() {
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            Collection collection2 = new Collection(collection);
            return collection2;
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    public void clearTrashCan() {
        trashCan_s_.delete();
    }

    private Collection openTrashCan() {
        if (!trashCan_s_.exists()) {
            Collection collection = new Collection();
            collection.setFile(trashCan_s_);
            return collection;
        }
        return this.openImpl(trashCan_s_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements ContextListener {
        private Listener() {
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            if (set.contains(ENABLE_DB.id())) {
                Ios.closeQuietly(FileManager.this.database_);
                FileManager.this.startup();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveResult {
        SAVE_OK,
        CHANGE_CHARSET;

    }
}

