/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.CharsetArrayCodec;
import org.unitarou.jface.pref.CodecServer;
import org.unitarou.jface.pref.FileArrayCodec;
import org.unitarou.jface.pref.IntArrayCodec;
import org.unitarou.lang.Strings;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.util.StrategyRegistrar;
import org.unitarou.util.WeakedList;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.AttributeMap;
import org.unitarou.yukinoshita.context.BooleanContextValue;
import org.unitarou.yukinoshita.context.CharsetArrayContextValue;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.EnumContextValue;
import org.unitarou.yukinoshita.context.FileArrayContextValue;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.context.IntArrayContextValue;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.view.jface.JFaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContext
implements Context {
    private static final Log log_s_ = LogFactory.getLog(DefaultContext.class);
    private static final Message MSG_IO_ERROR_IN_RESTORE = new Message(JFaceContext.class, "msgIoErrorInRestore");
    private static final Message MSG_IO_ERROR_IN_SAVE = new Message(JFaceContext.class, "msgIoErrorInSave");
    private final Object rootScope_ = new Object();
    private final StrategyRegistrar strategyRegistrar_ = new StrategyRegistrar();
    private final WeakHashMap<Object, CurrentContext> contextMap_ = new WeakHashMap();
    private final WeakHashMap<Object, Object> scopeMap_ = new WeakHashMap();
    private final WeakHashMap<Object, AttributeMap> attributeMap_ = new WeakHashMap();
    private final AttributeMap defaultMap_;
    private final WeakedList<ContextListener> listeners_;
    private final Properties properties_;
    private final File file_;

    public DefaultContext() {
        this.attributeMap_.put(this.rootScope_, new AttributeMap());
        this.defaultMap_ = new AttributeMap();
        this.listeners_ = new WeakedList();
        this.properties_ = new Properties();
        this.file_ = new File(Yukinoshita.USER_NAME + ".properties").getAbsoluteFile();
    }

    public boolean registerInterface(Class clazz) {
        ArgumentChecker.throwIfNull((Object)clazz);
        return this.strategyRegistrar_.registerStrategy(clazz);
    }

    @Override
    public Class<?>[] getInterfaces() {
        return this.strategyRegistrar_.getStrategies();
    }

    @Override
    public Class<?>[] registerProvider(Class<?> clazz) {
        Class<?>[] classArray;
        ArgumentChecker.throwIfNull(clazz);
        for (Class<?> clazz2 : classArray = this.strategyRegistrar_.registerConcreteStrategy(clazz)) {
            this.getProvider(clazz2, null);
        }
        return classArray;
    }

    @Override
    public CurrentContext getCurrent(Object object) {
        CurrentContext currentContext = this.contextMap_.get(object = this.toRootScopeIfNull(object));
        if (currentContext == null) {
            currentContext = new CurrentContextImpl(object);
            this.contextMap_.put(object, currentContext);
        }
        return currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        FileInputStream fileInputStream = null;
        try {
            FileUtils.touch(this.file_);
            fileInputStream = new FileInputStream(this.file_);
            this.properties_.load(fileInputStream);
            for (Map.Entry<Object, Object> entry : this.properties_.entrySet()) {
                String string = entry.getKey().toString();
                String string2 = entry.getValue().toString();
                this.loadContext(string, string2);
            }
        }
        catch (IOException iOException) {
            try {
                log_s_.warn(iOException.getMessage() + " File: " + this.file_.toString());
                Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, BasicMessages.NT_ERROR_FILE_INPUT.get(), MSG_IO_ERROR_IN_RESTORE.get((Object)iOException.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(fileInputStream);
        }
        IOUtils.closeQuietly(fileInputStream);
    }

    private void loadContext(String string, String string2) {
        if (string == null || string2 == null) {
            log_s_.warn("[IGNORE] Null key or value is fonund. key=" + string + ", value=" + string2);
            return;
        }
        Object object = CodecServer.instance().decode(string2);
        if (object == null) {
            log_s_.warn("[IGNORE] Can't parse value: key=" + string + ", value=" + string2);
        }
        this.setAttribute(string, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        for (Map.Entry entry : this.attributeMap_.get(this.rootScope_).entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            String string2 = CodecServer.instance().encode(v);
            if (string2 == null) {
                log_s_.warn("[IGNORE] Can't encode. key=" + string + ", object=" + v);
                continue;
            }
            this.properties_.setProperty(string, string2);
        }
        Object object = null;
        try {
            FileUtils.touch(this.file_);
            object = new FileOutputStream(this.file_);
            this.properties_.store((OutputStream)object, "");
        }
        catch (IOException iOException) {
            try {
                log_s_.warn("Cant save context. Reason: " + iOException.getMessage());
                Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, BasicMessages.NT_ERROR_FILE_OUTPUT.get(), MSG_IO_ERROR_IN_SAVE.get((Object)iOException.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(object);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)object);
        }
        IOUtils.closeQuietly((OutputStream)object);
    }

    private void setProvider(Class<?> clazz, Class<?> clazz2, Object object) {
        ArgumentChecker.throwIfNull(clazz, clazz2);
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Interface mismatch: " + clazz + " is no assignable from " + clazz2);
        }
        Class<?>[] classArray = this.strategyRegistrar_.getConcreteStrategies(clazz);
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].equals(clazz2)) continue;
            this.setProviderImpl(clazz, clazz2, object);
            return;
        }
        this.setProviderImpl(clazz, clazz2, object);
    }

    private void setProviderImpl(Class clazz, Class clazz2, Object object) {
        try {
            this.setAttribute(clazz.getName(), clazz2.newInstance(), object);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Instantiation failure:" + clazz2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Constructer access failure:" + clazz2);
        }
    }

    @Override
    public <T extends Provider> T[] getProviders(Class<T> clazz) {
        ArgumentChecker.throwIfNull(clazz);
        return (Provider[])this.strategyRegistrar_.getConcreteStrategyInstances(clazz);
    }

    private <T extends Provider> T getProvider(Class<T> clazz, Object object) {
        ArgumentChecker.throwIfNull(clazz);
        T t = this.getProviderFromAttribute(clazz, object);
        if (t != null) {
            return t;
        }
        return (T)((Provider)this.getProviderByCreateInstance(clazz, object));
    }

    private <T extends Provider> T getProviderFromAttribute(Class<T> clazz, Object object) {
        Object object2 = this.getAttribute(clazz.getName(), object);
        if (object2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(object2.getClass())) {
            throw new IllegalStateException("Bad attribute for " + clazz + ". " + object2 + " is not an instance of " + Provider.class);
        }
        return (T)((Provider)object2);
    }

    private <T> T getProviderByCreateInstance(Class<T> clazz, Object object) {
        Class<T>[] classArray = this.strategyRegistrar_.getConcreteStrategies(clazz);
        if (classArray.length == 0) {
            throw new IllegalStateException("There are any concrete providers for " + clazz);
        }
        try {
            T t = classArray[0].newInstance();
            this.setAttribute(clazz.getName(), t, object);
            return t;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Bad attribute for " + clazz + ". " + classArray[0] + " is not an instance of " + Provider.class);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Provider " + classArray[0] + " has no default constructer.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Default constructer for provider " + classArray[0] + " is not public scope.");
        }
    }

    private void setAttribute(String string, Object object, Object object2) {
        Object object3;
        ArgumentChecker.throwIfNull((Object)string, object);
        object2 = this.toRootScopeIfNull(object2);
        if (object2 instanceof Collection) {
            this.scopeMap_.put(object2, this.rootScope_);
        } else if (object2 instanceof RootGameTree && (object3 = this.findCollection((RootGameTree)object2)) != null) {
            this.scopeMap_.put(object3, object2);
        }
        object3 = this.attributeMap_.get(object2);
        if (object3 == null) {
            object3 = new AttributeMap();
            this.attributeMap_.put(object2, (AttributeMap)object3);
        }
        ((HashMap)object3).put(string, object);
    }

    private void setAttribute(ContextValue contextValue, Object object) {
        ArgumentChecker.throwIfNull((Object)contextValue);
        this.setAttribute(contextValue.id(), contextValue.defaultValue(), object);
        this.defaultMap_.put(contextValue.id(), contextValue.defaultValue());
    }

    private Object toRootScopeIfNull(Object object) {
        return object == null ? this.rootScope_ : object;
    }

    private Collection findCollection(RootGameTree rootGameTree) {
        for (Object object : this.scopeMap_.keySet()) {
            if (!(object instanceof Collection)) continue;
            Collection collection = (Collection)object;
            for (int i = 0; i < collection.size(); ++i) {
                if (rootGameTree != collection.get(i)) continue;
                return collection;
            }
        }
        return null;
    }

    @Override
    public String[] rootKeys() {
        Map map = this.attributeMap_.get(this.rootScope_);
        return map.keySet().toArray(new String[map.size()]);
    }

    private Object getAttribute(String string, Object object) {
        Object v;
        Map map;
        ArgumentChecker.throwIfNull((Object)string);
        object = this.toRootScopeIfNull(object);
        Map map2 = this.attributeMap_.get(this.rootScope_);
        do {
            if ((v = (map = this.findMap(object)).get(string)) != null) {
                return v;
            }
            object = this.scopeMap_.get(object);
            object = this.toRootScopeIfNull(object);
        } while (map != map2);
        return v;
    }

    protected Object getDefault(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        return this.defaultMap_.get(string);
    }

    private Map findMap(Object object) {
        Map map = this.attributeMap_.get(object);
        while (map == null) {
            object = this.scopeMap_.get(object);
            object = this.toRootScopeIfNull(object);
            map = this.attributeMap_.get(object);
        }
        return map;
    }

    protected String[] clearCurrent(Object object) {
        object = this.toRootScopeIfNull(object);
        this.contextMap_.remove(object);
        this.scopeMap_.remove(object);
        Map map = this.attributeMap_.remove(object);
        if (map == null) {
            return Strings.EMPTY_ARRAY;
        }
        return map.keySet().toArray(new String[map.size()]);
    }

    @Override
    public void addListener(ContextListener contextListener) {
        if (contextListener == null) {
            return;
        }
        this.listeners_.add(contextListener);
    }

    @Override
    public void removeListener(ContextListener contextListener) {
        this.listeners_.remove(contextListener);
    }

    @Override
    public void fireAttributeChanged(String[] stringArray) {
        ArgumentChecker.throwIfNull((Object)stringArray);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Set<String> set = Collections.unmodifiableSet(hashSet);
        ContextListener[] contextListenerArray = this.listeners_.toArray((ContextListener[])new ContextListener[0]);
        for (int i = 0; i < contextListenerArray.length; ++i) {
            contextListenerArray[i].attributeChanged(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CurrentContextImpl
    implements CurrentContext {
        private final WeakReference<Object> reference_;

        private CurrentContextImpl(Object object) {
            this.reference_ = new WeakReference<Object>(object);
        }

        @Override
        public String[] clearCurrent() {
            return DefaultContext.this.clearCurrent(this.reference_.get());
        }

        @Override
        public <T extends Provider> T getProvider(Class<T> clazz) {
            return (T)DefaultContext.this.getProvider(clazz, this.reference_.get());
        }

        @Override
        public <T extends Provider> void setProvider(Class<T> clazz, Provider provider) {
            DefaultContext.this.setAttribute(clazz.getName(), provider, this.reference_.get());
        }

        @Override
        public void setProvider(Class<?> clazz, Class<?> clazz2) {
            DefaultContext.this.setProvider(clazz, clazz2, this.reference_.get());
        }

        @Override
        public void setAttribute(String string, Object object) {
            ArgumentChecker.throwIfNull((Object)string);
            DefaultContext.this.setAttribute(string, object, this.reference_.get());
        }

        @Override
        public void setAttribute(ContextValue contextValue) {
            DefaultContext.this.setAttribute(contextValue, this.reference_.get());
        }

        @Override
        public Object getAttribute(String string) {
            return DefaultContext.this.getAttribute(string, this.reference_.get());
        }

        @Override
        public Object getAttribute(ContextValue contextValue) {
            Object object = DefaultContext.this.getAttribute(contextValue.id(), this.reference_.get());
            if (object == null) {
                return contextValue.defaultValue();
            }
            return object;
        }

        @Override
        public boolean getBoolean(BooleanContextValue booleanContextValue) {
            ArgumentChecker.throwIfNull((Object)booleanContextValue);
            Object object = DefaultContext.this.getAttribute(booleanContextValue.id(), this.reference_.get());
            if (object == null || !(object instanceof Boolean)) {
                return booleanContextValue.defaultBoolean();
            }
            return (Boolean)object;
        }

        @Override
        public void setBoolean(String string, boolean bl) {
            ArgumentChecker.throwIfNull((Object)string);
            DefaultContext.this.setAttribute(string, new Boolean(bl), this.reference_.get());
        }

        @Override
        public int getInteger(IntContextValue intContextValue) {
            ArgumentChecker.throwIfNull((Object)intContextValue);
            String string = intContextValue.id();
            int n = intContextValue.defaultInt();
            Object object = DefaultContext.this.getAttribute(string, this.reference_.get());
            if (object == null) {
                return n;
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                try {
                    return Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    log_s_.warn("Cant parse value: " + object);
                }
            }
            log_s_.warn(this.composeMsgMismatchValueType(string, object, int[].class));
            return n;
        }

        @Override
        public void setInteger(String string, int n) {
            DefaultContext.this.setAttribute(string, new Integer(n), this.reference_.get());
        }

        @Override
        public int[] getIntArray(IntArrayContextValue intArrayContextValue) {
            ArgumentChecker.throwIfNull((Object)intArrayContextValue);
            String string = intArrayContextValue.id();
            int[] nArray = intArrayContextValue.defaultIntArray();
            Object object = DefaultContext.this.getAttribute(string, this.reference_.get());
            if (object == null) {
                return nArray;
            }
            if (object instanceof int[]) {
                return (int[])object;
            }
            if (object instanceof String) {
                return IntArrayCodec.instance().decode((String)object);
            }
            log_s_.warn(this.composeMsgMismatchValueType(string, object, int[].class));
            return nArray;
        }

        @Override
        public void setIntArray(String string, int[] nArray) {
            ArgumentChecker.throwIfNull((Object)nArray);
            DefaultContext.this.setAttribute(string, nArray, this.reference_.get());
        }

        @Override
        public File getFile(FileContextValue fileContextValue) {
            ArgumentChecker.throwIfNull((Object)fileContextValue);
            Object object = DefaultContext.this.getAttribute(fileContextValue.id(), this.reference_.get());
            if (object == null) {
                return fileContextValue.defaultFile();
            }
            if (object instanceof String) {
                object = new File((String)object);
            }
            if (!(object instanceof File)) {
                log_s_.warn(this.composeMsgMismatchValueType(fileContextValue.id(), object, File.class));
                return fileContextValue.defaultFile();
            }
            return (File)object;
        }

        @Override
        public void setFile(String string, File file) {
            ArgumentChecker.throwIfNull((Object)file);
            DefaultContext.this.setAttribute(string, file, this.reference_.get());
        }

        @Override
        public File[] getFileArray(FileArrayContextValue fileArrayContextValue) {
            ArgumentChecker.throwIfNull((Object)fileArrayContextValue);
            Object object = DefaultContext.this.getAttribute(fileArrayContextValue.id(), this.reference_.get());
            if (object == null) {
                List<File> list = fileArrayContextValue.defaultFiles();
                return list.toArray(new File[list.size()]);
            }
            if (object instanceof String) {
                Object object2 = FileArrayCodec.instance().decode((String)object);
                return object2.toArray(new File[object2.size()]);
            }
            if (object instanceof File[]) {
                return (File[])object;
            }
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<File> arrayList = new ArrayList<File>(list.size());
                for (Object e : list) {
                    if (!(e instanceof File)) continue;
                    arrayList.add((File)e);
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            log_s_.warn(this.composeMsgMismatchValueType(fileArrayContextValue.id(), object, File.class));
            List<File> list = fileArrayContextValue.defaultFiles();
            return list.toArray(new File[list.size()]);
        }

        @Override
        public <E extends Enum> E getEnum(EnumContextValue<E> enumContextValue) {
            ArgumentChecker.throwIfNull(enumContextValue);
            Object object = DefaultContext.this.getAttribute(enumContextValue.id(), this.reference_.get());
            if (object == null) {
                return enumContextValue.defaultEnum();
            }
            E e = enumContextValue.defaultEnum();
            if (object instanceof String) {
                object = Enum.valueOf(((Enum)e).getDeclaringClass(), object.toString());
            }
            if (!(object instanceof Enum)) {
                log_s_.warn(this.composeMsgMismatchValueType(enumContextValue.id(), object, ((Enum)e).getDeclaringClass()));
                return enumContextValue.defaultEnum();
            }
            return (E)((Enum)object);
        }

        @Override
        public List<Charset> getCharsetArray(CharsetArrayContextValue charsetArrayContextValue) {
            ArgumentChecker.throwIfNull((Object)charsetArrayContextValue);
            Object object = DefaultContext.this.getAttribute(charsetArrayContextValue.id(), this.reference_.get());
            if (object == null) {
                return charsetArrayContextValue.defaultCharsets();
            }
            if (object instanceof String) {
                return CharsetArrayCodec.instance().decode((String)object);
            }
            if (object instanceof Charset[]) {
                return Arrays.asList((Charset[])object);
            }
            if (object instanceof List) {
                List list = (List)object;
                ArrayList<Charset> arrayList = new ArrayList<Charset>(list.size());
                for (Object e : list) {
                    if (!(e instanceof Charset)) continue;
                    arrayList.add((Charset)e);
                }
                return arrayList;
            }
            log_s_.warn(this.composeMsgMismatchValueType(charsetArrayContextValue.id(), object, Charset.class));
            return charsetArrayContextValue.defaultCharsets();
        }

        private String composeMsgMismatchValueType(String string, Object object, Class clazz) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Bad value type, use default value. key='").append(string);
            stringBuilder.append("', value='").append(object);
            stringBuilder.append("', class=" + clazz);
            return stringBuilder.toString();
        }
    }
}

