/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointSet;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrintingIgoBoard {
    private static final SgfColor[] BYTE_COLOR_MAP = new SgfColor[]{null, SgfColor.BLACK, SgfColor.WHITE};
    private SgfSize size_;
    private final SgfRectangle viewArea_ = new SgfRectangle();
    private byte[] stones_;
    private short[] moves_;
    private final List<PiledStone> piledStones_ = new ArrayList<PiledStone>();

    public PrintingIgoBoard() {
        this.resetField(new RootGameTree());
    }

    public PrintingIgoBoard(RootGameTree rootGameTree) {
        this.update(rootGameTree);
    }

    private void resetField(RootGameTree rootGameTree) {
        this.size_ = rootGameTree.getSize();
        this.stones_ = new byte[(int)Math.ceil((double)this.size_.width() * (double)this.size_.height() / 4.0)];
        this.moves_ = new short[this.size_.width() * this.size_.height()];
        this.piledStones_.clear();
        this.viewArea_.set(SgfPoint.create(this.size_, 1, 1), SgfPoint.create(this.size_, this.size_.width(), this.size_.height()));
    }

    public void update(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.resetField(rootGameTree);
        switch (rootGameTree.getGameType()) {
            case PROBLEM: {
                this.setupPositionJustBeforeMove(rootGameTree);
                break;
            }
            case GAME: {
                this.setupGameEndPosition(rootGameTree);
                break;
            }
        }
    }

    private void setupGameEndPosition(RootGameTree rootGameTree) {
        SgfSize sgfSize = rootGameTree.getSize();
        SgfId[] sgfIdArray = new SgfId[]{SgfId.ADD_BLACK, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.WHITE, SgfId.ADD_EMPTY};
        short s = 1;
        RootGameTree rootGameTree2 = rootGameTree;
        while (rootGameTree2 != null) {
            Sequence sequence = rootGameTree2.getSequence();
            for (Node node : sequence) {
                for (SgfId sgfId : new SgfId[]{SgfId.BLACK, SgfId.WHITE}) {
                    SgfPoint sgfPoint;
                    Property property = node.getProperty(sgfId);
                    if (property == null || (sgfPoint = SgfPoint.parseMoveQuietly(sgfSize, property.getString())) == null || sgfPoint.condition() != SgfPointType.IN) continue;
                    if (this.getByteColor(sgfPoint) == 0) {
                        this.setMove(sgfPoint, s);
                    } else {
                        PiledStone piledStone = new PiledStone();
                        piledStone.base_ = this.getStoneImpl(sgfPoint);
                        piledStone.piled_ = new Stone(SgfColor.getColor(sgfId), sgfPoint, new Integer(s));
                        this.piledStones_.add(piledStone);
                    }
                    s = (short)(s + 1);
                    break;
                }
                this.setColor(node, sgfIdArray, sgfSize);
                this.setView(node, sgfSize);
            }
            GameTree[] gameTreeArray = rootGameTree2.getChildren();
            rootGameTree2 = gameTreeArray.length == 0 ? null : gameTreeArray[0];
        }
    }

    private void setupPositionJustBeforeMove(RootGameTree rootGameTree) {
        SgfSize sgfSize = rootGameTree.getSize();
        SgfId[] sgfIdArray = new SgfId[]{SgfId.ADD_BLACK, SgfId.ADD_WHITE, SgfId.ADD_EMPTY};
        RootGameTree rootGameTree2 = rootGameTree;
        while (rootGameTree2 != null) {
            Sequence sequence = rootGameTree2.getSequence();
            for (Node node : sequence) {
                if (node.contains(PropertyType.MOVE)) {
                    return;
                }
                this.setColor(node, sgfIdArray, sgfSize);
                this.setView(node, sgfSize);
            }
            GameTree[] gameTreeArray = rootGameTree2.getChildren();
            rootGameTree2 = gameTreeArray.length == 0 ? null : gameTreeArray[0];
        }
    }

    private void setColor(Node node, SgfId[] sgfIdArray, SgfSize sgfSize) {
        for (SgfId sgfId : sgfIdArray) {
            Property property = node.getProperty(sgfId);
            if (property == null) continue;
            SgfColor sgfColor = SgfColor.getColor(sgfId);
            SgfPoint[] sgfPointArray = SgfPoint.parse(sgfSize, property.getStrings());
            if (sgfId.propertyType() == PropertyType.MOVE) {
                for (SgfPoint sgfPoint : sgfPointArray) {
                    if (this.getByteColor(sgfPoint) != 0) continue;
                    this.setStone(sgfPoint, sgfColor);
                }
                continue;
            }
            for (SgfPoint sgfPoint : sgfPointArray) {
                this.setStone(sgfPoint, sgfColor);
            }
        }
    }

    private byte getByteColor(SgfPoint sgfPoint) {
        int n = sgfPoint.index();
        return (byte)(this.stones_[n / 4] >> (3 - n % 4) * 2 & 3);
    }

    public SgfColor getColor(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return BYTE_COLOR_MAP[this.getByteColor(sgfPoint)];
    }

    public int getMove(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.moves_[sgfPoint.index()];
    }

    private void setStone(SgfPoint sgfPoint, SgfColor sgfColor) {
        int n = sgfPoint.index();
        int n2 = 0;
        if (sgfColor == null) {
            n2 = 0;
        } else {
            switch (sgfColor) {
                case BLACK: {
                    n2 = 1;
                    break;
                }
                case WHITE: {
                    n2 = 2;
                }
            }
        }
        n2 = (byte)(n2 << (3 - n % 4) * 2);
        int n3 = n / 4;
        this.stones_[n3] = (byte)(this.stones_[n3] | n2);
    }

    public Stone getStone(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.getStoneImpl(sgfPoint);
    }

    private Stone getStoneImpl(SgfPoint sgfPoint) {
        SgfColor sgfColor = BYTE_COLOR_MAP[this.getByteColor(sgfPoint)];
        if (sgfColor == null) {
            return null;
        }
        short s = this.moves_[sgfPoint.index()];
        Integer n = s != 0 ? new Integer(s) : null;
        return new Stone(sgfColor, sgfPoint, n);
    }

    private void setMove(SgfPoint sgfPoint, short s) {
        this.moves_[sgfPoint.index()] = s;
    }

    private void setView(Node node, SgfSize sgfSize) {
        SgfRectangle sgfRectangle;
        Property property = node.getProperty(SgfId.VIEW);
        if (property == null) {
            return;
        }
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>();
        for (SgfPoint sgfPoint : SgfPoint.parse(sgfSize, property.getStrings())) {
            if (sgfPoint.condition() != SgfPointType.IN) continue;
            arrayList.add(sgfPoint);
        }
        if (arrayList.isEmpty()) {
            sgfRectangle = new SgfRectangle();
            sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height()));
        } else {
            SgfPointSet sgfPointSet = new SgfPointSet();
            sgfPointSet.add(arrayList.toArray(new SgfPoint[arrayList.size()]));
            sgfRectangle = sgfPointSet.calcInclusiveRectangle();
        }
        this.viewArea_.set(sgfRectangle.getStart(), sgfRectangle.getEnd());
    }

    public SgfRectangle getViewArea() {
        return new SgfRectangle(this.viewArea_);
    }

    public int piledSize() {
        return this.piledStones_.size();
    }

    public PiledStone[] getPiledStones() {
        return this.piledStones_.toArray(new PiledStone[this.piledStones_.size()]);
    }

    public Map<SgfColor, Set<SgfPoint>> getAllStones() {
        HashMap<SgfColor, Set<SgfPoint>> hashMap = new HashMap<SgfColor, Set<SgfPoint>>();
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        HashSet<SgfPoint> hashSet2 = new HashSet<SgfPoint>();
        for (int i = 1; i <= this.size_.width(); ++i) {
            for (int j = 1; j <= this.size_.height(); ++j) {
                SgfPoint sgfPoint = SgfPoint.create(this.size_, i, j);
                SgfColor sgfColor = this.getColor(sgfPoint);
                if (sgfColor == SgfColor.BLACK) {
                    hashSet2.add(sgfPoint);
                    continue;
                }
                if (sgfColor != SgfColor.WHITE) continue;
                hashSet.add(sgfPoint);
            }
        }
        hashMap.put(SgfColor.BLACK, hashSet2);
        hashMap.put(SgfColor.WHITE, hashSet);
        return hashMap;
    }

    public static class PiledStone {
        private Stone piled_;
        private Stone base_;

        public Stone getPiled() {
            return this.piled_;
        }

        public Stone getBase() {
            return this.base_;
        }
    }
}

