/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.io.Closeable;
import java.io.File;
import java.util.EnumSet;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sql.CheckerMessage;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.NullDatabase;
import org.unitarou.yukinoshita.model.db.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Database
extends Closeable {
    public static final Database NULL_OBJECT = new NullDatabase();
    public static final Message NT_CANT_START_DB = new Message(Database.class, "ntCantStartDb");
    public static final Message MSG_BAD_CONNECTION_URL = new Message(Database.class, "msgBadConnectionUrl");
    public static final Message MSG_DB_CANNOT_BE_USED_BY_INIT_ERROR = new Message(Database.class, "msgDbCannotBeUsedByInitError");
    public static final Message MSG_DB_CANNOT_BE_USED = new Message(Database.class, "msgDbCannotBeUsed");
    public static final Message MSG_REBUILD_DB = new Message(Database.class, "msgRebuildDb");
    public static final Message MSG_RECREATE_DB = new Message(Database.class, "msgRecreateDb");

    public void setup(String var1);

    public Exception getExceptionAtSetup();

    @Override
    public void close();

    public CheckerMessage[] selfCheck();

    public void create() throws DatabaseException;

    public Master selectMaster(RootGameTree var1) throws DatabaseException;

    public Master insertMaster(RootGameTree var1) throws DatabaseException;

    public FileIndex selectFileIndex(File var1) throws DatabaseException;

    public void refreshFileIndex(Collection var1) throws DatabaseException;

    public boolean deleteFileIndex(int var1) throws DatabaseException;

    public int deleteNotFoundFileIndex() throws DatabaseException;

    public Score insertScore(RootGameTree var1, ProblemStatus var2, ProblemProperties var3, int var4) throws DatabaseException;

    public Score[] selectScores(RootGameTree var1) throws DatabaseException;

    public FileSearched[] selectFile(EnumSet<GameType> var1, String var2) throws DatabaseException;

    public DatabaseStatistics selectStatistics() throws DatabaseException;
}

