/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.filter.MirrorXFilter;
import org.unitarou.sgf.util.filter.ReflectionFilter;
import org.unitarou.sgf.util.filter.Rotate180Filter;
import org.unitarou.sgf.util.filter.Rotate270Filter;
import org.unitarou.sgf.util.filter.Rotate90Filter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.NullFilter;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.PrintingIgoBoard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataFactory {
    private static final MetaDataFactory instance_s_ = new MetaDataFactory();

    public static final MetaDataFactory instance() {
        return instance_s_;
    }

    private MetaDataFactory() {
    }

    public byte[] calcFingerprint(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfSize sgfSize = rootGameTree.getSize();
        byte[] byArray = new byte[this.getArrayLength(sgfSize)];
        PrintingIgoBoard printingIgoBoard = new PrintingIgoBoard(rootGameTree);
        Map<SgfColor, Set<SgfPoint>> map = printingIgoBoard.getAllStones();
        StoneSet stoneSet = this.select(sgfSize, map.get(SgfColor.WHITE), map.get(SgfColor.BLACK));
        this.setStone(byArray, stoneSet.whiteStones_, sgfSize, (byte)2);
        this.setStone(byArray, stoneSet.blackStones_, sgfSize, (byte)1);
        return byArray;
    }

    public byte[] calcFingerprint(IgoBoard igoBoard) {
        SgfSize sgfSize = igoBoard.size();
        byte[] byArray = new byte[this.getArrayLength(sgfSize)];
        StoneSet stoneSet = this.select(sgfSize, igoBoard.position(SgfColor.WHITE), igoBoard.position(SgfColor.BLACK));
        this.setStone(byArray, stoneSet.whiteStones_, sgfSize, (byte)2);
        this.setStone(byArray, stoneSet.blackStones_, sgfSize, (byte)1);
        return byArray;
    }

    private void setStone(byte[] byArray, Set<SgfPoint> set, SgfSize sgfSize, byte by) {
        for (SgfPoint sgfPoint : set) {
            int n = (sgfPoint.y() - 1) * sgfSize.width() + (sgfPoint.x() - 1);
            int n2 = n / 4;
            int n3 = (3 - n % 4) * 2;
            byte by2 = by;
            by2 = (byte)(by2 << n3);
            int n4 = n2;
            byArray[n4] = (byte)(byArray[n4] | by2);
        }
    }

    private int getArrayLength(SgfSize sgfSize) {
        return (int)Math.ceil((double)sgfSize.width() * (double)sgfSize.height() / 4.0);
    }

    private StoneSet select(SgfSize sgfSize, Set<SgfPoint> set, Set<SgfPoint> set2) {
        boolean bl = sgfSize.width() == sgfSize.height();
        ArrayList<StoneSet> arrayList = new ArrayList<StoneSet>(8);
        arrayList.add(this.filter(new NullFilter<SgfPoint>(), set, set2));
        if (bl) {
            arrayList.add(this.filter(new Rotate90Filter(), set, set2));
            arrayList.add(this.filter(new Rotate270Filter(), set, set2));
            arrayList.add(this.filter(new ReflectionFilter(), set, set2));
            arrayList.add(this.filter(new Rotate180Filter(new ReflectionFilter()), set, set2));
        }
        arrayList.add(this.filter(new Rotate180Filter(), set, set2));
        arrayList.add(this.filter(new MirrorXFilter(), set, set2));
        arrayList.add(this.filter(new Rotate180Filter(new MirrorXFilter()), set, set2));
        int n = Integer.MIN_VALUE;
        for (int i = 1; i <= sgfSize.height(); ++i) {
            for (int j = 1; j <= sgfSize.width(); ++j) {
                StoneSet stoneSet;
                SgfPoint sgfPoint = SgfPoint.create(sgfSize, j, i);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stoneSet.point_ += (stoneSet = (StoneSet)iterator.next()).whiteStones_.contains(sgfPoint) ? 2 : (stoneSet.blackStones_.contains(sgfPoint) ? 1 : 0);
                    n = Math.max(n, stoneSet.point_);
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    stoneSet = (StoneSet)iterator.next();
                    if (stoneSet.point_ >= n) continue;
                    iterator.remove();
                }
                if (arrayList.size() == 1) break;
            }
            if (arrayList.size() == 1) break;
        }
        return (StoneSet)arrayList.get(0);
    }

    private StoneSet filter(Filter<SgfPoint> filter, Set<SgfPoint> set, Set<SgfPoint> set2) {
        StoneSet stoneSet = new StoneSet();
        stoneSet.point_ = 0;
        stoneSet.whiteStones_ = new HashSet(set.size());
        stoneSet.blackStones_ = new HashSet(set2.size());
        for (SgfPoint sgfPoint : set) {
            stoneSet.whiteStones_.add(filter.filter(sgfPoint));
        }
        for (SgfPoint sgfPoint : set2) {
            stoneSet.blackStones_.add(filter.filter(sgfPoint));
        }
        return stoneSet;
    }

    public SgfColor getColor(byte[] byArray, SgfSize sgfSize, int n, int n2) {
        int n3 = (n2 - 1) * sgfSize.width() + (n - 1);
        int n4 = n3 / 4;
        byte by = byArray[n4];
        int n5 = (3 - n3 % 4) * 2;
        by = (byte)(by >> n5);
        by = (byte)(by & 3);
        switch (by) {
            case 0: {
                return null;
            }
            case 1: {
                return SgfColor.BLACK;
            }
            case 2: {
                return SgfColor.WHITE;
            }
        }
        return null;
    }

    public String gatherKeywords(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        StringBuilder stringBuilder = new StringBuilder();
        this.gatherKeywordsImpl(stringBuilder, rootGameTree);
        return stringBuilder.toString();
    }

    private void gatherKeywordsImpl(StringBuilder stringBuilder, GameTree gameTree) {
        EnumSet<ValueType> enumSet = EnumSet.of(ValueType.TEXT, ValueType.SIMPLE_TEXT);
        for (Node node : gameTree.getSequence()) {
            for (Property property : node.getProperties()) {
                SgfId sgfId = property.sgfId();
                if (!enumSet.contains((Object)sgfId.valueType())) continue;
                for (String string : property.getStrings()) {
                    stringBuilder.append(string).append(' ');
                }
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.gatherKeywordsImpl(stringBuilder, gameTree2);
        }
    }

    public String calcGameInfo(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Sequence sequence = rootGameTree.getSequence();
        for (Node node : sequence) {
            if (!node.contains(PropertyType.GAME_INFO)) continue;
            return this.calcGameInfoImpl(node);
        }
        return "";
    }

    private String calcGameInfoImpl(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Property property : node.getProperties()) {
            SgfId sgfId = property.sgfId();
            if (!PropertyType.GAME_INFO.equals(sgfId.propertyType()) || !ValueType.SIMPLE_TEXT.equals((Object)sgfId.valueType()) && !ValueType.REAL.equals((Object)sgfId.valueType())) continue;
            stringBuilder.append(property.toSgf());
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.insert(0, ';');
        }
        return stringBuilder.toString();
    }

    private static class StoneSet {
        private int point_;
        private Set<SgfPoint> whiteStones_;
        private Set<SgfPoint> blackStones_;

        private StoneSet() {
        }
    }
}

