/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.io.File;
import java.util.EnumSet;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sql.CheckerMessage;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NullDatabase
implements Database {
    NullDatabase() {
    }

    @Override
    public void setup(String string) {
    }

    @Override
    public Exception getExceptionAtSetup() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public CheckerMessage[] selfCheck() {
        return new CheckerMessage[0];
    }

    @Override
    public void create() throws DatabaseException {
    }

    @Override
    public Master selectMaster(RootGameTree rootGameTree) throws DatabaseException {
        return null;
    }

    @Override
    public Master insertMaster(RootGameTree rootGameTree) throws DatabaseException {
        return new Master(rootGameTree);
    }

    @Override
    public FileIndex selectFileIndex(File file) throws DatabaseException {
        return null;
    }

    @Override
    public void refreshFileIndex(Collection collection) throws DatabaseException {
    }

    @Override
    public boolean deleteFileIndex(int n) throws DatabaseException {
        return false;
    }

    @Override
    public int deleteNotFoundFileIndex() throws DatabaseException {
        return 0;
    }

    @Override
    public Score insertScore(RootGameTree rootGameTree, ProblemStatus problemStatus, ProblemProperties problemProperties, int n) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree, (Object)problemStatus);
        GameType gameType = rootGameTree.getGameType();
        if (gameType != GameType.PROBLEM || problemStatus.getId() == 0) {
            throw new IllegalArgumentException();
        }
        return new Score(rootGameTree);
    }

    @Override
    public Score[] selectScores(RootGameTree rootGameTree) throws DatabaseException {
        return new Score[0];
    }

    @Override
    public FileSearched[] selectFile(EnumSet<GameType> enumSet, String string) throws DatabaseException {
        return new FileSearched[0];
    }

    @Override
    public DatabaseStatistics selectStatistics() throws DatabaseException {
        return new DatabaseStatistics();
    }
}

