/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.sql.Timestamp;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.BasicFormatter;
import org.unitarou.util.ArgumentChecker;

public class Score {
    private int masterId_;
    private String user_;
    private Timestamp examined_;
    private int result_;
    private String moves_;
    private int pp_;
    private int timeLimit_;
    private int elapsed_;

    public Score() {
        this.user_ = "";
        this.examined_ = new Timestamp(0L);
        this.moves_ = "";
    }

    public Score(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        Sequence sequence = new Sequence();
        GameTree gameTree = rootGameTree;
        while (gameTree != null) {
            sequence.addAll(gameTree.getSequence());
            GameTree[] gameTreeArray = gameTree.getChildren();
            if (gameTreeArray.length == 0) {
                gameTree = null;
                continue;
            }
            gameTree = gameTreeArray[0];
        }
        this.moves_ = ((Object)BasicFormatter.pickOutToSgf(sequence, SgfId.WHITE, SgfId.BLACK, SgfId.ADD_BLACK, SgfId.ADD_WHITE, SgfId.ADD_EMPTY, SgfId.VIEW, SgfId.SIZE)).toString();
        this.user_ = "";
        this.examined_ = new Timestamp(0L);
    }

    public int getMasterId() {
        return this.masterId_;
    }

    public void setMasterId(int n) {
        this.masterId_ = n;
    }

    public String getUser() {
        return this.user_;
    }

    public void setUser(String string) {
        this.user_ = string;
    }

    public Timestamp getExamined() {
        return this.examined_;
    }

    public void setExamined(Timestamp timestamp) {
        this.examined_ = timestamp;
    }

    public int getResult() {
        return this.result_;
    }

    public void setResult(int n) {
        this.result_ = n;
    }

    public String getMoves() {
        return this.moves_;
    }

    public void setMoves(String string) {
        this.moves_ = string;
    }

    public int getPp() {
        return this.pp_;
    }

    public void setPp(int n) {
        this.pp_ = n;
    }

    public int getTimeLimit() {
        return this.timeLimit_;
    }

    public void setTimeLimit(int n) {
        this.timeLimit_ = n;
    }

    public int getElapsed() {
        return this.elapsed_;
    }

    public void setElapsed(int n) {
        this.elapsed_ = n;
    }
}

