/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.ml.Message;
import org.unitarou.sql.Checker;
import org.unitarou.sql.CheckerMessage;
import org.unitarou.sql.CheckerResult;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbQueryBuilder;
import org.unitarou.yukinoshita.model.db.hsql.Table;

abstract class AbstractTable
implements Table {
    private static final Log log_s_ = LogFactory.getLog(AbstractTable.class);
    public static final Message NT_CRATE_TABLE = new Message(AbstractTable.class, "ntCreateTable");

    public void create(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        queryRunner.update(connection, "DROP TABLE " + this.getTable() + " IF EXISTS");
        String string = HsqldbQueryBuilder.instance().buildTable(this.getTable(), this.getColumns(), this.getPrimaryKeys(), this.getInTableConstraints());
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("CREATE:" + string);
        }
        queryRunner.update(connection, string);
    }

    public void addConstraint(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        for (String string : this.getInterTableConstraintQueries()) {
            queryRunner.update(connection, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckerMessage[] selfCheck(Connection connection) {
        ArrayList<CheckerMessage> arrayList = new ArrayList<CheckerMessage>();
        ResultSet resultSet = null;
        try {
            CheckerMessage checkerMessage = Checker.instance().hasTable(connection, this.getTable());
            if (CheckerResult.TABLE_NOT_FOUND == checkerMessage.getResult()) {
                this.create(connection);
                checkerMessage = new CheckerMessage(NT_CRATE_TABLE.get((Object)this.getTable()), CheckerResult.OK);
            }
            arrayList.add(checkerMessage);
            if (CheckerResult.OK != checkerMessage.getResult()) {
                CheckerMessage[] checkerMessageArray = arrayList.toArray(new CheckerMessage[arrayList.size()]);
                return checkerMessageArray;
            }
            for (HsqldbColumn hsqldbColumn : this.getColumns()) {
                arrayList.add(Checker.instance().hasColumn(connection, this.getTable(), hsqldbColumn));
            }
            arrayList.add(Checker.instance().hasPrimeryKey(connection, this.getTable(), this.getPrimaryKeys()));
        }
        catch (SQLException sQLException) {
            arrayList.add(new CheckerMessage(Checker.NT_DB_ERROR.get((Object)sQLException.getLocalizedMessage()), CheckerResult.BROKEN));
        }
        finally {
            DbUtils.closeQuietly(resultSet);
        }
        return arrayList.toArray(new CheckerMessage[arrayList.size()]);
    }

    protected abstract String getTable();

    protected abstract HsqldbColumn[] getColumns();

    protected abstract PrimaryKey[] getPrimaryKeys();

    protected abstract String getInTableConstraints();

    protected abstract String[] getInterTableConstraintQueries();
}

