/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanHandler;
import org.unitarou.sql.UBeanListHandler;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

final class FileIndexTable
extends AbstractTable {
    private static final Log log_s_ = LogFactory.getLog(FileIndexTable.class);
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("FILE_ID", "INTEGER", 0, "NOT NULL", true), new HsqldbColumn("PATH", "VARCHAR", 0, "NOT NULL"), new HsqldbColumn("DIGEST", "VARBINARY", 16, "NOT NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("FILE_ID", 1)};
    private static final FileIndexTable instance_s_ = new FileIndexTable();

    static FileIndexTable instance() {
        return instance_s_;
    }

    private FileIndexTable() {
    }

    protected String getTable() {
        return "FILE_INDEX";
    }

    protected HsqldbColumn[] getColumns() {
        return columns_s_;
    }

    protected PrimaryKey[] getPrimaryKeys() {
        return primaryKey_s_;
    }

    protected String getInTableConstraints() {
        return "CONSTRAINT uq1_file_index UNIQUE (path)";
    }

    protected String[] getInterTableConstraintQueries() {
        return new String[0];
    }

    FileIndex[] select(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        List list = (List)queryRunner.query(connection, "SELECT file_id, path, digest FROM file_index", (ResultSetHandler)new UBeanListHandler(FileIndex.class));
        FileIndex[] fileIndexArray = new FileIndex[list.size()];
        for (int i = 0; i < fileIndexArray.length; ++i) {
            fileIndexArray[i] = (FileIndex)list.get(i);
        }
        return fileIndexArray;
    }

    FileIndex selectFromPath(Connection connection, String string) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        FileIndex fileIndex = (FileIndex)queryRunner.query(connection, "SELECT file_id, path, digest FROM file_index WHERE path=?", string, (ResultSetHandler)new UBeanHandler(FileIndex.class));
        return fileIndex;
    }

    FileIndex refresh(Connection connection, FileSnapshot fileSnapshot) throws SQLException, IOException {
        String string = fileSnapshot.file().getCanonicalPath();
        byte[] byArray = fileSnapshot.getDigest();
        FileIndex fileIndex = this.selectFromPath(connection, string);
        if (fileIndex != null) {
            if (!Arrays.equals(fileIndex.getDigest(), byArray)) {
                fileIndex.setDigest(byArray);
                this.update(connection, fileIndex);
            }
        } else {
            fileIndex = new FileIndex();
            fileIndex.setPath(string);
            fileIndex.setDigest(byArray);
            this.insert(connection, fileIndex);
        }
        return this.selectFromPath(connection, string);
    }

    private void update(Connection connection, FileIndex fileIndex) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "UPDATE file_index SET path=?, digest=? WHERE file_id=?", new Object[]{fileIndex.getPath(), fileIndex.getDigest(), new Integer(fileIndex.getFileId())});
        if (n != 1) {
            throw new SQLException("DB is broken: update error record:" + n);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("UPDATE: " + fileIndex);
        }
    }

    private void insert(Connection connection, FileIndex fileIndex) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO file_index (file_id, path, digest) VALUES(null, ?, ?)", new Object[]{fileIndex.getPath(), fileIndex.getDigest()});
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("INSERT: " + fileIndex);
        }
    }

    boolean delete(Connection connection, int n) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n2 = queryRunner.update(connection, "DELETE FROM file_index WHERE file_id = ? ", new Object[]{new Integer(n)});
        if (1 < n2) {
            throw new SQLException("DB is broken: delete error record:" + n2);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("DELETE: " + n);
        }
        return n2 == 1;
    }

    int selectCount(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Number number = (Number)queryRunner.query(connection, "SELECT count('X') records FROM file_index", (ResultSetHandler)new ScalarHandler());
        return number.intValue();
    }
}

