/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanHandler;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

final class GameIndexTable
extends AbstractTable {
    private static final Log log_s_ = LogFactory.getLog(GameIndexTable.class);
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("FILE_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FILE_ORDER", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("GAME_INFO", "VARCHAR", 0, "NULL"), new HsqldbColumn("KEYWORD", "VARCHAR", 0, "NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("FILE_ID", 1), new PrimaryKey("FILE_ORDER", 2)};
    private static final GameIndexTable instance_s_ = new GameIndexTable();

    static GameIndexTable instance() {
        return instance_s_;
    }

    private GameIndexTable() {
    }

    protected String getTable() {
        return "GAME_INDEX";
    }

    protected HsqldbColumn[] getColumns() {
        return columns_s_;
    }

    protected PrimaryKey[] getPrimaryKeys() {
        return primaryKey_s_;
    }

    protected String getInTableConstraints() {
        return "";
    }

    protected String[] getInterTableConstraintQueries() {
        return new String[]{"ALTER TABLE game_index ADD CONSTRAINT fk1_game_index FOREIGN KEY (file_id) REFERENCES file_index(file_id) ON DELETE CASCADE;", "ALTER TABLE game_index ADD CONSTRAINT fk2_game_index FOREIGN KEY (master_id) REFERENCES master(master_id) ON DELETE CASCADE;"};
    }

    void refresh(Connection connection, GameIndex gameIndex) throws SQLException {
        GameIndex gameIndex2 = this.selectFromFileIdAndIndex(connection, gameIndex.getFileId(), gameIndex.getFileOrder());
        if (gameIndex2 == null) {
            this.insert(connection, gameIndex);
        } else if (!gameIndex.equals(gameIndex2)) {
            this.update(connection, gameIndex);
        }
    }

    private GameIndex selectFromFileIdAndIndex(Connection connection, int n, int n2) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        GameIndex gameIndex = (GameIndex)queryRunner.query(connection, "SELECT file_id, file_order, master_id, game_info keyword FROM game_index WHERE file_id=? AND file_order=?", new Object[]{new Integer(n), new Integer(n2)}, (ResultSetHandler)new UBeanHandler(GameIndex.class));
        return gameIndex;
    }

    private void insert(Connection connection, GameIndex gameIndex) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO game_index (file_id, file_order, master_id, game_info, keyword) VALUES(?, ?, ?, ?, ?)", new Object[]{new Integer(gameIndex.getFileId()), new Integer(gameIndex.getFileOrder()), new Integer(gameIndex.getMasterId()), gameIndex.getGameInfo(), gameIndex.getKeyword()});
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("INSERT: " + gameIndex);
        }
    }

    private void update(Connection connection, GameIndex gameIndex) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "UPDATE game_index SET master_id=?, game_info=?, keyword=?WHERE file_id=? AND file_order=?", new Object[]{new Integer(gameIndex.getMasterId()), gameIndex.getGameInfo(), gameIndex.getKeyword(), new Integer(gameIndex.getFileId()), new Integer(gameIndex.getFileOrder())});
        if (n != 1) {
            throw new SQLException("DB is broken: update error record:" + n);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("UPDATE: " + gameIndex);
        }
    }
}

