/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sql.CheckerMessage;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.hsql.FileIndexTable;
import org.unitarou.yukinoshita.model.db.hsql.FileSearchedView;
import org.unitarou.yukinoshita.model.db.hsql.GameIndexTable;
import org.unitarou.yukinoshita.model.db.hsql.MasterTable;
import org.unitarou.yukinoshita.model.db.hsql.ScoreTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDatabase
implements Database {
    private static final Message MSG_DB_ALREADY_USED = new Message(HsqlDatabase.class, "msgDbAlreadyUsed");
    private static final String URL_PREFIX = "jdbc:hsqldb:file:";
    private static final int COMPACT_THRESHOLD = 100;
    private static final IntContextValue DELETE_RECORDS = new IntContextValue(HsqlDatabase.class, "deleteRecords", 0, 0, Integer.MAX_VALUE);
    private static final Log log_s_ = LogFactory.getLog(HsqlDatabase.class);
    private Exception exception_;
    private Connection connection_;
    private boolean needsShutdown_;
    private String standaloneFileName_;

    public HsqlDatabase() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.warn("Failure class loading JDBC driver. Cause: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public void setup(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            this.setupImpl(string);
        }
        catch (SQLException sQLException) {
            this.handleSqlExceptionInSetup(sQLException, string);
        }
    }

    private void setupImpl(String string) throws SQLException {
        DbUtils.closeQuietly(this.connection_);
        this.needsShutdown_ = string.startsWith(URL_PREFIX);
        this.standaloneFileName_ = this.needsShutdown_ ? string.substring(URL_PREFIX.length()) : "";
        this.connection_ = DriverManager.getConnection(string);
        this.exception_ = null;
    }

    private void handleSqlExceptionInSetup(SQLException sQLException, String string) {
        if (this.isLocalDbBroken(sQLException)) {
            this.rebuildLocalDb();
        } else if (this.isLocalDbOccupied(sQLException)) {
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, Database.NT_CANT_START_DB.get(), MSG_DB_ALREADY_USED.get());
            this.exception_ = null;
            this.connection_ = null;
        } else if (this.isBadUrl(sQLException)) {
            this.exception_ = new DatabaseException(Database.MSG_BAD_CONNECTION_URL.get((Object)string), sQLException);
            this.connection_ = null;
        } else {
            this.exception_ = sQLException;
            this.connection_ = null;
        }
    }

    private boolean isLocalDbBroken(SQLException sQLException) {
        return "S1000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -78;
    }

    private void rebuildLocalDb() {
        Application application = Yukinoshita.application();
        boolean bl = application.openMessageDialog(Application.MessageLevel.CONFIRM, Database.NT_CANT_START_DB.get(), Database.MSG_REBUILD_DB.get());
        if (!bl) {
            application.openMessageDialog(Application.MessageLevel.INFORMATION, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED.get());
            return;
        }
        try {
            this.deleteAllDbFiles();
            this.setupImpl(URL_PREFIX + this.standaloneFileName_);
            this.create();
        }
        catch (Exception exception) {
            this.exception_ = exception;
            this.connection_ = null;
        }
    }

    private boolean isLocalDbOccupied(SQLException sQLException) {
        return "08001".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -1;
    }

    private boolean isBadUrl(SQLException sQLException) {
        return "S1000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -29 || sQLException.getSQLState() == null && sQLException.getErrorCode() == 0;
    }

    private void deleteAllDbFiles() {
        File[] fileArray;
        final File file = new File(this.standaloneFileName_);
        File file2 = file.getParentFile();
        for (File file3 : fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file2, String string) {
                String string2 = FilenameUtils.getBaseName(string);
                return string2.equals(file.getName());
            }
        })) {
            if (!file3.delete()) continue;
            log_s_.info("DELETE: " + file3.getAbsolutePath());
        }
    }

    @Override
    public Exception getExceptionAtSetup() {
        return this.exception_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.connection_ != null) {
                this.close();
            }
        }
        finally {
            this.connection_ = null;
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.connection_ == null) {
            return;
        }
        try {
            if (!this.needsShutdown_) {
                return;
            }
            QueryRunner queryRunner = new QueryRunner();
            CurrentContext currentContext = Yukinoshita.context(null);
            if (100 < currentContext.getInteger(DELETE_RECORDS)) {
                queryRunner.update(this.connection_, "SHUTDOWN COMPACT");
                currentContext.setInteger(DELETE_RECORDS.id(), 0);
                log_s_.info("SHUTDOWN COMPACT is executed.");
            } else {
                queryRunner.update(this.connection_, "SHUTDOWN");
            }
        }
        catch (SQLException sQLException) {
            log_s_.info("close failure in dispose(): " + sQLException.getLocalizedMessage());
        }
        finally {
            DbUtils.closeQuietly(this.connection_);
            this.connection_ = null;
        }
    }

    @Override
    public CheckerMessage[] selfCheck() {
        if (this.connection_ == null) {
            return new CheckerMessage[0];
        }
        ArrayList<CheckerMessage> arrayList = new ArrayList<CheckerMessage>();
        arrayList.addAll(Arrays.asList(MasterTable.instance().selfCheck(this.connection_)));
        arrayList.addAll(Arrays.asList(FileIndexTable.instance().selfCheck(this.connection_)));
        arrayList.addAll(Arrays.asList(GameIndexTable.instance().selfCheck(this.connection_)));
        arrayList.addAll(Arrays.asList(ScoreTable.instance().selfCheck(this.connection_)));
        return arrayList.toArray(new CheckerMessage[arrayList.size()]);
    }

    @Override
    public void create() throws DatabaseException {
        if (this.connection_ == null) {
            return;
        }
        try {
            ScoreTable.instance().create(this.connection_);
            GameIndexTable.instance().create(this.connection_);
            FileIndexTable.instance().create(this.connection_);
            MasterTable.instance().create(this.connection_);
            ScoreTable.instance().addConstraint(this.connection_);
            GameIndexTable.instance().addConstraint(this.connection_);
            FileIndexTable.instance().addConstraint(this.connection_);
            MasterTable.instance().addConstraint(this.connection_);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public Master selectMaster(RootGameTree rootGameTree) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (this.connection_ == null) {
            return null;
        }
        GameType gameType = rootGameTree.getGameType();
        SgfSize sgfSize = rootGameTree.getSize();
        try {
            return MasterTable.instance().selectFromUnique(this.connection_, rootGameTree, gameType, sgfSize);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public Master insertMaster(RootGameTree rootGameTree) throws DatabaseException {
        if (this.connection_ == null) {
            return new Master(rootGameTree);
        }
        try {
            ArgumentChecker.throwIfNull((Object)rootGameTree);
            GameType gameType = rootGameTree.getGameType();
            SgfSize sgfSize = rootGameTree.getSize();
            Master master = MasterTable.instance().insert(this.connection_, rootGameTree, gameType, sgfSize);
            this.connection_.commit();
            Master master2 = master;
            return master2;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public FileIndex selectFileIndex(File file) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)file);
        if (this.connection_ == null) {
            return null;
        }
        try {
            return FileIndexTable.instance().selectFromPath(this.connection_, file.getCanonicalPath());
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
    }

    @Override
    public void refreshFileIndex(Collection collection) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.size() == 0) {
            return;
        }
        FileSnapshot fileSnapshot = collection.getFileSnapshot();
        if (fileSnapshot == null || !fileSnapshot.file().exists() || !fileSnapshot.file().isFile()) {
            return;
        }
        if (this.connection_ == null) {
            return;
        }
        FileIndexTable fileIndexTable = FileIndexTable.instance();
        try {
            String string = fileSnapshot.file().getCanonicalPath();
            FileIndex fileIndex = fileIndexTable.selectFromPath(this.connection_, string);
            if (fileIndex != null && Arrays.equals(fileSnapshot.getDigest(), fileIndex.getDigest())) {
                return;
            }
            fileIndex = FileIndexTable.instance().refresh(this.connection_, fileSnapshot);
            for (int i = 0; i < collection.size(); ++i) {
                RootGameTree rootGameTree = collection.get(i);
                GameType gameType = rootGameTree.getGameType();
                if (GameType.DRILL == gameType) continue;
                SgfSize sgfSize = rootGameTree.getSize();
                Master master = MasterTable.instance().insert(this.connection_, rootGameTree, gameType, sgfSize);
                GameIndex gameIndex = new GameIndex(rootGameTree);
                gameIndex.setFileId(fileIndex.getFileId());
                gameIndex.setFileOrder(i);
                gameIndex.setMasterId(master.getMasterId());
                GameIndexTable.instance().refresh(this.connection_, gameIndex);
            }
            this.connection_.commit();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public boolean deleteFileIndex(int n) throws DatabaseException {
        try {
            boolean bl = FileIndexTable.instance().delete(this.connection_, n);
            if (bl) {
                CurrentContext currentContext = Yukinoshita.context(null);
                int n2 = currentContext.getInteger(DELETE_RECORDS);
                currentContext.setInteger(DELETE_RECORDS.id(), ++n2);
            }
            this.connection_.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public int deleteNotFoundFileIndex() throws DatabaseException {
        try {
            int n = 0;
            FileIndex[] fileIndexArray = FileIndexTable.instance().select(this.connection_);
            for (FileIndex fileIndex : fileIndexArray) {
                File file = new File(fileIndex.getPath());
                if (Ios.isNormalFile(file)) continue;
                FileIndexTable.instance().delete(this.connection_, fileIndex.getFileId());
                ++n;
            }
            CurrentContext currentContext = Yukinoshita.context(null);
            int n2 = currentContext.getInteger(DELETE_RECORDS);
            currentContext.setInteger(DELETE_RECORDS.id(), n + n2);
            this.connection_.commit();
            int n3 = n;
            return n3;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public Score insertScore(RootGameTree rootGameTree, ProblemStatus problemStatus, ProblemProperties problemProperties, int n) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree, (Object)problemStatus, (Object)problemProperties);
        GameType gameType = rootGameTree.getGameType();
        if (gameType != GameType.PROBLEM || problemStatus.getId() == 0) {
            throw new IllegalArgumentException();
        }
        Score score = new Score(rootGameTree);
        if (this.connection_ == null) {
            return score;
        }
        try {
            Master master = MasterTable.instance().insert(this.connection_, rootGameTree, gameType, rootGameTree.getSize());
            score.setMasterId(master.getMasterId());
            score.setResult(problemStatus.getId());
            score.setUser(Yukinoshita.USER_NAME);
            score.setPp(problemProperties.getIntValue());
            String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.TIMELIMIT);
            SgfNumber sgfNumber = SgfNumber.parseQuietly(string);
            if (sgfNumber != null) {
                score.setTimeLimit(sgfNumber.getIntValue());
            }
            score.setElapsed(n);
            ScoreTable.instance().insertScoreImpl(this.connection_, score);
            this.connection_.commit();
            Score score2 = score;
            return score2;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
        finally {
            this.rollbackQuietly();
        }
    }

    @Override
    public Score[] selectScores(RootGameTree rootGameTree) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (this.connection_ == null) {
            return new Score[0];
        }
        try {
            return ScoreTable.instance().selectFromMaster(this.connection_, rootGameTree);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public FileSearched[] selectFile(EnumSet<GameType> enumSet, String string) throws DatabaseException {
        if (this.connection_ == null) {
            return new FileSearched[0];
        }
        try {
            return FileSearchedView.instance().selectFromKeyword(this.connection_, enumSet, string);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public DatabaseStatistics selectStatistics() throws DatabaseException {
        DatabaseStatistics databaseStatistics = new DatabaseStatistics();
        if (this.connection_ == null) {
            return databaseStatistics;
        }
        try {
            databaseStatistics.setFileCount(FileIndexTable.instance().selectCount(this.connection_));
            QueryRunner queryRunner = new QueryRunner();
            List list = (List)queryRunner.query(this.connection_, "SELECT m.game_type, COUNT('X') games FROM game_index g, master m WHERE g.master_id = m.master_id GROUP BY m.game_type ", (ResultSetHandler)new ArrayListHandler());
            block6: for (Object[] objectArray : list) {
                int n = ((Number)objectArray[1]).intValue();
                switch (((Number)objectArray[0]).intValue()) {
                    case 1: {
                        databaseStatistics.setGameCount(n);
                        continue block6;
                    }
                    case 3: {
                        databaseStatistics.setProblemCount(n);
                        continue block6;
                    }
                }
                log_s_.warn("[IGNORE] Unknown gametype " + objectArray[0]);
            }
            databaseStatistics.setScoreCount(ScoreTable.instance().selectCount(this.connection_));
            return databaseStatistics;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private void rollbackQuietly() {
        try {
            DbUtils.rollback(this.connection_);
        }
        catch (SQLException sQLException) {
            log_s_.warn("Error occurred in rollback", sQLException);
        }
    }
}

