/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import org.unitarou.sql.PrimaryKey;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

class HsqldbQueryBuilder {
    private static final HsqldbQueryBuilder instance_s_ = new HsqldbQueryBuilder();

    static HsqldbQueryBuilder instance() {
        return instance_s_;
    }

    private HsqldbQueryBuilder() {
    }

    String buildTable(String string, HsqldbColumn[] hsqldbColumnArray, PrimaryKey[] primaryKeyArray, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)hsqldbColumnArray, (Object)primaryKeyArray, (Object)string2);
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("CREATE CACHED TABLE ").append(string).append("(");
        for (HsqldbColumn object : hsqldbColumnArray) {
            stringBuilder.append(" ").append(object.getColumnName()).append(" ").append(object.getTypeName());
            if (object.getColumnSize() != 0 && object.getColumnSize() != Integer.MAX_VALUE) {
                stringBuilder.append("(").append(object.getColumnSize()).append(")");
            }
            if (object.getNullable() == 0) {
                stringBuilder.append(" ").append("NOT NULL");
            }
            if (object.isIdentity()) {
                stringBuilder.append(" ").append("IDENTITY");
            }
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (primaryKeyArray.length != 0) {
            stringBuilder.append(", CONSTRAINT PK_").append(string).append(" PRIMARY KEY (");
            for (PrimaryKey primaryKey : primaryKeyArray) {
                stringBuilder.append(primaryKey.getColumnName()).append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(")");
        }
        if (string2.length() != 0) {
            stringBuilder.append(",").append(string2);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

