/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanHandler;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.MetaDataFactory;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

final class MasterTable
extends AbstractTable {
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL", true), new HsqldbColumn("GAME_TYPE", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("WIDTH", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("HEIGHT", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FINGERPRINT", "VARBINARY", 676, "NOT NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("MASTER_ID", 1)};
    private static final MasterTable instance_s_ = new MasterTable();

    static MasterTable instance() {
        return instance_s_;
    }

    private MasterTable() {
    }

    protected String getTable() {
        return "MASTER";
    }

    protected HsqldbColumn[] getColumns() {
        return columns_s_;
    }

    protected PrimaryKey[] getPrimaryKeys() {
        return primaryKey_s_;
    }

    protected String getInTableConstraints() {
        return "CONSTRAINT uq1_master UNIQUE (game_type, width, height, fingerprint)";
    }

    protected String[] getInterTableConstraintQueries() {
        return new String[0];
    }

    Master selectFromUnique(Connection connection, RootGameTree rootGameTree, GameType gameType, SgfSize sgfSize) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Master master = (Master)queryRunner.query(connection, "SELECT master_id, game_type, width, height, fingerprint FROM master WHERE game_type=? AND width=? AND height=? AND fingerprint=?", new Object[]{new Integer(gameType.getString()), new Integer(sgfSize.width()), new Integer(sgfSize.height()), MetaDataFactory.instance().calcFingerprint(rootGameTree)}, (ResultSetHandler)new UBeanHandler(Master.class));
        return master;
    }

    Master insert(Connection connection, RootGameTree rootGameTree, GameType gameType, SgfSize sgfSize) throws SQLException {
        Master master = this.selectFromUnique(connection, rootGameTree, gameType, sgfSize);
        if (master != null) {
            return master;
        }
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO master (master_id, game_type, width, height, fingerprint) VALUES(null, ?, ?, ?, ?)", new Object[]{new Integer(gameType.getString()), new Integer(sgfSize.width()), new Integer(sgfSize.height()), MetaDataFactory.instance().calcFingerprint(rootGameTree)});
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        return this.selectFromUnique(connection, rootGameTree, gameType, sgfSize);
    }
}

