/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanListHandler;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.db.MetaDataFactory;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

final class ScoreTable
extends AbstractTable {
    private static final Log log_s_ = LogFactory.getLog(ScoreTable.class);
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("USER", "VARCHAR", 0, "NOT NULL"), new HsqldbColumn("EXAMINED", "TIMESTAMP", 0, "NOT NULL"), new HsqldbColumn("RESULT", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("MOVES", "VARCHAR", 0, "NOT NULL"), new HsqldbColumn("PP", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("TIME_LIMIT", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("ELAPSED", "INTEGER", 0, "NOT NULL")};
    private static final ScoreTable instance_s_ = new ScoreTable();

    static ScoreTable instance() {
        return instance_s_;
    }

    private ScoreTable() {
    }

    protected String getTable() {
        return "SCORE";
    }

    protected HsqldbColumn[] getColumns() {
        return columns_s_;
    }

    protected PrimaryKey[] getPrimaryKeys() {
        return new PrimaryKey[0];
    }

    protected String getInTableConstraints() {
        return "";
    }

    protected String[] getInterTableConstraintQueries() {
        return new String[]{"ALTER TABLE score ADD CONSTRAINT fk1_score FOREIGN KEY (master_id) REFERENCES master(master_id) ON DELETE CASCADE;"};
    }

    void insertScoreImpl(Connection connection, Score score) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO score (master_id, user, examined, result, moves, pp, time_limit, elapsed) VALUES(?, ?, CURRENT_TIMESTAMP, ?, ?, ?, ?, ?)", new Object[]{new Integer(score.getMasterId()), score.getUser(), new Integer(score.getResult()), score.getMoves(), new Integer(score.getPp()), new Integer(score.getTimeLimit()), new Integer(score.getElapsed())});
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("INSERT: " + score);
        }
    }

    Score[] selectFromMaster(Connection connection, RootGameTree rootGameTree) throws SQLException {
        ArgumentChecker.throwIfNull((Object)connection, (Object)rootGameTree);
        QueryRunner queryRunner = new QueryRunner();
        List list = (List)queryRunner.query(connection, "SELECT s.master_id, s.user, s.examined, s.result, s.moves, s.pp, s.time_limit, s.elapsed FROM master m, score s WHERE m.master_id = s.master_id AND m.game_type = ? AND m.width = ? AND m.height = ? AND m.fingerprint = ? AND s.user = ? ORDER BY s.examined ASC", new Object[]{new Integer(rootGameTree.getGameType().getString()), new Integer(rootGameTree.getSize().width()), new Integer(rootGameTree.getSize().height()), MetaDataFactory.instance().calcFingerprint(rootGameTree), Yukinoshita.USER_NAME}, (ResultSetHandler)new UBeanListHandler(Score.class));
        return list.toArray(new Score[list.size()]);
    }

    int selectCount(Connection connection) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Number number = (Number)queryRunner.query(connection, "SELECT count('X') records FROM score WHERE user = ?", Yukinoshita.USER_NAME, (ResultSetHandler)new ScalarHandler());
        return number.intValue();
    }
}

