/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.cmd.NodeSelectionCommand;

public class ViewerUtils {
    public static final Message NT_CHOOSE_DRILL_ROOT_DIRECTORY = new Message(ViewerUtils.class, "ntChooseDrillRootDirectory");
    public static final Message MSG_CHOOSE_DRILL_ROOT_DIRECTORY = new Message(ViewerUtils.class, "msgChooseDrillRootDirectory");
    public static final Message NT_AUTO_DRILL_NAME = new Message(ViewerUtils.class, "ntAutoDrillName");
    private static final char[] variationKeys_s_ = new char[26];

    public static boolean toVariationIndex(int n, NodeView nodeView, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)eventBroker);
        NodeView[] nodeViewArray = nodeView.getVariations();
        if (nodeViewArray.length == 0) {
            return false;
        }
        int n2 = nodeView.getSelectedVariationIndex();
        switch (n) {
            case 0x1000003: {
                int n3 = --n2;
                if (n3 < 0) {
                    n3 = nodeViewArray.length - 1;
                }
                eventBroker.executeCommand(new SelectVariation(n3));
                return true;
            }
            case 0x1000004: {
                eventBroker.executeCommand(new SelectVariation(++n2 % nodeViewArray.length));
                return true;
            }
        }
        for (int i = 0; i < variationKeys_s_.length; ++i) {
            if (n != variationKeys_s_[i]) continue;
            if (i < nodeViewArray.length) {
                eventBroker.executeCommand(new SelectVariation(i));
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean handleSelectNode(int n, NodeList nodeList, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeList, (Object)eventBroker);
        switch (n) {
            case 58: {
                ViewerUtils.goToNextVariationNode(nodeList, eventBroker);
                return true;
            }
            case 64: {
                ViewerUtils.goToPrevVariationNode(nodeList, eventBroker);
                return true;
            }
            case 93: {
                ViewerUtils.goToNextCommentNode(nodeList, eventBroker);
                return true;
            }
            case 91: {
                ViewerUtils.goToPrevCommentNode(nodeList, eventBroker);
                return true;
            }
        }
        return false;
    }

    private static void goToNextVariationNode(NodeList nodeList, EventBroker eventBroker) {
        int n = nodeList.getPositionIndex();
        int n2 = nodeList.size() - 1;
        ++n;
        while (n < nodeList.size()) {
            NodeView nodeView = nodeList.getNodeView(n);
            if (0 != nodeView.getVariations().length) {
                n2 = n;
                break;
            }
            ++n;
        }
        eventBroker.executeCommand(new NodeSelectionCommand(n2));
    }

    private static void goToPrevVariationNode(NodeList nodeList, EventBroker eventBroker) {
        int n = nodeList.getPositionIndex();
        int n2 = 0;
        --n;
        while (0 <= n) {
            NodeView nodeView = nodeList.getNodeView(n);
            if (0 != nodeView.getVariations().length) {
                n2 = n;
                break;
            }
            --n;
        }
        eventBroker.executeCommand(new NodeSelectionCommand(n2));
    }

    private static void goToNextCommentNode(NodeList nodeList, EventBroker eventBroker) {
        int n = nodeList.getPositionIndex();
        int n2 = nodeList.size() - 1;
        ++n;
        while (n < nodeList.size()) {
            NodeView nodeView = nodeList.getNodeView(n);
            if (null != nodeView.getProperty(SgfId.COMMENT)) {
                n2 = n;
                break;
            }
            ++n;
        }
        eventBroker.executeCommand(new NodeSelectionCommand(n2));
    }

    private static void goToPrevCommentNode(NodeList nodeList, EventBroker eventBroker) {
        int n = nodeList.getPositionIndex();
        int n2 = 0;
        --n;
        while (0 <= n) {
            NodeView nodeView = nodeList.getNodeView(n);
            if (null != nodeView.getProperty(SgfId.COMMENT)) {
                n2 = n;
                break;
            }
            --n;
        }
        eventBroker.executeCommand(new NodeSelectionCommand(n2));
    }

    public static void setupDriiRootDirectory(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (!collection.get(0).getGameType().equals(GameType.DRILL) || collection.getFile() != null) {
            return;
        }
        String[] stringArray = BasicFinder.findData(collection.get(0).getSequence(), SgfId.INPUT_FILES);
        stringArray = stringArray == null ? new String[]{} : stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                hashSet.add(".");
                continue;
            }
            hashSet.add(string.substring(0, n));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuilder.append(string).append(", ");
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if ((object = Yukinoshita.application().openDirectoryDialog(NT_CHOOSE_DRILL_ROOT_DIRECTORY.get(), MSG_CHOOSE_DRILL_ROOT_DIRECTORY.get((Object)stringBuilder.toString()), Ios.getCurrentDirectory())) == null) {
            object = Ios.getCurrentDirectory();
        }
        object = new File((File)object, NT_AUTO_DRILL_NAME.get());
        try {
            object = Ios.createTemporaryFile((File)object, 4);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        collection.setFile((File)object);
    }

    protected ViewerUtils() {
    }

    static {
        ViewerUtils.variationKeys_s_[0] = 32;
        for (int i = 1; i < variationKeys_s_.length; ++i) {
            ViewerUtils.variationKeys_s_[i] = (char)(97 + i - 1);
        }
    }
}

