/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.sgf.util.SgfArgumentChecker;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.model.cmd.StartSolvingProblem;
import org.unitarou.yukinoshita.view.cmd.AbstractCommand4View;

public class WrapperCommand
extends AbstractCommand4View {
    private static final Log log_s_ = LogFactory.getLog(WrapperCommand.class);
    private static Set<Class<? extends Command4NodeList>> permittedCommandInView_s_ = new HashSet<Class<? extends Command4NodeList>>(2);
    private final Command4NodeList wrappedCommand_;

    public WrapperCommand(Command4NodeList command4NodeList) {
        ArgumentChecker.throwIfNull((Object)command4NodeList);
        this.wrappedCommand_ = command4NodeList;
    }

    public void execute() {
        this.throwIfNotSetup();
        if (!this.isEditMode().booleanValue() && !permittedCommandInView_s_.contains(this.wrappedCommand_.getClass())) {
            log_s_.warn("Execute command in non-edit mode (BUG ?)." + this.wrappedCommand_);
        }
        GameMediator gameMediator = this.getCollectionEditor().getActiveGame();
        CommandDriver.Status status = gameMediator.executeCommand(this.wrappedCommand_);
        this.fireCommandDriverExecuted(status);
        block8: for (ModelInfluence modelInfluence : this.wrappedCommand_.getInfluence()) {
            switch (modelInfluence) {
                case COLLECTION: {
                    this.fireCollectionMonitorUpdate();
                    continue block8;
                }
                case ROOT_GAME_TREE: {
                    this.fireGameViewerUpdate();
                    continue block8;
                }
                case NODE_GAMEINFO: {
                    this.fireGameInfoNodeUpdate();
                    continue block8;
                }
                case NODE_DOWNWARD: {
                    this.fireNodeListUpdate();
                    continue block8;
                }
                case NODE_PEVIOUS: {
                    this.fireNodeViewerUpdate(-1);
                    continue block8;
                }
                case NODE_CURRENT: {
                    this.fireNodeViewerUpdate();
                    continue block8;
                }
            }
            log_s_.warn("Unsupported influence type, ignore it:" + (Object)((Object)modelInfluence));
        }
        SgfArgumentChecker.throwIfInvalid(this.getCollectionEditor().getActiveGame().getRootGameTree());
    }

    static {
        permittedCommandInView_s_.add(SelectVariation.class);
        permittedCommandInView_s_.add(StartSolvingProblem.class);
    }
}

