/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.unitarou.jface.pref.CodecServer;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.DefaultContext;

public class JFaceContext
extends DefaultContext {
    private static final Log log_s_ = LogFactory.getLog(JFaceContext.class);
    private final PreferenceStore preferenceStore_ = new PreferenceStore("./ps.preference");
    private final PropertyChangeListener listener_ = new PropertyChangeListener();

    public IPreferenceStore getPreferenceStore() {
        this.preferenceStore_.removePropertyChangeListener(this.listener_);
        CurrentContext currentContext = this.getCurrent(null);
        for (String string : this.rootKeys()) {
            String string2;
            Object object;
            String string3 = this.encode(string, currentContext.getAttribute(string));
            if (string3 != null) {
                this.preferenceStore_.setValue(string, string3);
            }
            if ((object = this.getDefault(string)) == null || (string2 = this.encode(string, object)) == null) continue;
            this.preferenceStore_.setDefault(string, string2);
        }
        this.preferenceStore_.addPropertyChangeListener(this.listener_);
        return this.preferenceStore_;
    }

    private String encode(String string, Object object) {
        if (object == null) {
            log_s_.warn("Null value found. key=" + string);
            return null;
        }
        String string2 = CodecServer.instance().encodeNoCodec(object);
        if (string2 == null) {
            log_s_.warn("Can't encode. key=" + string + ", obj=" + object);
            return null;
        }
        return string2;
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CurrentContext currentContext = JFaceContext.this.getCurrent(null);
            String string = propertyChangeEvent.getProperty();
            Object object = propertyChangeEvent.getNewValue();
            String string2 = object != null ? object.toString() : "";
            Object object2 = currentContext.getAttribute(string);
            if (object2 == null) {
                log_s_.warn("Null value found. key=" + string);
                return;
            }
            Object object3 = CodecServer.instance().decode(object2, string2);
            if (object3 == null) {
                log_s_.warn("Can't decode. key=" + string + ", value=" + string2);
                return;
            }
            currentContext.setAttribute(string, object3);
            JFaceContext.this.fireAttributeChanged(new String[]{string});
        }
    }
}

