/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRootGameTreeAction
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(AbstractRootGameTreeAction.class);
    private Reference<GameFrameController> refGfc_ = new WeakReference<Object>(null);
    private final Adapter adapter_ = new Adapter();

    public AbstractRootGameTreeAction(WindowController windowController) {
        super(windowController);
        windowController.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    protected final GameFrameController getGameFrameController() {
        return this.refGfc_.get();
    }

    protected EnumSet<SelectTargetFileDialog.Type> getTypes() {
        EnumSet<SelectTargetFileDialog.Type> enumSet = EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE);
        GameFrameController gameFrameController = this.getGameFrameController();
        if (gameFrameController == null) {
            return enumSet;
        }
        GameType gameType = gameFrameController.getCollectionEditor().getActiveGame().getGameType();
        switch (gameType) {
            case GAME: {
                enumSet.add(SelectTargetFileDialog.Type.PERMITS_GAME);
                return enumSet;
            }
            case PROBLEM: {
                enumSet.add(SelectTargetFileDialog.Type.PERMITS_PROBLEM);
                return enumSet;
            }
        }
        log_s_.warn("Unsupported game type (Maybe BUG). TYPE:" + gameType.name());
        return EnumSet.noneOf(SelectTargetFileDialog.Type.class);
    }

    protected boolean isRunnable(GameFrameController gameFrameController) {
        if (gameFrameController == null || !gameFrameController.isEditMode()) {
            return false;
        }
        Collection collection = gameFrameController.getCollection();
        if (collection.size() < 2) {
            return false;
        }
        return !GameType.DRILL.equals(collection.get(0).getGameType());
    }

    protected void notifyCollectionViewer(GameFrameController gameFrameController) {
        CollectionEditor collectionEditor = gameFrameController.getCollectionEditor();
        for (CollectionMonitor collectionMonitor : gameFrameController.getEventBroker().getListeners(CollectionMonitor.class)) {
            collectionMonitor.update(collectionEditor);
        }
    }

    protected void changeForLastGame(GameFrameController gameFrameController) {
        GameChangeCommand gameChangeCommand = new GameChangeCommand(gameFrameController.getCollectionEditor().size() - 1);
        gameFrameController.getEventBroker().executeCommand(gameChangeCommand);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements WindowControllerListener,
    ControllerStatusMonitor,
    CollectionMonitor,
    GameMonitor {
        private Adapter() {
        }

        @Override
        public void changeActive(GameFrameController gameFrameController) {
            GameFrameController gameFrameController2 = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            if (gameFrameController2 != null) {
                gameFrameController2.getEventBroker().removeView(AbstractRootGameTreeAction.this);
            }
            if (gameFrameController != null) {
                gameFrameController.getEventBroker().addView(AbstractRootGameTreeAction.this);
            }
            AbstractRootGameTreeAction.this.refGfc_ = new WeakReference<GameFrameController>(gameFrameController);
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(gameFrameController));
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        @Override
        public void setEditMode(boolean bl) {
            GameFrameController gameFrameController = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(gameFrameController));
        }

        @Override
        public void update(CollectionEditor collectionEditor) {
            GameFrameController gameFrameController = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(gameFrameController));
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
        }

        @Override
        public void update(GameMediator gameMediator) {
            GameFrameController gameFrameController = (GameFrameController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(gameFrameController));
        }
    }
}

