/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.FireMonitorCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsAction
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SaveAsAction.class);
    private final Adapter adapter_ = new Adapter();

    public SaveAsAction(WindowController windowController) {
        super(windowController);
        windowController.addListener(this.adapter_);
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Control control = Display.getCurrent().getFocusControl();
        control.getParent().forceFocus();
        control.forceFocus();
        GameFrameController gameFrameController = this.controller_.getActive();
        File file = IgoFileDialog.askSaveFile(gameFrameController.getCollection());
        if (file == null) {
            return;
        }
        try {
            EnumSet<FileManager.SaveResult> enumSet = FileManager.instance().saveAs(gameFrameController.getCollection(), file);
            if (enumSet.contains((Object)FileManager.SaveResult.CHANGE_CHARSET)) {
                FireMonitorCommand fireMonitorCommand = new FireMonitorCommand(ModelInfluence.ROOT_GAME_TREE);
                gameFrameController.getEventBroker().executeCommand(fireMonitorCommand);
            }
            if (enumSet.contains((Object)FileManager.SaveResult.SAVE_OK)) {
                gameFrameController.clearChangedFlag();
            }
        }
        catch (YukinoshitaException yukinoshitaException) {
            log_s_.error(BasicMessages.NT_FILE_SAVE_FAILURE.get(), yukinoshitaException);
            MessageDialog.openError(Display.getCurrent().getActiveShell(), BasicMessages.NT_FILE_SAVE_FAILURE.get(), yukinoshitaException.getLocalizedMessage());
        }
    }

    private class Adapter
    implements WindowControllerListener {
        private Adapter() {
        }

        public void changeActive(GameFrameController gameFrameController) {
            SaveAsAction.this.setEnabled(gameFrameController != null);
        }
    }
}

