/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectProviderAction<T extends Provider>
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SelectProviderAction.class);
    private final T provider_;
    private final Class<T> providerInterface_;
    private WindowController controller_;
    private final Adapter adapter_;

    public SelectProviderAction(Class<T> clazz, T t) {
        super("", 8);
        ArgumentChecker.throwIfNull(clazz, t);
        if (!clazz.isAssignableFrom(t.getClass())) {
            throw new IllegalArgumentException("provider: " + t + " must be subclass of " + clazz);
        }
        this.adapter_ = new Adapter();
        this.providerInterface_ = clazz;
        this.provider_ = t;
        this.setText(this.provider_.displayName());
        CoordinatesLabelProvider coordinatesLabelProvider = Yukinoshita.context(null).getProvider(CoordinatesLabelProvider.class);
        this.setChecked(t.equals(coordinatesLabelProvider));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.warn("#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        this.controller_.getActive().changeProvider(this.providerInterface_, (Provider)this.provider_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    public SelectProviderAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        if (this.controller_ != null) {
            this.controller_.removListener(this.adapter_);
        }
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    private class Adapter
    implements WindowControllerListener,
    ControllerStatusMonitor {
        private GameFrameController gfc_ = null;

        private Adapter() {
        }

        public void changeActive(GameFrameController gameFrameController) {
            if (this.gfc_ != null) {
                this.gfc_.getEventBroker().removeView(SelectProviderAction.this);
            }
            this.gfc_ = gameFrameController;
            this.updateEnableStatus();
        }

        public void setEditMode(boolean bl) {
            this.updateEnableStatus();
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        private void updateEnableStatus() {
            if (this.gfc_ == null) {
                SelectProviderAction.this.setEnabled(false);
            } else {
                this.gfc_.getEventBroker().addView(SelectProviderAction.this);
                GameType gameType = this.gfc_.getCollectionEditor().getActiveGame().getGameType();
                SelectProviderAction.this.setEnabled(this.gfc_.isEditMode() || !GameType.PROBLEM.equals(gameType));
            }
        }
    }
}

