/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.swt.EnumCombo;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.ann.AnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.CharsetEditor;
import org.unitarou.yukinoshita.view.jface.ann.Editor;
import org.unitarou.yukinoshita.view.jface.ann.SizeEditor;
import org.unitarou.yukinoshita.view.jface.util.UEnumCombo;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootAnnotationPanel
extends AnnotationPanel {
    private static final Message CLB_EDIT_ADVANCED_TYPE = new Message(RootAnnotationPanel.class, "clbEditAdvancedType");
    private static final SgfId[] TYPE_ENUM = new SgfId[]{SgfId.GAME_MODE, SgfId.STYLE};
    private final Map<SgfId, Object> widgetMap_;
    private GameMediator gameMediator_ = null;
    private Composite frame_;
    private Button chAdvancedEditMode_;
    private final CharsetEditor charsetEditor_;
    private final Adapter adapter_;
    private boolean isEditMode_ = false;
    private final ComboFocusLost comboFocusLost_;
    private final TextListener textListener_;
    private final ModifyListened modifyListened_;
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

    public RootAnnotationPanel() {
        this.widgetMap_ = new HashMap<SgfId, Object>();
        this.charsetEditor_ = new CharsetEditor();
        this.adapter_ = new Adapter();
        this.comboFocusLost_ = new ComboFocusLost();
        this.textListener_ = new TextListener();
        this.modifyListened_ = new ModifyListened();
    }

    @Override
    protected EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    @Override
    public void close() {
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(new GridLayout(2, false));
        this.createCbEditAdvancedType(this.frame_);
        this.createApplicationEdit(this.frame_);
        this.createCharset(this.frame_);
        this.createEnumCombo2(this.frame_, SgfId.FILE_FORMAT, EnumSet.allOf(FileFormat.class));
        this.createEnumCombo(this.frame_, SgfId.GAME_MODE, GameMode.class);
        this.createEnumCombo2(this.frame_, SgfId.GAME_TYPE, EnumSet.allOf(GameType.class));
        this.createEnumCombo(this.frame_, SgfId.STYLE, Style.class);
        this.createSizeEditor(this.frame_);
        this.adapter_.setEditMode(this.isEditMode_);
        this.frame_.pack();
        this.updateImpl();
        return this.frame_;
    }

    private void createCbEditAdvancedType(Composite composite) {
        this.chAdvancedEditMode_ = new Button(composite, 0x800020);
        this.chAdvancedEditMode_.setSelection(false);
        this.chAdvancedEditMode_.setText(CLB_EDIT_ADVANCED_TYPE.get());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.chAdvancedEditMode_.setLayoutData(gridData);
        this.chAdvancedEditMode_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RootAnnotationPanel.this.setEnableAdvanced(((Button)selectionEvent.widget).getSelection());
            }
        });
    }

    private void setEnableAdvanced(boolean bl) {
        Text text = (Text)this.widgetMap_.get(SgfId.APPLICATION);
        text.setEditable(bl && this.isEditMode_);
        EnumCombo enumCombo = (EnumCombo)this.widgetMap_.get(SgfId.FILE_FORMAT);
        enumCombo.getCombo().setEnabled(bl && this.isEditMode_);
        UEnumCombo uEnumCombo = (UEnumCombo)this.widgetMap_.get(SgfId.GAME_MODE);
        uEnumCombo.getCombo().setEnabled(bl && this.isEditMode_);
        SizeEditor sizeEditor = (SizeEditor)this.widgetMap_.get(SgfId.SIZE);
        sizeEditor.setAdvanced(bl);
    }

    private void createApplicationEdit(Composite composite) {
        Label label = new Label(composite, 131072);
        label.setText(SgfId.APPLICATION.displayName());
        label.setLayoutData(new GridData(128));
        Text text = new Text(composite, 2052);
        text.setLayoutData(new GridData(768));
        text.addFocusListener(this.textListener_);
        text.addModifyListener(this.textListener_);
        text.setData(SgfId.APPLICATION);
        this.widgetMap_.put(SgfId.APPLICATION, text);
    }

    private void createCharset(Composite composite) {
        Label label = new Label(composite, 131072);
        label.setText(SgfId.CHARSET.displayName());
        label.setLayoutData(new GridData(128));
        this.charsetEditor_.createContents(composite);
        this.charsetEditor_.addModifyListener(this.modifyListened_);
        this.widgetMap_.put(SgfId.CHARSET, this.charsetEditor_);
    }

    private <T extends UEnum> Combo createEnumCombo(Composite composite, SgfId sgfId, Class<T> clazz) {
        Label label = new Label(composite, 131072);
        label.setText(sgfId.displayName());
        label.setLayoutData(new GridData(128));
        UEnumCombo<T> uEnumCombo = new UEnumCombo<T>(clazz);
        Combo combo = (Combo)uEnumCombo.createContents(composite);
        combo.setLayoutData(new GridData(768));
        combo.addFocusListener(this.comboFocusLost_);
        combo.setData(sgfId);
        this.widgetMap_.put(sgfId, uEnumCombo);
        return combo;
    }

    private <T extends Enum<T>> Combo createEnumCombo2(Composite composite, SgfId sgfId, EnumSet<T> enumSet) {
        Label label = new Label(composite, 131072);
        label.setText(sgfId.displayName());
        label.setLayoutData(new GridData(128));
        EnumCombo<T> enumCombo = new EnumCombo<T>(enumSet);
        Combo combo = (Combo)enumCombo.createContents(composite);
        combo.setLayoutData(new GridData(768));
        combo.addFocusListener(this.comboFocusLost_);
        combo.setData(sgfId);
        this.widgetMap_.put(sgfId, enumCombo);
        return combo;
    }

    private void createSizeEditor(Composite composite) {
        Label label = new Label(composite, 131072);
        label.setText(SgfId.SIZE.displayName());
        label.setLayoutData(new GridData(128));
        GridData gridData = new GridData(768);
        SizeEditor sizeEditor = new SizeEditor();
        Control control = sizeEditor.createContents(composite);
        sizeEditor.addModifyListener(this.modifyListened_);
        control.setLayoutData(gridData);
        this.widgetMap_.put(SgfId.SIZE, sizeEditor);
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private NodeView getRootNodeView() {
        if (this.gameMediator_ == null) {
            throw new IllegalStateException();
        }
        return this.gameMediator_.getNodeList().getNodeView(0);
    }

    private void updateImpl() {
        if (this.frame_ == null) {
            return;
        }
        this.setModelUpdateMode(true);
        NodeView nodeView = this.getRootNodeView();
        Property property = nodeView.getProperty(SgfId.APPLICATION);
        Text text = (Text)this.widgetMap_.get(SgfId.APPLICATION);
        text.setText(property != null ? property.getString() : "");
        property = nodeView.getProperty(SgfId.CHARSET);
        this.charsetEditor_.setDatum(property != null ? property.getString() : "");
        property = nodeView.getProperty(SgfId.FILE_FORMAT);
        EnumCombo enumCombo = (EnumCombo)this.widgetMap_.get(SgfId.FILE_FORMAT);
        FileFormat fileFormat = null;
        if (property != null) {
            try {
                fileFormat = FileFormat.parse(property.getString());
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
        enumCombo.select(fileFormat);
        property = nodeView.getProperty(SgfId.GAME_MODE);
        UEnumCombo uEnumCombo = (UEnumCombo)this.widgetMap_.get(SgfId.GAME_MODE);
        uEnumCombo = (UEnumCombo)this.widgetMap_.get(SgfId.GAME_MODE);
        GameMode gameMode = null;
        if (property != null) {
            gameMode = GameMode.parse(property.getString());
        }
        uEnumCombo.select(gameMode);
        property = nodeView.getProperty(SgfId.GAME_TYPE);
        EnumCombo enumCombo2 = (EnumCombo)this.widgetMap_.get(SgfId.GAME_TYPE);
        GameType gameType = null;
        if (property != null) {
            try {
                gameType = GameType.parse(property.getString());
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
        enumCombo2.select(gameType);
        property = nodeView.getProperty(SgfId.STYLE);
        uEnumCombo = (UEnumCombo)this.widgetMap_.get(SgfId.STYLE);
        Style style = null;
        if (property != null) {
            style = Style.parse(property.getString());
        }
        uEnumCombo.select(style);
        property = nodeView.getProperty(SgfId.SIZE);
        SizeEditor sizeEditor = (SizeEditor)this.widgetMap_.get(SgfId.SIZE);
        SgfSize sgfSize = SgfSize.DEFAULT;
        if (property != null) {
            try {
                sgfSize = SgfSize.parse(property.getString());
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
        sizeEditor.select(sgfSize);
        this.setModelUpdateMode(false);
    }

    private class ModifyListened
    implements ModifyListener {
        private ModifyListened() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            SgfId sgfId = (SgfId)modifyEvent.widget.getData();
            String string = ((Editor)RootAnnotationPanel.this.widgetMap_.get(sgfId)).getDatum();
            RootAnnotationPanel.this.updateProperty(string, sgfId, RootAnnotationPanel.this.getRootNodeView());
        }
    }

    private class TextListener
    extends FocusAdapter
    implements ModifyListener {
        private final Map<Text, String> lastStringMap_ = new HashMap<Text, String>();

        private TextListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string;
            int n;
            Text text = (Text)modifyEvent.widget;
            String string2 = this.lastStringMap_.get(text);
            if (string2 == null) {
                string2 = "";
            }
            if ((n = Yukinoshita.context(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE)) <= Strings.calcDiffSize(string2, string = text.getText())) {
                this.update(text);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.update((Text)focusEvent.widget);
        }

        private void update(Text text) {
            if (!RootAnnotationPanel.this.isEditMode_) {
                return;
            }
            String string = text.getText();
            SgfId sgfId = (SgfId)text.getData();
            RootAnnotationPanel.this.updateProperty(string, sgfId, RootAnnotationPanel.this.getRootNodeView());
            this.lastStringMap_.put(text, string);
        }
    }

    private class ComboFocusLost
    extends FocusAdapter {
        private ComboFocusLost() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!RootAnnotationPanel.this.isEditMode_) {
                return;
            }
            Combo combo = (Combo)focusEvent.widget;
            SgfId sgfId = (SgfId)combo.getData();
            Object v = RootAnnotationPanel.this.widgetMap_.get(sgfId);
            String string = null;
            if (v instanceof UEnumCombo) {
                UEnumCombo uEnumCombo = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(sgfId);
                string = uEnumCombo.getSelectedDatum();
            } else if (v instanceof EnumCombo) {
                EnumCombo enumCombo = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(sgfId);
                Object e = enumCombo.getSelected();
                TypedString typedString = (TypedString)e;
                string = typedString != null ? typedString.getString() : "";
            }
            RootAnnotationPanel.this.updateProperty(string, sgfId, RootAnnotationPanel.this.getRootNodeView());
        }
    }

    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    EventBrokerMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            RootAnnotationPanel.this.eventBroker_.removeView(RootAnnotationPanel.this);
            RootAnnotationPanel.this.eventBroker_.removeView(RootAnnotationPanel.this.charsetEditor_);
            RootAnnotationPanel.this.eventBroker_ = eventBroker;
            RootAnnotationPanel.this.eventBroker_.addView(RootAnnotationPanel.this);
            RootAnnotationPanel.this.eventBroker_.addView(RootAnnotationPanel.this.charsetEditor_);
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            RootAnnotationPanel.this.gameMediator_ = gameMediator;
            RootAnnotationPanel.this.updateImpl();
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            RootAnnotationPanel.this.updateImpl();
        }

        public void setEditMode(boolean bl) {
            Object object;
            RootAnnotationPanel.this.isEditMode_ = bl;
            if (RootAnnotationPanel.this.frame_ == null) {
                return;
            }
            for (int i = 0; i < TYPE_ENUM.length; ++i) {
                object = (UEnumCombo)RootAnnotationPanel.this.widgetMap_.get(TYPE_ENUM[i]);
                ((UEnumCombo)object).setEditable(bl);
            }
            EnumCombo enumCombo = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.FILE_FORMAT);
            enumCombo.getCombo().setEnabled(bl);
            enumCombo = (EnumCombo)RootAnnotationPanel.this.widgetMap_.get(SgfId.GAME_TYPE);
            enumCombo.getCombo().setEnabled(bl);
            object = (Text)RootAnnotationPanel.this.widgetMap_.get(SgfId.APPLICATION);
            ((Text)object).setEditable(bl);
            SizeEditor sizeEditor = (SizeEditor)RootAnnotationPanel.this.widgetMap_.get(SgfId.SIZE);
            sizeEditor.setEditable(bl);
            RootAnnotationPanel.this.charsetEditor_.setEditable(bl);
            RootAnnotationPanel.this.setEnableAdvanced(RootAnnotationPanel.this.chAdvancedEditMode_.getSelection());
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

