/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.swt.Swts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.model.db.MetaDataFactory;
import org.unitarou.yukinoshita.view.jface.board.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;

public class FingerprintIgoBoard
implements WidgetContainer {
    private BoardPainter boardPainter_ = new SimpleBoardPainter();
    private RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private StonePainter stonePainter_ = StonePainter.CONTEXT.defaultProvider();
    private Canvas canvas_ = null;
    private Image boardImage_ = null;
    private FileSearched fileSearched_ = new FileSearched();

    public FingerprintIgoBoard() {
        this.fileSearched_.setWidth(SgfSize.DEFAULT.width());
        this.fileSearched_.setHeight(SgfSize.DEFAULT.height());
        this.fileSearched_.setFingerprint(MetaDataFactory.instance().calcFingerprint(new RootGameTree()));
    }

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.canvas_ = new Canvas(composite, 262144);
        this.boardImage_ = new Image((Device)this.canvas_.getDisplay(), this.getBoardSize());
        this.canvas_.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (FingerprintIgoBoard.this.boardImage_ == null) {
                    FingerprintIgoBoard.this.drawImage();
                }
                paintEvent.gc.drawImage(FingerprintIgoBoard.this.boardImage_, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
            }
        });
        this.canvas_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Swts.disposeQuietly(FingerprintIgoBoard.this.boardImage_);
                FingerprintIgoBoard.this.boardImage_ = null;
            }
        });
        return this.canvas_;
    }

    public Control getControl() {
        return this.canvas_;
    }

    public void close() {
        Swts.disposeQuietly(this.boardImage_);
    }

    public void updateImage(FileSearched fileSearched) {
        ArgumentChecker.throwIfNull((Object)fileSearched);
        this.fileSearched_ = fileSearched;
        if (this.canvas_ == null) {
            return;
        }
        Swts.disposeQuietly(this.boardImage_);
        this.boardImage_ = null;
        this.canvas_.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage() {
        GC gC = null;
        try {
            this.boardImage_ = new Image((Device)this.canvas_.getDisplay(), this.getBoardSize());
            gC = new GC(this.boardImage_);
            this.drawImageImpl(gC);
        }
        catch (Throwable throwable) {
            Swts.disposeQuietly(gC);
            throw throwable;
        }
        Swts.disposeQuietly(gC);
    }

    private Rectangle getBoardSize() {
        if (this.canvas_ == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        Rectangle rectangle = this.canvas_.getBounds();
        if (rectangle.width == 0 | rectangle.height == 0) {
            return new Rectangle(0, 0, 100, 100);
        }
        return rectangle;
    }

    private void drawImageImpl(GC gC) {
        SgfSize sgfSize = SgfSize.create(this.fileSearched_.getWidth(), this.fileSearched_.getHeight());
        SgfRectangle sgfRectangle = this.calcViewArea(sgfSize);
        Rectangle rectangle = this.boardImage_.getBounds();
        int n = Math.min(rectangle.width / sgfRectangle.width(), rectangle.height / sgfRectangle.height());
        gC.setBackground(this.canvas_.getDisplay().getSystemColor(22));
        gC.fillRectangle(rectangle);
        if (n < 3) {
            return;
        }
        Point point = new Point((rectangle.width - n * sgfRectangle.width()) / 2, (rectangle.height - n * sgfRectangle.height()) / 2);
        byte[] byArray = this.fileSearched_.getFingerprint();
        MetaDataFactory metaDataFactory = MetaDataFactory.instance();
        SgfPoint sgfPoint = sgfRectangle.getStart();
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        for (int i = sgfPoint.y(); i <= sgfRectangle.getEnd().y(); ++i) {
            for (int j = sgfPoint.x(); j <= sgfRectangle.getEnd().x(); ++j) {
                SgfPoint sgfPoint2 = SgfPoint.create(sgfSize, j, i);
                Rectangle rectangle2 = new Rectangle((j - 1) * n + point.x, (i - 1) * n + point.y, n, n);
                this.boardPainter_.paint(gC, sgfPoint2, rectangle2);
                this.ruledLinePainter_.paint(gC, sgfPoint2, rectangle2);
                SgfColor sgfColor = metaDataFactory.getColor(byArray, sgfSize, j, i);
                if (sgfColor == null) continue;
                Stone stone = new Stone(sgfColor, sgfPoint2, null);
                this.setParameters(stonePainterParameter, stone);
                this.stonePainter_.paintStone(gC, rectangle2, stonePainterParameter);
            }
        }
    }

    private SgfRectangle calcViewArea(SgfSize sgfSize) {
        int n;
        int n2;
        int n3;
        SgfRectangle sgfRectangle = new SgfRectangle();
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height()));
        if (this.fileSearched_.getGameType() != GameType.PROBLEM.getValue()) {
            return sgfRectangle;
        }
        MetaDataFactory metaDataFactory = MetaDataFactory.instance();
        byte[] byArray = this.fileSearched_.getFingerprint();
        int n4 = n3 = sgfSize.width();
        while (n4 >= 2) {
            n2 = 0;
            for (n = 1; n <= sgfSize.height(); ++n) {
                if (null == metaDataFactory.getColor(byArray, sgfSize, n4, n)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) break;
            n3 = n4--;
        }
        n2 = n4 = sgfSize.height();
        while (n2 >= 2) {
            n = 0;
            for (int i = 1; i <= sgfSize.width(); ++i) {
                if (null == metaDataFactory.getColor(byArray, sgfSize, i, n2)) continue;
                n = 1;
                break;
            }
            if (n != 0) break;
            n4 = n2--;
        }
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, n3, n4));
        return sgfRectangle;
    }

    private void setParameters(StonePainterParameter stonePainterParameter, Stone stone) {
        stonePainterParameter.setSgfColor(stone.getColor());
        stonePainterParameter.setLastMove(false);
        stonePainterParameter.setTransient(false);
    }
}

