/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.EnumSet;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class LearnEventDelegator
implements EventDelegator {
    private SgfColor selectedColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.selectedColor_ = SgfColor.BLACK;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation blockSituation = new BlockSituation();
        EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
        if (enumSet.contains((Object)SgfPointType.FORBIDDEN) || !enumSet.contains((Object)SgfPointType.EMPTY) || nodeView.isLast()) {
            return blockSituation;
        }
        NodeView nodeView2 = this.next(nodeView);
        SgfColor sgfColor = nodeView2.getMove().getColor();
        if (blockStatus.getPoint() == null) {
            blockSituation.setCursor(CanvasCursor.PASS.get(sgfColor));
        } else {
            blockSituation.setCursor(CanvasCursor.MOVE.get(sgfColor));
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
            }
            blockSituation.setTransientProperty(sgfColor.moveType().makeProperty(blockStatus.getPoint()));
        }
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        switch (mouseEvent.button) {
            case 3: {
                eventBroker.executeCommand(new NodeJumpCommand(-1));
                return true;
            }
            case 1: {
                NodeView nodeView2 = this.next(nodeView);
                if (nodeView2 == null) {
                    return false;
                }
                SgfPoint sgfPoint = nodeView2.getMove().getPoint();
                if (sgfPoint != null && !sgfPoint.equals(blockStatus.getPoint()) && !sgfPoint.condition().equals((Object)SgfPointType.PASS)) break;
                eventBroker.executeCommand(new NodeJumpCommand(1));
                return true;
            }
        }
        return false;
    }

    private NodeView next(NodeView nodeView) {
        if (nodeView.isLast()) {
            return null;
        }
        NodeList nodeList = nodeView.getNodeList();
        return nodeList.getNodeView(nodeList.getPositionIndex() + 1);
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }
}

