/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.unitarou.jface.CursorResource;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.swt.Line;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

public class LineEventDelegator
implements EventDelegator {
    private static final State FREE = new State("free");
    private static final State BOUND = new State("bound");
    private static final CursorResource[] decorationCursors_s_;
    private static final SgfId[] markIds_s_;
    private int currentLineIndex_ = 0;
    private State state_ = FREE;
    private SgfPoint startPoint_;

    public void resetStatus() {
        this.currentLineIndex_ = 0;
        this.state_ = FREE;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent);
        BlockSituation blockSituation = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            return blockSituation;
        }
        blockSituation.setCursor(decorationCursors_s_[this.currentLineIndex_].getCursor());
        if (BOUND.equals(this.state_)) {
            if (this.startPoint_.equals(blockStatus.getPoint())) {
                return blockSituation;
            }
            SgfLine sgfLine = new SgfLine(this.startPoint_, blockStatus.getPoint());
            blockSituation.setTransientProperty(markIds_s_[this.currentLineIndex_].makeProperty(sgfLine));
        } else if (FREE.equals(this.state_)) {
            Property property = this.findTouchedLine(nodeView, blockStatus, mouseEvent);
            if (property != null) {
                blockSituation.setTransientProperty(property);
            }
        } else assert (false) : "Unknown state_:" + this.state_;
        return blockSituation;
    }

    private Property findTouchedLine(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        TreeMap<Double, Property> treeMap = new TreeMap<Double, Property>();
        for (SgfId sgfId : markIds_s_) {
            Property property = nodeView.getProperty(sgfId);
            if (property == null) continue;
            for (String string : property.getStrings()) {
                Point point;
                SgfLine sgfLine = SgfLine.parseQuietly(nodeView.getSize(), string);
                if (sgfLine == null) continue;
                Point point2 = Geometry.centerPoint(blockStatus.getRectangle());
                int n = blockStatus.getRectangle().width;
                Point point3 = new Point(point2.x - (blockStatus.getPoint().x() - sgfLine.getStart().x()) * n, point2.y - (blockStatus.getPoint().y() - sgfLine.getStart().y()) * n);
                if (point3.equals(point = new Point(point2.x - (blockStatus.getPoint().x() - sgfLine.getEnd().x()) * n, point2.y - (blockStatus.getPoint().y() - sgfLine.getEnd().y()) * n))) continue;
                double d = new Line(point3, point).distance(new Point(mouseEvent.x, mouseEvent.y));
                treeMap.put(new Double(d), new Property(sgfId, string));
            }
        }
        if (treeMap.isEmpty()) {
            return null;
        }
        if ((Double)treeMap.firstKey() < 6.0) {
            Property property = (Property)treeMap.get(treeMap.firstKey());
            return property;
        }
        return null;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (blockStatus.getPoint() == null) {
            return false;
        }
        if (FREE.equals(this.state_)) {
            return this.executeEventInFree(nodeView, blockStatus, mouseEvent, eventBroker);
        }
        if (BOUND.equals(this.state_)) {
            if (this.startPoint_.equals(blockStatus.getPoint())) {
                return false;
            }
            return this.executeEventInBound(nodeView, blockStatus, mouseEvent, eventBroker);
        }
        assert (false) : "Unknown state: " + this.state_;
        return false;
    }

    private boolean executeEventInFree(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        Property property;
        if (mouseEvent.button == 1) {
            this.startPoint_ = blockStatus.getPoint();
            this.state_ = BOUND;
            return false;
        }
        if (mouseEvent.button == 3 && (property = this.findTouchedLine(nodeView, blockStatus, mouseEvent)) != null) {
            eventBroker.executeCommand(new UpdateProperty(new Property[]{property}, null, null));
            return true;
        }
        return false;
    }

    private boolean executeEventInBound(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        if (mouseEvent.button == 1) {
            SgfLine sgfLine = new SgfLine(this.startPoint_, blockStatus.getPoint());
            Property property = new Property(markIds_s_[this.currentLineIndex_], sgfLine.getString());
            eventBroker.executeCommand(new UpdateProperty(new Property[0], property, null));
            this.state_ = FREE;
            this.startPoint_ = null;
            return true;
        }
        if (mouseEvent.button == 3) {
            this.state_ = FREE;
            this.startPoint_ = null;
            return true;
        }
        return false;
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        switch (n) {
            case 131072: {
                --this.currentLineIndex_;
                if (this.currentLineIndex_ >= 0) break;
                this.currentLineIndex_ = decorationCursors_s_.length - 1;
                break;
            }
            case 262144: {
                ++this.currentLineIndex_;
                this.currentLineIndex_ %= decorationCursors_s_.length;
            }
        }
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    static {
        ArrayList<CursorResource> arrayList = new ArrayList<CursorResource>(2);
        arrayList.add(CanvasCursor.MARK_LINE);
        arrayList.add(CanvasCursor.MARK_ARROW);
        decorationCursors_s_ = arrayList.toArray(new CursorResource[arrayList.size()]);
        ArrayList<SgfId> arrayList2 = new ArrayList<SgfId>(2);
        arrayList2.add(SgfId.LINE);
        arrayList2.add(SgfId.ARROW);
        markIds_s_ = arrayList2.toArray(new SgfId[arrayList.size()]);
    }

    private static class State
    extends UEnum {
        protected State(String string) {
            super((Comparable)((Object)string));
        }
    }
}

