/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.ol;

import java.io.File;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.unitarou.io.Ios;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.Swts;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.view.jface.board.FingerprintIgoBoard;
import org.unitarou.yukinoshita.view.jface.gi.GameInfoPanel;
import org.unitarou.yukinoshita.view.jface.gi.GameInfoPanelFactory;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;

public class SearchedOutlinePanel
implements WidgetContainer {
    private static final Messages messages_s_ = Messages.createByPackage(GameInfoPanel.class);
    private Composite frame_ = null;
    private final FingerprintIgoBoard board_ = new FingerprintIgoBoard();
    private final GameInfoPanel gameInfo_ = GameInfoPanelFactory.instance().create(SearchedOutlinePanel.class.getResourceAsStream("AnnotationFormat.xml"), messages_s_.getAll());
    private final FilenameSheet fileSheet_ = new FilenameSheet();
    private FileSearched fileSearched_;
    private boolean isMarked_ = false;

    public void close() {
    }

    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        this.frame_.setLayout(gridLayout);
        Control control = this.board_.createContents(this.frame_);
        GridData gridData = new GridData(16384, 4, false, true);
        gridData.verticalSpan = 2;
        control.setLayoutData(gridData);
        Control control2 = this.gameInfo_.createContents(this.frame_);
        control2.setLayoutData(new GridData(4, 4, true, false));
        Control control3 = this.fileSheet_.createContents(this.frame_);
        control3.setLayoutData(new GridData(4, 128, true, true));
        return this.frame_;
    }

    public Control getControl() {
        return this.frame_;
    }

    public void setFileSearched(FileSearched fileSearched) {
        ArgumentChecker.throwIfNull((Object)fileSearched);
        this.fileSearched_ = fileSearched;
        this.board_.updateImage(this.fileSearched_);
        this.fileSheet_.update(this.fileSearched_);
        SgfParser sgfParser = new SgfParser();
        try {
            String string = this.fileSearched_.getGameInfo();
            Collection collection = sgfParser.parse('(' + string + ')', Ios.UTF8);
            if (collection.size() != 0) {
                RootGameTree rootGameTree = collection.get(0);
                rootGameTree.setGameType(GameType.parseQuietly(String.valueOf(this.fileSearched_.getGameType()), GameType.GAME));
                this.gameInfo_.update(rootGameTree);
            }
        }
        catch (SgfParserException sgfParserException) {
            sgfParserException.printStackTrace();
        }
    }

    public void setSizeHint(Point point) {
        ArgumentChecker.throwIfNull((Object)point);
        GridData gridData = (GridData)this.board_.getControl().getLayoutData();
        gridData.widthHint = point.y;
        gridData.heightHint = point.y;
    }

    public boolean isMarked() {
        return this.isMarked_;
    }

    public FileSearched getFileSearched() {
        return this.fileSearched_;
    }

    public Button getCheckButton() {
        return this.fileSheet_.cbFilename_;
    }

    private class FilenameSheet
    implements WidgetContainer {
        private Composite sheetFrame_ = null;
        private Button cbFilename_ = null;
        private String labelText_ = "";

        private FilenameSheet() {
        }

        public Control createContents(Composite composite) {
            this.sheetFrame_ = new Composite(composite, 0);
            this.sheetFrame_.setLayout(new FillLayout());
            this.cbFilename_ = WidgetFactory.createCheckButton(this.sheetFrame_, 0);
            this.cbFilename_.setSelection(SearchedOutlinePanel.this.isMarked_);
            this.cbFilename_.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SearchedOutlinePanel.this.isMarked_ = FilenameSheet.this.cbFilename_.getSelection();
                }
            });
            this.cbFilename_.addControlListener(new ControlAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void controlResized(ControlEvent controlEvent) {
                    GC gC = null;
                    try {
                        gC = new GC(FilenameSheet.this.cbFilename_.getDisplay());
                        gC.setFont(FilenameSheet.this.cbFilename_.getFont());
                        FilenameSheet.this.cbFilename_.setText(Swts.shortenText(gC, FilenameSheet.this.labelText_, ((FilenameSheet)FilenameSheet.this).cbFilename_.getSize().x - 20));
                    }
                    catch (Throwable throwable) {
                        Swts.disposeQuietly(gC);
                        throw throwable;
                    }
                    Swts.disposeQuietly(gC);
                }
            });
            return this.sheetFrame_;
        }

        public Control getControl() {
            return this.sheetFrame_;
        }

        public void close() {
        }

        private void update(FileSearched fileSearched) {
            String string = fileSearched.getPath();
            StringBuilder stringBuilder = new StringBuilder(string.length() + 5);
            stringBuilder.append('(').append(fileSearched.getFileOrder() + 1).append(')').append(string);
            this.labelText_ = stringBuilder.toString();
            File file = new File(string);
            this.cbFilename_.setEnabled(Ios.isNormalFile(file));
        }
    }
}

