/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseStatusPanel
implements YukinoshitaPanel {
    private static final FilenameFilter FILEFILTER = new SuffixFileFilter(".sgf");
    private static final FileFilter DIRFILETER = new FileFilter(){

        public boolean accept(File file) {
            return Ios.isNormalDirectory(file);
        }
    };
    private static final FileContextValue LAST_PATH = new FileContextValue(DatabaseStatusPanel.class, "lastPath", Ios.getCurrentDirectory());
    private static final Message LB_DB_STATUS = new Message(DatabaseStatusPanel.class, "lbDbStatus");
    private static final Message LB_FILE_COUNTS = new Message(DatabaseStatusPanel.class, "lbFileCounts");
    private static final Message LB_GAME_COUNTS = new Message(DatabaseStatusPanel.class, "lbGameCounts");
    private static final Message LB_PROBLEM_COUNTS = new Message(DatabaseStatusPanel.class, "lbProblemCounts");
    private static final Message LN_UPDATE_DB = new Message(DatabaseStatusPanel.class, "lnUpdateDatabase");
    private static final Message LB_UPDATE_DATABASE = new Message(DatabaseStatusPanel.class, "lbUpdateDatabase");
    private static final Message NT_LIST_FILES = new Message(DatabaseStatusPanel.class, "ntListFiles");
    private static final Message NT_DELETE_NOT_FOUND_RECORD = new Message(DatabaseStatusPanel.class, "ntDeleteNotFoundRecord");
    private static final Message NT_INSERT_RECORD = new Message(DatabaseStatusPanel.class, "ntInsertRecord");
    private static final Message NT_TARGET_DIR = new Message(DatabaseStatusPanel.class, "ntTargetDir");
    private static final Message NT_SET_ROOT_FOLDER = new Message(DatabaseStatusPanel.class, "ntSetRootFolder");
    private static final Message MSG_SET_ROOT_FOLDER = new Message(DatabaseStatusPanel.class, "msgSetRootFolder");
    private Group frame_ = null;
    private Label lbFileCounts_ = null;
    private Label lbGameCounts_ = null;
    private Label lbProblemCounts_ = null;

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = WidgetFactory.createGroup(composite, 0);
        this.frame_.setText(LB_DB_STATUS.get());
        this.frame_.setLayout(new GridLayout(1, false));
        this.lbFileCounts_ = new Label(this.frame_, 0);
        this.lbFileCounts_.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.lbGameCounts_ = new Label(this.frame_, 0);
        this.lbGameCounts_.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.lbProblemCounts_ = new Label(this.frame_, 0);
        this.lbProblemCounts_.setLayoutData(new GridData(16384, 0x1000000, true, false));
        Link link = new Link(this.frame_, 0);
        link.setText(LN_UPDATE_DB.get());
        link.setLayoutData(new GridData(131072, 0x1000000, true, false));
        link.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DatabaseStatusPanel.this.updateDatabase();
            }
        });
        this.updateStatistics();
        return this.frame_;
    }

    public void updateStatistics() {
        if (this.frame_ == null) {
            return;
        }
        DatabaseStatistics databaseStatistics = FileManager.instance().getDatabaseStatistics();
        this.lbFileCounts_.setText(LB_FILE_COUNTS.get((Object)new Integer(databaseStatistics.getFileCount())));
        this.lbGameCounts_.setText(LB_GAME_COUNTS.get((Object)new Integer(databaseStatistics.getGameCount())));
        this.lbProblemCounts_.setText(LB_PROBLEM_COUNTS.get((Object)new Integer(databaseStatistics.getProblemCount())));
        this.frame_.layout();
    }

    private void updateDatabase() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.frame_.getShell());
        directoryDialog.setText(NT_SET_ROOT_FOLDER.get());
        directoryDialog.setMessage(MSG_SET_ROOT_FOLDER.get());
        CurrentContext currentContext = Yukinoshita.context(null);
        directoryDialog.setFilterPath(currentContext.getFile(LAST_PATH).getAbsolutePath());
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        currentContext.setFile(LAST_PATH.id(), new File(string));
        this.updateDatabaseImpl(string);
        this.updateStatistics();
    }

    private void updateDatabaseImpl(final String string) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.create();
        progressMonitorDialog.getShell().setText(LB_UPDATE_DATABASE.get());
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask(NT_LIST_FILES.get(), -1);
                ArrayList arrayList = new ArrayList();
                DatabaseStatusPanel.this.findSgfFiles(iProgressMonitor, new File(string), arrayList);
                iProgressMonitor.beginTask(NT_DELETE_NOT_FOUND_RECORD.get(), -1);
                FileManager.instance().deleteNotFoundFileIndex();
                iProgressMonitor.beginTask(NT_INSERT_RECORD.get(), arrayList.size());
                for (File file : arrayList) {
                    if (iProgressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    iProgressMonitor.subTask(file.getAbsolutePath());
                    FileManager.instance().refreshIndex(file);
                    iProgressMonitor.worked(1);
                }
                iProgressMonitor.done();
            }
        };
        try {
            progressMonitorDialog.run(true, true, iRunnableWithProgress);
            progressMonitorDialog.close();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void findSgfFiles(IProgressMonitor iProgressMonitor, File file, List<File> list) throws InterruptedException {
        File[] fileArray;
        if (iProgressMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        iProgressMonitor.subTask(NT_TARGET_DIR.get((Object)file.getAbsolutePath()));
        File[] fileArray2 = fileArray = file.listFiles(FILEFILTER);
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray2[i];
            list.add(file2);
        }
        for (File file3 : fileArray2 = file.listFiles(DIRFILETER)) {
            this.findSgfFiles(iProgressMonitor, file3, list);
        }
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void close() {
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        return null;
    }
}

