/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.unitarou.io.Ios;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.ScrollableMouseWheelHandler;
import org.unitarou.swt.USashForm;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.db.FileSearched;
import org.unitarou.yukinoshita.view.jface.board.ol.SearchedOutlinePanel;
import org.unitarou.yukinoshita.view.jface.db.DatabaseStatusPanel;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSearchDialog
extends Dialog {
    private static final Log log_s_ = LogFactory.getLog(FileSearchDialog.class);
    private static final int OPEN_ID = 1024;
    private static final int CLOSE_ID = 12;
    private static final Message LB_OPEN_FILE = new Message(FileSearchDialog.class, "lbOpenFile");
    private static final Message CLB_SEARCH = new Message(FileSearchDialog.class, "clbSearch");
    private static final Message LB_KEYWORDS = new Message(FileSearchDialog.class, "lbKeywords");
    private static final Message LN_HELP = new Message(FileSearchDialog.class, "lnHelp");
    private static final Message LB_FILE_TYPE = new Message(FileSearchDialog.class, "lbFileType");
    private static final Message CLB_OPEN = new Message(FileSearchDialog.class, "clbOpen");
    private static final Message LB_SEARCH_DB = new Message(FileSearchDialog.class, "lbSearchDb");
    private static final Message LB_DRAW_RESULT = new Message(FileSearchDialog.class, "lbDrawResult");
    private static final Message LB_SEARCH_RESULT = new Message(FileSearchDialog.class, "lbSearchResult");
    private static final Message LB_ERROR_NO_SELECT_FILETYPE = new Message(FileSearchDialog.class, "lbErrorNoSelectFiletype");
    private static final Message LB_KEYWORD_USAGE = new Message(FileSearchDialog.class, "lbKeyworkUsage");
    private static final Message MSG_KEYWORD_USAGE = new Message(FileSearchDialog.class, "msgKeyworkUsage");
    private static final int MAX_LINES = 100;
    private Composite frame_ = null;
    private DatabaseStatusPanel databaseStatusPanel_;
    private Button btnSearch_;
    private Text txtKeyword_;
    private final Map<GameType, Button> typeMap_ = new HashMap<GameType, Button>();
    private Composite cSearched_;
    private Label lbStatus_;
    private final UpdateOpenButtonListener buttonListener_;
    private final List<SearchedOutlinePanel> searchedPanels_;
    private final ScrollableMouseWheelHandler handler_;

    public FileSearchDialog(Shell shell) {
        super(shell);
        this.setShellStyle(48);
        this.databaseStatusPanel_ = new DatabaseStatusPanel();
        this.buttonListener_ = new UpdateOpenButtonListener();
        this.searchedPanels_ = new ArrayList<SearchedOutlinePanel>(100);
        this.handler_ = new ScrollableMouseWheelHandler();
    }

    public FileSearchDialog(IShellProvider iShellProvider) {
        super(iShellProvider);
        this.setShellStyle(48);
        this.databaseStatusPanel_ = new DatabaseStatusPanel();
        this.buttonListener_ = new UpdateOpenButtonListener();
        this.searchedPanels_ = new ArrayList<SearchedOutlinePanel>(100);
        this.handler_ = new ScrollableMouseWheelHandler();
    }

    @Override
    protected Point getInitialSize() {
        return new Point(700, 480);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(LB_OPEN_FILE.get());
        this.frame_ = (Composite)super.createDialogArea(composite);
        USashForm uSashForm = WidgetFactory.createUSashForm(this.frame_, 256);
        uSashForm.setLayoutData(new GridData(4, 4, true, true));
        this.createSearchPanel(uSashForm);
        this.createResultPanel(uSashForm);
        uSashForm.setWeights(new int[]{-200, 1});
        return this.frame_;
    }

    private Composite createSearchPanel(Composite composite) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setLayout(new FillLayout());
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(false);
        scrolledComposite.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point = Geometry.getSize(scrolledComposite.getClientArea());
                scrolledComposite.setMinSize(point);
            }
        });
        Composite composite2 = new Composite(scrolledComposite, 0);
        composite2.setLayout(new GridLayout(1, true));
        Control control = this.databaseStatusPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 128, true, false));
        Composite composite3 = this.createKeywordPanel(composite2);
        composite3.setLayoutData(new GridData(4, 128, true, false));
        Group group = this.createSearchTypePanel(composite2);
        group.setLayoutData(new GridData(4, 128, true, false));
        this.btnSearch_ = new Button(composite2, 8);
        this.btnSearch_.setText(CLB_SEARCH.get());
        this.btnSearch_.setLayoutData(new GridData(131072, 128, false, false));
        this.btnSearch_.addSelectionListener(new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    FileSearchDialog.this.frame_.setCursor(FileSearchDialog.this.frame_.getDisplay().getSystemCursor(1));
                    FileSearchDialog.this.search();
                }
                finally {
                    FileSearchDialog.this.frame_.setCursor(null);
                }
            }
        });
        this.getShell().setDefaultButton(this.btnSearch_);
        this.btnSearch_.setFocus();
        composite2.pack();
        scrolledComposite.setContent(composite2);
        return scrolledComposite;
    }

    private Composite createKeywordPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(LB_KEYWORDS.get());
        label.setLayoutData(new GridData(16384, 1024, true, false));
        Link link = new Link(composite2, 0);
        link.setText(LN_HELP.get());
        link.setLayoutData(new GridData(131072, 1024, false, false));
        link.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, LB_KEYWORD_USAGE.get(), MSG_KEYWORD_USAGE.get());
            }
        });
        this.txtKeyword_ = new Text(composite2, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        this.txtKeyword_.setLayoutData(gridData);
        return composite2;
    }

    private Group createSearchTypePanel(Composite composite) {
        Group group = WidgetFactory.createGroup(composite, 0);
        group.setText(LB_FILE_TYPE.get());
        group.setLayout(new RowLayout(256));
        Button button = WidgetFactory.createCheckButton(group, 0);
        button.setText(GameType.GAME.displayName());
        button.setSelection(true);
        this.typeMap_.put(GameType.GAME, button);
        button = WidgetFactory.createCheckButton(group, 0);
        button.setText(GameType.PROBLEM.displayName());
        button.setSelection(false);
        this.typeMap_.put(GameType.PROBLEM, button);
        return group;
    }

    private Composite createResultPanel(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        composite2.setLayout(gridLayout);
        this.lbStatus_ = new Label(composite2, 0);
        this.lbStatus_.setLayoutData(new GridData(4, 128, true, false));
        final ScrolledComposite scrolledComposite = new ScrolledComposite(composite2, 2560);
        scrolledComposite.setLayoutData(new GridData(4, 4, true, true));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(false);
        this.cSearched_ = new Composite(scrolledComposite, 0);
        scrolledComposite.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point = Geometry.getSize(scrolledComposite.getClientArea());
                scrolledComposite.setMinSize(point);
            }
        });
        gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginRight = 1;
        this.cSearched_.setLayout(gridLayout);
        scrolledComposite.setContent(this.cSearched_);
        this.handler_.setScrollable(scrolledComposite);
        return composite2;
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1024, CLB_OPEN.get(), false).setEnabled(false);
        this.createButton(composite, 12, BasicMessages.CLB_CLOSE.get(), false);
    }

    private void search() {
        for (Control control : this.cSearched_.getChildren()) {
            control.dispose();
        }
        EnumSet<GameType> enumSet = EnumSet.noneOf(GameType.class);
        for (Map.Entry<GameType, Button> entry : this.typeMap_.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            enumSet.add(entry.getKey());
        }
        if (enumSet.isEmpty()) {
            this.cSearched_.setBackground(this.cSearched_.getDisplay().getSystemColor(22));
            this.lbStatus_.setText(LB_ERROR_NO_SELECT_FILETYPE.get((Object)LB_FILE_TYPE.get()));
            return;
        }
        this.lbStatus_.setText(LB_SEARCH_DB.get());
        this.lbStatus_.getParent().layout();
        FileSearched[] fileSearchedArray = FileManager.instance().search(this.txtKeyword_.getText(), enumSet);
        List<FileSearched> list = this.eliminateNotFoundFiles(fileSearchedArray);
        this.lbStatus_.setText(LB_DRAW_RESULT.get());
        this.lbStatus_.getParent().layout();
        this.createSearchedOutlinePanels(list);
        this.lbStatus_.setText(LB_SEARCH_RESULT.get(new Integer(list.size()), new Integer(Math.min(100, list.size()))));
    }

    private List<FileSearched> eliminateNotFoundFiles(FileSearched[] fileSearchedArray) {
        ArrayList<FileSearched> arrayList = new ArrayList<FileSearched>(fileSearchedArray.length);
        ArrayList<FileSearched> arrayList2 = new ArrayList<FileSearched>();
        for (FileSearched fileSearched : fileSearchedArray) {
            if (Ios.isNormalFile(new File(fileSearched.getPath()))) {
                arrayList.add(fileSearched);
                continue;
            }
            arrayList2.add(fileSearched);
        }
        if (!arrayList2.isEmpty()) {
            log_s_.info(arrayList2.size() + " file(s) are not found. remove these fileindex.");
        }
        for (FileSearched fileSearched : arrayList2) {
            FileManager.instance().deleteFileIndex(fileSearched.getFileId());
        }
        return arrayList;
    }

    private void createSearchedOutlinePanels(List<FileSearched> list) {
        for (SearchedOutlinePanel searchedOutlinePanel : this.searchedPanels_) {
            searchedOutlinePanel.getControl().dispose();
        }
        this.searchedPanels_.clear();
        long l = 0L;
        if (log_s_.isTraceEnabled()) {
            l = System.nanoTime();
        }
        if (list.isEmpty()) {
            this.cSearched_.setBackground(this.cSearched_.getDisplay().getSystemColor(22));
        } else {
            this.cSearched_.setBackground(this.cSearched_.getDisplay().getSystemColor(23));
        }
        ScrolledComposite scrolledComposite = (ScrolledComposite)this.cSearched_.getParent();
        Point point = Geometry.getSize(scrolledComposite.getClientArea());
        for (int i = 0; i < Math.min(list.size(), 100); ++i) {
            SearchedOutlinePanel searchedOutlinePanel = new SearchedOutlinePanel();
            Control control = searchedOutlinePanel.createContents(this.cSearched_);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = point.x;
            control.setLayoutData(gridData);
            searchedOutlinePanel.setFileSearched(list.get(i));
            searchedOutlinePanel.setSizeHint(new Point(point.x, 150));
            searchedOutlinePanel.getCheckButton().addSelectionListener(this.buttonListener_);
            this.searchedPanels_.add(searchedOutlinePanel);
        }
        point = this.cSearched_.computeSize(point.x, -1);
        this.cSearched_.setSize(point);
        this.cSearched_.layout();
        scrolledComposite.setOrigin(0, 0);
        this.handler_.addListeners();
        if (log_s_.isTraceEnabled()) {
            log_s_.trace((int)((double)(System.nanoTime() - l) / 1000000.0) + "[ms] elapsed for creating SearchedOutlinePanel");
        }
    }

    @Override
    protected void buttonPressed(int n) {
        switch (n) {
            case 1024: {
                this.okPressed();
                break;
            }
            case 12: {
                this.cancelPressed();
                break;
            }
            default: {
                assert (false) : "Unknown ID; " + n;
                break;
            }
        }
    }

    public FileSearched[] getSelected() {
        ArrayList<FileSearched> arrayList = new ArrayList<FileSearched>(this.searchedPanels_.size());
        for (SearchedOutlinePanel searchedOutlinePanel : this.searchedPanels_) {
            if (!searchedOutlinePanel.isMarked()) continue;
            arrayList.add(searchedOutlinePanel.getFileSearched());
        }
        return arrayList.toArray(new FileSearched[arrayList.size()]);
    }

    private class UpdateOpenButtonListener
    extends SelectionAdapter {
        private UpdateOpenButtonListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = FileSearchDialog.this.getButton(1024);
            for (SearchedOutlinePanel searchedOutlinePanel : FileSearchDialog.this.searchedPanels_) {
                if (!searchedOutlinePanel.getCheckButton().getSelection()) continue;
                button.setEnabled(true);
                return;
            }
            button.setEnabled(false);
        }
    }
}

