/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.yukinoshita.model.ProblemStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Answer {
    private ProblemStatus status_;
    private final List<Integer> tracks_;

    static List<Answer> addAllVariation(RootGameTree rootGameTree) {
        ArrayList<Answer> arrayList = new ArrayList<Answer>();
        SgfColor sgfColor = BasicFinder.firstMove(rootGameTree);
        if (sgfColor == null) {
            return arrayList;
        }
        SgfId sgfId = sgfColor == SgfColor.BLACK ? SgfId.GOOD_FOR_BLACK : SgfId.GOOD_FOR_WHITE;
        Answer.addAllVariationImpl(rootGameTree, sgfId, new Answer(), arrayList);
        Collections.sort(arrayList, new Comparator<Answer>(){

            @Override
            public int compare(Answer answer, Answer answer2) {
                return answer.getStatus().compareTo(answer2.getStatus());
            }
        });
        return arrayList;
    }

    private static void addAllVariationImpl(GameTree gameTree, SgfId sgfId, Answer answer, List<Answer> list) {
        String string = BasicFinder.findDatum(gameTree.getSequence(), sgfId);
        SgfDouble sgfDouble = SgfDouble.parseQuietly(string);
        if (SgfDouble.NORMAL.equals(sgfDouble)) {
            answer.setStatus(ProblemStatus.ONE_STEP_SHORT);
        } else if (SgfDouble.EMPHASIZED.equals(sgfDouble)) {
            answer.setStatus(ProblemStatus.CORRECT);
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        if (gameTreeArray.length == 0) {
            boolean bl = true;
            for (Integer n : answer.getTracks()) {
                if (n == 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                answer.setStatus(ProblemStatus.CORRECT);
            }
            list.add(answer);
            return;
        }
        for (int i = 0; i < gameTreeArray.length; ++i) {
            Answer answer2 = new Answer(answer);
            answer2.addTrack(new Integer(i));
            Answer.addAllVariationImpl(gameTreeArray[i], sgfId, answer2, list);
        }
    }

    Answer() {
        this.status_ = ProblemStatus.MISTAKE;
        this.tracks_ = new ArrayList<Integer>(1);
    }

    Answer(Answer answer) {
        this.status_ = answer.status_;
        this.tracks_ = new ArrayList<Integer>(answer.tracks_);
    }

    ProblemStatus getStatus() {
        return this.status_;
    }

    void setStatus(ProblemStatus problemStatus) {
        this.status_ = problemStatus;
    }

    Integer[] getTracks() {
        return this.tracks_.toArray(new Integer[this.tracks_.size()]);
    }

    void addTrack(Integer n) {
        this.tracks_.add(n);
    }
}

