/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.swt.USashForm;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeProblemCommand;
import org.unitarou.yukinoshita.view.cmd.TimeupInProblemCommand;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.gm.NoteMemoPanel;
import org.unitarou.yukinoshita.view.jface.pa.SolveStatusPanel;
import org.unitarou.yukinoshita.view.jface.pa.Timer;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemActionPanel
implements YukinoshitaPanel {
    private static final Message CLB_ANSWER = new Message(ProblemActionPanel.class, "clbAnswer");
    private static final Message CLB_RETRY = new Message(ProblemActionPanel.class, "clbRetry");
    private static final Message CLB_PREVIOUS = new Message(ProblemActionPanel.class, "clbPrevious");
    private static final Message CLB_NEXT = new Message(ProblemActionPanel.class, "clbNext");
    private static final Message LB_TIME_LEFT = new Message(ProblemActionPanel.class, "lbTimeLeft");
    private static final Message LB_PAUSE_TIMER = new Message(ProblemActionPanel.class, "lbPauseTimer");
    private static final FontResource FONT_TIME_LEFT = new FontResource("Helvetica", 18, 0);
    private static final ColorResource COL_TIME_OK = new ColorResource(6);
    private static final ColorResource COL_TIME_WARN = new ColorResource(8);
    private static final ColorResource COL_TIME_UP = new ColorResource(4);
    private static final ColorResource COL_TIME_DISABLE = new ColorResource(16);
    private Reference<CollectionEditor> refCe_ = new WeakReference<Object>(null);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Control frame_ = null;
    private final Adapter adapter_ = new Adapter();
    private final SolveStatusPanel solveStatusPanel_ = new SolveStatusPanel();
    private Button answer_ = null;
    private Button retry_ = null;
    private Button previous_ = null;
    private Button next_ = null;
    private final List<Integer> indexList_ = new ArrayList<Integer>();
    private Label timeLeft_ = null;
    private Button pauseTimer_;
    private final Timer timer_ = new Timer();
    private long startTime_;
    private boolean enableTimer_;
    private final NoteMemoPanel noteMemoPanel_ = new NoteMemoPanel();
    private final YukinoshitaPanel[] adaptables_s_ = new YukinoshitaPanel[]{this.solveStatusPanel_, this.noteMemoPanel_};

    @Override
    public Control createContents(Composite composite) {
        USashForm uSashForm = WidgetFactory.createUSashForm(composite, 512);
        Composite composite2 = new Composite(uSashForm, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout(gridLayout);
        Control control = this.createButtonFrame(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        control = this.solveStatusPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 4, true, true));
        control = this.createTimerFrame(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.noteMemoPanel_.createContents(uSashForm);
        uSashForm.setWeights(new int[]{2, 1});
        this.frame_ = uSashForm;
        return this.frame_;
    }

    private Control createButtonFrame(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        composite2.setLayout(gridLayout);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        this.previous_ = new Button(composite2, 8);
        this.previous_.setLayoutData(gridData);
        this.previous_.setText(CLB_PREVIOUS.get());
        this.previous_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeProblemCommand(-1));
            }
        });
        gridData = new GridData(131072, 0x1000000, true, false);
        this.retry_ = new Button(composite2, 8);
        this.retry_.setLayoutData(gridData);
        this.retry_.setText(CLB_RETRY.get());
        this.retry_.setEnabled(false);
        this.retry_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
            }
        });
        gridData = new GridData(16384, 0x1000000, true, false);
        this.next_ = new Button(composite2, 8);
        this.next_.setLayoutData(gridData);
        this.next_.setText(CLB_NEXT.get());
        this.next_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeProblemCommand(1));
            }
        });
        gridData = new GridData(131072, 0x1000000, true, false);
        this.answer_ = new Button(composite2, 8);
        this.answer_.setLayoutData(gridData);
        this.answer_.setText(CLB_ANSWER.get());
        this.answer_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.ANSWER));
            }
        });
        return composite2;
    }

    private Control createTimerFrame(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(3, false));
        Label label = new Label(composite2, 0);
        label.setText(LB_TIME_LEFT.get());
        label.setLayoutData(new GridData(131072, 0x1000000, false, true));
        this.timeLeft_ = new Label(composite2, 0);
        this.timeLeft_.setText("");
        this.timeLeft_.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.timeLeft_.setFont(FONT_TIME_LEFT.get());
        this.timer_.addListener(new Timer.TimerListener(){

            public void countDown() {
                ProblemActionPanel.this.countDown();
            }

            public void timeup() {
                ProblemActionPanel.this.timeup();
            }
        });
        this.pauseTimer_ = new Button(composite2, 2);
        this.pauseTimer_.setSelection(false);
        this.pauseTimer_.setText(LB_PAUSE_TIMER.get());
        this.pauseTimer_.setLayoutData(new GridData(131072, 0x1000000, false, true));
        this.pauseTimer_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ProblemActionPanel.this.pauseTimer_.getSelection()) {
                    ProblemActionPanel.this.timer_.pause();
                } else {
                    ProblemActionPanel.this.timer_.restart();
                }
            }
        });
        return composite2;
    }

    @Override
    public void close() {
        this.timerStop();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private void timerStart() {
        this.timeLeft_.setText(String.valueOf(this.timer_.timeLimit()));
        if (this.enableTimer_) {
            this.timer_.start();
        }
        this.startTime_ = System.currentTimeMillis();
        this.updateFontColor();
    }

    private void timerStop() {
        this.timer_.stop();
    }

    private void countDown() {
        if (!this.timeLeft_.isDisposed()) {
            this.timeLeft_.setText(String.valueOf(this.timer_.timeLeft()));
            this.updateFontColor();
        }
    }

    private void timeup() {
        if (!this.timeLeft_.isDisposed()) {
            this.timerStop();
            this.updateFontColor();
            this.eventBroker_.executeCommand(new TimeupInProblemCommand());
        }
    }

    private void updateFontColor() {
        if (!this.enableTimer_) {
            this.timeLeft_.setForeground(COL_TIME_DISABLE.get());
        } else if (10 < this.timer_.timeLeft()) {
            this.timeLeft_.setForeground(COL_TIME_OK.get());
        } else if (0 < this.timer_.timeLeft()) {
            this.timeLeft_.setForeground(COL_TIME_WARN.get());
        } else {
            this.timeLeft_.setForeground(COL_TIME_UP.get());
        }
    }

    private void enableNextPrevButtons() {
        if (this.next_ == null || this.previous_ == null) {
            return;
        }
        CollectionEditor collectionEditor = this.refCe_.get();
        int n = this.indexList_.indexOf(new Integer(collectionEditor.getActiveGameIndex()));
        if (collectionEditor == null) {
            this.next_.setEnabled(false);
            this.previous_.setEnabled(false);
        } else {
            this.next_.setEnabled(n != this.indexList_.size() - 1);
            this.previous_.setEnabled(n != 0);
        }
    }

    private void updateProblemProperties(boolean bl, boolean bl2) {
        if (this.frame_ == null) {
            return;
        }
        ProblemProperties problemProperties = this.getCurrentContextPp();
        this.retry_.setEnabled(problemProperties.contains(ProblemProperties.Flag.RETRYABLE) && bl);
        this.answer_.setEnabled(problemProperties.contains(ProblemProperties.Flag.SHOW_ANSWER) && bl2);
        this.enableTimer_ = problemProperties.contains(ProblemProperties.Flag.TIME_LIMIT) && this.timer_.timeLimit() != 0;
        this.pauseTimer_.setEnabled(this.enableTimer_);
        if (!this.enableTimer_) {
            this.timerStop();
        }
    }

    private ProblemProperties getCurrentContextPp() {
        CollectionEditor collectionEditor = this.refCe_.get();
        Collection collection = collectionEditor != null ? collectionEditor.getCollection() : null;
        CurrentContext currentContext = Yukinoshita.context(collection);
        return new ProblemProperties(currentContext.getInteger(Context.PROBLEM_PROPERTIES));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    extends TieredModelEventNotifier
    implements EventBrokerMonitor,
    CollectionMonitor,
    GameMonitor,
    GameInfoNodeMonitor,
    ControllerStatusMonitor,
    ProblemStatusMonitor,
    ContextMonitor {
        private Reference<GameMediator> refGm_ = new WeakReference<Object>(null);
        private boolean isEditMode_ = false;

        private Adapter() {
        }

        @Override
        protected Adaptable[] getAdaptables() {
            return ProblemActionPanel.this.adaptables_s_;
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            ProblemActionPanel.this.eventBroker_.removeView(ProblemActionPanel.this);
            ProblemActionPanel.this.eventBroker_ = eventBroker;
            ProblemActionPanel.this.eventBroker_.addView(ProblemActionPanel.this);
            super.setEventBroker(eventBroker);
        }

        @Override
        public void update(CollectionEditor collectionEditor) {
            ProblemActionPanel.this.refCe_ = new WeakReference<CollectionEditor>(collectionEditor);
            this.refGm_ = new WeakReference<GameMediator>(collectionEditor.getActiveGame());
            ProblemActionPanel.this.indexList_.clear();
            Collection collection = collectionEditor.getCollection();
            for (int i = 0; i < collection.size(); ++i) {
                if (collection.get(i).getGameType() != GameType.PROBLEM) continue;
                ProblemActionPanel.this.indexList_.add(new Integer(i));
            }
            ProblemActionPanel.this.enableNextPrevButtons();
            ProblemActionPanel.this.updateProblemProperties(true, true);
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
            ArgumentChecker.throwIfNull(list);
            ProblemActionPanel.this.indexList_.clear();
            ProblemActionPanel.this.indexList_.addAll(list);
            ProblemActionPanel.this.enableNextPrevButtons();
        }

        @Override
        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.refGm_ = new WeakReference<GameMediator>(gameMediator);
            if (this.isEditMode_) {
                return;
            }
            if (ProblemActionPanel.this.frame_ == null) {
                return;
            }
            ProblemActionPanel.this.enableNextPrevButtons();
            this.updateProblemSettings();
            ProblemActionPanel.this.timerStart();
        }

        @Override
        public void gameInfoChanged(NodeView nodeView) {
            this.updateProblemSettings();
        }

        private void updateProblemSettings() {
            GameMediator gameMediator = this.refGm_.get();
            if (gameMediator == null) {
                return;
            }
            String string = BasicFinder.findDatum(gameMediator.getRootGameTree().getSequence(), SgfId.TIMELIMIT);
            SgfNumber sgfNumber = SgfNumber.parseQuietly(string);
            if (sgfNumber != null) {
                ProblemActionPanel.this.timer_.setTimeLimit(sgfNumber.getIntValue());
            }
            ProblemActionPanel.this.updateProblemProperties(true, true);
        }

        @Override
        public void setEditMode(boolean bl) {
            this.isEditMode_ = bl;
            ProblemActionPanel.this.timerStop();
            if (this.isEditMode_) {
                return;
            }
            CollectionEditor collectionEditor = (CollectionEditor)ProblemActionPanel.this.refCe_.get();
            if (collectionEditor == null) {
                return;
            }
            Collection collection = collectionEditor.getCollection();
            if (collection.size() == 0) {
                return;
            }
            this.refGm_ = new WeakReference<GameMediator>(collectionEditor.getActiveGame());
            if (collectionEditor.getActiveGame().getGameType().equals(GameType.GAME)) {
                return;
            }
            ProblemActionPanel.this.enableNextPrevButtons();
            ProblemActionPanel.this.timerStart();
            RootGameTree rootGameTree = collection.get(0);
            if (!rootGameTree.getGameType().equals(GameType.DRILL)) {
                return;
            }
            String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES);
            ProblemProperties problemProperties = ProblemProperties.parsePpQuietly(string);
            ProblemProperties problemProperties2 = ProblemActionPanel.this.getCurrentContextPp();
            if (problemProperties == null || problemProperties2.equals(problemProperties)) {
                return;
            }
            Yukinoshita.context(collection).setInteger(Context.PROBLEM_PROPERTIES.id(), problemProperties.getIntValue());
            Yukinoshita.context().fireAttributeChanged(new String[]{Context.PROBLEM_PROPERTIES.id()});
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (ProblemActionPanel.this.frame_ == null) {
                return;
            }
            if (handlerPhase.equals(HandlerPhase.SOLVE)) {
                ProblemActionPanel.this.updateProblemProperties(false, true);
                ProblemActionPanel.this.pauseTimer_.setSelection(false);
                ProblemActionPanel.this.timerStart();
            } else if (handlerPhase.equals(HandlerPhase.ANSWER)) {
                ProblemActionPanel.this.updateProblemProperties(true, false);
                ProblemActionPanel.this.pauseTimer_.setEnabled(false);
                ProblemActionPanel.this.timerStop();
            }
        }

        @Override
        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull((Object)problemStatus);
            switch (problemStatus) {
                case SOLVE: {
                    ProblemActionPanel.this.updateProblemProperties(true, false);
                    break;
                }
                case MISTAKE: 
                case CORRECT: 
                case ONE_STEP_SHORT: {
                    ProblemActionPanel.this.updateProblemProperties(true, true);
                    ProblemActionPanel.this.timerStop();
                    GameMediator gameMediator = this.refGm_.get();
                    if (gameMediator == null) break;
                    int n = ProblemActionPanel.this.enableTimer_ ? ProblemActionPanel.this.timer_.timeLimit() - ProblemActionPanel.this.timer_.timeLeft() : (int)((System.currentTimeMillis() - ProblemActionPanel.this.startTime_) / 1000L);
                    FileManager.instance().registerProblemResult(this.compose(gameMediator.getNodeList()), problemStatus, n);
                    break;
                }
                default: {
                    ProblemActionPanel.this.updateProblemProperties(true, false);
                }
            }
        }

        private RootGameTree compose(NodeList nodeList) {
            RootGameTree rootGameTree = new RootGameTree();
            for (int i = 0; i <= nodeList.getPositionIndex(); ++i) {
                NodeView nodeView = nodeList.getNodeView(i);
                Node node = nodeView.copyNode();
                rootGameTree.getSequence().addLast(node);
            }
            return rootGameTree;
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            if (set.contains(Context.PROBLEM_PROPERTIES.id())) {
                ProblemActionPanel.this.updateProblemProperties(ProblemActionPanel.this.retry_.getEnabled(), ProblemActionPanel.this.answer_.getEnabled());
            }
        }
    }
}

