/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pref;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.unitarou.jface.pref.CharsetArrayCodec;
import org.unitarou.jface.pref.CheckGroupFieldEditor;
import org.unitarou.jface.pref.FileArrayCodec;
import org.unitarou.jface.pref.SelectOrderFieldEditor;
import org.unitarou.ml.Message;
import org.unitarou.util.CharsetLabeler;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.view.jface.dlg.ExplorerLikeFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.FileDialogStyle;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePreferencePage
extends FieldEditorPreferencePage {
    private static final Message NT_TITLE = new Message(FilePreferencePage.class, "ntTitle");
    private static final Message LB_NO_OPTION_CHARSETS = new Message(FilePreferencePage.class, "lbNoOptionCharsets");
    private static final Message LB_OPTION_CHARSET = new Message(FilePreferencePage.class, "lbOptionCharsets");

    public static PreferenceNode createPreferenceNode() {
        String string = FilePreferencePage.class.getName();
        return new PreferenceNode(string, NT_TITLE.get(), null, string);
    }

    public FilePreferencePage() {
        super(0);
    }

    @Override
    protected void createFieldEditors() {
        Object object;
        Composite composite = this.getFieldEditorParent();
        this.addField(new RadioGroupFieldEditor(IgoFileDialog.FILE_DIALOG_STYLE.id(), IgoFileDialog.FILE_DIALOG_STYLE.displayName(), 2, this.composeEnumSelector(FileDialogStyle.class), composite, true));
        File[] fileArray = File.listRoots();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        String[][] stringArray = new String[fileArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            object = fileArray[i].getAbsolutePath();
            stringArray[i] = new String[]{object, object};
        }
        this.addField(new CheckGroupFieldEditor<File>(ExplorerLikeFileChooser.IGNORE_DRIVES.id(), '[' + FileDialogStyle.ORIGINAL.toString() + ']' + ' ' + ExplorerLikeFileChooser.IGNORE_DRIVES.displayName(), composite, stringArray, 4, FileArrayCodec.instance()));
        Yukinoshita yukinoshita = Yukinoshita.instance();
        object = new ArrayList();
        for (Charset charset : Charset.availableCharsets().values()) {
            if (!charset.canEncode() || yukinoshita.isInvalidCharset(charset)) continue;
            object.add(charset);
        }
        this.addField(new SelectOrderFieldEditor<Charset>(Context.CHARSET_OPTIONS.id(), Context.CHARSET_OPTIONS.displayName(), LB_NO_OPTION_CHARSETS.get(), LB_OPTION_CHARSET.get(), composite, (List<Charset>)object, CharsetArrayCodec.instance(), new CharsetLabeler()));
    }

    private <E extends Enum<E>> String[][] composeEnumSelector(Class<E> clazz) {
        EnumSet<Enum> enumSet = EnumSet.allOf(clazz);
        String[][] stringArray = new String[enumSet.size()][];
        int n = 0;
        for (Enum enum_ : enumSet) {
            stringArray[n] = new String[]{enum_.toString(), enum_.name()};
            ++n;
        }
        return stringArray;
    }
}

