<?php
//
// +----------------------------------------------------------------------+
// |zen-cart Open Source E-commerce                                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 The zen-cart developers                           |
// |                                                                      |
// | http://www.zen-cart.com/index.php                                    |
// |                                                                      |
// | Portions Copyright (c) 2003 osCommerce                               |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the GPL license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.zen-cart.com/license/2_0.txt.                             |
// | If you did not receive a copy of the zen-cart license and are unable |
// | to obtain it through the world-wide-web, please send a note to       |
// | license@zen-cart.com so we can mail you a copy immediately.          |
// +----------------------------------------------------------------------+
//  $Id: sqlpatch.php,v 1.1.1.1 2004/09/01 04:46:54 shidairiki Exp $
//
  require('includes/application_top.php');

  define('HEADING_TITLE','SQL Query Executor');
  define('TEXT_QUERY_RESULTS','Query Results:');
  define('FILENAME_SQLPATCH','sqlpatch');
  define('TEXT_ENTER_QUERY_STRING','Enter the query <br />to be executed:&nbsp;&nbsp;');
  define('TEXT_QUERY_FILENAME','Upload file:');
  define('ERROR_NOTHING_TO_DO','Error: Nothing to do - no query or query-file specified.');
  define('SQLPATCH_HELP_TEXT','The SQLPATCH tool lets you install system patches by pasting SQL code directly into the textarea field, '.
                              'or by uploading a supplied script (.SQL) file.  ' . "\n\n" . 'The commands entered or uploaded may ' .
                              'only begin with the following statements, and MUST be in UPPERCASE: ' . "\n" .
                              '<ul><li>DROP TABLE IF EXISTS</li><li>CREATE TABLE</li><li>INSERT INTO</li><li>ALTER TABLE</li>' .
                              '<li>UPDATE</li><li>DELETE FROM</li></ul>' . "\n");

//NOTE: THIS IS INTENTIONAL:
$linebreak = '
';
// NOTE: this line break is intentional!!!!

  function executeSql($lines, $database, $table_prefix = -1) {
    if (!get_cfg_var('safe_mode')) {
      set_time_limit(1200);
    }
    global $db;
    $newline = '';
    $saveline = '';
    foreach ($lines as $line) {
      $line = trim($line);
      $line = $saveline . $line;
      if (substr($line,0,1) != '#' && substr($line,0,1) != '-' && $line != '') {
        if ( substr($line, strlen($line)-1, 1) ==  ';') {
          $newline .= $line;
          $saveline = '';
          $complete_line = true;
        } else {
          $newline .= $line;
          $saveline = '';
          $complete_line = false;
        }
        if ($complete_line) {
          $command = substr($newline, 0, 6);
          if ($table_prefix != -1) {
            if (strtoupper(substr($newline, 0, 21)) == 'DROP TABLE IF EXISTS ') {
              $newline = 'DROP TABLE IF EXISTS ' . $table_prefix . substr($newline, 21);
            } elseif (strtoupper(substr($newline, 0, 13)) == 'CREATE TABLE ') {
              $newline = 'CREATE TABLE ' . $table_prefix . substr($newline, 13);
            } elseif (strtoupper(substr($newline, 0, 12)) == 'INSERT INTO ') {
              $newline = 'INSERT INTO ' . $table_prefix . substr($newline, 12);
            } elseif (strtoupper(substr($newline, 0, 12)) == 'ALTER TABLE ') {
              $newline = 'ALTER TABLE ' . $table_prefix . substr($newline, 12);
            } elseif (strtoupper(substr($newline, 0, 7)) == 'UPDATE ') {
              $newline = 'UPDATE ' . $table_prefix . substr($newline, 7);
            } elseif (strtoupper(substr($newline, 0, 12)) == 'DELETE FROM ') {
              $newline = 'DELETE FROM ' . $table_prefix . substr($newline, 12);
            }
          }
//	  echo $newline . '<br />';
          $db->Execute($newline);
          $newline = '';
        }
      }
    }
  }



  $action = (isset($_GET['action']) ? $_GET['action'] : '');
  if (zen_not_null($action)) {
    switch ($action) {
      case 'execute':
       if (isset($_POST['query_string']) && $_POST['query_string'] !='' ) {
         $query_string = explode($linebreak, $_POST['query_string']);
         $query_results = executeSql($query_string, DB_DATABASE, DB_PREFIX);
           if ($query_results = true) {
           } else {
             $messageStack->add('Success', 'success');
           }
       } else {
         $messageStack->add(ERROR_NOTHING_TO_DO, 'error');
       }
       break;
      case 'uploadquery':
            $upload_query = file($_FILES['sql_file']['tmp_name']);
//            $query_string  = zen_db_prepare_input($upload_query);
            if ($query_string !='') {
              $query_results = executeSql($query_string, DB_DATABASE, DB_PREFIX);
            } else {
              $messageStack->add(ERROR_NOTHING_TO_DO, 'error');
            }
       break;
      case 'help':
       break;
      default:
       break;
    }
  }
?>
<? if ($action != 'help') { ?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<script language="javascript" src="includes/menu.js"></script>
<script type="text/javascript">
  <!--
  function popupHelpWindow(url) {
    window.open(url,'popupImageWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes,copyhistory=no,width=100,height=100,screenX=150,screenY=150,top=150,left=150')
  }
  function init()
  {
    cssjsmenu('navbar');
    if (document.getElementById)
    {
      var kill = document.getElementById('hoverJS');
      kill.disabled = true;
    }
  }
  // -->
</script>
</head>
<body onload="init()" >
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->


<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr>
        <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
        <td class="pageHeading" align="right"><?php echo zen_draw_separator('pixel_trans.gif', HEADING_IMAGE_WIDTH, HEADING_IMAGE_HEIGHT); ?></td>
      </tr>
    </table></td>
  </tr>
<?php
  if ( $action == 'execute'  && $_POST['query_string'] !='' ) {
?>
  <tr>
    <td><table border="0" width="100%" cellspacing="0" cellpadding="2">
       <tr>
          <td class="smallText"><b><?php echo TEXT_QUERY_RESULTS; ?></td>
       </tr>
       <tr>
         <td class="smallText"><?php echo $query_result_messages; ?></td>
       </tr>
     </table></td>
   </tr>
<?php
  }
?>
    <tr><?php echo zen_draw_form('getquery', FILENAME_SQLPATCH, 'action=execute','post', ''); ?>
      <td><table border="0" cellpadding="0" cellspacing="2">
        <tr>
          <td colspan="2"><?php echo zen_draw_separator('pixel_trans.gif', '1', '5'); ?></td>
        </tr>
        <tr>
          <td valign="top" class="main" width="110px"><?php echo TEXT_ENTER_QUERY_STRING; ?></td>
          <td><?php echo zen_draw_textarea_field('query_string', 'soft', '80%', '10'); ?></td>
        </tr>
        <tr>
          <td colspan="2" align="right"><?php echo zen_image_submit('button_upload.gif', IMAGE_UPLOAD); ?></td>
        </tr>
      </table></td>
    </form></tr>


    <tr><?php echo zen_draw_form('getqueryfile', FILENAME_SQLPATCH, 'action=uploadquery','post', 'enctype="multipart/form-data"'); ?>
      <td><table border="0" cellpadding="0" cellspacing="2">
        <tr>
          <td valign="top" class="main" width="110px">&nbsp<?php echo TEXT_QUERY_FILENAME; ?> </td>
          <td><?php echo zen_draw_file_field('sql_file'); ?>&nbsp;&nbsp;&nbsp;<?php echo zen_image_submit('button_upload.gif', IMAGE_UPLOAD); ?></td>
        </tr>
      </table></td>
    </form></tr>
        <tr>
          <td colspan="2"><?php echo zen_draw_separator('pixel_trans.gif', '1', '5'); ?></td>
        </tr>
    <tr>
      <td width="300" align="right">
        <a href="<?php echo zen_href_link(FILENAME_SQLPATCH, 'action=help'); ?>" target='_blank'><?php echo zen_image_button('button_details.gif', IMAGE_DETAILS); ?></a></td>
    </tr>
<!-- body_text_eof //-->
</table>
<!-- body_eof //-->
<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>

<?php } elseif ($action == 'help') { // endif $action != 'help' ?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html  <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>" />
<title>HELP</title>
</head>
<body id="popup"></body>
<div id="popup_header">
<h1>
<?php
  echo HEADING_TITLE;
  echo '<br /><br />';
?>
</h1>
</div>
<div id="popup_content">
<?php
  echo SQLPATCH_HELP_TEXT;
  echo '<br /><br />';
?>
</div>
<?php
  echo '<center>' . '<a href="javascript:window.close()">' . TEXT_CLOSE_WINDOW . '</a></center>';
?>
</body>
</html>
<?php } //endif $action = help ?>