<?php
//
// +----------------------------------------------------------------------+
// |zen-cart Open Source E-commerce                                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2006 The zen-cart developers                           |
// |                                                                      |
// | http://www.zen-cart.com/index.php                                    |
// |                                                                      |
// | Portions Copyright (c) 2003 osCommerce                               |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the GPL license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.zen-cart.com/license/2_0.txt.                             |
// | If you did not receive a copy of the zen-cart license and are unable |
// | to obtain it through the world-wide-web, please send a note to       |
// | license@zen-cart.com so we can mail you a copy immediately.          |
// +----------------------------------------------------------------------+
// $Id: order.php,v 1.3 2006/02/19 02:54:16 shida Exp $
//

  class order {
    var $info, $totals, $products, $customer, $delivery, $content_type;

    function order($order_id = '') {
      $this->info = array();
      $this->totals = array();
      $this->products = array();
      $this->customer = array();
      $this->delivery = array();

      if (zen_not_null($order_id)) {
        $this->query($order_id);
      } else {
        $this->cart();
      }
    }

    function query($order_id) {
      global $db;

      $order_id = zen_db_prepare_input($order_id);

      $order_query = "select customers_id, customers_name, customers_company,
                             customers_street_address, customers_suburb, customers_city,
                             customers_postcode, customers_state, customers_country,
                             customers_telephone, customers_email_address, customers_address_format_id,
                             delivery_name, delivery_company, delivery_street_address, delivery_suburb,
                             delivery_city, delivery_postcode, delivery_state, delivery_country,
                             delivery_address_format_id, billing_name, billing_company,
                             billing_street_address, billing_suburb, billing_city, billing_postcode,
                             billing_state, billing_country, billing_address_format_id, payment_method,
                             cc_type, cc_owner, cc_number, cc_expires, currency, currency_value,
                             date_purchased, orders_status, last_modified, order_total, order_tax
							 , delivery_telephone, delivery_fax, billing_telephone, billing_fax, customers_fax
                      from " . TABLE_ORDERS . "
                      where orders_id = '" . (int)$order_id . "'";

      $order = $db->Execute($order_query);

      $totals_query = "select title, text, class
                       from " . TABLE_ORDERS_TOTAL . "
                       where orders_id = '" . (int)$order_id . "'
                       order by sort_order";

      $totals = $db->Execute($totals_query);

      while (!$totals->EOF) {
        $this->totals[] = array('title' => $totals->fields['title'],
                                'text' => $totals->fields['text'],
                                'class' => $totals->fields['class']);
        $totals->MoveNext();
      }

      $order_total_query = "select text
                            from " . TABLE_ORDERS_TOTAL . "
                            where orders_id = '" . (int)$order_id . "'
                            and class = 'ot_total'";

      $order_total = $db->Execute($order_total_query);

      $shipping_method_query = "select title
                                from " . TABLE_ORDERS_TOTAL . "
                                where orders_id = '" . (int)$order_id . "'
                                and class = 'ot_shipping'";

      $shipping_method = $db->Execute($shipping_method_query);

      $order_status_query = "select orders_status_name
                             from " . TABLE_ORDERS_STATUS . "
                             where orders_status_id = '" . $order->fields['orders_status'] . "'
                             and language_id = '" . (int)$_SESSION['languages_id'] . "'";

      $order_status = $db->Execute($order_status_query);

      $this->info = array('currency' => $order->fields['currency'],
                          'currency_value' => $order->fields['currency_value'],
                          'payment_method' => $order->fields['payment_method'],
                          'cc_type' => $order->fields['cc_type'],
                          'cc_owner' => $order->fields['cc_owner'],
                          'cc_number' => $order->fields['cc_number'],
                          'cc_expires' => $order->fields['cc_expires'],
                          'date_purchased' => $order->fields['date_purchased'],
                          'orders_status' => $order_status->fields['orders_status_name'],
                          'last_modified' => $order->fields['last_modified'],
                          'total' => $order->fields['order_total'],
                          'tax' => $order->fields['order_tax'],
                          'shipping_method' => ((substr($shipping_method->fields['title'], -1) == ':') ? substr(strip_tags($shipping_method->fields['title']), 0, -1) : strip_tags($shipping_method->fields['title'])));

      $this->customer = array('id' => $order->fields['customers_id'],
                              'name' => $order->fields['customers_name'],
                              'company' => $order->fields['customers_company'],
                              'street_address' => $order->fields['customers_street_address'],
                              'suburb' => $order->fields['customers_suburb'],
                              'city' => $order->fields['customers_city'],
                              'postcode' => $order->fields['customers_postcode'],
                              'state' => $order->fields['customers_state'],
                              'country' => $order->fields['customers_country'],
                              'format_id' => $order->fields['customers_address_format_id'],
                              'telephone' => $order->fields['customers_telephone'],
                              'fax' => $order->fields['customers_fax'],
                              'email_address' => $order->fields['customers_email_address']);

      $this->delivery = array('name' => $order->fields['delivery_name'],
                              'company' => $order->fields['delivery_company'],
                              'street_address' => $order->fields['delivery_street_address'],
                              'suburb' => $order->fields['delivery_suburb'],
                              'city' => $order->fields['delivery_city'],
                              'postcode' => $order->fields['delivery_postcode'],
                              'state' => $order->fields['delivery_state'],
                              'country' => $order->fields['delivery_country'],
                              'telephone' => $order->fields['delivery_telephone'],
                              'fax' => $order->fields['delivery_fax'],
                              'format_id' => $order->fields['delivery_address_format_id']);

      if (empty($this->delivery['name']) && empty($this->delivery['street_address'])) {
        $this->delivery = false;
      }

      $this->billing = array('name' => $order->fields['billing_name'],
                             'company' => $order->fields['billing_company'],
                             'street_address' => $order->fields['billing_street_address'],
                             'suburb' => $order->fields['billing_suburb'],
                             'city' => $order->fields['billing_city'],
                             'postcode' => $order->fields['billing_postcode'],
                             'state' => $order->fields['billing_state'],
                             'country' => $order->fields['billing_country'],
                             'telephone' => $order->fields['billing_telephone'],
                             'fax' => $order->fields['billing_fax'],
                             'format_id' => $order->fields['billing_address_format_id']);

      $index = 0;
      $orders_products_query = "select orders_products_id, products_id, products_name,
                                       products_model, products_price, products_tax,
                                       products_quantity, final_price,
                                       onetime_charges,
                                       products_priced_by_attribute, product_is_free, products_discount_type, products_discount_type_from
                                from " . TABLE_ORDERS_PRODUCTS . "
                                where orders_id = '" . (int)$order_id . "'";

      $orders_products = $db->Execute($orders_products_query);

      while (!$orders_products->EOF) {
// convert quantity to proper decimals - account history
          if (QUANTITY_DECIMALS != 0) {
            $fix_qty = $orders_products->fields['products_quantity'];
            switch (true) {
            case (!strstr($fix_qty, '.')):
              $new_qty = $fix_qty;
              break;
            default:
              $new_qty = preg_replace('/[0]+$/', '', $orders_products->fields['products_quantity']);
              break;
            }
          } else {
            $new_qty = $orders_products->fields['products_quantity'];
          }

          $new_qty = round($new_qty, QUANTITY_DECIMALS);

          if ($new_qty == (int)$new_qty) {
            $new_qty = (int)$new_qty;
          }

        $this->products[$index] = array('qty' => $new_qty,
	                                'id' => $orders_products->fields['products_id'],
                                        'name' => $orders_products->fields['products_name'],
                                        'model' => $orders_products->fields['products_model'],
                                        'tax' => $orders_products->fields['products_tax'],
                                        'price' => $orders_products->fields['products_price'],
                                        'final_price' => $orders_products->fields['final_price'],
                                        'onetime_charges' => $orders_products->fields['onetime_charges'],
                                        'products_priced_by_attribute' => $orders_products->fields['products_priced_by_attribute'],
                                        'product_is_free' => $orders_products->fields['product_is_free'],
                                        'products_discount_type' => $orders_products->fields['products_discount_type'],
                                        'products_discount_type_from' => $orders_products->fields['products_discount_type_from']);

        $subindex = 0;
        $attributes_query = "select products_options, products_options_values, options_values_price,
                                    price_prefix from " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . "
                             where orders_id = '" . (int)$order_id . "'
                             and orders_products_id = '" . (int)$orders_products->fields['orders_products_id'] . "'";

        $attributes = $db->Execute($attributes_query);
        if ($attributes->RecordCount()) {
          while (!$attributes->EOF) {
            $this->products[$index]['attributes'][$subindex] = array('option' => $attributes->fields['products_options'],
                                                                     'value' => $attributes->fields['products_options_values'],
                                                                     'prefix' => $attributes->fields['price_prefix'],
                                                                     'price' => $attributes->fields['options_values_price']);

            $subindex++;
            $attributes->MoveNext();
          }
        }

        $this->info['tax_groups']["{$this->products[$index]['tax']}"] = '1';

        $index++;
        $orders_products->MoveNext();
      }
    }

    function cart() {
      global $db, $currencies;

      $this->content_type = $_SESSION['cart']->get_content_type();

      $customer_address_query = "select c.customers_firstname, c.customers_lastname, c.customers_telephone,
                                        c.customers_email_address, ab.entry_company, ab.entry_street_address,
                                        ab.entry_suburb, ab.entry_postcode, ab.entry_city, ab.entry_zone_id,
										ab.entry_telephone, ab.entry_fax,
                                        z.zone_name, co.countries_id, co.countries_name,
                                        co.countries_iso_code_2, co.countries_iso_code_3,
                                        co.address_format_id, ab.entry_state
                                 from " . TABLE_CUSTOMERS . " c, " . TABLE_ADDRESS_BOOK . " ab
                                 left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                 left join " . TABLE_COUNTRIES . " co on (ab.entry_country_id = co.countries_id)
                                 where c.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                 and ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                 and c.customers_default_address_id = ab.address_book_id";

      $customer_address = $db->Execute($customer_address_query);

      $shipping_address_query = "select ab.entry_firstname, ab.entry_lastname, ab.entry_company,
                                        ab.entry_street_address, ab.entry_suburb, ab.entry_postcode,
                                        ab.entry_city, ab.entry_zone_id, z.zone_name, ab.entry_country_id,
										ab.entry_telephone, ab.entry_fax,
                                        c.countries_id, c.countries_name, c.countries_iso_code_2,
                                        c.countries_iso_code_3, c.address_format_id, ab.entry_state
                                 from " . TABLE_ADDRESS_BOOK . " ab
                                 left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                 left join " . TABLE_COUNTRIES . " c on (ab.entry_country_id = c.countries_id)
                                 where ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                 and ab.address_book_id = '" . (int)$_SESSION['sendto'] . "'";

      $shipping_address = $db->Execute($shipping_address_query);

      $billing_address_query = "select ab.entry_firstname, ab.entry_lastname, ab.entry_company,
                                       ab.entry_street_address, ab.entry_suburb, ab.entry_postcode,
                                       ab.entry_city, ab.entry_zone_id, z.zone_name, ab.entry_country_id,
									   ab.entry_telephone, ab.entry_fax,
                                       c.countries_id, c.countries_name, c.countries_iso_code_2,
                                       c.countries_iso_code_3, c.address_format_id, ab.entry_state
                                from " . TABLE_ADDRESS_BOOK . " ab
                                left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                left join " . TABLE_COUNTRIES . " c on (ab.entry_country_id = c.countries_id)
                                where ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                and ab.address_book_id = '" . (int)$_SESSION['billto'] . "'";

      $billing_address = $db->Execute($billing_address_query);
//STORE_PRODUCT_TAX_BASIS
      
      switch (STORE_PRODUCT_TAX_BASIS) {
        case 'Shipping':     

          $tax_address_query = "select ab.entry_country_id, ab.entry_zone_id
                                from " . TABLE_ADDRESS_BOOK . " ab
                                left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                where ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                and ab.address_book_id = '" . (int)($this->content_type == 'virtual' ? $_SESSION['billto'] : $_SESSION['sendto']) . "'";
        break;
        case 'Billing':

          $tax_address_query = "select ab.entry_country_id, ab.entry_zone_id
                                from " . TABLE_ADDRESS_BOOK . " ab
                                left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                where ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                and ab.address_book_id = '" . (int)$_SESSION['billto'] . "'";
        break;
        case 'Store':
          if ($billing_address->fields['entry_zone_id'] == STORE_ZONE) {
	  
            $tax_address_query = "select ab.entry_country_id, ab.entry_zone_id
                                  from " . TABLE_ADDRESS_BOOK . " ab
                                  left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                  where ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                  and ab.address_book_id = '" . (int)$_SESSION['billto'] . "'";
          } else {
            $tax_address_query = "select ab.entry_country_id, ab.entry_zone_id
                                  from " . TABLE_ADDRESS_BOOK . " ab
                                  left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id)
                                  where ab.customers_id = '" . (int)$_SESSION['customer_id'] . "'
                                  and ab.address_book_id = '" . (int)($this->content_type == 'virtual' ? $_SESSION['billto'] : $_SESSION['sendto']) . "'";
          }
     }

      $tax_address = $db->Execute($tax_address_query);

      $class =& $_SESSION['payment'];

      $this->info = array('order_status' => DEFAULT_ORDERS_STATUS_ID,
                          'currency' => $_SESSION['currency'],
                          'currency_value' => $currencies->currencies[$_SESSION['currency']]['value'],
                          'payment_method' => $GLOBALS[$class]->title,
//                          'cc_type' => (isset($GLOBALS['cc_type']) ? $GLOBALS['cc_type'] : ''),
//                          'cc_owner' => (isset($GLOBALS['cc_owner']) ? $GLOBALS['cc_owner'] : ''),
//                          'cc_number' => (isset($GLOBALS['cc_number']) ? $GLOBALS['cc_number'] : ''),
//                          'cc_expires' => (isset($GLOBALS['cc_expires']) ? $GLOBALS['cc_expires'] : ''),
//                          'cc_cvv' => (isset($GLOBALS['cc_cvv']) ? $GLOBALS['cc_cvv'] : ''),
                          'shipping_method' => $_SESSION['shipping']['title'],
                          'shipping_cost' => $_SESSION['shipping']['cost'],
                          'subtotal' => 0,
                          'tax' => 0,
                          'total' => 0,
                          'tax_groups' => array(),
                          'comments' => (isset($_SESSION['comments']) ? $_SESSION['comments'] : ''));

//print_r($GLOBALS[$class]);
//echo $class;
//print_r($GLOBALS);
//echo $_SESSION['payment'];
/*
// this is set above to the module filename it should be set to the module title like Checks/Money Order rather than moneyorder
      if (isset($$_SESSION['payment']) && is_object($$_SESSION['payment'])) {
        $this->info['payment_method'] = $$_SESSION['payment']->title;
      }
*/

      if (isset($GLOBALS[$class]) && is_object($GLOBALS[$class])) {
        if ( isset($GLOBALS[$class]->order_status) && is_numeric($GLOBALS[$class]->order_status) && ($GLOBALS[$class]->order_status > 0) ) {
          $this->info['order_status'] = $GLOBALS[$class]->order_status;
        }
      }

      $this->customer = array('firstname' => $customer_address->fields['customers_firstname'],
                              'lastname' => $customer_address->fields['customers_lastname'],
                              'company' => $customer_address->fields['entry_company'],
                              'street_address' => $customer_address->fields['entry_street_address'],
                              'suburb' => $customer_address->fields['entry_suburb'],
                              'city' => $customer_address->fields['entry_city'],
                              'postcode' => $customer_address->fields['entry_postcode'],
                              'state' => ((zen_not_null($customer_address->fields['entry_state'])) ? $customer_address->fields['entry_state'] : $customer_address->fields['zone_name']),
                              'zone_id' => $customer_address->fields['entry_zone_id'],
                              'country' => array('id' => $customer_address->fields['countries_id'], 'title' => $customer_address->fields['countries_name'], 'iso_code_2' => $customer_address->fields['countries_iso_code_2'], 'iso_code_3' => $customer_address->fields['countries_iso_code_3']),
                              'format_id' => $customer_address->fields['address_format_id'],
                              'telephone' => $customer_address->fields['entry_telephone'],
                              'fax' => $customer_address->fields['entry_fax'],
                              'email_address' => $customer_address->fields['customers_email_address']);

      $this->delivery = array('firstname' => $shipping_address->fields['entry_firstname'],
                              'lastname' => $shipping_address->fields['entry_lastname'],
                              'company' => $shipping_address->fields['entry_company'],
                              'street_address' => $shipping_address->fields['entry_street_address'],
                              'suburb' => $shipping_address->fields['entry_suburb'],
                              'city' => $shipping_address->fields['entry_city'],
                              'postcode' => $shipping_address->fields['entry_postcode'],
                              'state' => ((zen_not_null($shipping_address->fields['entry_state'])) ? $shipping_address->fields['entry_state'] : $shipping_address->fields['zone_name']),
                              'zone_id' => $shipping_address->fields['entry_zone_id'],
                              'country' => array('id' => $shipping_address->fields['countries_id'], 'title' => $shipping_address->fields['countries_name'], 'iso_code_2' => $shipping_address->fields['countries_iso_code_2'], 'iso_code_3' => $shipping_address->fields['countries_iso_code_3']),
                              'country_id' => $shipping_address->fields['entry_country_id'],
                              'telephone' => $shipping_address->fields['entry_telephone'],
                              'fax' => $shipping_address->fields['entry_fax'],
                              'format_id' => $shipping_address->fields['address_format_id']);

      $this->billing = array('firstname' => $billing_address->fields['entry_firstname'],
                             'lastname' => $billing_address->fields['entry_lastname'],
                             'company' => $billing_address->fields['entry_company'],
                             'street_address' => $billing_address->fields['entry_street_address'],
                             'suburb' => $billing_address->fields['entry_suburb'],
                             'city' => $billing_address->fields['entry_city'],
                             'postcode' => $billing_address->fields['entry_postcode'],
                             'state' => ((zen_not_null($billing_address->fields['entry_state'])) ? $billing_address->fields['entry_state'] : $billing_address->fields['zone_name']),
                             'zone_id' => $billing_address->fields['entry_zone_id'],
                             'country' => array('id' => $billing_address->fields['countries_id'], 'title' => $billing_address->fields['countries_name'], 'iso_code_2' => $billing_address->fields['countries_iso_code_2'], 'iso_code_3' => $billing_address->fields['countries_iso_code_3']),
                             'country_id' => $billing_address->fields['entry_country_id'],
                             'telephone' => $billing_address->fields['entry_telephone'],
                             'fax' => $billing_address->fields['entry_fax'],
                             'format_id' => $billing_address->fields['address_format_id']);

      $index = 0;
      $products = $_SESSION['cart']->get_products();
      for ($i=0, $n=sizeof($products); $i<$n; $i++) {
        $this->products[$index] = array('qty' => $products[$i]['quantity'],
                                        'name' => $products[$i]['name'],
                                        'model' => $products[$i]['model'],
                                        'tax' => zen_get_tax_rate($products[$i]['tax_class_id'], $tax_address->fields['entry_country_id'], $tax_address->fields['entry_zone_id']),
                                        'tax_description' => zen_get_tax_description($products[$i]['tax_class_id'], $tax_address->fields['entry_country_id'], $tax_address->fields['entry_zone_id']),
                                        'price' => $products[$i]['price'],
                                        'final_price' => $products[$i]['price'] + $_SESSION['cart']->attributes_price($products[$i]['id']),
                                        'onetime_charges' => $_SESSION['cart']->attributes_price_onetime_charges($products[$i]['id'], $products[$i]['quantity']),
                                        'weight' => $products[$i]['weight'],
                                        'products_priced_by_attribute' => $products[$i]['products_priced_by_attribute'],
                                        'product_is_free' => $products[$i]['product_is_free'],
                                        'products_discount_type' => $products[$i]['products_discount_type'],
                                        'products_discount_type_from' => $products[$i]['products_discount_type_from'],
                                        'id' => $products[$i]['id']);

        if ($products[$i]['attributes']) {
          $subindex = 0;
          reset($products[$i]['attributes']);
          while (list($option, $value) = each($products[$i]['attributes'])) {
/*
	//clr 030714 Determine if attribute is a text attribute and change products array if it is.
            if ($value == PRODUCTS_OPTIONS_VALUES_TEXT_ID){
              $attr_value = $products[$i]['attributes_values'][$option];
            } else {
              $attr_value = $attributes->fields['products_options_values_name'];
            }
*/

            $attributes_query = "select popt.products_options_name, poval.products_options_values_name,
                                        pa.options_values_price, pa.price_prefix
                                 from " . TABLE_PRODUCTS_OPTIONS . " popt,
                                      " . TABLE_PRODUCTS_OPTIONS_VALUES . " poval,
                                      " . TABLE_PRODUCTS_ATTRIBUTES . " pa
                                 where pa.products_id = '" . (int)$products[$i]['id'] . "'
                                 and pa.options_id = '" . (int)$option . "'
                                 and pa.options_id = popt.products_options_id
                                 and pa.options_values_id = '" . (int)$value . "'
                                 and pa.options_values_id = poval.products_options_values_id
                                 and popt.language_id = '" . (int)$_SESSION['languages_id'] . "'
                                 and poval.language_id = '" . (int)$_SESSION['languages_id'] . "'";

            $attributes = $db->Execute($attributes_query);

	//clr 030714 Determine if attribute is a text attribute and change products array if it is.
            if ($value == PRODUCTS_OPTIONS_VALUES_TEXT_ID){
              $attr_value = $products[$i]['attributes_values'][$option];
            } else {
              $attr_value = $attributes->fields['products_options_values_name'];
            }

            $this->products[$index]['attributes'][$subindex] = array('option' => $attributes->fields['products_options_name'],
                                                                     'value' => $attr_value,
                                                                     'option_id' => $option,
                                                                     'value_id' => $value,
                                                                     'prefix' => $attributes->fields['price_prefix'],
                                                                     'price' => $attributes->fields['options_values_price']);

            $subindex++;
          }
        }

// add onetime charges here
//$_SESSION['cart']->attributes_price_onetime_charges($products[$i]['id'], $products[$i]['quantity'])

        $shown_price = (zen_add_tax($this->products[$index]['final_price'], $this->products[$index]['tax']) * $this->products[$index]['qty'])
                      + zen_add_tax($this->products[$index]['onetime_charges'], $this->products[$index]['tax']);
        $this->info['subtotal'] += $shown_price;

        $products_tax = $this->products[$index]['tax'];
        $products_tax_description = $this->products[$index]['tax_description'];

        // calculate the amount of tax "inc"luded in price (used if tax-in pricing is enabled)
        $current_row_tax_inc = $shown_price - ($shown_price / (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax)));

        // calculate the amount of tax for this product (assuming tax is NOT included in the price)
        $current_row_tax_exc = zen_round(($products_tax / 100) * $shown_price, $currencies->currencies[$this->info['currency']]['decimal_places']);

        if (DISPLAY_PRICE_WITH_TAX == 'true') {
          $this->info['tax'] += $current_row_tax_inc;
          if (isset($this->info['tax_groups']["$products_tax_description"])) {
            $this->info['tax_groups']["$products_tax_description"] += $current_row_tax_inc;
          } else {
            $this->info['tax_groups']["$products_tax_description"] = $current_row_tax_inc;
          }
        } else {
          // this adds the tax rate for cases where tax is NOT included in the product
          $this->info['tax'] += $current_row_tax_exc;
          if (isset($this->info['tax_groups']["$products_tax_description"])) {
            $this->info['tax_groups']["$products_tax_description"] += $current_row_tax_exc;
          } else {
            $this->info['tax_groups']["$products_tax_description"] = $current_row_tax_exc;
          }
        }
        $index++;
      }

      if (DISPLAY_PRICE_WITH_TAX == 'true') {
        $this->info['total'] = $this->info['subtotal'] + $this->info['shipping_cost'];
      } else {
        $this->info['total'] = $this->info['subtotal'] + $this->info['tax'] + $this->info['shipping_cost'];
      }
    }
  }
?>
