<?php
//
// +----------------------------------------------------------------------+
// |zen-cart Open Source E-commerce                                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 The zen-cart developers                           |
// |                                                                      |
// | http://www.zen-cart.com/index.php                                    |
// |                                                                      |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the GPL license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.zen-cart.com/license/2_0.txt.                             |
// | If you did not receive a copy of the zen-cart license and are unable |
// | to obtain it through the world-wide-web, please send a note to       |
// | license@zen-cart.com so we can mail you a copy immediately.          |
// +----------------------------------------------------------------------+
// $Id: sniffer.php,v 1.1.1.1 2004/09/01 04:47:51 shidairiki Exp $
//
/**
 * Sniffer Class.
 * This class is used to collect information on the system that Zen Cart is running on
 * and to return error reports
 * @package ZenCart_Classes
*/

  class sniffer {

    function sniffer() {
      $this->browser = Array();
      $this->php = Array();
      $this->server = Array();
      $this->database = Array();
      $this->phpBB = Array();
      $this->get_phpBB_info();
    }

    function get_phpBB_info() {
      //calculate the path from root of server for absolute path info
      $script_filename = $_SERVER['PATH_TRANSLATED'];
      if (empty($script_filename)) $script_filename = $_SERVER['SCRIPT_FILENAME'];
      $script_filename = str_replace(array('\\', '//'), '/', $script_filename);  //convert slashes
      $dir_phpbb = DIR_WS_PHPBB ;
      if (substr(DIR_WS_PHPBB,-1)!='/') $dir_phpbb .= '/'; // ensure has a trailing slash
//echo 'dir='.$dir_phpbb;
      //check if file exists
      if (@file_exists($dir_phpbb . 'config.php')) {
        $this->phpBB['files_installed'] = true;
//echo "files_installed<br>";
        // if exists, also store it for future use
        $this->phpBB['phpbb_path'] = $dir_phpbb;
//echo 'phpbb_path='. $dir_phpbb . '<br>';

       // find phpbb table prefix without including file:
        $lines = array();
        $lines = @file($this->phpBB['phpbb_path']. 'config.php');
        foreach($lines as $line) { // read the configure.php file for specific variables
//echo $line.'<br>';
          if (substr($line,0,13)!='$table_prefix') continue;
          $def_string=array();
          $def_string=explode("'",$line);
          $table_prefix = $def_string[1];
        }//end foreach $line
//echo 'prefix='.$table_prefix.'<br>';

        if ($this->table_exists($table_prefix.TABLE_PHPBB_USERS)) {
          $this->phpBB['db_installed'] = true;
//echo "db_installed<br>";
        }

      }//endif @file_exists

//echo "link_enabled_admin=".PHPBB_LINKS_ENABLED.'<br>';
      if ( ($this->phpBB['db_installed']) && ($this->phpBB['files_installed'])  && (PHPBB_LINKS_ENABLED=='true')) {
       //good so far. now let's check for relative path access so we can successfully "include" the config.php file when needed.
//echo "ok, now let's check relative paths";
//echo 'docroot='.$_SERVER['DOCUMENT_ROOT'].'<br>';
        $this->phpBB['phpbb_url'] = str_replace(array($_SERVER['DOCUMENT_ROOT'],substr($script_filename,0,strpos($script_filename,$_SERVER['PHP_SELF']))),'',$dir_phpbb);
        $this->phpBB['installed'] = true;
//echo 'URL='.$this->phpBB['phpbb_url'].'<br>';
  //      }
        //if neither of the relative paths validate, the function still returns false for 'installed'.
      }
     // will use $sniffer->phpBB['installed'] to check for suitability of calling phpBB in the future.
    }

    function table_exists($table_name) {
      global $db;

    // Check to see if the requested Zen Cart table exists
      $sql = "SHOW TABLES like '".$table_name."'";
//echo $sql.'<br>';
      $tables = $db->Execute($sql);
//echo 'tables_found = '. $tables->RecordCount() .'<br>';
      if ($tables->RecordCount() > 0) {
        $found_table = true;
      }

//      $sql = "SHOW TABLES";
////      $tables = $db->execute($sql);
//      $found_table = false;
////      while (!$tables->EOF) {
////        list(,$table) = each($tables->fields);
////         if ($table == $table_name) {
////           $found_table = true;
////         }
////         $tables->MoveNext();
////      }
//

      return $found_table;
    }

  }
?>