------------------------------------------------------------------
-- My2Pg 1.28 translated dump
--
------------------------------------------------------------------

--
-- Sequences for table ADDRESS_BOOK
--

CREATE SEQUENCE address_book_address_book_id;

-- Table structure for table address_book
--

CREATE TABLE address_book (
  address_book_id INT4 DEFAULT nextval('address_book_address_book_id'),
  customers_id INT4 NOT NULL DEFAULT '0',
  entry_gender char(1) NOT NULL DEFAULT '',
  entry_company varchar(32) DEFAULT NULL,
  entry_firstname varchar(32) NOT NULL DEFAULT '',
  entry_lastname varchar(32) NOT NULL DEFAULT '',
  entry_street_address varchar(64) NOT NULL DEFAULT '',
  entry_suburb varchar(32) DEFAULT NULL,
  entry_postcode varchar(10) NOT NULL DEFAULT '',
  entry_city varchar(32) NOT NULL DEFAULT '',
  entry_state varchar(32) DEFAULT NULL,
  entry_country_id INT4 NOT NULL DEFAULT '0',
  entry_zone_id INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (address_book_id)

);

-- --------------------------------------------------------

--
-- Table structure for table address_format
--



--
-- Sequences for table ADDRESS_FORMAT
--

CREATE SEQUENCE address_format_address_forma;

CREATE TABLE address_format (
  address_format_id INT4 DEFAULT nextval('address_format_address_forma'),
  address_format varchar(128) NOT NULL DEFAULT '',
  address_summary varchar(48) NOT NULL DEFAULT '',
  PRIMARY KEY (address_format_id)

);

-- --------------------------------------------------------

--
-- Table structure for table admin
--



--
-- Sequences for table ADMIN
--

CREATE SEQUENCE admin_admin_id_seq;

CREATE TABLE admin (
  admin_id INT4 DEFAULT nextval('admin_admin_id_seq'),
  admin_name varchar(32) NOT NULL DEFAULT '',
  admin_email varchar(96) NOT NULL DEFAULT '',
  admin_pass varchar(40) NOT NULL DEFAULT '',
  admin_level INT2 NOT NULL DEFAULT '1',
  PRIMARY KEY (admin_id)

);

-- --------------------------------------------------------

--
-- Table structure for table banners
--



--
-- Sequences for table BANNERS
--

CREATE SEQUENCE banners_banners_id_seq;

CREATE TABLE banners (
  banners_id INT4 DEFAULT nextval('banners_banners_id_seq'),
  banners_title varchar(64) NOT NULL DEFAULT '',
  banners_url varchar(255) NOT NULL DEFAULT '',
  banners_image varchar(64) NOT NULL DEFAULT '',
  banners_group varchar(10) NOT NULL DEFAULT '',
  banners_html_text text,
  expires_impressions INT4 DEFAULT '0',
  expires_date TIMESTAMP DEFAULT NULL,
  date_scheduled TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  date_status_change TIMESTAMP DEFAULT NULL,
  status INT4 NOT NULL DEFAULT '1',
  PRIMARY KEY (banners_id)

);

-- --------------------------------------------------------

--
-- Table structure for table banners_history
--



--
-- Sequences for table BANNERS_HISTORY
--

CREATE SEQUENCE banners_history_banners_hist;

CREATE TABLE banners_history (
  banners_history_id INT4 DEFAULT nextval('banners_history_banners_hist'),
  banners_id INT4 NOT NULL DEFAULT '0',
  banners_shown INT4 NOT NULL DEFAULT '0',
  banners_clicked INT4 NOT NULL DEFAULT '0',
  banners_history_date TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (banners_history_id)

);

-- --------------------------------------------------------

--
-- Table structure for table categories
--



--
-- Sequences for table CATEGORIES
--

CREATE SEQUENCE categories_categories_id_seq;

CREATE TABLE categories (
  categories_id INT4 DEFAULT nextval('categories_categories_id_seq'),
  categories_image varchar(64) DEFAULT NULL,
  parent_id INT4 NOT NULL DEFAULT '0',
  sort_order INT4 DEFAULT NULL,
  date_added TIMESTAMP DEFAULT NULL,
  last_modified TIMESTAMP DEFAULT NULL,
  PRIMARY KEY (categories_id)

);

-- --------------------------------------------------------

--
-- Table structure for table categories_description
--

CREATE TABLE categories_description (
  categories_id INT4 NOT NULL DEFAULT '0',
  language_id INT4 NOT NULL DEFAULT '1',
  categories_name varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (categories_id,language_id)

);

-- --------------------------------------------------------

--
-- Table structure for table configuration
--



--
-- Sequences for table CONFIGURATION
--

CREATE SEQUENCE configuration_configuration_;

CREATE TABLE configuration (
  configuration_id INT4 DEFAULT nextval('configuration_configuration_'),
  configuration_title TEXT DEFAULT '' NOT NULL,
  configuration_key varchar(64) NOT NULL DEFAULT '',
  configuration_value TEXT DEFAULT '' NOT NULL,
  configuration_description TEXT DEFAULT '' NOT NULL,
  configuration_group_id INT4 NOT NULL DEFAULT '0',
  sort_order INT4 DEFAULT NULL,
  last_modified TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  use_function text DEFAULT NULL,
  set_function text DEFAULT NULL,
  PRIMARY KEY (configuration_id)

);

-- --------------------------------------------------------

--
-- Table structure for table configuration_group
--



--
-- Sequences for table CONFIGURATION_GROUP
--

CREATE SEQUENCE configuration_group_configur;

CREATE TABLE configuration_group (
  configuration_group_id INT4 DEFAULT nextval('configuration_group_configur'),
  configuration_group_title varchar(64) NOT NULL DEFAULT '',
  configuration_group_description varchar(255) NOT NULL DEFAULT '',
  sort_order INT4 DEFAULT NULL,
  visible INT4 DEFAULT '1',
  PRIMARY KEY (configuration_group_id)

);

-- --------------------------------------------------------

--
-- Table structure for table counter
--

CREATE TABLE counter (
  startdate char(8) DEFAULT NULL,
  counter INT4 DEFAULT NULL
);

-- --------------------------------------------------------

--
-- Table structure for table counter_history
--

CREATE TABLE counter_history (
  month char(8) DEFAULT NULL,
  counter INT4 DEFAULT NULL
);

-- --------------------------------------------------------

--
-- Table structure for table countries
--



--
-- Sequences for table COUNTRIES
--

CREATE SEQUENCE countries_countries_id_seq;

CREATE TABLE countries (
  countries_id INT4 DEFAULT nextval('countries_countries_id_seq'),
  countries_name varchar(64) NOT NULL DEFAULT '',
  countries_iso_code_2 char(2) NOT NULL DEFAULT '',
  countries_iso_code_3 char(3) NOT NULL DEFAULT '',
  address_format_id INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (countries_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupon_email_track
--



--
-- Sequences for table COUPON_EMAIL_TRACK
--

CREATE SEQUENCE coupon_email_track_unique_id;

CREATE TABLE coupon_email_track (
  unique_id INT4 DEFAULT nextval('coupon_email_track_unique_id'),
  coupon_id INT4 NOT NULL DEFAULT '0',
  customer_id_sent INT4 NOT NULL DEFAULT '0',
  sent_firstname varchar(32) DEFAULT NULL,
  sent_lastname varchar(32) DEFAULT NULL,
  emailed_to varchar(32) DEFAULT NULL,
  date_sent TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (unique_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupon_gv_customer
--

CREATE TABLE coupon_gv_customer (
  customer_id INT4 NOT NULL DEFAULT '0',
  amount decimal(8,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (customer_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupon_gv_queue
--



--
-- Sequences for table COUPON_GV_QUEUE
--

CREATE SEQUENCE coupon_gv_queue_unique_id_se;

CREATE TABLE coupon_gv_queue (
  unique_id INT4 DEFAULT nextval('coupon_gv_queue_unique_id_se'),
  customer_id INT4 NOT NULL DEFAULT '0',
  order_id INT4 NOT NULL DEFAULT '0',
  amount decimal(8,4) NOT NULL DEFAULT '0.0000',
  date_created TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  ipaddr varchar(32) NOT NULL DEFAULT '',
  release_flag char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (unique_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupon_redeem_track
--



--
-- Sequences for table COUPON_REDEEM_TRACK
--

CREATE SEQUENCE coupon_redeem_track_unique_i;

CREATE TABLE coupon_redeem_track (
  unique_id INT4 DEFAULT nextval('coupon_redeem_track_unique_i'),
  coupon_id INT4 NOT NULL DEFAULT '0',
  customer_id INT4 NOT NULL DEFAULT '0',
  redeem_date TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  redeem_ip varchar(32) NOT NULL DEFAULT '',
  order_id INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (unique_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupon_restrict
--



--
-- Sequences for table COUPON_RESTRICT
--

CREATE SEQUENCE coupon_restrict_restrict_id_;

CREATE TABLE coupon_restrict (
  restrict_id INT4 DEFAULT nextval('coupon_restrict_restrict_id_'),
  coupon_id INT4 NOT NULL DEFAULT '0',
  product_id INT4 NOT NULL DEFAULT '0',
  category_id INT4 NOT NULL DEFAULT '0',
  coupon_restrict char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (restrict_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupons
--



--
-- Sequences for table COUPONS
--

CREATE SEQUENCE coupons_coupon_id_seq;

CREATE TABLE coupons (
  coupon_id INT4 DEFAULT nextval('coupons_coupon_id_seq'),
  coupon_type char(1) NOT NULL DEFAULT 'F',
  coupon_code varchar(32) NOT NULL DEFAULT '',
  coupon_amount decimal(8,4) NOT NULL DEFAULT '0.0000',
  coupon_minimum_order decimal(8,4) NOT NULL DEFAULT '0.0000',
  coupon_start_date TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  coupon_expire_date TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  uses_per_coupon INT4 NOT NULL DEFAULT '1',
  uses_per_user INT4 NOT NULL DEFAULT '0',
  restrict_to_products varchar(255) DEFAULT NULL,
  restrict_to_categories varchar(255) DEFAULT NULL,
  restrict_to_customers text,
  coupon_active char(1) NOT NULL DEFAULT 'Y',
  date_created TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  date_modified TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (coupon_id)

);

-- --------------------------------------------------------

--
-- Table structure for table coupons_description
--

CREATE TABLE coupons_description (
  coupon_id INT4 NOT NULL DEFAULT '0',
  language_id INT4 NOT NULL DEFAULT '0',
  coupon_name varchar(32) NOT NULL DEFAULT '',
  coupon_description text
);

-- --------------------------------------------------------

--
-- Table structure for table currencies
--



--
-- Sequences for table CURRENCIES
--

CREATE SEQUENCE currencies_currencies_id_seq;

CREATE TABLE currencies (
  currencies_id INT4 DEFAULT nextval('currencies_currencies_id_seq'),
  title varchar(32) NOT NULL DEFAULT '',
  code char(3) NOT NULL DEFAULT '',
  symbol_left varchar(24) DEFAULT NULL,
  symbol_right varchar(24) DEFAULT NULL,
  decimal_point char(1) DEFAULT NULL,
  thousands_point char(1) DEFAULT NULL,
  decimal_places char(1) DEFAULT NULL,
  value DECIMAL(13,8) DEFAULT NULL,
  last_updated TIMESTAMP DEFAULT NULL,
  PRIMARY KEY (currencies_id)

);

-- --------------------------------------------------------

--
-- Table structure for table customers
--



--
-- Sequences for table CUSTOMERS
--

CREATE SEQUENCE customers_customers_id_seq;

CREATE TABLE customers (
  customers_id INT4 DEFAULT nextval('customers_customers_id_seq'),
  customers_gender char(1) NOT NULL DEFAULT '',
  customers_firstname varchar(32) NOT NULL DEFAULT '',
  customers_lastname varchar(32) NOT NULL DEFAULT '',
  customers_dob TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  customers_email_address varchar(96) NOT NULL DEFAULT '',
  customers_nick varchar(96) NOT NULL DEFAULT '',
  customers_DEFAULT_address_id INT4 NOT NULL default '0',
  customers_telephone varchar(32) NOT NULL DEFAULT '',
  customers_fax varchar(32) DEFAULT NULL,
  customers_password varchar(40) NOT NULL DEFAULT '',
  customers_newsletter char(1) DEFAULT NULL,
  PRIMARY KEY (customers_id)

);

-- --------------------------------------------------------

--
-- Table structure for table customers_basket
--



--
-- Sequences for table CUSTOMERS_BASKET
--

CREATE SEQUENCE customers_basket_customers_b;

CREATE TABLE customers_basket (
  customers_basket_id INT4 DEFAULT nextval('customers_basket_customers_b'),
  customers_id INT4 NOT NULL DEFAULT '0',
  products_id TEXT DEFAULT '' NOT NULL,
  customers_basket_quantity decimal(11,3) NOT NULL DEFAULT '0.000',
  final_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  customers_basket_date_added varchar(8) DEFAULT NULL,
  PRIMARY KEY (customers_basket_id)

);

-- --------------------------------------------------------

--
-- Table structure for table customers_basket_attributes
--



--
-- Sequences for table CUSTOMERS_BASKET_ATTRIBUTES
--

CREATE SEQUENCE customers_basket_attributes_;

CREATE TABLE customers_basket_attributes (
  customers_basket_attributes_id INT4 DEFAULT nextval('customers_basket_attributes_'),
  customers_id INT4 NOT NULL DEFAULT '0',
  products_id TEXT DEFAULT '' NOT NULL,
  products_options_id varchar(64) NOT NULL DEFAULT '0',
  products_options_value_id INT4 NOT NULL DEFAULT '0',
  products_options_value_text varchar(64) DEFAULT NULL,
  products_options_sort_order INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (customers_basket_attributes_id)

);

-- --------------------------------------------------------

--
-- Table structure for table customers_info
--

CREATE TABLE customers_info (
  customers_info_id INT4 NOT NULL DEFAULT '0',
  customers_info_date_of_last_logon TIMESTAMP DEFAULT NULL,
  customers_info_number_of_logons INT4 DEFAULT NULL,
  customers_info_date_account_created TIMESTAMP DEFAULT NULL,
  customers_info_date_account_last_modified TIMESTAMP DEFAULT NULL,
  global_product_notifications INT4 DEFAULT '0',
  PRIMARY KEY (customers_info_id)

);

-- --------------------------------------------------------

--
-- Table structure for table db_cache
--
CREATE TABLE db_cache (
  cache_entry_name varchar(64) NOT NULL,
  cache_data text,
  cache_entry_created TIMESTAMP,
  cache_entry_expires TIMESTAMP,
  PRIMARY KEY (cache_entry_name)

);


-- --------------------------------------------------------

--
-- Table structure for table discount_quantity
--
CREATE TABLE discount_quantity (
  discount_id INT4 NOT NULL DEFAULT '0',
  products_id INT4 NOT NULL DEFAULT '0',
  discount_qty decimal(11,3) NOT NULL DEFAULT '0.000',
  discount_price decimal(15,4) NOT NULL DEFAULT '0.0000'
);

-- --------------------------------------------------------

--
-- Table structure for table featured
--



--
-- Sequences for table FEATURED
--

CREATE SEQUENCE featured_featured_id_seq;

CREATE TABLE featured (
  featured_id INT4 DEFAULT nextval('featured_featured_id_seq'),
  products_id INT4 NOT NULL DEFAULT '0',
  featured_date_added TIMESTAMP DEFAULT NULL,
  featured_last_modified TIMESTAMP DEFAULT NULL,
  expires_date DATE NOT NULL DEFAULT '0001-01-01',
  date_status_change TIMESTAMP DEFAULT NULL,
  status INT4 NOT NULL DEFAULT '1',
  featured_date_available DATE NOT NULL DEFAULT '0001-01-01',
  PRIMARY KEY (featured_id)

);

-- --------------------------------------------------------

--
-- Table structure for table files_uploaded
--



--
-- Sequences for table FILES_UPLOADED
--

CREATE SEQUENCE files_uploaded_files_uploade;

CREATE TABLE files_uploaded (
  files_uploaded_id INT4 DEFAULT nextval('files_uploaded_files_uploade'),
  sesskey varchar(32) DEFAULT NULL,
  customers_id INT4 DEFAULT NULL,
  files_uploaded_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (files_uploaded_id)

);

-- --------------------------------------------------------

--
-- Table structure for table geo_zones
--



--
-- Sequences for table GEO_ZONES
--

CREATE SEQUENCE geo_zones_geo_zone_id_seq;

CREATE TABLE geo_zones (
  geo_zone_id INT4 DEFAULT nextval('geo_zones_geo_zone_id_seq'),
  geo_zone_name varchar(32) NOT NULL DEFAULT '',
  geo_zone_description varchar(255) NOT NULL DEFAULT '',
  last_modified TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (geo_zone_id)

);

-- --------------------------------------------------------

--
-- Table structure for table languages
--



--
-- Sequences for table LANGUAGES
--

CREATE SEQUENCE languages_languages_id_seq;

CREATE TABLE languages (
  languages_id INT4 DEFAULT nextval('languages_languages_id_seq'),
  name varchar(32) NOT NULL DEFAULT '',
  code char(2) NOT NULL DEFAULT '',
  image varchar(64) DEFAULT NULL,
  directory varchar(32) DEFAULT NULL,
  sort_order INT4 DEFAULT NULL,
  PRIMARY KEY (languages_id)

);

-- --------------------------------------------------------

--
-- Table structure for table layout_boxes
--



--
-- Sequences for table LAYOUT_BOXES
--

CREATE SEQUENCE layout_boxes_layout_id_seq;

CREATE TABLE layout_boxes (
  layout_id INT4 DEFAULT nextval('layout_boxes_layout_id_seq'),
  layout_template varchar(64) NOT NULL DEFAULT '',
  layout_box_name varchar(64) NOT NULL DEFAULT '',
  layout_box_status INT2 NOT NULL DEFAULT '0',
  layout_box_location INT2 NOT NULL DEFAULT '0',
  layout_box_sort_order INT4 NOT NULL DEFAULT '0',
  layout_box_sort_order_single INT4 NOT NULL DEFAULT '0',
  layout_box_status_single INT2 NOT NULL DEFAULT '0',
  PRIMARY KEY (layout_id)

);

-- --------------------------------------------------------

--
-- Table structure for table manufacturers
--



--
-- Sequences for table MANUFACTURERS
--

CREATE SEQUENCE manufacturers_manufacturers_;

CREATE TABLE manufacturers (
  manufacturers_id INT4 DEFAULT nextval('manufacturers_manufacturers_'),
  manufacturers_name varchar(32) NOT NULL DEFAULT '',
  manufacturers_image varchar(64) DEFAULT NULL,
  date_added TIMESTAMP DEFAULT NULL,
  last_modified TIMESTAMP DEFAULT NULL,
  PRIMARY KEY (manufacturers_id)

);

-- --------------------------------------------------------

--
-- Table structure for table manufacturers_info
--

CREATE TABLE manufacturers_info (
  manufacturers_id INT4 NOT NULL DEFAULT '0',
  languages_id INT4 NOT NULL DEFAULT '0',
  manufacturers_url varchar(255) NOT NULL DEFAULT '',
  url_clicked INT4 NOT NULL DEFAULT '0',
  date_last_click TIMESTAMP DEFAULT NULL,
  PRIMARY KEY (manufacturers_id,languages_id)

);

-- --------------------------------------------------------

--
-- Table structure for table newsletters
--



--
-- Sequences for table NEWSLETTERS
--

CREATE SEQUENCE newsletters_newsletters_id_s;

CREATE TABLE newsletters (
  newsletters_id INT4 DEFAULT nextval('newsletters_newsletters_id_s'),
  title varchar(255) NOT NULL DEFAULT '',
  content TEXT DEFAULT '' NOT NULL,
  module varchar(255) NOT NULL DEFAULT '',
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  date_sent TIMESTAMP DEFAULT NULL,
  status INT4 DEFAULT NULL,
  locked INT4 DEFAULT '0',
  PRIMARY KEY (newsletters_id)

);

-- --------------------------------------------------------

--
-- Table structure for table orders
--



--
-- Sequences for table ORDERS
--

CREATE SEQUENCE orders_orders_id_seq;

CREATE TABLE orders (
  orders_id INT4 DEFAULT nextval('orders_orders_id_seq'),
  customers_id INT4 NOT NULL DEFAULT '0',
  customers_name varchar(64) NOT NULL DEFAULT '',
  customers_company varchar(32) DEFAULT NULL,
  customers_street_address varchar(64) NOT NULL DEFAULT '',
  customers_suburb varchar(32) DEFAULT NULL,
  customers_city varchar(32) NOT NULL DEFAULT '',
  customers_postcode varchar(10) NOT NULL DEFAULT '',
  customers_state varchar(32) DEFAULT NULL,
  customers_country varchar(32) NOT NULL DEFAULT '',
  customers_telephone varchar(32) NOT NULL DEFAULT '',
  customers_email_address varchar(96) NOT NULL DEFAULT '',
  customers_address_format_id INT4 NOT NULL DEFAULT '0',
  delivery_name varchar(64) NOT NULL DEFAULT '',
  delivery_company varchar(32) DEFAULT NULL,
  delivery_street_address varchar(64) NOT NULL DEFAULT '',
  delivery_suburb varchar(32) DEFAULT NULL,
  delivery_city varchar(32) NOT NULL DEFAULT '',
  delivery_postcode varchar(10) NOT NULL DEFAULT '',
  delivery_state varchar(32) DEFAULT NULL,
  delivery_country varchar(32) NOT NULL DEFAULT '',
  delivery_address_format_id INT4 NOT NULL DEFAULT '0',
  billing_name varchar(64) NOT NULL DEFAULT '',
  billing_company varchar(32) DEFAULT NULL,
  billing_street_address varchar(64) NOT NULL DEFAULT '',
  billing_suburb varchar(32) DEFAULT NULL,
  billing_city varchar(32) NOT NULL DEFAULT '',
  billing_postcode varchar(10) NOT NULL DEFAULT '',
  billing_state varchar(32) DEFAULT NULL,
  billing_country varchar(32) NOT NULL DEFAULT '',
  billing_address_format_id INT4 NOT NULL DEFAULT '0',
  payment_method varchar(32) NOT NULL DEFAULT '',
  cc_type varchar(20) DEFAULT NULL,
  cc_owner varchar(64) DEFAULT NULL,
  cc_number varchar(32) DEFAULT NULL,
  cc_expires varchar(4) DEFAULT NULL,
  cc_cvv text,
  last_modified TIMESTAMP DEFAULT NULL,
  date_purchased TIMESTAMP DEFAULT NULL,
  orders_date_finished TIMESTAMP DEFAULT NULL,
  orders_status INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (orders_id)

);


-- --------------------------------------------------------

--
-- Table structure for table orders_products
--



--
-- Sequences for table ORDERS_PRODUCTS
--

CREATE SEQUENCE orders_products_orders_produ;

CREATE TABLE orders_products (
  orders_products_id INT4 DEFAULT nextval('orders_products_orders_produ'),
  orders_id INT4 NOT NULL DEFAULT '0',
  products_id INT4 NOT NULL DEFAULT '0',
  products_model varchar(32) DEFAULT NULL,
  products_name varchar(64) NOT NULL DEFAULT '',
  products_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  final_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  products_tax decimal(7,4) NOT NULL DEFAULT '0.0000',
  products_quantity decimal(11,3) NOT NULL DEFAULT '0.000',
  onetime_charges decimal(15,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (orders_products_id)

);

-- --------------------------------------------------------

--
-- Table structure for table orders_products_attributes
--



--
-- Sequences for table ORDERS_PRODUCTS_ATTRIBUTES
--

CREATE SEQUENCE orders_products_attributes_o;

CREATE TABLE orders_products_attributes (
  orders_products_attributes_id INT4 DEFAULT nextval('orders_products_attributes_o'),
  orders_id INT4 NOT NULL DEFAULT '0',
  orders_products_id INT4 NOT NULL DEFAULT '0',
  products_options varchar(32) NOT NULL DEFAULT '',
  products_options_values varchar(32) NOT NULL DEFAULT '',
  options_values_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  price_prefix char(1) NOT NULL DEFAULT '',
  product_attribute_is_free INT2 NOT NULL DEFAULT '0',
  products_attributes_weight decimal(8,4) NOT NULL DEFAULT '0.0000',
  products_attributes_weight_prefix char(1) NOT NULL DEFAULT '',
  attributes_discounted INT2 NOT NULL DEFAULT '1',
  attributes_price_base_included INT2 NOT NULL DEFAULT '1',
  attributes_price_onetime decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor_offset decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor_onetime decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor_onetime_offset decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_qty_prices text,
  attributes_qty_prices_onetime text,
  attributes_price_words decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_words_free INT4 NOT NULL DEFAULT '0',
  attributes_price_letters decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_letters_free INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (orders_products_attributes_id)

);

-- --------------------------------------------------------

--
-- Table structure for table orders_products_download
--



--
-- Sequences for table ORDERS_PRODUCTS_DOWNLOAD
--

CREATE SEQUENCE orders_products_download_ord;

CREATE TABLE orders_products_download (
  orders_products_download_id INT4 DEFAULT nextval('orders_products_download_ord'),
  orders_id INT4 NOT NULL DEFAULT '0',
  orders_products_id INT4 NOT NULL DEFAULT '0',
  orders_products_filename varchar(255) NOT NULL DEFAULT '',
  download_maxdays INT4 NOT NULL DEFAULT '0',
  download_count INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (orders_products_download_id)

);

-- --------------------------------------------------------

--
-- Table structure for table orders_status
--

CREATE TABLE orders_status (
  orders_status_id INT4 NOT NULL DEFAULT '0',
  language_id INT4 NOT NULL DEFAULT '1',
  orders_status_name varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (orders_status_id,language_id)

);

-- --------------------------------------------------------

--
-- Table structure for table orders_status_history
--



--
-- Sequences for table ORDERS_STATUS_HISTORY
--

CREATE SEQUENCE orders_status_history_orders;

CREATE TABLE orders_status_history (
  orders_status_history_id INT4 DEFAULT nextval('orders_status_history_orders'),
  orders_id INT4 NOT NULL DEFAULT '0',
  orders_status_id INT4 NOT NULL DEFAULT '0',
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  customer_notified INT4 DEFAULT '0',
  comments text,
  PRIMARY KEY (orders_status_history_id)

);

-- --------------------------------------------------------

--
-- Table structure for table orders_total
--



--
-- Sequences for table ORDERS_TOTAL
--

CREATE SEQUENCE orders_total_orders_total_id;

CREATE TABLE orders_total (
  orders_total_id INT4 DEFAULT nextval('orders_total_orders_total_id'),
  orders_id INT4 NOT NULL DEFAULT '0',
  title varchar(255) NOT NULL DEFAULT '',
  text varchar(255) NOT NULL DEFAULT '',
  value decimal(15,4) NOT NULL DEFAULT '0.0000',
  class varchar(32) NOT NULL DEFAULT '',
  sort_order INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (orders_total_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_auth_access
--

CREATE TABLE phpbb_auth_access (
  group_id INT4 NOT NULL DEFAULT '0',
  forum_id INT2  NOT NULL DEFAULT '0',
  auth_view INT2 NOT NULL DEFAULT '0',
  auth_read INT2 NOT NULL DEFAULT '0',
  auth_post INT2 NOT NULL DEFAULT '0',
  auth_reply INT2 NOT NULL DEFAULT '0',
  auth_edit INT2 NOT NULL DEFAULT '0',
  auth_delete INT2 NOT NULL DEFAULT '0',
  auth_sticky INT2 NOT NULL DEFAULT '0',
  auth_announce INT2 NOT NULL DEFAULT '0',
  auth_vote INT2 NOT NULL DEFAULT '0',
  auth_pollcreate INT2 NOT NULL DEFAULT '0',
  auth_attachments INT2 NOT NULL DEFAULT '0',
  auth_mod INT2 NOT NULL DEFAULT '0'
);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_banlist
--



--
-- Sequences for table PHPBB_BANLIST
--

CREATE SEQUENCE phpbb_banlist_ban_id_seq;

CREATE TABLE phpbb_banlist (
  ban_id INT4 DEFAULT nextval('phpbb_banlist_ban_id_seq'),
  ban_userid INT4 NOT NULL DEFAULT '0',
  ban_ip varchar(8) NOT NULL DEFAULT '',
  ban_email varchar(255) DEFAULT NULL,
  PRIMARY KEY (ban_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_categories
--



--
-- Sequences for table PHPBB_CATEGORIES
--

CREATE SEQUENCE phpbb_categories_cat_id_seq;

CREATE TABLE phpbb_categories (
  cat_id INT4 DEFAULT nextval('phpbb_categories_cat_id_seq'),
  cat_title varchar(100) DEFAULT NULL,
  cat_order INT4  NOT NULL DEFAULT '0',
  PRIMARY KEY (cat_id),
  CHECK (cat_order>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_config
--

CREATE TABLE phpbb_config (
  config_name varchar(255) NOT NULL DEFAULT '',
  config_value varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (config_name)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_confirm
--

CREATE TABLE phpbb_confirm (
  confirm_id char(32) NOT NULL DEFAULT '',
  session_id char(32) NOT NULL DEFAULT '',
  code char(6) NOT NULL DEFAULT '',
  PRIMARY KEY (session_id,confirm_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_disallow
--



--
-- Sequences for table PHPBB_DISALLOW
--

CREATE SEQUENCE phpbb_disallow_disallow_id_s;

CREATE TABLE phpbb_disallow (
  disallow_id INT4 DEFAULT nextval('phpbb_disallow_disallow_id_s'),
  disallow_username varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (disallow_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_forum_prune
--



--
-- Sequences for table PHPBB_FORUM_PRUNE
--

CREATE SEQUENCE phpbb_forum_prune_prune_id_s;

CREATE TABLE phpbb_forum_prune (
  prune_id INT4 DEFAULT nextval('phpbb_forum_prune_prune_id_s'),
  forum_id INT2  NOT NULL DEFAULT '0',
  prune_days INT2  NOT NULL DEFAULT '0',
  prune_freq INT2  NOT NULL DEFAULT '0',
  PRIMARY KEY (prune_id),
  CHECK (forum_id>=0),
  CHECK (prune_days>=0),
  CHECK (prune_freq>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_forums
--

CREATE TABLE phpbb_forums (
  forum_id INT2  NOT NULL DEFAULT '0',
  cat_id INT4  NOT NULL DEFAULT '0',
  forum_name varchar(150) DEFAULT NULL,
  forum_desc text,
  forum_status INT2 NOT NULL DEFAULT '0',
  forum_order INT4  NOT NULL DEFAULT '1',
  forum_posts INT4  NOT NULL DEFAULT '0',
  forum_topics INT4  NOT NULL DEFAULT '0',
  forum_last_post_id INT4  NOT NULL DEFAULT '0',
  prune_next INT4 DEFAULT NULL,
  prune_enable INT2 NOT NULL DEFAULT '0',
  auth_view INT2 NOT NULL DEFAULT '0',
  auth_read INT2 NOT NULL DEFAULT '0',
  auth_post INT2 NOT NULL DEFAULT '0',
  auth_reply INT2 NOT NULL DEFAULT '0',
  auth_edit INT2 NOT NULL DEFAULT '0',
  auth_delete INT2 NOT NULL DEFAULT '0',
  auth_sticky INT2 NOT NULL DEFAULT '0',
  auth_announce INT2 NOT NULL DEFAULT '0',
  auth_vote INT2 NOT NULL DEFAULT '0',
  auth_pollcreate INT2 NOT NULL DEFAULT '0',
  auth_attachments INT2 NOT NULL DEFAULT '0',
  PRIMARY KEY (forum_id),
  CHECK (forum_id>=0),
  CHECK (cat_id>=0),
  CHECK (forum_order>=0),
  CHECK (forum_posts>=0),
  CHECK (forum_topics>=0),
  CHECK (forum_last_post_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_groups
--



--
-- Sequences for table PHPBB_GROUPS
--

CREATE SEQUENCE phpbb_groups_group_id_seq;

CREATE TABLE phpbb_groups (
  group_id INT4 DEFAULT nextval('phpbb_groups_group_id_seq'),
  group_type INT2 NOT NULL DEFAULT '1',
  group_name varchar(40) NOT NULL DEFAULT '',
  group_description varchar(255) NOT NULL DEFAULT '',
  group_moderator INT4 NOT NULL DEFAULT '0',
  group_single_user INT2 NOT NULL DEFAULT '1',
  PRIMARY KEY (group_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_posts
--



--
-- Sequences for table PHPBB_POSTS
--

CREATE SEQUENCE phpbb_posts_post_id_seq;

CREATE TABLE phpbb_posts (
  post_id INT4 DEFAULT nextval('phpbb_posts_post_id_seq'),
  topic_id INT4  NOT NULL DEFAULT '0',
  forum_id INT2  NOT NULL DEFAULT '0',
  poster_id INT4 NOT NULL DEFAULT '0',
  post_time INT4 NOT NULL DEFAULT '0',
  poster_ip varchar(8) NOT NULL DEFAULT '',
  post_username varchar(25) DEFAULT NULL,
  enable_bbcode INT2 NOT NULL DEFAULT '1',
  enable_html INT2 NOT NULL DEFAULT '0',
  enable_smilies INT2 NOT NULL DEFAULT '1',
  enable_sig INT2 NOT NULL DEFAULT '1',
  post_edit_time INT4 DEFAULT NULL,
  post_edit_count INT2  NOT NULL DEFAULT '0',
  PRIMARY KEY (post_id),
  CHECK (topic_id>=0),
  CHECK (forum_id>=0),
  CHECK (post_edit_count>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_posts_text
--

CREATE TABLE phpbb_posts_text (
  post_id INT4  NOT NULL DEFAULT '0',
  bbcode_uid varchar(10) NOT NULL DEFAULT '',
  post_subject varchar(60) DEFAULT NULL,
  post_text text,
  PRIMARY KEY (post_id),
  CHECK (post_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_privmsgs
--



--
-- Sequences for table PHPBB_PRIVMSGS
--

CREATE SEQUENCE phpbb_privmsgs_privmsgs_id_s;

CREATE TABLE phpbb_privmsgs (
  privmsgs_id INT4 DEFAULT nextval('phpbb_privmsgs_privmsgs_id_s'),
  privmsgs_type INT2 NOT NULL DEFAULT '0',
  privmsgs_subject varchar(255) NOT NULL DEFAULT '0',
  privmsgs_from_userid INT4 NOT NULL DEFAULT '0',
  privmsgs_to_userid INT4 NOT NULL DEFAULT '0',
  privmsgs_date INT4 NOT NULL DEFAULT '0',
  privmsgs_ip varchar(8) NOT NULL DEFAULT '',
  privmsgs_enable_bbcode INT2 NOT NULL DEFAULT '1',
  privmsgs_enable_html INT2 NOT NULL DEFAULT '0',
  privmsgs_enable_smilies INT2 NOT NULL DEFAULT '1',
  privmsgs_attach_sig INT2 NOT NULL DEFAULT '1',
  PRIMARY KEY (privmsgs_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_privmsgs_text
--

CREATE TABLE phpbb_privmsgs_text (
  privmsgs_text_id INT4  NOT NULL DEFAULT '0',
  privmsgs_bbcode_uid varchar(10) NOT NULL DEFAULT '0',
  privmsgs_text text,
  PRIMARY KEY (privmsgs_text_id),
  CHECK (privmsgs_text_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_ranks
--



--
-- Sequences for table PHPBB_RANKS
--

CREATE SEQUENCE phpbb_ranks_rank_id_seq;

CREATE TABLE phpbb_ranks (
  rank_id INT2 DEFAULT nextval('phpbb_ranks_rank_id_seq'),
  rank_title varchar(50) NOT NULL DEFAULT '',
  rank_min INT4 NOT NULL DEFAULT '0',
  rank_special INT2 DEFAULT '0',
  rank_image varchar(255) DEFAULT NULL,
  PRIMARY KEY (rank_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_search_results
--

CREATE TABLE phpbb_search_results (
  search_id INT4  NOT NULL DEFAULT '0',
  session_id varchar(32) NOT NULL DEFAULT '',
  search_array TEXT DEFAULT '' NOT NULL,
  PRIMARY KEY (search_id),
  CHECK (search_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_search_wordlist
--



--
-- Sequences for table PHPBB_SEARCH_WORDLIST
--

CREATE SEQUENCE phpbb_search_wordlist_word_i;

CREATE TABLE phpbb_search_wordlist (
  word_text varchar(50) NOT NULL DEFAULT '',
  word_id INT4 DEFAULT nextval('phpbb_search_wordlist_word_i'),
  word_common INT2  NOT NULL DEFAULT '0',
  PRIMARY KEY (word_text),
  CHECK (word_common>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_search_wordmatch
--

CREATE TABLE phpbb_search_wordmatch (
  post_id INT4  NOT NULL DEFAULT '0',
  word_id INT4  NOT NULL DEFAULT '0',
  title_match INT2 NOT NULL DEFAULT '0'
);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_sessions
--

CREATE TABLE phpbb_sessions (
  session_id char(32) NOT NULL DEFAULT '',
  session_user_id INT4 NOT NULL DEFAULT '0',
  session_start INT4 NOT NULL DEFAULT '0',
  session_time INT4 NOT NULL DEFAULT '0',
  session_ip char(8) NOT NULL DEFAULT '0',
  session_page INT4 NOT NULL DEFAULT '0',
  session_logged_in INT2 NOT NULL DEFAULT '0',
  PRIMARY KEY (session_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_smilies
--



--
-- Sequences for table PHPBB_SMILIES
--

CREATE SEQUENCE phpbb_smilies_smilies_id_seq;

CREATE TABLE phpbb_smilies (
  smilies_id INT2 DEFAULT nextval('phpbb_smilies_smilies_id_seq'),
  code varchar(50) DEFAULT NULL,
  smile_url varchar(100) DEFAULT NULL,
  emoticon varchar(75) DEFAULT NULL,
  PRIMARY KEY (smilies_id)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_themes
--



--
-- Sequences for table PHPBB_THEMES
--

CREATE SEQUENCE phpbb_themes_themes_id_seq;

CREATE TABLE phpbb_themes (
  themes_id INT4 DEFAULT nextval('phpbb_themes_themes_id_seq'),
  template_name varchar(30) NOT NULL DEFAULT '',
  style_name varchar(30) NOT NULL DEFAULT '',
  head_stylesheet varchar(100) DEFAULT NULL,
  body_background varchar(100) DEFAULT NULL,
  body_bgcolor varchar(6) DEFAULT NULL,
  body_text varchar(6) DEFAULT NULL,
  body_link varchar(6) DEFAULT NULL,
  body_vlink varchar(6) DEFAULT NULL,
  body_alink varchar(6) DEFAULT NULL,
  body_hlink varchar(6) DEFAULT NULL,
  tr_color1 varchar(6) DEFAULT NULL,
  tr_color2 varchar(6) DEFAULT NULL,
  tr_color3 varchar(6) DEFAULT NULL,
  tr_class1 varchar(25) DEFAULT NULL,
  tr_class2 varchar(25) DEFAULT NULL,
  tr_class3 varchar(25) DEFAULT NULL,
  th_color1 varchar(6) DEFAULT NULL,
  th_color2 varchar(6) DEFAULT NULL,
  th_color3 varchar(6) DEFAULT NULL,
  th_class1 varchar(25) DEFAULT NULL,
  th_class2 varchar(25) DEFAULT NULL,
  th_class3 varchar(25) DEFAULT NULL,
  td_color1 varchar(6) DEFAULT NULL,
  td_color2 varchar(6) DEFAULT NULL,
  td_color3 varchar(6) DEFAULT NULL,
  td_class1 varchar(25) DEFAULT NULL,
  td_class2 varchar(25) DEFAULT NULL,
  td_class3 varchar(25) DEFAULT NULL,
  fontface1 varchar(50) DEFAULT NULL,
  fontface2 varchar(50) DEFAULT NULL,
  fontface3 varchar(50) DEFAULT NULL,
  fontsize1 INT2 DEFAULT NULL,
  fontsize2 INT2 DEFAULT NULL,
  fontsize3 INT2 DEFAULT NULL,
  fontcolor1 varchar(6) DEFAULT NULL,
  fontcolor2 varchar(6) DEFAULT NULL,
  fontcolor3 varchar(6) DEFAULT NULL,
  span_class1 varchar(25) DEFAULT NULL,
  span_class2 varchar(25) DEFAULT NULL,
  span_class3 varchar(25) DEFAULT NULL,
  img_size_poll INT2  DEFAULT NULL,
  img_size_privmsg INT2  DEFAULT NULL,
  PRIMARY KEY (themes_id),
  CHECK (img_size_poll>=0),
  CHECK (img_size_privmsg>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_themes_name
--

CREATE TABLE phpbb_themes_name (
  themes_id INT2  NOT NULL DEFAULT '0',
  tr_color1_name char(50) DEFAULT NULL,
  tr_color2_name char(50) DEFAULT NULL,
  tr_color3_name char(50) DEFAULT NULL,
  tr_class1_name char(50) DEFAULT NULL,
  tr_class2_name char(50) DEFAULT NULL,
  tr_class3_name char(50) DEFAULT NULL,
  th_color1_name char(50) DEFAULT NULL,
  th_color2_name char(50) DEFAULT NULL,
  th_color3_name char(50) DEFAULT NULL,
  th_class1_name char(50) DEFAULT NULL,
  th_class2_name char(50) DEFAULT NULL,
  th_class3_name char(50) DEFAULT NULL,
  td_color1_name char(50) DEFAULT NULL,
  td_color2_name char(50) DEFAULT NULL,
  td_color3_name char(50) DEFAULT NULL,
  td_class1_name char(50) DEFAULT NULL,
  td_class2_name char(50) DEFAULT NULL,
  td_class3_name char(50) DEFAULT NULL,
  fontface1_name char(50) DEFAULT NULL,
  fontface2_name char(50) DEFAULT NULL,
  fontface3_name char(50) DEFAULT NULL,
  fontsize1_name char(50) DEFAULT NULL,
  fontsize2_name char(50) DEFAULT NULL,
  fontsize3_name char(50) DEFAULT NULL,
  fontcolor1_name char(50) DEFAULT NULL,
  fontcolor2_name char(50) DEFAULT NULL,
  fontcolor3_name char(50) DEFAULT NULL,
  span_class1_name char(50) DEFAULT NULL,
  span_class2_name char(50) DEFAULT NULL,
  span_class3_name char(50) DEFAULT NULL,
  PRIMARY KEY (themes_id),
  CHECK (themes_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_topics
--


--
-- Sequences for table PHPBB_TOPICS
--

CREATE SEQUENCE phpbb_topics_topic_id_seq;

CREATE TABLE phpbb_topics (
  topic_id INT4 DEFAULT nextval('phpbb_topics_topic_id_seq'),
  forum_id INT2  NOT NULL DEFAULT '0',
  topic_title char(60) NOT NULL DEFAULT '',
  topic_poster INT4 NOT NULL DEFAULT '0',
  topic_time INT4 NOT NULL DEFAULT '0',
  topic_views INT4  NOT NULL DEFAULT '0',
  topic_replies INT4  NOT NULL DEFAULT '0',
  topic_status INT2 NOT NULL DEFAULT '0',
  topic_vote INT2 NOT NULL DEFAULT '0',
  topic_type INT2 NOT NULL DEFAULT '0',
  topic_first_post_id INT4  NOT NULL DEFAULT '0',
  topic_last_post_id INT4  NOT NULL DEFAULT '0',
  topic_moved_id INT4  NOT NULL DEFAULT '0',
  PRIMARY KEY (topic_id),
  CHECK (forum_id>=0),
  CHECK (topic_views>=0),
  CHECK (topic_replies>=0),
  CHECK (topic_first_post_id>=0),
  CHECK (topic_last_post_id>=0),
  CHECK (topic_moved_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_topics_watch
--

CREATE TABLE phpbb_topics_watch (
  topic_id INT4  NOT NULL DEFAULT '0',
  user_id INT4 NOT NULL DEFAULT '0',
  notify_status INT2 NOT NULL DEFAULT '0'
);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_user_group
--

CREATE TABLE phpbb_user_group (
  group_id INT4 NOT NULL DEFAULT '0',
  user_id INT4 NOT NULL DEFAULT '0',
  user_pending INT2 DEFAULT NULL
);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_users
--

CREATE TABLE phpbb_users (
  user_id INT4 NOT NULL DEFAULT '0',
  user_active INT2 DEFAULT '1',
  username varchar(25) NOT NULL DEFAULT '',
  user_password varchar(32) NOT NULL DEFAULT '',
  user_session_time INT4 NOT NULL DEFAULT '0',
  user_session_page INT2 NOT NULL DEFAULT '0',
  user_lastvisit INT4 NOT NULL DEFAULT '0',
  user_regdate INT4 NOT NULL DEFAULT '0',
  user_level INT2 DEFAULT '0',
  user_posts INT4  NOT NULL DEFAULT '0',
  user_timezone decimal(5,2) NOT NULL DEFAULT '0.00',
  user_style INT2 DEFAULT NULL,
  user_lang varchar(255) DEFAULT NULL,
  user_dateformat varchar(14) NOT NULL DEFAULT 'd M Y H:i',
  user_new_privmsg INT2  NOT NULL DEFAULT '0',
  user_unread_privmsg INT2  NOT NULL DEFAULT '0',
  user_last_privmsg INT4 NOT NULL DEFAULT '0',
  user_emailtime INT4 DEFAULT NULL,
  user_viewemail INT2 DEFAULT NULL,
  user_attachsig INT2 DEFAULT NULL,
  user_allowhtml INT2 DEFAULT '1',
  user_allowbbcode INT2 DEFAULT '1',
  user_allowsmile INT2 DEFAULT '1',
  user_allowavatar INT2 NOT NULL DEFAULT '1',
  user_allow_pm INT2 NOT NULL DEFAULT '1',
  user_allow_viewonline INT2 NOT NULL DEFAULT '1',
  user_notify INT2 NOT NULL DEFAULT '1',
  user_notify_pm INT2 NOT NULL DEFAULT '0',
  user_popup_pm INT2 NOT NULL DEFAULT '0',
  user_rank INT4 DEFAULT '0',
  user_avatar varchar(100) DEFAULT NULL,
  user_avatar_type INT2 NOT NULL DEFAULT '0',
  user_email varchar(255) DEFAULT NULL,
  user_icq varchar(15) DEFAULT NULL,
  user_website varchar(100) DEFAULT NULL,
  user_from varchar(100) DEFAULT NULL,
  user_sig text,
  user_sig_bbcode_uid varchar(10) DEFAULT NULL,
  user_aim varchar(255) DEFAULT NULL,
  user_yim varchar(255) DEFAULT NULL,
  user_msnm varchar(255) DEFAULT NULL,
  user_occ varchar(100) DEFAULT NULL,
  user_interests varchar(255) DEFAULT NULL,
  user_actkey varchar(32) DEFAULT NULL,
  user_newpasswd varchar(32) DEFAULT NULL,
  PRIMARY KEY (user_id),
  CHECK (user_posts>=0),
  CHECK (user_new_privmsg>=0),
  CHECK (user_unread_privmsg>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_vote_desc
--


--
-- Sequences for table PHPBB_VOTE_DESC
--

CREATE SEQUENCE phpbb_vote_desc_vote_id_seq;

CREATE TABLE phpbb_vote_desc (
  vote_id INT4 DEFAULT nextval('phpbb_vote_desc_vote_id_seq'),
  topic_id INT4  NOT NULL DEFAULT '0',
  vote_text TEXT DEFAULT '' NOT NULL,
  vote_start INT4 NOT NULL DEFAULT '0',
  vote_length INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (vote_id),
  CHECK (topic_id>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_vote_results
--

CREATE TABLE phpbb_vote_results (
  vote_id INT4  NOT NULL DEFAULT '0',
  vote_option_id INT2  NOT NULL DEFAULT '0',
  vote_option_text varchar(255) NOT NULL DEFAULT '',
  vote_result INT4 NOT NULL DEFAULT '0'
);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_vote_voters
--

CREATE TABLE phpbb_vote_voters (
  vote_id INT4  NOT NULL DEFAULT '0',
  vote_user_id INT4 NOT NULL DEFAULT '0',
  vote_user_ip char(8) NOT NULL DEFAULT ''
);

-- --------------------------------------------------------

--
-- Table structure for table phpbb_words
--



--
-- Sequences for table PHPBB_WORDS
--

CREATE SEQUENCE phpbb_words_word_id_seq;

CREATE TABLE phpbb_words (
  word_id INT4 DEFAULT nextval('phpbb_words_word_id_seq'),
  word char(100) NOT NULL DEFAULT '',
  replacement char(100) NOT NULL DEFAULT '',
  PRIMARY KEY (word_id)

);

-- --------------------------------------------------------

--
-- Table structure for table product_types
--



--
-- Sequences for table PRODUCT_TYPES
--

CREATE SEQUENCE product_types_type_id_seq;

CREATE TABLE product_types (
  type_id INT4 DEFAULT nextval('product_types_type_id_seq'),
  type_name varchar(255) NOT NULL DEFAULT '',
  type_handler varchar(255) NOT NULL DEFAULT '',
  allow_add_to_cart char(1) NOT NULL DEFAULT 'Y',
  DEFAULT_image varchar(255) NOT NULL default '',
  date_addded TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  last_modified TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (type_id)

);

-- --------------------------------------------------------

--
-- Table structure for table product_types_to_category
--

CREATE TABLE product_types_to_category (
  product_type_id INT4 NOT NULL DEFAULT '0',
  category_id INT4 NOT NULL DEFAULT '0'
);

-- --------------------------------------------------------

--
-- Table structure for table products
--



--
-- Sequences for table PRODUCTS
--

CREATE SEQUENCE products_products_id_seq;

CREATE TABLE products (
  products_id INT4 DEFAULT nextval('products_products_id_seq'),
  products_type INT4 NOT NULL DEFAULT '1',
  products_quantity INT4 NOT NULL DEFAULT '0',
  products_model varchar(32) DEFAULT NULL,
  products_image varchar(64) DEFAULT NULL,
  products_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  products_virtual INT2 NOT NULL DEFAULT '0',
  products_date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  products_last_modified TIMESTAMP DEFAULT NULL,
  products_date_available TIMESTAMP DEFAULT NULL,
  products_weight decimal(5,2) NOT NULL DEFAULT '0.00',
  products_status INT2 NOT NULL DEFAULT '0',
  products_tax_class_id INT4 NOT NULL DEFAULT '0',
  manufacturers_id INT4 DEFAULT NULL,
  products_ordered INT4 NOT NULL DEFAULT '0',
  products_quantity_order_min INT4 NOT NULL DEFAULT '1',
  products_quantity_order_units INT4 NOT NULL DEFAULT '1',
  products_priced_by_attribute INT2 NOT NULL DEFAULT '0',
  product_is_free INT2 NOT NULL DEFAULT '0',
  product_is_call INT2 NOT NULL DEFAULT '0',
  products_quantity_mixed INT2 NOT NULL DEFAULT '0',
  product_is_always_free_shipping INT2 NOT NULL DEFAULT '0',
  products_qty_box_status INT2 NOT NULL DEFAULT '1',
  products_quantity_order_max INT4 NOT NULL DEFAULT '0',
  products_sort_order INT4 NOT NULL DEFAULT '0',
  products_discount_type INT2 NOT NULL DEFAULT '0',
  products_discount_type_from INT2 NOT NULL DEFAULT '0',
  products_price_sorter decimal(15,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (products_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_attributes
--



--
-- Sequences for table PRODUCTS_ATTRIBUTES
--

CREATE SEQUENCE products_attributes_products;

CREATE TABLE products_attributes (
  products_attributes_id INT4 DEFAULT nextval('products_attributes_products'),
  products_id INT4 NOT NULL DEFAULT '0',
  options_id INT4 NOT NULL DEFAULT '0',
  options_values_id INT4 NOT NULL DEFAULT '0',
  options_values_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  price_prefix char(1) NOT NULL DEFAULT '',
  products_options_sort_order INT4 NOT NULL DEFAULT '0',
  product_attribute_is_free INT2 NOT NULL DEFAULT '0',
  products_attributes_weight decimal(8,4) NOT NULL DEFAULT '0.0000',
  products_attributes_weight_prefix char(1) NOT NULL DEFAULT '',
  attributes_display_only INT2 NOT NULL DEFAULT '0',
  attributes_DEFAULT INT2 NOT NULL default '0',
  attributes_discounted INT2 NOT NULL DEFAULT '1',
  attributes_image varchar(64) DEFAULT NULL,
  attributes_price_base_included INT2 NOT NULL DEFAULT '1',
  attributes_price_onetime decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor_offset decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor_onetime decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_factor_onetime_offset decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_qty_prices text,
  attributes_qty_prices_onetime text,
  attributes_price_words decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_words_free INT4 NOT NULL DEFAULT '0',
  attributes_price_letters decimal(15,4) NOT NULL DEFAULT '0.0000',
  attributes_price_letters_free INT4 NOT NULL DEFAULT '0',
  attributes_required INT2 NOT NULL DEFAULT '0',
  PRIMARY KEY (products_attributes_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_attributes_download
--

CREATE TABLE products_attributes_download (
  products_attributes_id INT4 NOT NULL DEFAULT '0',
  products_attributes_filename varchar(255) NOT NULL DEFAULT '',
  products_attributes_maxdays INT4 DEFAULT '0',
  products_attributes_maxcount INT4 DEFAULT '0',
  PRIMARY KEY (products_attributes_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_description
--



--
-- Sequences for table PRODUCTS_DESCRIPTION
--

CREATE SEQUENCE products_description_product;

CREATE TABLE products_description (
  products_id INT4 DEFAULT nextval('products_description_product'),
  language_id INT4 NOT NULL DEFAULT '1',
  products_name varchar(64) NOT NULL DEFAULT '',
  products_description text,
  products_url varchar(255) DEFAULT NULL,
  products_viewed INT4 DEFAULT '0',
  PRIMARY KEY (products_id,language_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_notifications
--

CREATE TABLE products_notifications (
  products_id INT4 NOT NULL DEFAULT '0',
  customers_id INT4 NOT NULL DEFAULT '0',
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (products_id,customers_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_options
--

CREATE TABLE products_options (
  products_options_id INT4 NOT NULL DEFAULT '0',
  language_id INT4 NOT NULL DEFAULT '1',
  products_options_name varchar(32) NOT NULL DEFAULT '',
  products_options_sort_order INT4 NOT NULL DEFAULT '0',
  products_options_type INT4 NOT NULL DEFAULT '0',
  products_options_length INT2 NOT NULL DEFAULT '32',
  products_options_comment varchar(64) DEFAULT NULL,
  products_options_size INT2 NOT NULL DEFAULT '32',
  PRIMARY KEY (products_options_id,language_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_options_types
--

CREATE TABLE products_options_types (
  products_options_types_id INT4 NOT NULL DEFAULT '0',
  products_options_types_name varchar(32) DEFAULT NULL,
  PRIMARY KEY (products_options_types_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_options_values
--

CREATE TABLE products_options_values (
  products_options_values_id INT4 NOT NULL DEFAULT '0',
  language_id INT4 NOT NULL DEFAULT '1',
  products_options_values_name varchar(64) NOT NULL DEFAULT '',
  products_options_values_sort_order INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (products_options_values_id,language_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_options_values_to_products_options
--



--
-- Sequences for table PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS
--

CREATE SEQUENCE products_options_values_to_p;

CREATE TABLE products_options_values_to_products_options (
  products_options_values_to_products_options_id INT4 DEFAULT nextval('products_options_values_to_p'),
  products_options_id INT4 NOT NULL DEFAULT '0',
  products_options_values_id INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (products_options_values_to_products_options_id)

);

-- --------------------------------------------------------

--
-- Table structure for table products_to_categories
--

CREATE TABLE products_to_categories (
  products_id INT4 NOT NULL DEFAULT '0',
  categories_id INT4 NOT NULL DEFAULT '0',
  PRIMARY KEY (products_id,categories_id)

);

-- --------------------------------------------------------

--
-- Table structure for table reviews
--



--
-- Sequences for table REVIEWS
--

CREATE SEQUENCE reviews_reviews_id_seq;

CREATE TABLE reviews (
  reviews_id INT4 DEFAULT nextval('reviews_reviews_id_seq'),
  products_id INT4 NOT NULL DEFAULT '0',
  customers_id INT4 DEFAULT NULL,
  customers_name varchar(64) NOT NULL DEFAULT '',
  reviews_rating INT4 DEFAULT NULL,
  date_added TIMESTAMP DEFAULT NULL,
  last_modified TIMESTAMP DEFAULT NULL,
  reviews_read INT4 NOT NULL DEFAULT '0',
  status INT4 NOT NULL DEFAULT '1',
  PRIMARY KEY (reviews_id)

);

-- --------------------------------------------------------

--
-- Table structure for table reviews_description
--

CREATE TABLE reviews_description (
  reviews_id INT4 NOT NULL DEFAULT '0',
  languages_id INT4 NOT NULL DEFAULT '0',
  reviews_text TEXT DEFAULT '' NOT NULL,
  PRIMARY KEY (reviews_id,languages_id)

);

-- --------------------------------------------------------

--
-- Table structure for table salemaker_sales
--



--
-- Sequences for table SALEMAKER_SALES
--

CREATE SEQUENCE salemaker_sales_sale_id_seq;

CREATE TABLE salemaker_sales (
  sale_id INT4 DEFAULT nextval('salemaker_sales_sale_id_seq'),
  sale_status INT2 NOT NULL DEFAULT '0',
  sale_name varchar(30) NOT NULL DEFAULT '',
  sale_deduction_value decimal(15,4) NOT NULL DEFAULT '0.0000',
  sale_deduction_type INT2 NOT NULL DEFAULT '0',
  sale_pricerange_from decimal(15,4) NOT NULL DEFAULT '0.0000',
  sale_pricerange_to decimal(15,4) NOT NULL DEFAULT '0.0000',
  sale_specials_condition INT2 NOT NULL DEFAULT '0',
  sale_categories_selected text,
  sale_categories_all text,
  sale_date_start DATE NOT NULL DEFAULT '0001-01-01',
  sale_date_end DATE NOT NULL DEFAULT '0001-01-01',
  sale_date_added DATE NOT NULL DEFAULT '0001-01-01',
  sale_date_last_modified DATE NOT NULL DEFAULT '0001-01-01',
  sale_date_status_change DATE NOT NULL DEFAULT '0001-01-01',
  PRIMARY KEY (sale_id)

);

-- --------------------------------------------------------

--
-- Table structure for table sessions
--

CREATE TABLE sessions (
  sesskey varchar(32) NOT NULL DEFAULT '',
  expiry INT4  NOT NULL DEFAULT '0',
  value TEXT DEFAULT '' NOT NULL,
  PRIMARY KEY (sesskey),
  CHECK (expiry>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table specials
--



--
-- Sequences for table SPECIALS
--

CREATE SEQUENCE specials_specials_id_seq;

CREATE TABLE specials (
  specials_id INT4 DEFAULT nextval('specials_specials_id_seq'),
  products_id INT4 NOT NULL DEFAULT '0',
  specials_new_products_price decimal(15,4) NOT NULL DEFAULT '0.0000',
  specials_date_added TIMESTAMP DEFAULT NULL,
  specials_last_modified TIMESTAMP DEFAULT NULL,
  expires_date DATE NOT NULL DEFAULT '0001-01-01',
  date_status_change TIMESTAMP DEFAULT NULL,
  status INT4 NOT NULL DEFAULT '1',
  specials_date_available DATE NOT NULL DEFAULT '0001-01-01',
  PRIMARY KEY (specials_id)

);

-- --------------------------------------------------------

--
-- Table structure for table tax_class
--



--
-- Sequences for table TAX_CLASS
--

CREATE SEQUENCE tax_class_tax_class_id_seq;

CREATE TABLE tax_class (
  tax_class_id INT4 DEFAULT nextval('tax_class_tax_class_id_seq'),
  tax_class_title varchar(32) NOT NULL DEFAULT '',
  tax_class_description varchar(255) NOT NULL DEFAULT '',
  last_modified TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (tax_class_id)

);

-- --------------------------------------------------------

--
-- Table structure for table tax_rates
--



--
-- Sequences for table TAX_RATES
--

CREATE SEQUENCE tax_rates_tax_rates_id_seq;

CREATE TABLE tax_rates (
  tax_rates_id INT4 DEFAULT nextval('tax_rates_tax_rates_id_seq'),
  tax_zone_id INT4 NOT NULL DEFAULT '0',
  tax_class_id INT4 NOT NULL DEFAULT '0',
  tax_priority INT4 DEFAULT '1',
  tax_rate decimal(7,4) NOT NULL DEFAULT '0.0000',
  tax_description varchar(255) NOT NULL DEFAULT '',
  last_modified TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (tax_rates_id)

);

-- --------------------------------------------------------

--
-- Table structure for table template_select
--



--
-- Sequences for table TEMPLATE_SELECT
--

CREATE SEQUENCE template_select_template_id_;

CREATE TABLE template_select (
  template_id INT4 DEFAULT nextval('template_select_template_id_'),
  template_dir varchar(64) NOT NULL DEFAULT '',
  template_language varchar(64) NOT NULL DEFAULT '0',
  PRIMARY KEY (template_id)

);

-- --------------------------------------------------------

--
-- Table structure for table whos_online
--

CREATE TABLE whos_online (
  customer_id INT4 DEFAULT NULL,
  full_name varchar(64) NOT NULL DEFAULT '',
  session_id varchar(128) NOT NULL DEFAULT '',
  ip_address varchar(15) NOT NULL DEFAULT '',
  time_entry varchar(14) NOT NULL DEFAULT '',
  time_last_click varchar(14) NOT NULL DEFAULT '',
  last_page_url varchar(255) NOT NULL DEFAULT '',
  host_address TEXT DEFAULT '' NOT NULL
);

-- --------------------------------------------------------

--
-- Table structure for table zones
--

--
-- Sequences for table ZONES
--

CREATE SEQUENCE zones_zone_id_seq;

CREATE TABLE zones (
  zone_id INT4 DEFAULT nextval('zones_zone_id_seq'),
  zone_country_id INT4 NOT NULL DEFAULT '0',
  zone_code varchar(32) NOT NULL DEFAULT '',
  zone_name varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (zone_id)

);

-- --------------------------------------------------------

--
-- Table structure for table zones_to_geo_zones
--


--
-- Sequences for table ZONES_TO_GEO_ZONES
--

CREATE SEQUENCE zones_to_geo_zones_associati;

CREATE TABLE zones_to_geo_zones (
  association_id INT4 DEFAULT nextval('zones_to_geo_zones_associati'),
  zone_country_id INT4 NOT NULL DEFAULT '0',
  zone_id INT4 DEFAULT NULL,
  geo_zone_id INT4 DEFAULT NULL,
  last_modified TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (association_id)

);


--
-- Database table for customers_wishlist
--

CREATE TABLE customers_wishlist (
  products_id INT4 NOT NULL DEFAULT '0',
  customers_id INT4 NOT NULL DEFAULT '0',
  products_model varchar(13) DEFAULT NULL,
  products_name varchar(64) NOT NULL DEFAULT '',
  products_price decimal(8,2) NOT NULL DEFAULT '0.00',
  final_price decimal(8,2) NOT NULL DEFAULT '0.00',
  products_quantity INT4 NOT NULL DEFAULT '0',
  wishlist_name varchar(64) DEFAULT NULL
);


-- data
INSERT INTO template_select VALUES (1, 'classic', '0');

-- 1 - Default, 2 - USA, 3 - Spain, 4 - Singapore, 5 - Germany
INSERT INTO address_format VALUES (1, '$firstname $lastname$cr$streets$cr$city, $postcode$cr$statecomma$country','$city / $country');
INSERT INTO address_format VALUES (2, '$firstname $lastname$cr$streets$cr$city, $state    $postcode$cr$country','$city, $state / $country');
INSERT INTO address_format VALUES (3, '$firstname $lastname$cr$streets$cr$city$cr$postcode - $statecomma$country','$state / $country');
INSERT INTO address_format VALUES (4, '$firstname $lastname$cr$streets$cr$city ($postcode)$cr$country', '$postcode / $country');
INSERT INTO address_format VALUES (5, '$firstname $lastname$cr$streets$cr$postcode $city$cr$country','$city / $country');

INSERT INTO admin VALUES (1, 'Admin', 'admin@localhost', '351683ea4e19efe34874b501fdbf9792:9b', 1);
INSERT INTO admin VALUES (2, 'demo', 'demo@localhost', '23ce1aad0e04a3d2334c7aef2f8ade83:58', 2);

INSERT INTO banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status) VALUES (1, 'Zen Cart', 'http://www.zen-cart.com', 'banners/zencart_468_60_02.gif', '468x50', '', 0, NULL, NULL, '2004-01-11 20:59:12', NULL, 1);
INSERT INTO banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status) VALUES (2, 'Zen Cart the art of e-commerce', 'http://www.zen-cart.com', 'banners/125zen_logo.gif', '125x125', '', 0, NULL, NULL, '2004-01-11 20:59:12', NULL, 1);
INSERT INTO banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status) VALUES (3, 'Zen Cart the art of e-commerce', 'http://www.zen-cart.com', 'banners/125x125_zen_logo.gif', '125x125', '', 0, NULL, NULL, '2004-01-11 20:59:12', NULL, 1);
INSERT INTO banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status) VALUES (4, 'if you have to think ... you haven\'t been Zenned!', 'http://www.zen-cart.com', 'banners/think_anim.gif', '468x50', '', 0, NULL, NULL, '2004-01-12 20:53:18', NULL, 1);
INSERT INTO banners (banners_id, banners_title, banners_url, banners_image, banners_group, banners_html_text, expires_impressions, expires_date, date_scheduled, date_added, date_status_change, status) VALUES (5, 'Chain Reaction Web', 'http://www.chainreactionweb.com', 'banners/crw-zen-banner.gif', '468x50', '', 0, NULL, NULL, '2004-01-12 20:56:01', NULL, 1);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Store Name', 'STORE_NAME', 'Zen Cart', 'The name of my store', '1', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Store Owner', 'STORE_OWNER', 'Team Zen Cart', 'The name of my store owner', '1', '2', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Country', 'STORE_COUNTRY', '223', 'The country my store is located in <br /><br /><b>Note: Please remember to update the store zone.</b>', '1', '6', 'zen_get_country_name', 'zen_cfg_pull_down_country_list(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Zone', 'STORE_ZONE', '18', 'The zone my store is located in', '1', '7', 'zen_cfg_get_zone_name', 'zen_cfg_pull_down_zone_list(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Expected Sort Order', 'EXPECTED_PRODUCTS_SORT', 'desc', 'This is the sort order used in the expected products box.', '1', '8', 'zen_cfg_select_option(array(\'asc\', \'desc\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Expected Sort Field', 'EXPECTED_PRODUCTS_FIELD', 'date_expected', 'The column to sort by in the expected products box.', '1', '9', 'zen_cfg_select_option(array(\'products_name\', \'date_expected\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Switch To Default Language Currency', 'USE_DEFAULT_LANGUAGE_CURRENCY', 'false', 'Automatically switch to the language\'s currency when it is changed', '1', '10', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Use Search-Engine Safe URLs (still in development)', 'SEARCH_ENGINE_FRIENDLY_URLS', 'false', 'Use search-engine safe urls for all site links', '1', '12', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Cart After Adding Product', 'DISPLAY_CART', 'true', 'Display the shopping cart after adding a product (or return back to their origin)', '1', '14', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Default Search Operator', 'ADVANCED_SEARCH_DEFAULT_OPERATOR', 'and', 'Default search operators', '1', '17', 'zen_cfg_select_option(array(\'and\', \'or\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Store Address and Phone', 'STORE_NAME_ADDRESS', 'Store Name\nAddress\nCountry\nPhone', 'This is the Store Name, Address and Phone used on printable documents and displayed online', '1', '18', 'zen_cfg_textarea(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Category Counts', 'SHOW_COUNTS', 'true', 'Count recursively how many products are in each category', '1', '19', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Tax Decimal Places', 'TAX_DECIMAL_PLACES', '0', 'Pad the tax value this amount of decimal places', '1', '20', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Prices with Tax', 'DISPLAY_PRICE_WITH_TAX', 'false', 'Display prices with tax included (true) or add the tax at the end (false)', '1', '21', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Admin Session Time Out in Seconds', 'SESSION_TIMEOUT_ADMIN', '3600', 'Enter the time in seconds. Default=3600<br />Example: 3600= 1 hour<br /><br />Note: Too few seconds can result in timeout issues when adding/editing products', 1, 22, NULL, now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Tutorial Status', 'TUTORIAL_STATUS', '1', 'Include Tutorial in Catalog<br />0= off 1= on', '1', '25', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Store Status', 'STORE_STATUS', '0', 'What is your Store Status<br />0= Normal Store<br />1= Showcase no prices<br />2= Showcase with prices', '1', '50', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Server Uptime', 'DISPLAY_SERVER_UPTIME', 'true', 'Displaying Server uptime can cause entries in error logs on some servers. (true = Display, false = don\'t display)', 1, 99, '2003-11-08 20:24:47', '0001-01-01 00:00:00', '', 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Missing Page Check', 'MISSING_PAGE_CHECK', 'true', 'Zen-Cart can check for missing pages in the URL and reditect to Index page. For debugging you may want to turn this off. (true = Check for missing pages, false = Don\'t check for missing pages)', 1, 99, '2003-11-08 20:24:47', '0001-01-01 00:00:00', '', 'zen_cfg_select_option(array(\'true\', \'false\'),');

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('First Name', 'ENTRY_FIRST_NAME_MIN_LENGTH', '2', 'Minimum length of first name', '2', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Last Name', 'ENTRY_LAST_NAME_MIN_LENGTH', '2', 'Minimum length of last name', '2', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Date of Birth', 'ENTRY_DOB_MIN_LENGTH', '10', 'Minimum length of date of birth', '2', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('E-Mail Address', 'ENTRY_EMAIL_ADDRESS_MIN_LENGTH', '6', 'Minimum length of e-mail address', '2', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Street Address', 'ENTRY_STREET_ADDRESS_MIN_LENGTH', '5', 'Minimum length of street address', '2', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Company', 'ENTRY_COMPANY_MIN_LENGTH', '2', 'Minimum length of company name', '2', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Post Code', 'ENTRY_POSTCODE_MIN_LENGTH', '4', 'Minimum length of post code', '2', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('City', 'ENTRY_CITY_MIN_LENGTH', '3', 'Minimum length of city', '2', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('State', 'ENTRY_STATE_MIN_LENGTH', '2', 'Minimum length of state', '2', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Telephone Number', 'ENTRY_TELEPHONE_MIN_LENGTH', '3', 'Minimum length of telephone number', '2', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Password', 'ENTRY_PASSWORD_MIN_LENGTH', '5', 'Minimum length of password', '2', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Credit Card Owner Name', 'CC_OWNER_MIN_LENGTH', '3', 'Minimum length of credit card owner name', '2', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Credit Card Number', 'CC_NUMBER_MIN_LENGTH', '10', 'Minimum length of credit card number', '2', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Credit Card CVV Number', 'CC_CVV_MIN_LENGTH', '3', 'Minimum length of credit card CVV number', '2', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Review Text', 'REVIEW_TEXT_MIN_LENGTH', '50', 'Minimum length of product review text', '2', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Best Sellers', 'MIN_DISPLAY_BESTSELLERS', '1', 'Minimum number of best sellers to display', '2', '15', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Also Purchased Products', 'MIN_DISPLAY_ALSO_PURCHASED', '1', 'Minimum number of products to display in the \'This Customer Also Purchased\' box', '2', '16', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Nick Name', 'ENTRY_NICK_MIN_LENGTH', '3', 'Minimum length of Nick Name', '2', '1', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Address Book Entries', 'MAX_ADDRESS_BOOK_ENTRIES', '5', 'Maximum address book entries a customer is allowed to have', '3', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Search Results Per Page', 'MAX_DISPLAY_SEARCH_RESULTS', '20', 'Number of products to list on a search result page', '3', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Prev/Next Navigation Page Links', 'MAX_DISPLAY_PAGE_LINKS', '5', 'Number of \'number\' links use for page-sets', '3', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Products on Special ', 'MAX_DISPLAY_SPECIAL_PRODUCTS', '9', 'Number of products on special to display', '3', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('New Products Module', 'MAX_DISPLAY_NEW_PRODUCTS', '9', 'Number of new products to display in a category', '3', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Upcoming Products ', 'MAX_DISPLAY_UPCOMING_PRODUCTS', '10', 'Number of \'upcoming\' products to display', '3', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Manufacturers List- Box Style', 'MAX_DISPLAY_MANUFACTURERS_IN_A_LIST', '0', 'Choose the style for the Manufacturers List Box<br />\'0\'=Drop Down List  \'1\'= Scroll Bar Style', '3', '7', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Manufacturers List- Scroll Box Size', 'MAX_MANUFACTURERS_LIST', '1', 'Number of manufacturers names to be displayed in the scroll box window. Must be set to \'1\' for the classic drop-down list, otherwise, the scroll box with the specified number of rows will be displayed.', '3', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Length of Manufacturers Name', 'MAX_DISPLAY_MANUFACTURER_NAME_LEN', '15', 'Used in manufacturers box; maximum length of manufacturers name to display. Longer names will be truncated.', '3', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('New Product Reviews Per Page', 'MAX_DISPLAY_NEW_REVIEWS', '6', 'Number of new reviews to display on each page', '3', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Random Product Reviews For Box', 'MAX_RANDOM_SELECT_REVIEWS', '10', 'Number of random product reviews to rotate in the box', '3', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Random New Products For Box', 'MAX_RANDOM_SELECT_NEW', '10', 'Number of random new product to display in box', '3', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Random Products On Special For Box', 'MAX_RANDOM_SELECT_SPECIALS', '10', 'Number of random products on special to display in box', '3', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Categories To List Per Row', 'MAX_DISPLAY_CATEGORIES_PER_ROW', '3', 'How many categories to list per row', '3', '13', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('New Products Listing- Number Per Page', 'MAX_DISPLAY_PRODUCTS_NEW', '10', 'Number of new products\' listings per page', '3', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Best Sellers For Box', 'MAX_DISPLAY_BESTSELLERS', '10', 'Number of best sellers to display in box', '3', '15', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Also Purchased Products', 'MAX_DISPLAY_ALSO_PURCHASED', '6', 'Number of products to display in the \'This Customer Also Purchased\' box', '3', '16', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Recent Purchases Box- NOTE: box is disabled ', 'MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX', '6', 'Number of products to display in the recent purchases box', '3', '17', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Customer Order History List Per Page', 'MAX_DISPLAY_ORDER_HISTORY', '10', 'Number of orders to display in the order history list in \'My Account\'', '3', '18', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Customers on Customers Page', 'MAX_DISPLAY_SEARCH_RESULTS_CUSTOMER', '20', '', 3, 19, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Orders on Orders Page', 'MAX_DISPLAY_SEARCH_RESULTS_ORDERS', '20', '', 3, 20, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Products on Reports', 'MAX_DISPLAY_SEARCH_RESULTS_REPORTS', '20', '', 3, 21, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Categories Products Display List', 'MAX_DISPLAY_RESULTS_CATEGORIES', '10', 'Number of products to list per screen', 3, 22, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Products Listing- Number Per Page', 'MAX_DISPLAY_PRODUCTS_LISTING', '10', 'Maximum Number of Products to list per page on main page', '3', '30', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Products Attributes - Option Names and Values Display', 'MAX_ROW_LISTS_OPTIONS', '10', 'Maximum number of option names and values to display in the products attributes page', '3', '24', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Products Attributes - Attributes Controller Display', 'MAX_ROW_LISTS_ATTRIBUTES_CONTROLLER', '30', 'Maximum number of attributes to display in the Attributes Controller page', '3', '25', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Products Attributes - Downloads Manager Display', 'MAX_DISPLAY_SEARCH_RESULTS_DOWNLOADS_MANAGER', '30', 'Maximum number of attributes downloads to display in the Downloads Manager page', '3', '26', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Featured Products - Number to Display Admin', 'MAX_DISPLAY_SEARCH_RESULTS_FEATURED_ADMIN', '10', 'Number of featured products to list per screen - Admin', 3, 27, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Featured Products - Main Page', 'MAX_DISPLAY_SEARCH_RESULTS_FEATURED', '9', 'Number of featured products to list on main page', 3, 28, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Featured Products Page', 'MAX_DISPLAY_PRODUCTS_FEATURED_PRODUCTS', '10', 'Number of featured products to list per screen', 3, 29, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Random Featured Products For Box', 'MAX_RANDOM_SELECT_FEATURED_PRODUCTS', '10', 'Number of random featured products to display in box', '3', '30', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Specials Products - Main Page', 'MAX_DISPLAY_SPECIAL_PRODUCTS_INDEX', '9', 'Number of special products to list on main page', 3, 31, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('New Product Listing - Limited to ...', 'SHOW_NEW_PRODUCTS_LIMIT', '0', 'Limit the New Product Listing to<br />0= All desc<br />1= Current Month<br />30= 30 Days<br />60= 60 Days<br />90= 90 Days<br />120= 120 Days', '3', '40', 'zen_cfg_select_option(array(\'0\', \'1\', \'30\', \'60\', \'90\', \'120\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Products All Page', 'MAX_DISPLAY_PRODUCTS_ALL', '10', 'Number of products to list per screen', 3, 45, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Maximum Display of Language Flags in Language Side Box', 'MAX_LANGUAGE_FLAGS_COLUMNS', '3', 'Number of Language Flags per Row', 3, 50, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Small Image Width', 'SMALL_IMAGE_WIDTH', '100', 'The pixel width of small images', '4', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Small Image Height', 'SMALL_IMAGE_HEIGHT', '80', 'The pixel height of small images', '4', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Heading Image Width', 'HEADING_IMAGE_WIDTH', '57', 'The pixel width of heading images', '4', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Heading Image Height', 'HEADING_IMAGE_HEIGHT', '40', 'The pixel height of heading images', '4', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Subcategory Image Width', 'SUBCATEGORY_IMAGE_WIDTH', '100', 'The pixel width of subcategory images', '4', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Subcategory Image Height', 'SUBCATEGORY_IMAGE_HEIGHT', '57', 'The pixel height of subcategory images', '4', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Calculate Image Size', 'CONFIG_CALCULATE_IMAGE_SIZE', 'true', 'Calculate the size of images?', '4', '7', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Image Required', 'IMAGE_REQUIRED', 'true', 'Enable to display broken images. Good for development.', '4', '8', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Image - Shopping Cart Status', 'IMAGE_SHOPPING_CART_STATUS', '1', 'Show product image in the shopping cart?<br />0= off 1= on', 4, 9, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Shopping Cart Width', 'IMAGE_SHOPPING_CART_WIDTH', '50', 'Default = 50', 4, 10, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Shopping Cart Height', 'IMAGE_SHOPPING_CART_HEIGHT', '40', 'Default = 40', 4, 11, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Info - Image Width', 'MEDIUM_IMAGE_WIDTH', '150', 'The pixel width of Product Info images', '4', '20', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Info - Image Height', 'MEDIUM_IMAGE_HEIGHT', '120', 'The pixel height of Product Info images', '4', '21', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Info - Image Medium Suffix', 'IMAGE_SUFFIX_MEDIUM', '_MED', 'Product Info Medium Image Suffix<br />Default = _MED', '4', '22', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Info - Image Large Suffix', 'IMAGE_SUFFIX_LARGE', '_LRG', 'Product Info Large Image Suffix<br />Default = _LRG', '4', '23', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Info - Number of Additional Images per Row', 'IMAGES_AUTO_ADDED', '3', 'Product Info - Enter the number of additional images to display per row<br />Default = 3', '4', '30', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Product Listing Width', 'IMAGE_PRODUCT_LISTING_WIDTH', '100', 'Default = 100', 4, 40, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Product Listing Height', 'IMAGE_PRODUCT_LISTING_HEIGHT', '80', 'Default = 80', 4, 41, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Product New Listing Width', 'IMAGE_PRODUCT_NEW_LISTING_WIDTH', '100', 'Default = 100', 4, 42, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Product New Listing Height', 'IMAGE_PRODUCT_NEW_LISTING_HEIGHT', '80', 'Default = 80', 4, 43, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - New Products Width', 'IMAGE_PRODUCT_NEW_WIDTH', '100', 'Default = 100', 4, 44, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - New Products Height', 'IMAGE_PRODUCT_NEW_HEIGHT', '80', 'Default = 80', 4, 45, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Featured Products Width', 'IMAGE_FEATURED_PRODUCTS_LISTING_WIDTH', '100', 'Default = 100', 4, 46, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Featured Products Height', 'IMAGE_FEATURED_PRODUCTS_LISTING_HEIGHT', '80', 'Default = 80', 4, 47, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Product All Listing Width', 'IMAGE_PRODUCT_ALL_LISTING_WIDTH', '100', 'Default = 100', 4, 48, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Image - Product All Listing Height', 'IMAGE_PRODUCT_ALL_LISTING_HEIGHT', '80', 'Default = 80', 4, 49, now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Image - No Image Status', 'PRODUCTS_IMAGE_NO_IMAGE_STATUS', '1', 'Use automatic No Image when none is added to product<br />0= off<br />1= On', '4', '60', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Image - No Image picture', 'PRODUCTS_IMAGE_NO_IMAGE', 'no_picture.gif', 'Use automatic No Image when none is added to product<br />Default = no_picture.gif', '4', '61', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Email Salutation', 'ACCOUNT_GENDER', 'true', 'Display salutation choice during account creation and with account information', '5', '1', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Date of Birth', 'ACCOUNT_DOB', 'true', 'Display date of birth field during account creation and with account information', '5', '2', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Company', 'ACCOUNT_COMPANY', 'true', 'Display company field during account creation and with account information', '5', '3', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Address Line 2', 'ACCOUNT_SUBURB', 'true', 'Display address line 2 field during account creation and with account information', '5', '4', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('State', 'ACCOUNT_STATE', 'true', 'Display state field during account creation and with account information', '5', '5', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Create Account Default Country ID', 'SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY', '223', 'Set Create Account Default Country ID to:<br />Default is 223', '5', '6', 'zen_get_country_name', 'zen_cfg_pull_down_country_list_none(', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Newsletter Checkbox', 'ACCOUNT_NEWSLETTER_STATUS', '1', 'Show Newsletter Checkbox<br />0= off<br />1= Display Unchecked<br />2= Display Checked<br /><b>Note: Defaulting this to accepted may be in violation of certain regulations for your state or country</b>', 5, 45, 'zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Customer Approval Status', 'CUSTOMERS_APPROVAL', '0', 'Customer must be approved to shop<br />0= Not required<br />1= Must login to browse<br />2= May browse but no prices unless logged in', '5', '55', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Customer Product Notification Status', 'CUSTOMERS_PRODUCTS_NOTIFICATION_STATUS', '1', 'Customer should be asked about product notifications after checkout success<br />0= Never ask<br />1= Ask, unless already set to global<br /><br />Note: Sidebox must be turned off seperately', '5', '50', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules', 'MODULE_PAYMENT_INSTALLED', 'cc.php;cod.php', 'List of payment module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: cc.php;cod.php;paypal.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules', 'MODULE_ORDER_TOTAL_INSTALLED', 'ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_gv.php;ot_coupon.php;ot_total.php', 'List of order_total module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ot_subtotal.php;ot_tax.php;ot_shipping.php;ot_total.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Installed Modules', 'MODULE_SHIPPING_INSTALLED', 'flat.php', 'List of shipping module filenames separated by a semi-colon. This is automatically updated. No need to edit. (Example: ups.php;flat.php;item.php)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Cash On Delivery Module', 'MODULE_PAYMENT_COD_STATUS', 'True', 'Do you want to accept Cash On Delevery payments?', '6', '1', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Payment Zone', 'MODULE_PAYMENT_COD_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'zen_get_zone_class_title', 'zen_cfg_pull_down_zone_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort order of display.', 'MODULE_PAYMENT_COD_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('Set Order Status', 'MODULE_PAYMENT_COD_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'zen_cfg_pull_down_order_statuses(', 'zen_get_order_status_name', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Credit Card Module', 'MODULE_PAYMENT_CC_STATUS', 'True', 'Do you want to accept credit card payments?', '6', '0', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Split Credit Card E-Mail Address', 'MODULE_PAYMENT_CC_EMAIL', '', 'If an e-mail address is entered, the middle digits of the credit card number will be sent to the e-mail address (the outside digits are stored in the database with the middle digits censored)', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Collect & store the CVV number', 'MODULE_PAYMENT_CC_COLLECT_CVV', 'True', 'Do you want to collect the CVV number. Note: If you do the CVV number will be stored in the database in an encoded format.', 6, 0, NULL, '2004-01-11 22:55:51', NULL, 'zen_cfg_select_option(array(\'True\', \'False\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Store the Credit Card Number', 'MODULE_PAYMENT_CC_STORE_NUMBER', 'False', 'Do you want to store the Credit Card Number. Note: The Credit Card Number will be stored unenecrypted, and as such may represent a security problem', 6, 0, NULL, now(), NULL, 'zen_cfg_select_option(array(\'True\', \'False\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort order of display.', 'MODULE_PAYMENT_CC_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '0' , now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Payment Zone', 'MODULE_PAYMENT_CC_ZONE', '0', 'If a zone is selected, only enable this payment method for that zone.', '6', '2', 'zen_get_zone_class_title', 'zen_cfg_pull_down_zone_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, use_function, date_added) VALUES ('Set Order Status', 'MODULE_PAYMENT_CC_ORDER_STATUS_ID', '0', 'Set the status of orders made with this payment module to this value', '6', '0', 'zen_cfg_pull_down_order_statuses(', 'zen_get_order_status_name', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Flat Shipping', 'MODULE_SHIPPING_FLAT_STATUS', 'True', 'Do you want to offer flat rate shipping?', '6', '0', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Shipping Cost', 'MODULE_SHIPPING_FLAT_COST', '5.00', 'The shipping cost for all orders using this shipping method.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Tax Class', 'MODULE_SHIPPING_FLAT_TAX_CLASS', '0', 'Use the following tax class on the shipping fee.', '6', '0', 'zen_get_tax_class_title', 'zen_cfg_pull_down_tax_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Shipping Zone', 'MODULE_SHIPPING_FLAT_ZONE', '0', 'If a zone is selected, only enable this shipping method for that zone.', '6', '0', 'zen_get_zone_class_title', 'zen_cfg_pull_down_zone_classes(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Sort Order', 'MODULE_SHIPPING_FLAT_SORT_ORDER', '0', 'Sort order of display.', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Currency', 'DEFAULT_CURRENCY', 'USD', 'Default Currency', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Language', 'DEFAULT_LANGUAGE', 'en', 'Default Language', '6', '0', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Order Status For New Orders', 'DEFAULT_ORDERS_STATUS_ID', '1', 'When a new order is created, this order status will be assigned to it.', '6', '0', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Country of Origin', 'SHIPPING_ORIGIN_COUNTRY', '223', 'Select the country of origin to be used in shipping quotes.', '7', '1', 'zen_get_country_name', 'zen_cfg_pull_down_country_list(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Postal Code', 'SHIPPING_ORIGIN_ZIP', 'NONE', 'Enter the Postal Code (ZIP) of the Store to be used in shipping quotes.', '7', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Enter the Maximum Package Weight you will ship', 'SHIPPING_MAX_WEIGHT', '50', 'Carriers have a max weight limit for a single package. This is a common one for all.', '7', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Package Tare weight.', 'SHIPPING_BOX_WEIGHT', '3', 'What is the weight of typical packaging of small to medium packages?', '7', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Larger packages - percentage increase.', 'SHIPPING_BOX_PADDING', '10', 'For 10% enter 10', '7', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Virtual Default Status - Skip Shipping Address', 'PRODUCTS_VIRTUAL_DEFAULT', '0', 'What should the Default Virtual Product status be when adding new products?<br /><br />0= Virtual Product Defaults to OFF<br />1= Virtual Product Defaults to ON<br />NOTE: Virtual Products do not require a Shipping Address', '7', '10', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Free Shipping Default Status - Normal Shipping Rules', 'PRODUCTS_IS_ALWAYS_FREE_SHIPPING_DEFAULT', '0', 'What should the Default Free Shipping status be when adding new products?<br /><br />0= Free Shipping Defaults to OFF<br />1= Free Shipping Defaults to ON<br />NOTE: Free Shipping Products require a Shipping Address', '7', '11', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Number of Boxes and Weight Status', 'SHIPPING_BOX_WEIGHT_DISPLAY', '3', 'Display Shipping Weight and Number of Boxes?<br /><br />0= off<br />1= Boxes Only<br />2= Weight Only<br />3= Both Boxes and Weight', '7', '15', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Order Free Shipping 0 Weight Status', 'ORDER_WEIGHT_ZERO_STATUS', '0', 'If there is no weight to the order, does the order have Free Shipping?<br />0= no<br />1= yes<br /><br />Note: When using Free Shipping, Enable the Free Shipping Module this will only show when shipping is free', '7', '15', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Image', 'PRODUCT_LIST_IMAGE', '1', 'Do you want to display the Product Image?', '8', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Manufaturer Name','PRODUCT_LIST_MANUFACTURER', '0', 'Do you want to display the Product Manufacturer Name?', '8', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Model', 'PRODUCT_LIST_MODEL', '0', 'Do you want to display the Product Model?', '8', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Name', 'PRODUCT_LIST_NAME', '2', 'Do you want to display the Product Name?', '8', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Price/Buy Now', 'PRODUCT_LIST_PRICE', '3', 'Do you want to display the Product Price/Buy Now', '8', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Quantity', 'PRODUCT_LIST_QUANTITY', '0', 'Do you want to display the Product Quantity?', '8', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Weight', 'PRODUCT_LIST_WEIGHT', '0', 'Do you want to display the Product Weight?', '8', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Price/Buy Now Column Width', 'PRODUCTS_LIST_PRICE_WIDTH', '125', 'Define the width of the Price/Buy Now column<br />Default= 125', '8', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Category/Manufacturer Filter (0=off; 1=on)', 'PRODUCT_LIST_FILTER', '1', 'Do you want to display the Category/Manufacturer Filter?', '8', '9', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Prev/Next Split Page Navigation (1-top, 2-bottom, 3-both)', 'PREV_NEXT_BAR_LOCATION', '3', 'Sets the location of the Prev/Next Split Page Navigation', '8', '10', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\'), ', now());


INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Check stock level', 'STOCK_CHECK', 'true', 'Check to see if sufficent stock is available', '9', '1', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Subtract stock', 'STOCK_LIMITED', 'true', 'Subtract product in stock by product orders', '9', '2', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Allow Checkout', 'STOCK_ALLOW_CHECKOUT', 'true', 'Allow customer to checkout even if there is insufficient stock', '9', '3', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Mark product out of stock', 'STOCK_MARK_PRODUCT_OUT_OF_STOCK', '***', 'Display something on screen so customer can see which product has insufficient stock', '9', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Stock Re-order level', 'STOCK_REORDER_LEVEL', '5', 'Define when stock needs to be re-ordered', '9', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Products status in Catalog when out of stock should be set to', 'SHOW_PRODUCTS_SOLD_OUT', '0', 'Show Products when out of stock<br /><br />0= set product status to OFF<br />1= leave product status ON', '9', '10', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Sold Out Image in place of Add to Cart', 'SHOW_PRODUCTS_SOLD_OUT_IMAGE', '1', 'Show Sold Out Image instead of Add to Cart Button<br /><br />0= off<br />1= on', '9', '11', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Quantity Decimals', 'QUANTITY_DECIMALS', '0', 'Allow how many decimals on Quantity<br /><br />0= off', '9', '15', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Store Page Parse Time', 'STORE_PAGE_PARSE_TIME', 'false', 'Store the time it takes to parse a page', '10', '1', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Log Destination', 'STORE_PAGE_PARSE_TIME_LOG', '/var/log/www/zen/page_parse_time.log', 'Directory and filename of the page parse time log', '10', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Log Date Format', 'STORE_PARSE_DATE_TIME_FORMAT', '%d/%m/%Y %H:%M:%S', 'The date format', '10', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display The Page Parse Time', 'DISPLAY_PAGE_PARSE_TIME', 'true', 'Display the page parse time on the bottom of each page<br />You do not need to store the times to display them in the Catalog', '10', '4', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Store Database Queries', 'STORE_DB_TRANSACTIONS', 'false', 'Store the database queries in the page parse time log (PHP4 only)', '10', '5', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('E-Mail Transport Method', 'EMAIL_TRANSPORT', 'sendmail', 'Defines if this server uses a local connection to sendmail or uses an SMTP connection via TCP/IP. Servers running on Windows and MacOS should change this setting to SMTP.', '12', '1', 'zen_cfg_select_option(array(\'sendmail\', \'smtp\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('E-Mail Linefeeds', 'EMAIL_LINEFEED', 'LF', 'Defines the character sequence used to separate mail headers.', '12', '2', 'zen_cfg_select_option(array(\'LF\', \'CRLF\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Use MIME HTML When Sending Emails', 'EMAIL_USE_HTML', 'false', 'Send e-mails in HTML format', '12', '3', 'zen_cfg_select_option(array(\'true\', \'false\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Verify E-Mail Addresses Through DNS', 'ENTRY_EMAIL_ADDRESS_CHECK', 'false', 'Verify e-mail address through a DNS server', '12', '4', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send E-Mails', 'SEND_EMAILS', 'true', 'Send out e-mails', '12', '5', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('E-Mail Address', 'STORE_OWNER_EMAIL_ADDRESS', 'root@localhost', 'The e-mail address of my store owner', '12', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('E-Mail From', 'EMAIL_FROM', 'Zen Cart <root@localhost>', 'The e-mail address used in (sent) e-mails', '12', '11', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Extra Order Emails To', 'SEND_EXTRA_ORDER_EMAILS_TO', '', 'Send extra order emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '12', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send Copy of Create Account Emails To - Status', 'SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_STATUS', '0', 'Send copy of Create Account Status<br />0= off 1= on', '12', '13', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Copy of Create Account Emails To', 'SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO', '', 'Send copy of Create Account emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '14', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send Copy of Tell a Friend Emails To - Status', 'SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_STATUS', '0', 'Send copy of Tell a Friend Status<br />0= off 1= on', '12', '15', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Copy of Tell a Friend Emails To', 'SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO', '', 'Send copy of Tell a Friend emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '16', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send Copy of Customer GV Send Emails To - Status', 'SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_STATUS', '0', 'Send copy of Customer GV Send Status<br />0= off 1= on', '12', '17', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Copy of Customer GV Send Emails To', 'SEND_EXTRA_GV_CUSTOMER_EMAILS_TO', '', 'Send copy of Customer GV Send emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '18', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send Copy of Admin GV Mail Emails To - Status', 'SEND_EXTRA_GV_ADMIN_EMAILS_TO_STATUS', '0', 'Send copy of Admin GV Mail Status<br />0= off 1= on', '12', '19', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Copy of Customer Admin GV Mail Emails To', 'SEND_EXTRA_GV_ADMIN_EMAILS_TO', '', 'Send copy of Admin GV Mail emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '20', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send Copy of Admin Discount Coupon Mail Emails To - Status', 'SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_STATUS', '0', 'Send copy of Admin Discount Coupon Mail Status<br />0= off 1= on', '12', '21', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Copy of Customer Admin Discount Coupon Mail Emails To', 'SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO', '', 'Send copy of Admin Discount Coupon Mail emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '22', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Send Copy of Admin Orders Status Emails To - Status', 'SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_STATUS', '0', 'Send copy of Admin Orders Status Status<br />0= off 1= on', '12', '23', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Send Copy of Admin Orders Status Emails To', 'SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO', '', 'Send copy of Admin Orders Status emails to the following email addresses, in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '24', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Set "Contact Us" Email Dropdown List', 'CONTACT_US_LIST', '', 'On the "Contact Us" Page, set the list of email addresses , in this format: Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;', '12', '40', 'zen_cfg_textarea(', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Allow Guest To Tell A Friend', 'ALLOW_GUEST_TO_TELL_A_FRIEND', 'true', 'Allow guests to tell a friend about a product', '12', '50', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Contact Us - Show Store Name and Address', 'CONTACT_US_STORE_NAME_ADDRESS', '1', 'Include Store Name and Address<br />0= off 1= on', '12', '50', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('New Signup Discount Coupon ID#', 'NEW_SIGNUP_DISCOUNT_COUPON', '', 'Select the coupon<br />', 16, 75, NULL, now(), NULL, 'zen_cfg_select_coupon_id(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('New Signup Gift Voucher Amount', 'NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', '', 'Leave blank for none<br />Or enter an amount ie. 10 for $10.00', 16, 76, NULL, now(), NULL, NULL);


INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable Downloads', 'DOWNLOAD_ENABLED', 'false', 'Enable the products download functions.', '13', '1', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Download by Redirect', 'DOWNLOAD_BY_REDIRECT', 'false', 'Use browser redirection for download. Disable on non-Unix systems.', '13', '2', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Download Expiration- Number of Days)' ,'DOWNLOAD_MAX_DAYS', '7', 'Set number of days before the download link expires. 0 means no limit.', '13', '3', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Number of Downloads Allowed - Per Product' ,'DOWNLOAD_MAX_COUNT', '5', 'Set the maximum number of downloads. 0 means no download authorized.', '13', '4', '', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified) VALUES ('Downloads Controller Update Status Value', 'DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE', '4', 'What orders_status resets the Download days and Max Downloads - Default is 4', '13', '10', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified) VALUES ('Downloads Controller Order Status Value', 'DOWNLOADS_CONTROLLER_ORDERS_STATUS', '2', 'Downloads Controller Order Status Value - Default=2', '13', '12', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Enable GZip Compression', 'GZIP_LEVEL', '0', '0= off 1= on', '14', '1', 'zen_cfg_select_option(array(\'0\', \'1\'),', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Session Directory', 'SESSION_WRITE_DIRECTORY', '/tmp', 'If sessions are file based, store them in this directory.', '15', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Force Cookie Use', 'SESSION_FORCE_COOKIE_USE', 'False', 'Force the use of sessions when cookies are only enabled.', '15', '2', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Check SSL Session ID', 'SESSION_CHECK_SSL_SESSION_ID', 'False', 'Validate the SSL_SESSION_ID on every secure HTTPS page request.', '15', '3', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Check User Agent', 'SESSION_CHECK_USER_AGENT', 'False', 'Validate the clients browser user agent on every page request.', '15', '4', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Check IP Address', 'SESSION_CHECK_IP_ADDRESS', 'False', 'Validate the clients IP address on every page request.', '15', '5', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Prevent Spider Sessions', 'SESSION_BLOCK_SPIDERS', 'False', 'Prevent known spiders from starting a session.', '15', '6', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Recreate Session', 'SESSION_RECREATE', 'False', 'Recreate the session to generate a new session ID when the customer logs on or creates an account (PHP >=4.1 needed).', '15', '7', 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Length of the redeem code', 'SECURITY_CODE_LENGTH', '10', 'Enter the length of the redeem code<br />The longer the more secure', 16, 1, NULL, now(), NULL, NULL);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - VISA', 'CC_ENABLED_VISA', '1', 'Accept VISA 0= off 1= on', '17', '1', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - MasterCard', 'CC_ENABLED_MC', '1', 'Accept MasterCard 0= off 1= on', '17', '2', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - AmericanExpress', 'CC_ENABLED_AMEX', '0', 'Accept AmericanExpress 0= off 1= on', '17', '3', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - Diners Club', 'CC_ENABLED_DINERS_CLUB', '0', 'Accept Diners Club 0= off 1= on', '17', '4', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - Discover Card', 'CC_ENABLED_DISCOVER', '0', 'Accept Discover Card 0= off 1= on', '17', '5', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - JCB', 'CC_ENABLED_JCB', '0', 'Accept JCB 0= off 1= on', '17', '6', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enable Status - AUSTRALIAN BANKCARD', 'CC_ENABLED_AUSTRALIAN_BANKCARD', '0', 'Accept AUSTRALIAN BANKCARD 0= off 1= on', '17', '7', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Credit Card Enabled - Show on Payment', 'SHOW_ACCEPTED_CREDIT_CARDS', '0', 'Show accepted credit cards on Payment page?<br />0= off<br />1= As Text<br />2= As Images<br /><br />Note: images and text must be defined in both the database and language file for specific credit card types.', '17', '50', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_GV_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:40', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_GV_SORT_ORDER', '840', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:40', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Queue Purchases', 'MODULE_ORDER_TOTAL_GV_QUEUE', 'true', 'Do you want to queue purchases of the Gift Voucher?', 6, 3, NULL, '2003-10-30 22:16:40', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Include Shipping', 'MODULE_ORDER_TOTAL_GV_INC_SHIPPING', 'true', 'Include Shipping in calculation', 6, 5, NULL, '2003-10-30 22:16:40', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Include Tax', 'MODULE_ORDER_TOTAL_GV_INC_TAX', 'true', 'Include Tax in calculation.', 6, 6, NULL, '2003-10-30 22:16:40', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Re-calculate Tax', 'MODULE_ORDER_TOTAL_GV_CALC_TAX', 'None', 'Re-Calculate Tax', 6, 7, NULL, '2003-10-30 22:16:40', NULL, 'zen_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Tax Class', 'MODULE_ORDER_TOTAL_GV_TAX_CLASS', '0', 'Use the following tax class when treating Gift Voucher as Credit Note.', 6, 0, NULL, '2003-10-30 22:16:40', 'zen_get_tax_class_title', 'zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Credit including Tax', 'MODULE_ORDER_TOTAL_GV_CREDIT_TAX', 'false', 'Add tax to purchased Gift Voucher when crediting to Account', 6, 8, NULL, '2003-10-30 22:16:40', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:43', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER', '400', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:43', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Allow Low Order Fee', 'MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE', 'false', 'Do you want to allow low order fees?', 6, 3, NULL, '2003-10-30 22:16:43', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Order Fee For Orders Under', 'MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER', '50', 'Add the low order fee to orders under this amount.', 6, 4, NULL, '2003-10-30 22:16:43', 'currencies->format', NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Order Fee', 'MODULE_ORDER_TOTAL_LOWORDERFEE_FEE', '5', 'Low order fee.', 6, 5, NULL, '2003-10-30 22:16:43', 'currencies->format', NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Attach Low Order Fee On Orders Made', 'MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION', 'both', 'Attach low order fee for orders sent to the set destination.', 6, 6, NULL, '2003-10-30 22:16:43', NULL, 'zen_cfg_select_option(array(\'national\', \'international\', \'both\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Tax Class', 'MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS', '0', 'Use the following tax class on the low order fee.', 6, 7, NULL, '2003-10-30 22:16:43', 'zen_get_tax_class_title', 'zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_SHIPPING_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:46', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER', '200', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:46', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Allow Free Shipping', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING', 'false', 'Do you want to allow free shipping?', 6, 3, NULL, '2003-10-30 22:16:46', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Free Shipping For Orders Over', 'MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER', '50', 'Provide free shipping for orders over the set amount.', 6, 4, NULL, '2003-10-30 22:16:46', 'currencies->format', NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Provide Free Shipping For Orders Made', 'MODULE_ORDER_TOTAL_SHIPPING_DESTINATION', 'national', 'Provide free shipping for orders sent to the set destination.', 6, 5, NULL, '2003-10-30 22:16:46', NULL, 'zen_cfg_select_option(array(\'national\', \'international\', \'both\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_SUBTOTAL_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:49', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER', '100', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:49', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_TAX_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:52', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_TAX_SORT_ORDER', '300', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:52', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:55', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '999', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:55', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Tax Class', 'MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', '0', 'Use the following tax class when treating Discount Coupon as Credit Note.', 6, 0, NULL, '2003-10-30 22:16:36', 'zen_get_tax_class_title', 'zen_cfg_pull_down_tax_classes(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Include Tax', 'MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'true', 'Include Tax in calculation.', 6, 6, NULL, '2003-10-30 22:16:36', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Sort Order', 'MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '740', 'Sort order of display.', 6, 2, NULL, '2003-10-30 22:16:36', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Include Shipping', 'MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'true', 'Include Shipping in calculation', 6, 5, NULL, '2003-10-30 22:16:36', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('This module is installed', 'MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', '', 6, 1, NULL, '2003-10-30 22:16:36', NULL, 'zen_cfg_select_option(array(\'true\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Re-calculate Tax', 'MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'None', 'Re-Calculate Tax', 6, 7, NULL, '2003-10-30 22:16:36', NULL, 'zen_cfg_select_option(array(\'None\', \'Standard\', \'Credit Note\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Admin Demo Status', 'ADMIN_DEMO', '0', 'Admin Demo should be on?<br />0= off 1= on', 6, '0', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Product option type Select', 'PRODUCTS_OPTIONS_TYPE_SELECT', '0', 'The number representing the Select type of product option.', 0, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Text product option type', 'PRODUCTS_OPTIONS_TYPE_TEXT', '1', 'Numeric value of the text product option type', 6, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Radio button product option type', 'PRODUCTS_OPTIONS_TYPE_RADIO', '2', 'Numeric value of the radio button product option type', 6, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Check box product option type', 'PRODUCTS_OPTIONS_TYPE_CHECKBOX', '3', 'Numeric value of the check box product option type', 6, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('File product option type', 'PRODUCTS_OPTIONS_TYPE_FILE', '4', 'Numeric value of the file product option type', 6, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('ID for text and file oroducts options values', 'PRODUCTS_OPTIONS_VALUES_TEXT_ID', '0', 'Numeric value of the products_options_values_id used by the text and file attributes.', 6, NULL, now(), now(), NULL, NULL);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Upload prefix', 'UPLOAD_PREFIX', 'upload_', 'Prefix used to differentiate between upload options and other options', 0, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Text prefix', 'TEXT_PREFIX', 'txt_', 'Prefix used to differentiate between text option values and other option values', 0, NULL, now(), now(), NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Read Only option type', 'PRODUCTS_OPTIONS_TYPE_READONLY', '5', 'Numeric value of the file product option type', 6, NULL, now(), now(), NULL, NULL);







INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Products Info - Products Option Name Sort Order', 'PRODUCTS_OPTIONS_SORT_ORDER', '0', 'Sort order of Option Names for Products Info<br>0= Sort Order, Option Name<br>1= Option Name', 18, 35, now(), now(), NULL, 'zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Products Info - Product Option Value of Attributes Sort Order', 'PRODUCTS_OPTIONS_SORT_BY_PRICE', '1', 'Sort order of Product Option Values of Attributes for Products Info<br>0= Sort Order, Price<br>1= Sort Order, Option Value Name', 18, 36, now(), now(), NULL, 'zen_cfg_select_option(array(\'0\', \'1\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Product Info - Number of Attribute Images per Row', 'PRODUCTS_IMAGES_ATTRIBUTES_PER_ROW', '5', 'Product Info - Enter the number of attribute images to display per row<br />Default = 5', '18', '40', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Show Option Values Name Below Attributes Image', 'PRODUCT_IMAGES_ATTRIBUTES_NAMES', '1', 'Product Info - Show the name of the Option Value beneath the Attribute Image?<br />0= off 1= on', 18, 41, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Show Option Values and Attributes Images for Radio Buttons and Checkboxes', 'PRODUCT_IMAGES_ATTRIBUTES_NAMES_COLUMN', '0', '0= Images Below Option Names<br />1= Element, Image and Option Value<br />2= Element, Image and Option Name Below<br />3= Option Name Below Element and Image<br />4= Element Below Image and Option Name<br />5= Element Above Image and Option Name', 18, 42, 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Show Sales Discount Savings Status', 'SHOW_SALE_DISCOUNT_STATUS', '1', 'Product Info - Show the amount of discount savings?<br />0= off 1= on', 18, 45, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Show Sales Discount Savings Dollars or Percentage', 'SHOW_SALE_DISCOUNT', '1', 'Product Info - Show the amount of discount savings display as:<br />1= % off 2= $amount off', 18, 46, 'zen_cfg_select_option(array(\'1\', \'2\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Show Sales Discount Savings Percentage Decimals', 'SHOW_SALE_DISCOUNT_DECIMALS', '0', 'Product Info - Show discount savings display as a Percentage with how many decimals?:<br />Default= 0', 18, 47, NULL, now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Price is Free Image or Text Status', 'OTHER_IMAGE_PRICE_IS_FREE_ON', '1', 'Product Info - Show the Price is Free Image or Text on Displayed Price<br />0= Text<br />1= Image', 18, 50, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Info - Price is Call for Price Image or Text Status', 'PRODUCTS_PRICE_IS_CALL_IMAGE_ON', '1', 'Product Info - Show the Price is Call for Price Image or Text on Displayed Price<br />0= Text<br />1= Image', 18, 51, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Quantity Box Status', 'PRODUCTS_QTY_BOX_STATUS', '1', 'What should the Default Quantity Box Status be on New Products?<br /><br />0= off<br />1= on<br />NOTE: This will show a Qty Box when ON and default the Add to Cart to 1', '18', '55', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Product Reviews Button Status', 'SHOW_PRODUCT_INFO_REVIEW_BUTTON', '1', 'Display Product Reviews Button<br />0= Only when reviews exist<br />1= Always show button', '18', '60', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Product Reviews Require Approval', 'REVIEWS_APPROVAL', '1', 'Do product reviews require approval?<br /><br />Note: When Review Status is off, it will also not show<br /><br />0= off 1= on', '18', '62', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Meta Tags - Include Product Price in Title', 'META_TAG_INCLUDE_PRICE', '1', 'Do you want to include the Product Price in the Meta Tag Title?<br /><br />0= off 1= on', '18', '70', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Text Pricing - Spaces are Free', 'TEXT_SPACES_FREE', '1', 'On Text pricing Spaces are Free<br /><br />0= off 1= on', '18', '100', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());




INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Column Width - Left Boxes', 'BOX_WIDTH_LEFT', '150px', 'Width of the Left Column Boxes<br />px may be included<br />Default = 150px', 19, 1, NULL, '2003-11-21 22:16:36', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Column Width - Right Boxes', 'BOX_WIDTH_RIGHT', '150px', 'Width of the Right Column Boxes<br />px may be included<br />Default = 150px', 19, 2, NULL, '2003-11-21 22:16:36', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Bread Crumbs Navigation Separator', 'BREAD_CRUMBS_SEPARATOR', '&nbsp;::&nbsp;', 'Enter the separator symbol to appear between the Navigation Bread Crumb trail<br />Note: Include spaces with the &amp;nbsp; symbol if you want them part of the separator.<br />Default = &amp;nbsp;::&amp;nbsp;', 19, 3, NULL, '2003-11-21 22:16:36', NULL, 'zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Bestsellers - Number Padding', 'BEST_SELLERS_FILLER', '&nbsp;', 'What do you want to Pad the numbers with?<br />Default = &amp;nbsp;', 19, 5, NULL, '2003-11-21 22:16:36', NULL, 'zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Bestsellers - Truncate Product Names', 'BEST_SELLERS_TRUNCATE', '35', 'What size do you want to truncate the Product Names?<br />Default = 35', 19, 6, NULL, '2003-11-21 22:16:36', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Bestsellers - Truncate Product Names followed by ...', 'BEST_SELLERS_TRUNCATE_MORE', 'true', 'When truncated Product Names follow with ...<br />Default = true', 19, 7, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Box - Show Specials Link', 'SHOW_CATEGORIES_BOX_SPECIALS', 'true', 'Show Specials Link in the Categories Box', 19, 8, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Box - Show Products New Link', 'SHOW_CATEGORIES_BOX_PRODUCTS_NEW', 'true', 'Show Products New Link in the Categories Box', 19, 9, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Shopping Cart Box Status', 'SHOW_SHOPPING_CART_BOX_STATUS', '1', 'Shopping Cart Shows<br />0= Always<br />1= Only when full<br />2= Only when full but when viewing the Shopping Cart', 19, 10, 'zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Box - Show Featured Products Link', 'SHOW_CATEGORIES_BOX_FEATURED_PRODUCTS', 'true', 'Show Featured Products Link in the Categories Box', 19, 11, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Box - Show Products All Link', 'SHOW_CATEGORIES_BOX_PRODUCTS_ALL', 'true', 'Show Products All Link in the Categories Box', 19, 12, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Column Left Status - Global', 'COLUMN_LEFT_STATUS', '1', 'Show Column Left, unless page override exists?<br />0= Column Left is always off<br />1= Column Left is on, unless page override', 19, 15, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Column Right Status - Global', 'COLUMN_RIGHT_STATUS', '1', 'Show Column Right, unless page override exists?<br />0= Column Right is always off<br />1= Column Right is on, unless page override', 19, 16, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Column Width - Left', 'COLUMN_WIDTH_LEFT', '150px', 'Width of the Left Column<br />px may be included<br />Default = 150px', 19, 20, NULL, '2003-11-21 22:16:36', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Column Width - Right', 'COLUMN_WIDTH_RIGHT', '150px', 'Width of the Right Column<br />px may be included<br />Default = 150px', 19, 21, NULL, '2003-11-21 22:16:36', NULL, NULL);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Seperator between the Category Name and Count', 'CATEGORIES_SEPARATOR', '-&gt;', 'What separator do you want between the Category name and the count?<br />Default = -&amp;gt;', 19, 25, NULL, '2003-11-21 22:16:36', NULL, 'zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Seperator between the Category Name and Sub Categories', 'CATEGORIES_SEPARATOR_SUBS', '|_&nbsp;', 'What separator do you want between the Category name and Sub Category Name?<br />Default = |_&amp;nbsp;', 19, 26, NULL, '2004-03-25 22:16:36', NULL, 'zen_cfg_textarea_small(');

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Count Prefix', 'CATEGORIES_COUNT_PREFIX', '&nbsp;(', 'What do you want to Prefix the count with?<br />Default= (', 19, 27, NULL, '2003-01-21 22:16:36', NULL, 'zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Categories Count Suffix', 'CATEGORIES_COUNT_SUFFIX', ')', 'What do you want as a Suffix to the count?<br />Default= )', 19, 28, NULL, '2003-01-21 22:16:36', NULL, 'zen_cfg_textarea_small(');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Categories with 0 Products Status', 'CATEGORIES_COUNT_ZERO', '0', 'Show Category Count for 0 Products?<br />0= off<br />1= on', 19, 30, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Split Categories Box', 'CATEGORIES_SPLIT_DISPLAY', 'True', 'Split the categories box display by product type', 19, 31, 'zen_cfg_select_option(array(\'True\', \'False\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Shopping Cart - Show Totals', 'SHOW_TOTALS_IN_CART', '1', 'Show Totals Above Shopping Cart?<br />0= off<br />1= on<br />2= on, no weight when 0', 19, 31, 'zen_cfg_select_option(array(\'0\', \'1\', \'2\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Categories - Always Show on Main Page', 'SHOW_CATEGORIES_ALWAYS', '1', 'Always Show Categories on Main Page<br />0= off<br />1= on<br />Default category can be set to Top Level or a Specific Top Level', 19, 45, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Main Page - Opens with Category', 'CATEGORIES_START_MAIN', '0', '0= Top Level Categories<br />Or enter the Category ID#<br />Note: Sub Categories can also be used Example: 3_10', '19', '46', '', '', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Header Position 1', 'SHOW_BANNERS_GROUP_SET1', '', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br /><br />What Banner Group(s) do you want to use in the Header Position 1?<br />Leave blank for none', '19', '55', '', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Header Position 2', 'SHOW_BANNERS_GROUP_SET2', '', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br /><br />What Banner Group(s) do you want to use in the Header Position 2?<br />Leave blank for none', '19', '56', '', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Header Position 3', 'SHOW_BANNERS_GROUP_SET3', '', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br /><br />What Banner Group(s) do you want to use in the Header Position 3?<br />Leave blank for none', '19', '57', '', '', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Footer Position 1', 'SHOW_BANNERS_GROUP_SET4', '', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br /><br />What Banner Group(s) do you want to use in the Footer Position 1?<br />Leave blank for none', '19', '65', '', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Footer Position 2', 'SHOW_BANNERS_GROUP_SET5', '', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br /><br />What Banner Group(s) do you want to use in the Footer Position 2?<br />Leave blank for none', '19', '66', '', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Footer Position 3', 'SHOW_BANNERS_GROUP_SET6', '468x50', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br /><br />Default Group is 468x50<br /><br />What Banner Group(s) do you want to use in the Footer Position 3?<br />Leave blank for none', '19', '67', '', '', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Side Box banner_box', 'SHOW_BANNERS_GROUP_SET7', '125x125', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br />Default Group is 125x125<br /><br />What Banner Group(s) do you want to use in the Side Box - banner_box?<br />Leave blank for none', '19', '70', '', '', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Banner Display Groups - Side Box banner_box2', 'SHOW_BANNERS_GROUP_SET8', '125x125', 'The Banner Display Groups can be from 1 Banner Group or Multiple Banner Groups<br /><br />For Multiple Banner Groups enter the Banner Group Name seperated by a colon <strong>:</strong><br /><br />Example: 468x50:125x125<br />Default Group is 125x125<br /><br />What Banner Group(s) do you want to use in the Side Box - banner_box2?<br />Leave blank for none', '19', '71', '', '', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Footer - Show IP Address status', 'SHOW_FOOTER_IP', '1', 'Show Customer IP Address in the Footer<br />0= off<br />1= on<br />Should the Customer IP Address show in the footer?', 19, 80, 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('<B>Down for Maintenance: ON/OFF</B>', 'DOWN_FOR_MAINTENANCE', 'false', 'Down for Maintenance <br>(true=on false=off)', '20', '1', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now(), NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('Down for Maintenance: filename', 'DOWN_FOR_MAINTENANCE_FILENAME', 'down_for_maintenance', 'Down for Maintenance filename<br />Note: Do not include the extention<br />Default=down_for_maintenance', '20', '2', '', now(), NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('Down for Maintenance: Hide Header', 'DOWN_FOR_MAINTENANCE_HEADER_OFF', 'false', 'Down for Maintenance: Hide Header <br>(true=hide false=show)', '20', '3', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now(), NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('Down for Maintenance: Hide Column Left', 'DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF', 'false', 'Down for Maintenance: Hide Column Left <br>(true=hide false=show)', '20', '4', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now(), NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('Down for Maintenance: Hide Column Right', 'DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF', 'false', 'Down for Maintenance: Hide Column Right <br>(true=hide false=show)r', '20', '5', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now(), NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('Down for Maintenance: Hide Footer', 'DOWN_FOR_MAINTENANCE_FOOTER_OFF', 'false', 'Down for Maintenance: Hide Footer <br>(true=hide false=show)', '20', '6', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now(), NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added, use_function) VALUES ('Down for Maintenance: Hide Prices', 'DOWN_FOR_MAINTENANCE_PRICES_OFF', 'false', 'Down for Maintenance: Hide Prices <br>(true=hide false=show)', '20', '7', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now(), NULL);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Down For Maintenance (exclude this IP-Address)', 'EXCLUDE_ADMIN_IP_FOR_MAINTENANCE', 'your IP (ADMIN)', 'This IP Address is able to access the website while it is Down For Maintenance (like webmaster)', 20, 8, '2003-03-21 13:43:22', '2003-03-21 21:20:07', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('NOTICE PUBLIC Before going Down for Maintenance: ON/OFF', 'WARN_BEFORE_DOWN_FOR_MAINTENANCE', 'false', 'Give a WARNING some time before you put your website Down for Maintenance<br>(true=on false=off)<br>If you set the \'Down For Maintenance: ON/OFF\' to true this will automaticly be updated to false', 20, 9, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Date and hours for notice before maintenance', 'PERIOD_BEFORE_DOWN_FOR_MAINTENANCE', '15/05/2003  2-3 PM', 'Date and hours for notice before maintenance website, enter date and hours for maintenance website', 20, 10, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, NULL);
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Display when webmaster has enabled maintenance', 'DISPLAY_MAINTENANCE_TIME', 'false', 'Display when Webmaster has enabled maintenance <br>(true=on false=off)<br>', 20, 11, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Display website maintenance period', 'DISPLAY_MAINTENANCE_PERIOD', 'false', 'Display Website maintenance period <br>(true=on false=off)<br>', 20, 12, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, 'zen_cfg_select_option(array(\'true\', \'false\'),');
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Website maintenance period', 'TEXT_MAINTENANCE_PERIOD_TIME', '2h00', 'Enter Website Maintenance period (hh:mm)', 20, 13, '2003-03-21 13:08:25', '2003-03-21 11:42:47', NULL, NULL);

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Confirm Terms and Conditions During Checkout Procedure', 'DISPLAY_CONDITIONS_ON_CHECKOUT', 'false', 'Show the Terms and Conditions during the checkout procedure which the customer must agree to.', '11', '1', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Confirm Privacy Notice During Account Creation Procedure', 'DISPLAY_PRIVACY_CONDITIONS', 'false', 'Show the Privacy Notice during the account creation procedure which the customer must agree to.', '11', '2', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Image', 'PRODUCT_NEW_LIST_IMAGE', '1102', 'Do you want to display the Product Image?', '21', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Quantity', 'PRODUCT_NEW_LIST_QUANTITY', '1202', 'Do you want to display the Product Quantity?', '21', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Buy Now Button', 'PRODUCT_NEW_BUY_NOW', '1300', 'Do you want to display the Product Buy Now Button', '21', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Name', 'PRODUCT_NEW_LIST_NAME', '2101', 'Do you want to display the Product Name?', '21', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Model', 'PRODUCT_NEW_LIST_MODEL', '2201', 'Do you want to display the Product Model?', '21', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Manufaturer Name','PRODUCT_NEW_LIST_MANUFACTURER', '2302', 'Do you want to display the Product Manufacturer Name?', '21', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Price', 'PRODUCT_NEW_LIST_PRICE', '2402', 'Do you want to display the Product Price', '21', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Weight', 'PRODUCT_NEW_LIST_WEIGHT', '2502', 'Do you want to display the Product Weight?', '21', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Date Added', 'PRODUCT_NEW_LIST_DATE_ADDED', '2601', 'Do you want to display the Product Date Added?', '21', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Product Description', 'PRODUCT_NEW_LIST_DESCRIPTION', '1', 'Do you want to display the Product Description - First 150 characters?<br />0= off<br />1= on', '21', '10', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Product Display - Default Sort Order', 'PRODUCT_NEW_LIST_SORT_DEFAULT', '4', 'What Sort Order Default should be used for New Products Display?<br />Default= 4 for Date<br />1= Products Name<br />2= Price, Products Name<br />3= Model<br />4= Date Added desc', '21', '11', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Products New Group ID', 'PRODUCT_NEW_LIST_GROUP_ID', '21', 'Warning: Only change this if your Products New Group ID has changed from the default of 21<br />What is the configuration_group_id for New Products Listings?', '21', '12', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Image', 'PRODUCT_FEATURED_LIST_IMAGE', '1102', 'Do you want to display the Product Image?', '22', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Quantity', 'PRODUCT_FEATURED_LIST_QUANTITY', '1202', 'Do you want to display the Product Quantity?', '22', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Buy Now Button', 'PRODUCT_FEATURED_BUY_NOW', '1300', 'Do you want to display the Product Buy Now Button', '22', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Name', 'PRODUCT_FEATURED_LIST_NAME', '2101', 'Do you want to display the Product Name?', '22', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Model', 'PRODUCT_FEATURED_LIST_MODEL', '2201', 'Do you want to display the Product Model?', '22', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Manufaturer Name','PRODUCT_FEATURED_LIST_MANUFACTURER', '2302', 'Do you want to display the Product Manufacturer Name?', '22', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Price', 'PRODUCT_FEATURED_LIST_PRICE', '2402', 'Do you want to display the Product Price', '22', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Weight', 'PRODUCT_FEATURED_LIST_WEIGHT', '2502', 'Do you want to display the Product Weight?', '22', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Date Added', 'PRODUCT_FEATURED_LIST_DATE_ADDED', '2601', 'Do you want to display the Product Date Added?', '22', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Product Description', 'PRODUCT_FEATURED_LIST_DESCRIPTION', '1', 'Do you want to display the Product Description - First 150 characters?', '22', '10', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Product Display - Default Sort Order', 'PRODUCT_FEATURED_LIST_SORT_DEFAULT', '1', 'What Sort Order Default should be used for Featured Product Display?<br />Default= 1 for Product Name<br />1= Products Name<br />2= Price, Products Name<br />3= Model<br />4= Date Added desc', '22', '11', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Featured Products Group ID', 'PRODUCT_FEATURED_LIST_GROUP_ID', '22', 'Warning: Only change this if your Featured Products Group ID has changed from the default of 22<br />What is the configuration_group_id for Featured Products Listings?', '22', '12', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Image', 'PRODUCT_ALL_LIST_IMAGE', '1102', 'Do you want to display the Product Image?', '23', '1', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Quantity', 'PRODUCT_ALL_LIST_QUANTITY', '1202', 'Do you want to display the Product Quantity?', '23', '2', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Buy Now Button', 'PRODUCT_ALL_BUY_NOW', '1300', 'Do you want to display the Product Buy Now Button', '23', '3', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Name', 'PRODUCT_ALL_LIST_NAME', '2101', 'Do you want to display the Product Name?', '23', '4', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Model', 'PRODUCT_ALL_LIST_MODEL', '2201', 'Do you want to display the Product Model?', '23', '5', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Manufaturer Name','PRODUCT_ALL_LIST_MANUFACTURER', '2302', 'Do you want to display the Product Manufacturer Name?', '23', '6', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Price', 'PRODUCT_ALL_LIST_PRICE', '2402', 'Do you want to display the Product Price', '23', '7', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Weight', 'PRODUCT_ALL_LIST_WEIGHT', '2502', 'Do you want to display the Product Weight?', '23', '8', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Display Product Date Added', 'PRODUCT_ALL_LIST_DATE_ADDED', '2601', 'Do you want to display the Product Date Added?', '23', '9', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Product Description', 'PRODUCT_ALL_LIST_DESCRIPTION', '1', 'Do you want to display the Product Description - First 150 characters?', '23', '10', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Display Product Display - Default Sort Order', 'PRODUCT_ALL_LIST_SORT_DEFAULT', '1', 'What Sort Order Default should be used for All Products Display?<br />Default= 1 for Product Name<br />1= Products Name<br />2= Price, Products Name<br />3= Model<br />4= Date Added desc', '23', '11', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) VALUES ('Default Products All Group ID', 'PRODUCT_ALL_LIST_GROUP_ID', '23', 'Warning: Only change this if your Products All Group ID has changed from the default of 23<br />What is the configuration_group_id for Products All Listings?', '23', '12', now());


INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show New Products on Main Page', 'SHOW_PRODUCT_INFO_MAIN_NEW_PRODUCTS', '1', 'Show New Products on Main Page<br />0= off or set the sort order', '24', '65', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Featured Products on Main Page', 'SHOW_PRODUCT_INFO_MAIN_FEATURED_PRODUCTS', '2', 'Show Featured Products on Main Page<br />0= off or set the sort order', '24', '66', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Special Products on Main Page', 'SHOW_PRODUCT_INFO_MAIN_SPECIALS_PRODUCTS', '3', 'Show Special Products on Main Page<br />0= off or set the sort order', '24', '67', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Upcoming Products on Main Page', 'SHOW_PRODUCT_INFO_MAIN_UPCOMING', '4', 'Show Upcoming Products on Main Page<br />0= off or set the sort order', '24', '68', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show New Products on Main Page - Category with SubCategories', 'SHOW_PRODUCT_INFO_CATEGORY_NEW_PRODUCTS', '1', 'Show New Products on Main Page - Category with SubCategories<br />0= off or set the sort order', '24', '70', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Featured Products on Main Page - Category with SubCategories', 'SHOW_PRODUCT_INFO_CATEGORY_FEATURED_PRODUCTS', '2', 'Show Featured Products on Main Page - Category with SubCategories<br />0= off or set the sort order', '24', '71', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Special Products on Main Page - Category with SubCategories', 'SHOW_PRODUCT_INFO_CATEGORY_SPECIALS_PRODUCTS', '3', 'Show Special Products on Main Page - Category with SubCategories<br />0= off or set the sort order', '24', '72', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Upcoming Products on Main Page - Category with SubCategories', 'SHOW_PRODUCT_INFO_CATEGORY_UPCOMING', '4', 'Show Upcoming Products on Main Page - Category with SubCategories<br />0= off or set the sort order', '24', '73', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show New Products on Main Page - Errors and Missing Products Page', 'SHOW_PRODUCT_INFO_MISSING_NEW_PRODUCTS', '1', 'Show New Products on Main Page - Errors and Missing Product<br />0= off or set the sort order', '24', '75', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Featured Products on Main Page - Errors and Missing Products Page', 'SHOW_PRODUCT_INFO_MISSING_FEATURED_PRODUCTS', '2', 'Show Featured Products on Main Page - Errors and Missing Product<br />0= off or set the sort order', '24', '76', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Special Products on Main Page - Errors and Missing Products Page', 'SHOW_PRODUCT_INFO_MISSING_SPECIALS_PRODUCTS', '3', 'Show Special Products on Main Page - Errors and Missing Product<br />0= off or set the sort order', '24', '77', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Upcoming Products on Main Page - Errors and Missing Products Page', 'SHOW_PRODUCT_INFO_MISSING_UPCOMING', '4', 'Show Upcoming Products on Main Page - Errors and Missing Product<br />0= off or set the sort order', '24', '78', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show New Products - below Product Listing', 'SHOW_PRODUCT_INFO_LISTING_BELOW_NEW_PRODUCTS', '1', 'Show New Products below Product Listing<br />0= off or set the sort order', '24', '85', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Featured Products - below Product Listing', 'SHOW_PRODUCT_INFO_LISTING_BELOW_FEATURED_PRODUCTS', '2', 'Show Featured Products below Product Listing<br />0= off or set the sort order', '24', '86', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Special Products - below Product Listing', 'SHOW_PRODUCT_INFO_LISTING_BELOW_SPECIALS_PRODUCTS', '3', 'Show Special Products below Product Listing<br />0= off or set the sort order', '24', '87', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Upcoming Products - below Product Listing', 'SHOW_PRODUCT_INFO_LISTING_BELOW_UPCOMING', '4', 'Show Upcoming Products below Product Listing<br />0= off or set the sort order', '24', '88', 'zen_cfg_select_option(array(\'0\', \'1\', \'2\', \'3\', \'4\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('New Products Columns per Row', 'SHOW_PRODUCT_INFO_COLUMNS_NEW_PRODUCTS', '3', 'New Products Columns per Row', '24', '95', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Featured Products Columns per Row', 'SHOW_PRODUCT_INFO_COLUMNS_FEATURED_PRODUCTS', '3', 'Featured Products Columns per Row', '24', '96', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\'), ', now());
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Special Products Columns per Row', 'SHOW_PRODUCT_INFO_COLUMNS_SPECIALS_PRODUCTS', '3', 'Special Products Columns per Row', '24', '97', 'zen_cfg_select_option(array(\'1\', \'2\', \'3\', \'4\'), ', now());

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Filter Product Listing for Current Top Level Category When Enabled', 'SHOW_PRODUCT_INFO_ALL_PRODUCTS', '1', 'Filter the products when Product Listing is enabled for current Main Category or show products from all categories?<br />0= Filter Off 1=Filter On ', '24', '100', 'zen_cfg_select_option(array(\'0\', \'1\'), ', now());


INSERT INTO configuration_group VALUES ('1', 'My Store', 'General information about my store', '1', '1');
INSERT INTO configuration_group VALUES ('2', 'Minimum Values', 'The minimum values for functions / data', '2', '1');
INSERT INTO configuration_group VALUES ('3', 'Maximum Values', 'The maximum values for functions / data', '3', '1');
INSERT INTO configuration_group VALUES ('4', 'Images', 'Image parameters', '4', '1');
INSERT INTO configuration_group VALUES ('5', 'Customer Details', 'Customer account configuration', '5', '1');
INSERT INTO configuration_group VALUES ('6', 'Module Options', 'Hidden from configuration', '6', '0');
INSERT INTO configuration_group VALUES ('7', 'Shipping/Packaging', 'Shipping options available at my store', '7', '1');
INSERT INTO configuration_group VALUES ('8', 'Product Listing', 'Product Listing configuration options', '8', '1');
INSERT INTO configuration_group VALUES ('9', 'Stock', 'Stock configuration options', '9', '1');
INSERT INTO configuration_group VALUES ('10', 'Logging', 'Logging configuration options', '10', '1');
INSERT INTO configuration_group VALUES ('11', 'Regulations', 'Regulation options', '16', '1');
INSERT INTO configuration_group VALUES ('12', 'E-Mail Options', 'General setting for E-Mail transport and HTML E-Mails', '12', '1');
INSERT INTO configuration_group VALUES ('13', 'Download', 'Downloadable products options', '13', '1');
INSERT INTO configuration_group VALUES ('14', 'GZip Compression', 'GZip compression options', '14', '1');
INSERT INTO configuration_group VALUES ('15', 'Sessions', 'Session options', '15', '1');
INSERT INTO configuration_group VALUES ('16', 'GV Coupons', 'Gift Vouchers and Coupons', '16', '1');
INSERT INTO configuration_group VALUES ('17', 'Credit Cards', 'Credit Cards Accepted', '17', '1');
INSERT INTO configuration_group VALUES ('18', 'Product Info', 'Product Info Display Options', '18', '1');
INSERT INTO configuration_group VALUES ('19', 'Layout Settings', 'Layout Options', '19', '1');
INSERT INTO configuration_group VALUES ('20', 'Website Maintenance', 'Website Maintenance Options', '20', '1');
INSERT INTO configuration_group VALUES ('21', 'New Listing', 'New Products Listing', '21', '1');
INSERT INTO configuration_group VALUES ('22', 'Featured Listing', 'Featured Products Listing', '22', '1');
INSERT INTO configuration_group VALUES ('23', 'All Listing', 'All Products Listing', '23', '1');
INSERT INTO configuration_group VALUES ('24', 'Index Listing', 'Index Products Listing', '24', '1');

INSERT INTO countries VALUES (1,'Afghanistan','AF','AFG','1');
INSERT INTO countries VALUES (2,'Albania','AL','ALB','1');
INSERT INTO countries VALUES (3,'Algeria','DZ','DZA','1');
INSERT INTO countries VALUES (4,'American Samoa','AS','ASM','1');
INSERT INTO countries VALUES (5,'Andorra','AD','AND','1');
INSERT INTO countries VALUES (6,'Angola','AO','AGO','1');
INSERT INTO countries VALUES (7,'Anguilla','AI','AIA','1');
INSERT INTO countries VALUES (8,'Antarctica','AQ','ATA','1');
INSERT INTO countries VALUES (9,'Antigua and Barbuda','AG','ATG','1');
INSERT INTO countries VALUES (10,'Argentina','AR','ARG','1');
INSERT INTO countries VALUES (11,'Armenia','AM','ARM','1');
INSERT INTO countries VALUES (12,'Aruba','AW','ABW','1');
INSERT INTO countries VALUES (13,'Australia','AU','AUS','1');
INSERT INTO countries VALUES (14,'Austria','AT','AUT','5');
INSERT INTO countries VALUES (15,'Azerbaijan','AZ','AZE','1');
INSERT INTO countries VALUES (16,'Bahamas','BS','BHS','1');
INSERT INTO countries VALUES (17,'Bahrain','BH','BHR','1');
INSERT INTO countries VALUES (18,'Bangladesh','BD','BGD','1');
INSERT INTO countries VALUES (19,'Barbados','BB','BRB','1');
INSERT INTO countries VALUES (20,'Belarus','BY','BLR','1');
INSERT INTO countries VALUES (21,'Belgium','BE','BEL','1');
INSERT INTO countries VALUES (22,'Belize','BZ','BLZ','1');
INSERT INTO countries VALUES (23,'Benin','BJ','BEN','1');
INSERT INTO countries VALUES (24,'Bermuda','BM','BMU','1');
INSERT INTO countries VALUES (25,'Bhutan','BT','BTN','1');
INSERT INTO countries VALUES (26,'Bolivia','BO','BOL','1');
INSERT INTO countries VALUES (27,'Bosnia and Herzegowina','BA','BIH','1');
INSERT INTO countries VALUES (28,'Botswana','BW','BWA','1');
INSERT INTO countries VALUES (29,'Bouvet Island','BV','BVT','1');
INSERT INTO countries VALUES (30,'Brazil','BR','BRA','1');
INSERT INTO countries VALUES (31,'British Indian Ocean Territory','IO','IOT','1');
INSERT INTO countries VALUES (32,'Brunei Darussalam','BN','BRN','1');
INSERT INTO countries VALUES (33,'Bulgaria','BG','BGR','1');
INSERT INTO countries VALUES (34,'Burkina Faso','BF','BFA','1');
INSERT INTO countries VALUES (35,'Burundi','BI','BDI','1');
INSERT INTO countries VALUES (36,'Cambodia','KH','KHM','1');
INSERT INTO countries VALUES (37,'Cameroon','CM','CMR','1');
INSERT INTO countries VALUES (38,'Canada','CA','CAN','1');
INSERT INTO countries VALUES (39,'Cape Verde','CV','CPV','1');
INSERT INTO countries VALUES (40,'Cayman Islands','KY','CYM','1');
INSERT INTO countries VALUES (41,'Central African Republic','CF','CAF','1');
INSERT INTO countries VALUES (42,'Chad','TD','TCD','1');
INSERT INTO countries VALUES (43,'Chile','CL','CHL','1');
INSERT INTO countries VALUES (44,'China','CN','CHN','1');
INSERT INTO countries VALUES (45,'Christmas Island','CX','CXR','1');
INSERT INTO countries VALUES (46,'Cocos (Keeling) Islands','CC','CCK','1');
INSERT INTO countries VALUES (47,'Colombia','CO','COL','1');
INSERT INTO countries VALUES (48,'Comoros','KM','COM','1');
INSERT INTO countries VALUES (49,'Congo','CG','COG','1');
INSERT INTO countries VALUES (50,'Cook Islands','CK','COK','1');
INSERT INTO countries VALUES (51,'Costa Rica','CR','CRI','1');
INSERT INTO countries VALUES (52,'Cote D\'Ivoire','CI','CIV','1');
INSERT INTO countries VALUES (53,'Croatia','HR','HRV','1');
INSERT INTO countries VALUES (54,'Cuba','CU','CUB','1');
INSERT INTO countries VALUES (55,'Cyprus','CY','CYP','1');
INSERT INTO countries VALUES (56,'Czech Republic','CZ','CZE','1');
INSERT INTO countries VALUES (57,'Denmark','DK','DNK','1');
INSERT INTO countries VALUES (58,'Djibouti','DJ','DJI','1');
INSERT INTO countries VALUES (59,'Dominica','DM','DMA','1');
INSERT INTO countries VALUES (60,'Dominican Republic','DO','DOM','1');
INSERT INTO countries VALUES (61,'East Timor','TP','TMP','1');
INSERT INTO countries VALUES (62,'Ecuador','EC','ECU','1');
INSERT INTO countries VALUES (63,'Egypt','EG','EGY','1');
INSERT INTO countries VALUES (64,'El Salvador','SV','SLV','1');
INSERT INTO countries VALUES (65,'Equatorial Guinea','GQ','GNQ','1');
INSERT INTO countries VALUES (66,'Eritrea','ER','ERI','1');
INSERT INTO countries VALUES (67,'Estonia','EE','EST','1');
INSERT INTO countries VALUES (68,'Ethiopia','ET','ETH','1');
INSERT INTO countries VALUES (69,'Falkland Islands (Malvinas)','FK','FLK','1');
INSERT INTO countries VALUES (70,'Faroe Islands','FO','FRO','1');
INSERT INTO countries VALUES (71,'Fiji','FJ','FJI','1');
INSERT INTO countries VALUES (72,'Finland','FI','FIN','1');
INSERT INTO countries VALUES (73,'France','FR','FRA','1');
INSERT INTO countries VALUES (74,'France, Metropolitan','FX','FXX','1');
INSERT INTO countries VALUES (75,'French Guiana','GF','GUF','1');
INSERT INTO countries VALUES (76,'French Polynesia','PF','PYF','1');
INSERT INTO countries VALUES (77,'French Southern Territories','TF','ATF','1');
INSERT INTO countries VALUES (78,'Gabon','GA','GAB','1');
INSERT INTO countries VALUES (79,'Gambia','GM','GMB','1');
INSERT INTO countries VALUES (80,'Georgia','GE','GEO','1');
INSERT INTO countries VALUES (81,'Germany','DE','DEU','5');
INSERT INTO countries VALUES (82,'Ghana','GH','GHA','1');
INSERT INTO countries VALUES (83,'Gibraltar','GI','GIB','1');
INSERT INTO countries VALUES (84,'Greece','GR','GRC','1');
INSERT INTO countries VALUES (85,'Greenland','GL','GRL','1');
INSERT INTO countries VALUES (86,'Grenada','GD','GRD','1');
INSERT INTO countries VALUES (87,'Guadeloupe','GP','GLP','1');
INSERT INTO countries VALUES (88,'Guam','GU','GUM','1');
INSERT INTO countries VALUES (89,'Guatemala','GT','GTM','1');
INSERT INTO countries VALUES (90,'Guinea','GN','GIN','1');
INSERT INTO countries VALUES (91,'Guinea-bissau','GW','GNB','1');
INSERT INTO countries VALUES (92,'Guyana','GY','GUY','1');
INSERT INTO countries VALUES (93,'Haiti','HT','HTI','1');
INSERT INTO countries VALUES (94,'Heard and Mc Donald Islands','HM','HMD','1');
INSERT INTO countries VALUES (95,'Honduras','HN','HND','1');
INSERT INTO countries VALUES (96,'Hong Kong','HK','HKG','1');
INSERT INTO countries VALUES (97,'Hungary','HU','HUN','1');
INSERT INTO countries VALUES (98,'Iceland','IS','ISL','1');
INSERT INTO countries VALUES (99,'India','IN','IND','1');
INSERT INTO countries VALUES (100,'Indonesia','ID','IDN','1');
INSERT INTO countries VALUES (101,'Iran (Islamic Republic of)','IR','IRN','1');
INSERT INTO countries VALUES (102,'Iraq','IQ','IRQ','1');
INSERT INTO countries VALUES (103,'Ireland','IE','IRL','1');
INSERT INTO countries VALUES (104,'Israel','IL','ISR','1');
INSERT INTO countries VALUES (105,'Italy','IT','ITA','1');
INSERT INTO countries VALUES (106,'Jamaica','JM','JAM','1');
INSERT INTO countries VALUES (107,'Japan','JP','JPN','1');
INSERT INTO countries VALUES (108,'Jordan','JO','JOR','1');
INSERT INTO countries VALUES (109,'Kazakhstan','KZ','KAZ','1');
INSERT INTO countries VALUES (110,'Kenya','KE','KEN','1');
INSERT INTO countries VALUES (111,'Kiribati','KI','KIR','1');
INSERT INTO countries VALUES (112,'Korea, Democratic People\'s Republic of','KP','PRK','1');
INSERT INTO countries VALUES (113,'Korea, Republic of','KR','KOR','1');
INSERT INTO countries VALUES (114,'Kuwait','KW','KWT','1');
INSERT INTO countries VALUES (115,'Kyrgyzstan','KG','KGZ','1');
INSERT INTO countries VALUES (116,'Lao People\'s Democratic Republic','LA','LAO','1');
INSERT INTO countries VALUES (117,'Latvia','LV','LVA','1');
INSERT INTO countries VALUES (118,'Lebanon','LB','LBN','1');
INSERT INTO countries VALUES (119,'Lesotho','LS','LSO','1');
INSERT INTO countries VALUES (120,'Liberia','LR','LBR','1');
INSERT INTO countries VALUES (121,'Libyan Arab Jamahiriya','LY','LBY','1');
INSERT INTO countries VALUES (122,'Liechtenstein','LI','LIE','1');
INSERT INTO countries VALUES (123,'Lithuania','LT','LTU','1');
INSERT INTO countries VALUES (124,'Luxembourg','LU','LUX','1');
INSERT INTO countries VALUES (125,'Macau','MO','MAC','1');
INSERT INTO countries VALUES (126,'Macedonia, The Former Yugoslav Republic of','MK','MKD','1');
INSERT INTO countries VALUES (127,'Madagascar','MG','MDG','1');
INSERT INTO countries VALUES (128,'Malawi','MW','MWI','1');
INSERT INTO countries VALUES (129,'Malaysia','MY','MYS','1');
INSERT INTO countries VALUES (130,'Maldives','MV','MDV','1');
INSERT INTO countries VALUES (131,'Mali','ML','MLI','1');
INSERT INTO countries VALUES (132,'Malta','MT','MLT','1');
INSERT INTO countries VALUES (133,'Marshall Islands','MH','MHL','1');
INSERT INTO countries VALUES (134,'Martinique','MQ','MTQ','1');
INSERT INTO countries VALUES (135,'Mauritania','MR','MRT','1');
INSERT INTO countries VALUES (136,'Mauritius','MU','MUS','1');
INSERT INTO countries VALUES (137,'Mayotte','YT','MYT','1');
INSERT INTO countries VALUES (138,'Mexico','MX','MEX','1');
INSERT INTO countries VALUES (139,'Micronesia, Federated States of','FM','FSM','1');
INSERT INTO countries VALUES (140,'Moldova, Republic of','MD','MDA','1');
INSERT INTO countries VALUES (141,'Monaco','MC','MCO','1');
INSERT INTO countries VALUES (142,'Mongolia','MN','MNG','1');
INSERT INTO countries VALUES (143,'Montserrat','MS','MSR','1');
INSERT INTO countries VALUES (144,'Morocco','MA','MAR','1');
INSERT INTO countries VALUES (145,'Mozambique','MZ','MOZ','1');
INSERT INTO countries VALUES (146,'Myanmar','MM','MMR','1');
INSERT INTO countries VALUES (147,'Namibia','NA','NAM','1');
INSERT INTO countries VALUES (148,'Nauru','NR','NRU','1');
INSERT INTO countries VALUES (149,'Nepal','NP','NPL','1');
INSERT INTO countries VALUES (150,'Netherlands','NL','NLD','1');
INSERT INTO countries VALUES (151,'Netherlands Antilles','AN','ANT','1');
INSERT INTO countries VALUES (152,'New Caledonia','NC','NCL','1');
INSERT INTO countries VALUES (153,'New Zealand','NZ','NZL','1');
INSERT INTO countries VALUES (154,'Nicaragua','NI','NIC','1');
INSERT INTO countries VALUES (155,'Niger','NE','NER','1');
INSERT INTO countries VALUES (156,'Nigeria','NG','NGA','1');
INSERT INTO countries VALUES (157,'Niue','NU','NIU','1');
INSERT INTO countries VALUES (158,'Norfolk Island','NF','NFK','1');
INSERT INTO countries VALUES (159,'Northern Mariana Islands','MP','MNP','1');
INSERT INTO countries VALUES (160,'Norway','NO','NOR','1');
INSERT INTO countries VALUES (161,'Oman','OM','OMN','1');
INSERT INTO countries VALUES (162,'Pakistan','PK','PAK','1');
INSERT INTO countries VALUES (163,'Palau','PW','PLW','1');
INSERT INTO countries VALUES (164,'Panama','PA','PAN','1');
INSERT INTO countries VALUES (165,'Papua New Guinea','PG','PNG','1');
INSERT INTO countries VALUES (166,'Paraguay','PY','PRY','1');
INSERT INTO countries VALUES (167,'Peru','PE','PER','1');
INSERT INTO countries VALUES (168,'Philippines','PH','PHL','1');
INSERT INTO countries VALUES (169,'Pitcairn','PN','PCN','1');
INSERT INTO countries VALUES (170,'Poland','PL','POL','1');
INSERT INTO countries VALUES (171,'Portugal','PT','PRT','1');
INSERT INTO countries VALUES (172,'Puerto Rico','PR','PRI','1');
INSERT INTO countries VALUES (173,'Qatar','QA','QAT','1');
INSERT INTO countries VALUES (174,'Reunion','RE','REU','1');
INSERT INTO countries VALUES (175,'Romania','RO','ROM','1');
INSERT INTO countries VALUES (176,'Russian Federation','RU','RUS','1');
INSERT INTO countries VALUES (177,'Rwanda','RW','RWA','1');
INSERT INTO countries VALUES (178,'Saint Kitts and Nevis','KN','KNA','1');
INSERT INTO countries VALUES (179,'Saint Lucia','LC','LCA','1');
INSERT INTO countries VALUES (180,'Saint Vincent and the Grenadines','VC','VCT','1');
INSERT INTO countries VALUES (181,'Samoa','WS','WSM','1');
INSERT INTO countries VALUES (182,'San Marino','SM','SMR','1');
INSERT INTO countries VALUES (183,'Sao Tome and Principe','ST','STP','1');
INSERT INTO countries VALUES (184,'Saudi Arabia','SA','SAU','1');
INSERT INTO countries VALUES (185,'Senegal','SN','SEN','1');
INSERT INTO countries VALUES (186,'Seychelles','SC','SYC','1');
INSERT INTO countries VALUES (187,'Sierra Leone','SL','SLE','1');
INSERT INTO countries VALUES (188,'Singapore','SG','SGP', '4');
INSERT INTO countries VALUES (189,'Slovakia (Slovak Republic)','SK','SVK','1');
INSERT INTO countries VALUES (190,'Slovenia','SI','SVN','1');
INSERT INTO countries VALUES (191,'Solomon Islands','SB','SLB','1');
INSERT INTO countries VALUES (192,'Somalia','SO','SOM','1');
INSERT INTO countries VALUES (193,'South Africa','ZA','ZAF','1');
INSERT INTO countries VALUES (194,'South Georgia and the South Sandwich Islands','GS','SGS','1');
INSERT INTO countries VALUES (195,'Spain','ES','ESP','3');
INSERT INTO countries VALUES (196,'Sri Lanka','LK','LKA','1');
INSERT INTO countries VALUES (197,'St. Helena','SH','SHN','1');
INSERT INTO countries VALUES (198,'St. Pierre and Miquelon','PM','SPM','1');
INSERT INTO countries VALUES (199,'Sudan','SD','SDN','1');
INSERT INTO countries VALUES (200,'Suriname','SR','SUR','1');
INSERT INTO countries VALUES (201,'Svalbard and Jan Mayen Islands','SJ','SJM','1');
INSERT INTO countries VALUES (202,'Swaziland','SZ','SWZ','1');
INSERT INTO countries VALUES (203,'Sweden','SE','SWE','1');
INSERT INTO countries VALUES (204,'Switzerland','CH','CHE','1');
INSERT INTO countries VALUES (205,'Syrian Arab Republic','SY','SYR','1');
INSERT INTO countries VALUES (206,'Taiwan','TW','TWN','1');
INSERT INTO countries VALUES (207,'Tajikistan','TJ','TJK','1');
INSERT INTO countries VALUES (208,'Tanzania, United Republic of','TZ','TZA','1');
INSERT INTO countries VALUES (209,'Thailand','TH','THA','1');
INSERT INTO countries VALUES (210,'Togo','TG','TGO','1');
INSERT INTO countries VALUES (211,'Tokelau','TK','TKL','1');
INSERT INTO countries VALUES (212,'Tonga','TO','TON','1');
INSERT INTO countries VALUES (213,'Trinidad and Tobago','TT','TTO','1');
INSERT INTO countries VALUES (214,'Tunisia','TN','TUN','1');
INSERT INTO countries VALUES (215,'Turkey','TR','TUR','1');
INSERT INTO countries VALUES (216,'Turkmenistan','TM','TKM','1');
INSERT INTO countries VALUES (217,'Turks and Caicos Islands','TC','TCA','1');
INSERT INTO countries VALUES (218,'Tuvalu','TV','TUV','1');
INSERT INTO countries VALUES (219,'Uganda','UG','UGA','1');
INSERT INTO countries VALUES (220,'Ukraine','UA','UKR','1');
INSERT INTO countries VALUES (221,'United Arab Emirates','AE','ARE','1');
INSERT INTO countries VALUES (222,'United Kingdom','GB','GBR','1');
INSERT INTO countries VALUES (223,'United States','US','USA', '2');
INSERT INTO countries VALUES (224,'United States Minor Outlying Islands','UM','UMI','1');
INSERT INTO countries VALUES (225,'Uruguay','UY','URY','1');
INSERT INTO countries VALUES (226,'Uzbekistan','UZ','UZB','1');
INSERT INTO countries VALUES (227,'Vanuatu','VU','VUT','1');
INSERT INTO countries VALUES (228,'Vatican City State (Holy See)','VA','VAT','1');
INSERT INTO countries VALUES (229,'Venezuela','VE','VEN','1');
INSERT INTO countries VALUES (230,'Viet Nam','VN','VNM','1');
INSERT INTO countries VALUES (231,'Virgin Islands (British)','VG','VGB','1');
INSERT INTO countries VALUES (232,'Virgin Islands (U.S.)','VI','VIR','1');
INSERT INTO countries VALUES (233,'Wallis and Futuna Islands','WF','WLF','1');
INSERT INTO countries VALUES (234,'Western Sahara','EH','ESH','1');
INSERT INTO countries VALUES (235,'Yemen','YE','YEM','1');
INSERT INTO countries VALUES (236,'Yugoslavia','YU','YUG','1');
INSERT INTO countries VALUES (237,'Zaire','ZR','ZAR','1');
INSERT INTO countries VALUES (238,'Zambia','ZM','ZMB','1');
INSERT INTO countries VALUES (239,'Zimbabwe','ZW','ZWE','1');

INSERT INTO currencies VALUES (1,'US Dollar','USD','$','','.',',','2','1.0000', now());
INSERT INTO currencies VALUES (2,'Euro','EUR','','EUR','.',',','2','1.1036', now());

INSERT INTO languages VALUES (1,'English','en','icon.gif','english',1);

INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'best_sellers.php', 1, 1, 30, 70, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'categories.php', 1, 0, 10, 10, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'currencies.php', 1, 1, 80, 60, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'information.php', 1, 0, 50, 40, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'languages.php', 1, 1, 70, 50, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'manufacturer_info.php', 1, 1, 35, 95, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'manufacturers.php', 1, 0, 30, 20, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'more_information.php', 1, 0, 200, 200, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'order_history.php', 0, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'product_notifications.php', 1, 1, 55, 85, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'reviews.php', 1, 0, 40, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'search.php', 1, 1, 10, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'search_header.php', 0, 0, 0, 0, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'shopping_cart.php', 1, 1, 20, 30, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'banner_box2.php', 1, 1, 15, 1, 15);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'specials.php', 1, 1, 45, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'tell_a_friend.php', 1, 1, 65, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'whats_new.php', 1, 0, 20, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'banner_box.php', 1, 0, 300, 1, 300);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'my_broken_box.php', 1, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('template_default', 'featured.php', 1, 0, 45, 0, 0);

INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'best_sellers.php', 1, 1, 30, 70, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'categories.php', 1, 0, 10, 10, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'currencies.php', 1, 1, 80, 60, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'information.php', 1, 0, 50, 40, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'languages.php', 1, 1, 70, 50, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'manufacturer_info.php', 1, 1, 35, 95, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'manufacturers.php', 1, 0, 30, 20, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'more_information.php', 1, 0, 200, 200, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'order_history.php', 0, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'product_notifications.php', 1, 1, 55, 85, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'reviews.php', 1, 0, 40, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'search.php', 1, 1, 10, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'banner_box2.php', 1, 1, 15, 1, 15);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'search_header.php', 0, 0, 0, 0, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'shopping_cart.php', 1, 1, 20, 30, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'specials.php', 1, 1, 45, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'tell_a_friend.php', 1, 1, 65, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'whats_new.php', 1, 0, 20, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'banner_box.php', 1, 0, 300, 1, 300);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('default_template_settings', 'featured.php', 1, 0, 45, 0, 0);

INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'best_sellers.php', 1, 1, 30, 70, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'categories.php', 1, 0, 10, 10, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'currencies.php', 1, 1, 80, 60, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'information.php', 1, 0, 50, 40, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'languages.php', 1, 1, 70, 50, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'manufacturer_info.php', 1, 1, 35, 95, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'manufacturers.php', 1, 0, 30, 20, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'more_information.php', 1, 0, 100, 200, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'order_history.php', 0, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'product_notifications.php', 1, 1, 55, 85, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'reviews.php', 1, 0, 40, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'search.php', 1, 1, 10, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'banner_box2.php', 1, 1, 15, 1, 15);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'search_header.php', 0, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'shopping_cart.php', 1, 1, 20, 30, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'specials.php', 1, 1, 45, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'tell_a_friend.php', 1, 1, 65, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'whats_new.php', 1, 0, 20, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('zencss', 'my_broken_box.php', 1, 0, 0, 1, 0);

INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'best_sellers.php', 1, 1, 30, 70, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'categories.php', 1, 0, 10, 10, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'currencies.php', 1, 1, 80, 60, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'information.php', 1, 0, 50, 40, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'languages.php', 1, 1, 70, 50, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'manufacturer_info.php', 1, 1, 35, 95, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'manufacturers.php', 1, 0, 30, 20, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'more_information.php', 1, 0, 200, 200, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'order_history.php', 0, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'product_notifications.php', 1, 1, 55, 85, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'reviews.php', 1, 0, 40, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'search.php', 1, 1, 10, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'banner_box2.php', 1, 1, 15, 1, 15);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'search_header.php', 0, 0, 0, 0, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'shopping_cart.php', 1, 1, 20, 30, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'specials.php', 1, 1, 45, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'tell_a_friend.php', 1, 1, 65, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'whats_new.php', 1, 0, 20, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'banner_box.php', 1, 0, 300, 1, 300);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('classic', 'featured.php', 1, 0, 45, 0, 0);

INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'best_sellers.php', 1, 1, 30, 70, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'categories.php', 1, 0, 10, 10, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'currencies.php', 1, 1, 80, 60, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'information.php', 1, 0, 50, 40, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'languages.php', 1, 1, 70, 50, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'manufacturer_info.php', 1, 1, 35, 95, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'manufacturers.php', 1, 0, 30, 20, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'more_information.php', 1, 0, 200, 200, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'order_history.php', 0, 0, 0, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'product_notifications.php', 1, 1, 55, 85, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'reviews.php', 1, 0, 40, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'search.php', 1, 1, 10, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'banner_box2.php', 1, 1, 15, 1, 15);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'search_header.php', 0, 0, 0, 0, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'shopping_cart.php', 1, 1, 20, 30, 1);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'specials.php', 1, 1, 45, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'tell_a_friend.php', 1, 1, 65, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'whats_new.php', 1, 0, 20, 0, 0);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'banner_box.php', 1, 0, 300, 1, 300);
INSERT INTO layout_boxes (layout_template, layout_box_name, layout_box_status, layout_box_location, layout_box_sort_order, layout_box_sort_order_single, layout_box_status_single) VALUES ('blue_strip', 'featured.php', 1, 0, 45, 0, 0);

INSERT INTO orders_status VALUES ( '1', '1', 'Pending');
INSERT INTO orders_status VALUES ( '1', '2', 'Offen');
INSERT INTO orders_status VALUES ( '1', '3', 'Pendiente');
INSERT INTO orders_status VALUES ( '2', '1', 'Processing');
INSERT INTO orders_status VALUES ( '2', '2', 'In Bearbeitung');
INSERT INTO orders_status VALUES ( '2', '3', 'Proceso');
INSERT INTO orders_status VALUES ( '3', '1', 'Delivered');
INSERT INTO orders_status VALUES ( '3', '2', 'Versendet');
INSERT INTO orders_status VALUES ( '3', '3', 'Entregado');
INSERT INTO orders_status VALUES ( '4', '1', 'Update');
INSERT INTO orders_status VALUES ( '4', '2', 'Update');
INSERT INTO orders_status VALUES ( '4', '3', 'Update');

INSERT INTO product_types VALUES (1, 'Product - General', 'products_general', 'Y', '', now(), now());

INSERT INTO products_options_types (products_options_types_id, products_options_types_name) VALUES (0, 'Select');
INSERT INTO products_options_types (products_options_types_id, products_options_types_name) VALUES (1, 'Text');
INSERT INTO products_options_types (products_options_types_id, products_options_types_name) VALUES (2, 'Radio');
INSERT INTO products_options_types (products_options_types_id, products_options_types_name) VALUES (3, 'Checkbox');
INSERT INTO products_options_types (products_options_types_id, products_options_types_name) VALUES (4, 'File');
INSERT INTO products_options_types (products_options_types_id, products_options_types_name) VALUES (5, 'Read Only');

INSERT INTO products_options_values (products_options_values_id, language_id, products_options_values_name) VALUES (0, 1, 'TEXT');

-- USA/Florida
INSERT INTO tax_rates VALUES (1, 1, 1, 1, 7.0, 'FL TAX 7.0%', now(), now());

INSERT INTO geo_zones (geo_zone_id, geo_zone_name,geo_zone_description,date_added) VALUES (1, 'Florida','Florida local sales tax zone',now());
INSERT INTO zones_to_geo_zones (association_id,zone_country_id,zone_id,geo_zone_id,date_added) VALUES (1,223,18,1,now());

-- USA
INSERT INTO zones VALUES (1,223,'AL','Alabama');
INSERT INTO zones VALUES (2,223,'AK','Alaska');
INSERT INTO zones VALUES (3,223,'AS','American Samoa');
INSERT INTO zones VALUES (4,223,'AZ','Arizona');
INSERT INTO zones VALUES (5,223,'AR','Arkansas');
INSERT INTO zones VALUES (6,223,'AF','Armed Forces Africa');
INSERT INTO zones VALUES (7,223,'AA','Armed Forces Americas');
INSERT INTO zones VALUES (8,223,'AC','Armed Forces Canada');
INSERT INTO zones VALUES (9,223,'AE','Armed Forces Europe');
INSERT INTO zones VALUES (10,223,'AM','Armed Forces Middle East');
INSERT INTO zones VALUES (11,223,'AP','Armed Forces Pacific');
INSERT INTO zones VALUES (12,223,'CA','California');
INSERT INTO zones VALUES (13,223,'CO','Colorado');
INSERT INTO zones VALUES (14,223,'CT','Connecticut');
INSERT INTO zones VALUES (15,223,'DE','Delaware');
INSERT INTO zones VALUES (16,223,'DC','District of Columbia');
INSERT INTO zones VALUES (17,223,'FM','Federated States Of Micronesia');
INSERT INTO zones VALUES (18,223,'FL','Florida');
INSERT INTO zones VALUES (19,223,'GA','Georgia');
INSERT INTO zones VALUES (20,223,'GU','Guam');
INSERT INTO zones VALUES (21,223,'HI','Hawaii');
INSERT INTO zones VALUES (22,223,'ID','Idaho');
INSERT INTO zones VALUES (23,223,'IL','Illinois');
INSERT INTO zones VALUES (24,223,'IN','Indiana');
INSERT INTO zones VALUES (25,223,'IA','Iowa');
INSERT INTO zones VALUES (26,223,'KS','Kansas');
INSERT INTO zones VALUES (27,223,'KY','Kentucky');
INSERT INTO zones VALUES (28,223,'LA','Louisiana');
INSERT INTO zones VALUES (29,223,'ME','Maine');
INSERT INTO zones VALUES (30,223,'MH','Marshall Islands');
INSERT INTO zones VALUES (31,223,'MD','Maryland');
INSERT INTO zones VALUES (32,223,'MA','Massachusetts');
INSERT INTO zones VALUES (33,223,'MI','Michigan');
INSERT INTO zones VALUES (34,223,'MN','Minnesota');
INSERT INTO zones VALUES (35,223,'MS','Mississippi');
INSERT INTO zones VALUES (36,223,'MO','Missouri');
INSERT INTO zones VALUES (37,223,'MT','Montana');
INSERT INTO zones VALUES (38,223,'NE','Nebraska');
INSERT INTO zones VALUES (39,223,'NV','Nevada');
INSERT INTO zones VALUES (40,223,'NH','New Hampshire');
INSERT INTO zones VALUES (41,223,'NJ','New Jersey');
INSERT INTO zones VALUES (42,223,'NM','New Mexico');
INSERT INTO zones VALUES (43,223,'NY','New York');
INSERT INTO zones VALUES (44,223,'NC','North Carolina');
INSERT INTO zones VALUES (45,223,'ND','North Dakota');
INSERT INTO zones VALUES (46,223,'MP','Northern Mariana Islands');
INSERT INTO zones VALUES (47,223,'OH','Ohio');
INSERT INTO zones VALUES (48,223,'OK','Oklahoma');
INSERT INTO zones VALUES (49,223,'OR','Oregon');
INSERT INTO zones VALUES (50,223,'PW','Palau');
INSERT INTO zones VALUES (51,223,'PA','Pennsylvania');
INSERT INTO zones VALUES (52,223,'PR','Puerto Rico');
INSERT INTO zones VALUES (53,223,'RI','Rhode Island');
INSERT INTO zones VALUES (54,223,'SC','South Carolina');
INSERT INTO zones VALUES (55,223,'SD','South Dakota');
INSERT INTO zones VALUES (56,223,'TN','Tennessee');
INSERT INTO zones VALUES (57,223,'TX','Texas');
INSERT INTO zones VALUES (58,223,'UT','Utah');
INSERT INTO zones VALUES (59,223,'VT','Vermont');
INSERT INTO zones VALUES (60,223,'VI','Virgin Islands');
INSERT INTO zones VALUES (61,223,'VA','Virginia');
INSERT INTO zones VALUES (62,223,'WA','Washington');
INSERT INTO zones VALUES (63,223,'WV','West Virginia');
INSERT INTO zones VALUES (64,223,'WI','Wisconsin');
INSERT INTO zones VALUES (65,223,'WY','Wyoming');

-- Canada
INSERT INTO zones VALUES (66,38,'AB','Alberta');
INSERT INTO zones VALUES (67,38,'BC','British Columbia');
INSERT INTO zones VALUES (68,38,'MB','Manitoba');
INSERT INTO zones VALUES (69,38,'NF','Newfoundland');
INSERT INTO zones VALUES (70,38,'NB','New Brunswick');
INSERT INTO zones VALUES (71,38,'NS','Nova Scotia');
INSERT INTO zones VALUES (72,38,'NT','Northwest Territories');
INSERT INTO zones VALUES (73,38,'NU','Nunavut');
INSERT INTO zones VALUES (74,38,'ON','Ontario');
INSERT INTO zones VALUES (75,38,'PE','Prince Edward Island');
INSERT INTO zones VALUES (76,38,'QC','Quebec');
INSERT INTO zones VALUES (77,38,'SK','Saskatchewan');
INSERT INTO zones VALUES (78,38,'YT','Yukon Territory');

-- Germany
INSERT INTO zones VALUES (79,81,'NDS','Niedersachsen');
INSERT INTO zones VALUES (80,81,'BAW','Baden-Wrttemberg');
INSERT INTO zones VALUES (81,81,'BAY','Bayern');
INSERT INTO zones VALUES (82,81,'BER','Berlin');
INSERT INTO zones VALUES (83,81,'BRG','Brandenburg');
INSERT INTO zones VALUES (84,81,'BRE','Bremen');
INSERT INTO zones VALUES (85,81,'HAM','Hamburg');
INSERT INTO zones VALUES (86,81,'HES','Hessen');
INSERT INTO zones VALUES (87,81,'MEC','Mecklenburg-Vorpommern');
INSERT INTO zones VALUES (88,81,'NRW','Nordrhein-Westfalen');
INSERT INTO zones VALUES (89,81,'RHE','Rheinland-Pfalz');
INSERT INTO zones VALUES (90,81,'SAR','Saarland');
INSERT INTO zones VALUES (91,81,'SAS','Sachsen');
INSERT INTO zones VALUES (92,81,'SAC','Sachsen-Anhalt');
INSERT INTO zones VALUES (93,81,'SCN','Schleswig-Holstein');
INSERT INTO zones VALUES (94,81,'THE','Thringen');

-- Austria
INSERT INTO zones VALUES (95,14,'WI','Wien');
INSERT INTO zones VALUES (96,14,'NO','Niedersterreich');
INSERT INTO zones VALUES (97,14,'OO','Obersterreich');
INSERT INTO zones VALUES (98,14,'SB','Salzburg');
INSERT INTO zones VALUES (99,14,'KN','K�nten');
INSERT INTO zones VALUES (100,14,'ST','Steiermark');
INSERT INTO zones VALUES (101,14,'TI','Tirol');
INSERT INTO zones VALUES (102,14,'BL','Burgenland');
INSERT INTO zones VALUES (103,14,'VB','Voralberg');

-- Swizterland
INSERT INTO zones VALUES (104,204,'AG','Aargau');
INSERT INTO zones VALUES (105,204,'AI','Appenzell Innerrhoden');
INSERT INTO zones VALUES (106,204,'AR','Appenzell Ausserrhoden');
INSERT INTO zones VALUES (107,204,'BE','Bern');
INSERT INTO zones VALUES (108,204,'BL','Basel-Landschaft');
INSERT INTO zones VALUES (109,204,'BS','Basel-Stadt');
INSERT INTO zones VALUES (110,204,'FR','Freiburg');
INSERT INTO zones VALUES (111,204,'GE','Genf');
INSERT INTO zones VALUES (112,204,'GL','Glarus');
INSERT INTO zones VALUES (113,204,'JU','Graubnden');
INSERT INTO zones VALUES (114,204,'JU','Jura');
INSERT INTO zones VALUES (115,204,'LU','Luzern');
INSERT INTO zones VALUES (116,204,'NE','Neuenburg');
INSERT INTO zones VALUES (117,204,'NW','Nidwalden');
INSERT INTO zones VALUES (118,204,'OW','Obwalden');
INSERT INTO zones VALUES (119,204,'SG','St. Gallen');
INSERT INTO zones VALUES (120,204,'SH','Schaffhausen');
INSERT INTO zones VALUES (121,204,'SO','Solothurn');
INSERT INTO zones VALUES (122,204,'SZ','Schwyz');
INSERT INTO zones VALUES (123,204,'TG','Thurgau');
INSERT INTO zones VALUES (124,204,'TI','Tessin');
INSERT INTO zones VALUES (125,204,'UR','Uri');
INSERT INTO zones VALUES (126,204,'VD','Waadt');
INSERT INTO zones VALUES (127,204,'VS','Wallis');
INSERT INTO zones VALUES (128,204,'ZG','Zug');
INSERT INTO zones VALUES (129,204,'ZH','Zrich');

SELECT SETVAL('zones_zone_id_seq',(select case when max(zone_id)>0 then max(zone_id)+1 else 1 end from zones));

-- Spain
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'A Corua','A Corua');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Alava','Alava');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Albacete','Albacete');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Alicante','Alicante');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Almeria','Almeria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Asturias','Asturias');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Avila','Avila');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Badajoz','Badajoz');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Baleares','Baleares');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Barcelona','Barcelona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Burgos','Burgos');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Caceres','Caceres');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cadiz','Cadiz');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cantabria','Cantabria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Castellon','Castellon');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ceuta','Ceuta');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ciudad Real','Ciudad Real');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cordoba','Cordoba');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Cuenca','Cuenca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Girona','Girona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Granada','Granada');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Guadalajara','Guadalajara');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Guipuzcoa','Guipuzcoa');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Huelva','Huelva');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Huesca','Huesca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Jaen','Jaen');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'La Rioja','La Rioja');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Las Palmas','Las Palmas');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Leon','Leon');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Lleida','Lleida');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Lugo','Lugo');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Madrid','Madrid');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Malaga','Malaga');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Melilla','Melilla');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Murcia','Murcia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Navarra','Navarra');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Ourense','Ourense');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Palencia','Palencia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Pontevedra','Pontevedra');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Salamanca','Salamanca');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Santa Cruz de Tenerife','Santa Cruz de Tenerife');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Segovia','Segovia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Sevilla','Sevilla');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Soria','Soria');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Tarragona','Tarragona');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Teruel','Teruel');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Toledo','Toledo');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Valencia','Valencia');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Valladolid','Valladolid');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Vizcaya','Vizcaya');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Zamora','Zamora');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (195,'Zaragoza','Zaragoza');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('config_id','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_disable','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sitename','yourdomain.com');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('site_desc','A _little_ text to describe your forum');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_name','phpbb2mysql');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_path','/');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_domain','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('cookie_secure','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('session_length','3600');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_html','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_html_tags','b,i,u,pre');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_bbcode','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_smilies','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_sig','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_namechange','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_theme_create','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar_local','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar_remote','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('allow_avatar_upload','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('enable_confirm', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('override_user_style','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('posts_per_page','15');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('topics_per_page','50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('hot_threshold','25');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_poll_options','10');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sig_chars','255');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_inbox_privmsgs','50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_sentbox_privmsgs','25');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('max_savebox_privmsgs','50');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_email_sig','Thanks, The Management');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_email','youraddress@yourdomain.com');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_delivery','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_host','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_username','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smtp_password','');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('sendmail_fix','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('require_activation','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('flood_interval','15');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_email_form','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_filesize','6144');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_max_width','80');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_max_height','80');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_path','images/avatars');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('avatar_gallery_path','images/avatars/gallery');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('smilies_path','images/smiles');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('default_style','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('default_dateformat','D M d, Y g:i a');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('board_timezone','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('prune_enable','1');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('privmsg_disable','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('gzip_compress','0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('coppa_fax', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('coppa_mail', '');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('record_online_users', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('record_online_date', '0');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('server_name', 'www.myserver.tld');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('server_port', '80');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('script_path', '/phpBB2/');
INSERT INTO phpbb_config (config_name, config_value) VALUES ('version', '.0.6');


-- -- Categories
INSERT INTO phpbb_categories (cat_id, cat_title, cat_order) VALUES (1, 'Test category 1', 10);


-- -- Forums
INSERT INTO phpbb_forums (forum_id, forum_name, forum_desc, cat_id, forum_order, forum_posts, forum_topics, forum_last_post_id, auth_view, auth_read, auth_post, auth_reply, auth_edit, auth_delete, auth_announce, auth_sticky, auth_pollcreate, auth_vote, auth_attachments) VALUES (1, 'Test Forum 1', 'This is just a test forum.', 1, 10, 1, 1, 1, 0, 0, 0, 0, 1, 1, 3, 3, 1, 1, 3);


-- -- Users
INSERT INTO phpbb_users (user_id, username, user_level, user_regdate, user_password, user_email, user_icq, user_website, user_occ, user_from, user_interests, user_sig, user_viewemail, user_style, user_aim, user_yim, user_msnm, user_posts, user_attachsig, user_allowsmile, user_allowhtml, user_allowbbcode, user_allow_pm, user_notify_pm, user_allow_viewonline, user_rank, user_avatar, user_lang, user_timezone, user_dateformat, user_actkey, user_newpasswd, user_notify, user_active) VALUES ( -1, 'Anonymous', 0, 0, '', '', '', '', '', '', '', '', 0, NULL, '', '', '', 0, 0, 1, 0, 1, 0, 1, 1, NULL, '', '', 0, '', '', '', 0, 0);

-- -- username: admin    password: admin (change this or remove it once everything is working!)
INSERT INTO phpbb_users (user_id, username, user_level, user_regdate, user_password, user_email, user_icq, user_website, user_occ, user_from, user_interests, user_sig, user_viewemail, user_style, user_aim, user_yim, user_msnm, user_posts, user_attachsig, user_allowsmile, user_allowhtml, user_allowbbcode, user_allow_pm, user_notify_pm, user_popup_pm, user_allow_viewonline, user_rank, user_avatar, user_lang, user_timezone, user_dateformat, user_actkey, user_newpasswd, user_notify, user_active) VALUES ( 2, 'Admin', 1, 0, '21232f297a57a5a743894a0e4a801fc3', 'admin@yourdomain.com', '', '', '', '', '', '', 1, 1, '', '', '', 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, '', 'english', 0, 'd M Y h:i a', '', '', 0, 1);


-- -- Ranks
INSERT INTO phpbb_ranks (rank_id, rank_title, rank_min, rank_special, rank_image) VALUES ( 1, 'Site Admin', -1, 1, NULL);


-- -- Groups
INSERT INTO phpbb_groups (group_id, group_name, group_description, group_single_user) VALUES (1, 'Anonymous', 'Personal User', 1);
INSERT INTO phpbb_groups (group_id, group_name, group_description, group_single_user) VALUES (2, 'Admin', 'Personal User', 1);


-- -- User -> Group
INSERT INTO phpbb_user_group (group_id, user_id, user_pending) VALUES (1, -1, 0);
INSERT INTO phpbb_user_group (group_id, user_id, user_pending) VALUES (2, 2, 0);


-- -- Demo Topic
INSERT INTO phpbb_topics (topic_id, topic_title, topic_poster, topic_time, topic_views, topic_replies, forum_id, topic_status, topic_type, topic_vote, topic_first_post_id, topic_last_post_id) VALUES (1, 'Welcome to phpBB 2', 2, '972086460', 0, 0, 1, 0, 0, 0, 1, 1);


-- -- Demo Post
INSERT INTO phpbb_posts (post_id, topic_id, forum_id, poster_id, post_time, post_username, poster_ip) VALUES (1, 1, 1, 2, 972086460, NULL, '7F000001');
INSERT INTO phpbb_posts_text (post_id, post_subject, post_text) VALUES (1, NULL, 'This is an example post in your phpBB 2 installation. You may delete this post, this topic and even this forum if you like since everything seems to be working!');


-- -- Themes
INSERT INTO phpbb_themes (themes_id, template_name, style_name, head_stylesheet, body_background, body_bgcolor, body_text, body_link, body_vlink, body_alink, body_hlink, tr_color1, tr_color2, tr_color3, tr_class1, tr_class2, tr_class3, th_color1, th_color2, th_color3, th_class1, th_class2, th_class3, td_color1, td_color2, td_color3, td_class1, td_class2, td_class3, fontface1, fontface2, fontface3, fontsize1, fontsize2, fontsize3, fontcolor1, fontcolor2, fontcolor3, span_class1, span_class2, span_class3) VALUES (1, 'subSilver', 'subSilver', 'subSilver.css', '', 'E5E5E5', '000000', '006699', '5493B4', '', 'DD6900', 'EFEFEF', 'DEE3E7', 'D1D7DC', '', '', '', '98AAB1', '006699', 'FFFFFF', 'cellpic1.gif', 'cellpic3.gif', 'cellpic2.jpg', 'FAFAFA', 'FFFFFF', '', 'row1', 'row2', '', 'Verdana, Arial, Helvetica, sans-serif', 'Trebuchet MS', 'Courier, \'Courier New\', sans-serif', 10, 11, 12, '444444', '006600', 'FFA34F', '', '', '');

INSERT INTO phpbb_themes_name (themes_id, tr_color1_name, tr_color2_name, tr_color3_name, tr_class1_name, tr_class2_name, tr_class3_name, th_color1_name, th_color2_name, th_color3_name, th_class1_name, th_class2_name, th_class3_name, td_color1_name, td_color2_name, td_color3_name, td_class1_name, td_class2_name, td_class3_name, fontface1_name, fontface2_name, fontface3_name, fontsize1_name, fontsize2_name, fontsize3_name, fontcolor1_name, fontcolor2_name, fontcolor3_name, span_class1_name, span_class2_name, span_class3_name) VALUES (1, 'The lightest row colour', 'The medium row color', 'The darkest row colour', '', '', '', 'Border round the whole page', 'Outer table border', 'Inner table border', 'Silver gradient picture', 'Blue gradient picture', 'Fade-out gradient on index', 'Background for quote boxes', 'All white areas', '', 'Background for topic posts', '2nd background for topic posts', '', 'Main fonts', 'Additional topic title font', 'Form fonts', 'Smallest font size', 'Medium font size', 'Normal font size (post body etc)', 'Quote & copyright text', 'Code text colour', 'Main table header text colour', '', '', '');


-- -- Smilies
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 1, ':D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 2, ':-D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 3, ':grin:', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 4, ':)', 'icon_smile.gif', 'Smile');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 5, ':-)', 'icon_smile.gif', 'Smile');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 6, ':smile:', 'icon_smile.gif', 'Smile');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 7, ':(', 'icon_sad.gif', 'Sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 8, ':-(', 'icon_sad.gif', 'Sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 9, ':sad:', 'icon_sad.gif', 'Sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 10, ':o', 'icon_surprised.gif', 'Surprised');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 11, ':-o', 'icon_surprised.gif', 'Surprised');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 12, ':eek:', 'icon_surprised.gif', 'Surprised');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 13, ':shock:', 'icon_eek.gif', 'Shocked');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 14, ':?', 'icon_confused.gif', 'Confused');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 15, ':-?', 'icon_confused.gif', 'Confused');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 16, ':???:', 'icon_confused.gif', 'Confused');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 17, '8)', 'icon_cool.gif', 'Cool');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 18, '8-)', 'icon_cool.gif', 'Cool');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 19, ':cool:', 'icon_cool.gif', 'Cool');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 20, ':lol:', 'icon_lol.gif', 'Laughing');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 21, ':x', 'icon_mad.gif', 'Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 22, ':-x', 'icon_mad.gif', 'Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 23, ':mad:', 'icon_mad.gif', 'Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 24, ':P', 'icon_razz.gif', 'Razz');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 25, ':-P', 'icon_razz.gif', 'Razz');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 26, ':razz:', 'icon_razz.gif', 'Razz');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 27, ':oops:', 'icon_redface.gif', 'Embarassed');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 28, ':cry:', 'icon_cry.gif', 'Crying or Very sad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 29, ':evil:', 'icon_evil.gif', 'Evil or Very Mad');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 30, ':twisted:', 'icon_twisted.gif', 'Twisted Evil');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 31, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 32, ':wink:', 'icon_wink.gif', 'Wink');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 33, ';)', 'icon_wink.gif', 'Wink');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 34, ';-)', 'icon_wink.gif', 'Wink');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 35, ':!:', 'icon_exclaim.gif', 'Exclamation');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 36, ':?:', 'icon_question.gif', 'Question');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 37, ':idea:', 'icon_idea.gif', 'Idea');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 38, ':arrow:', 'icon_arrow.gif', 'Arrow');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 39, ':|', 'icon_neutral.gif', 'Neutral');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 40, ':-|', 'icon_neutral.gif', 'Neutral');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 41, ':neutral:', 'icon_neutral.gif', 'Neutral');
INSERT INTO phpbb_smilies (smilies_id, code, smile_url, emoticon) VALUES ( 42, ':mrgreen:', 'icon_mrgreen.gif', 'Mr. Green');


-- -- wordlist
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 1, 'example', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 2, 'post', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 3, 'phpbb', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 4, 'installation', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 5, 'delete', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 6, 'topic', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 7, 'forum', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 8, 'since', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 9, 'everything', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 10, 'seems', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 11, 'working', 0 );
INSERT INTO phpbb_search_wordlist (word_id, word_text, word_common) VALUES ( 12, 'welcome', 0 );


-- -- wordmatch
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 1, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 2, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 3, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 4, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 5, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 6, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 7, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 8, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 9, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 10, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 11, 1, 0 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 12, 1, 1 );
INSERT INTO phpbb_search_wordmatch (word_id, post_id, title_match) VALUES ( 3, 1, 1 );
--

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn
--


--
-- Sequences for table PAYPAL_IPN
--

CREATE SEQUENCE paypal_ipn_paypal_ipn_id_seq;

CREATE TABLE paypal_ipn (
  paypal_ipn_id INT4 DEFAULT nextval('paypal_ipn_paypal_ipn_id_seq'),
  txn_type INT4  NOT NULL DEFAULT '0',
  reason_code INT4 DEFAULT NULL,
  payment_type INT4 NOT NULL DEFAULT '0',
  payment_status INT4 NOT NULL DEFAULT '0',
  pending_reason INT4 DEFAULT NULL,
  invoice varchar(64) DEFAULT NULL,
  mc_currency INT4 NOT NULL DEFAULT '1',
  first_name varchar(32) NOT NULL DEFAULT '',
  last_name varchar(32) NOT NULL DEFAULT '',
  payer_business_name varchar(32) DEFAULT NULL,
  address_name varchar(32) NOT NULL DEFAULT '',
  address_street varchar(64) NOT NULL DEFAULT '',
  address_city varchar(32) NOT NULL DEFAULT '',
  address_state varchar(32) NOT NULL DEFAULT '',
  address_zip varchar(64) NOT NULL DEFAULT '',
  address_country varchar(32) NOT NULL DEFAULT '',
  address_status varchar(64) NOT NULL DEFAULT '',
  address_owner varchar(64) NOT NULL DEFAULT '0',
  payer_email varchar(96) NOT NULL DEFAULT '',
  ebay_address_id varchar(96) DEFAULT NULL,
  payer_id varchar(32) NOT NULL DEFAULT '',
  payer_status varchar(32) NOT NULL DEFAULT '',
  payment_date varchar(32) NOT NULL DEFAULT '',
  business varchar(32) NOT NULL DEFAULT '',
  receiver_email varchar(96) NOT NULL DEFAULT '',
  receiver_id varchar(32) NOT NULL DEFAULT '',
  paypal_address_id varchar(64) NOT NULL DEFAULT '',
  txn_id varchar(17) NOT NULL DEFAULT '',
  notify_version varchar(17) NOT NULL DEFAULT '',
  verify_sign varchar(64) NOT NULL DEFAULT '',
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  PRIMARY KEY (paypal_ipn_id,txn_id),
  CHECK (txn_type>=0)

);

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_address_status
--



--
-- Sequences for table PAYPAL_IPN_ADDRESS_STATUS
--

CREATE SEQUENCE paypal_ipn_address_status_ad;

CREATE TABLE paypal_ipn_address_status (
  address_status_id INT4 DEFAULT nextval('paypal_ipn_address_status_ad'),
  language_id INT4 NOT NULL DEFAULT '1',
  address_status_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (address_status_id,language_id)

);

--
-- Dumping data for table paypal_ipn_address_status
--

INSERT INTO paypal_ipn_address_status VALUES (1, 1, 'confirmed');
INSERT INTO paypal_ipn_address_status VALUES (1, 2, 'confirmed');
INSERT INTO paypal_ipn_address_status VALUES (1, 3, 'confirmed');
INSERT INTO paypal_ipn_address_status VALUES (2, 1, 'unconfirmed');
INSERT INTO paypal_ipn_address_status VALUES (2, 2, 'unconfirmed');
INSERT INTO paypal_ipn_address_status VALUES (2, 3, 'unconfirmed');

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_mc_currency
--



--
-- Sequences for table PAYPAL_IPN_MC_CURRENCY
--

CREATE SEQUENCE paypal_ipn_mc_currency_mc_cu;

CREATE TABLE paypal_ipn_mc_currency (
  mc_currency_id INT4 DEFAULT nextval('paypal_ipn_mc_currency_mc_cu'),
  language_id INT4 NOT NULL DEFAULT '1',
  mc_currency_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (mc_currency_id,language_id)

);

--
-- Dumping data for table paypal_ipn_mc_currency
--

INSERT INTO paypal_ipn_mc_currency VALUES (1, 1, 'USD');
INSERT INTO paypal_ipn_mc_currency VALUES (1, 2, 'USD');
INSERT INTO paypal_ipn_mc_currency VALUES (1, 3, 'USD');
INSERT INTO paypal_ipn_mc_currency VALUES (2, 1, 'GBP');
INSERT INTO paypal_ipn_mc_currency VALUES (2, 2, 'GBP');
INSERT INTO paypal_ipn_mc_currency VALUES (2, 3, 'GBP');
INSERT INTO paypal_ipn_mc_currency VALUES (3, 1, 'EUR');
INSERT INTO paypal_ipn_mc_currency VALUES (3, 2, 'EUR');
INSERT INTO paypal_ipn_mc_currency VALUES (3, 3, 'EUR');
INSERT INTO paypal_ipn_mc_currency VALUES (4, 1, 'CAD');
INSERT INTO paypal_ipn_mc_currency VALUES (4, 2, 'CAD');
INSERT INTO paypal_ipn_mc_currency VALUES (4, 3, 'CAD');
INSERT INTO paypal_ipn_mc_currency VALUES (5, 1, 'JPY');
INSERT INTO paypal_ipn_mc_currency VALUES (5, 2, 'JPY');
INSERT INTO paypal_ipn_mc_currency VALUES (5, 3, 'JPY');

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_orders
--



--
-- Sequences for table PAYPAL_IPN_ORDERS
--

CREATE SEQUENCE paypal_ipn_orders_paypal_ipn;

CREATE TABLE paypal_ipn_orders (
  paypal_ipn_orders_id INT4 DEFAULT nextval('paypal_ipn_orders_paypal_ipn'),
  paypal_ipn_id INT4 NOT NULL DEFAULT '0',
  num_cart_items INT2 NOT NULL DEFAULT '0',
  mc_gross decimal(7,2) NOT NULL DEFAULT '0.00',
  mc_fee decimal(7,2) NOT NULL DEFAULT '0.00',
  payment_gross decimal(7,2) NOT NULL DEFAULT '0.00',
  payment_fee decimal(7,2) NOT NULL DEFAULT '0.00',
  settle_amount decimal(7,2) NOT NULL DEFAULT '0.00',
  settle_currency decimal(7,2) NOT NULL DEFAULT '0.00',
  exchange_rate decimal(7,2) DEFAULT '0.00',
  PRIMARY KEY (paypal_ipn_orders_id,paypal_ipn_id)

);

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_orders_memo
--



--
-- Sequences for table PAYPAL_IPN_ORDERS_MEMO
--

CREATE SEQUENCE paypal_ipn_orders_memo_order;

CREATE TABLE paypal_ipn_orders_memo (
  orders_memo_id INT4 DEFAULT nextval('paypal_ipn_orders_memo_order'),
  paypal_ipn_id INT4 NOT NULL DEFAULT '1',
  memo text,
  PRIMARY KEY (orders_memo_id,paypal_ipn_id)

);

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_payment_status
--



--
-- Sequences for table PAYPAL_IPN_PAYMENT_STATUS
--

CREATE SEQUENCE paypal_ipn_payment_status_pa;

CREATE TABLE paypal_ipn_payment_status (
  payment_status_id INT4 DEFAULT nextval('paypal_ipn_payment_status_pa'),
  language_id INT4 NOT NULL DEFAULT '1',
  payment_status_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (payment_status_id,language_id)

);

--
-- Dumping data for table paypal_ipn_payment_status
--

INSERT INTO paypal_ipn_payment_status VALUES (1, 1, 'Completed');
INSERT INTO paypal_ipn_payment_status VALUES (1, 2, 'Completed');
INSERT INTO paypal_ipn_payment_status VALUES (1, 3, 'Completed');
INSERT INTO paypal_ipn_payment_status VALUES (2, 1, 'Pending');
INSERT INTO paypal_ipn_payment_status VALUES (2, 2, 'Pending');
INSERT INTO paypal_ipn_payment_status VALUES (2, 3, 'Pending');
INSERT INTO paypal_ipn_payment_status VALUES (3, 1, 'Failed');
INSERT INTO paypal_ipn_payment_status VALUES (3, 2, 'Failed');
INSERT INTO paypal_ipn_payment_status VALUES (3, 3, 'Failed');
INSERT INTO paypal_ipn_payment_status VALUES (4, 1, 'Denied');
INSERT INTO paypal_ipn_payment_status VALUES (4, 2, 'Denied');
INSERT INTO paypal_ipn_payment_status VALUES (4, 3, 'Denied');
INSERT INTO paypal_ipn_payment_status VALUES (5, 1, 'Refunded');
INSERT INTO paypal_ipn_payment_status VALUES (5, 2, 'Refunded');
INSERT INTO paypal_ipn_payment_status VALUES (5, 3, 'Refunded');
INSERT INTO paypal_ipn_payment_status VALUES (6, 1, 'Cancelled');
INSERT INTO paypal_ipn_payment_status VALUES (6, 2, 'Cancelled');
INSERT INTO paypal_ipn_payment_status VALUES (6, 3, 'Cancelled');

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_payment_type
--



--
-- Sequences for table PAYPAL_IPN_PAYMENT_TYPE
--

CREATE SEQUENCE paypal_ipn_payment_type_paym;

CREATE TABLE paypal_ipn_payment_type (
  payment_type_id INT4 DEFAULT nextval('paypal_ipn_payment_type_paym'),
  language_id INT4 NOT NULL DEFAULT '1',
  payment_type_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (payment_type_id,language_id)

);

--
-- Dumping data for table paypal_ipn_payment_type
--

INSERT INTO paypal_ipn_payment_type VALUES (1, 1, 'instant');
INSERT INTO paypal_ipn_payment_type VALUES (1, 2, 'instant');
INSERT INTO paypal_ipn_payment_type VALUES (1, 3, 'instant');
INSERT INTO paypal_ipn_payment_type VALUES (2, 1, 'echeck');
INSERT INTO paypal_ipn_payment_type VALUES (2, 2, 'echeck');
INSERT INTO paypal_ipn_payment_type VALUES (2, 3, 'echeck');

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_pending_reason
--



--
-- Sequences for table PAYPAL_IPN_PENDING_REASON
--

CREATE SEQUENCE paypal_ipn_pending_reason_pe;

CREATE TABLE paypal_ipn_pending_reason (
  pending_reason_id INT4 DEFAULT nextval('paypal_ipn_pending_reason_pe'),
  language_id INT4 NOT NULL DEFAULT '1',
  pending_reason_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (pending_reason_id,language_id)

);

--
-- Dumping data for table paypal_ipn_pending_reason
--

INSERT INTO paypal_ipn_pending_reason VALUES (1, 1, 'echeck');
INSERT INTO paypal_ipn_pending_reason VALUES (1, 2, 'echeck');
INSERT INTO paypal_ipn_pending_reason VALUES (1, 3, 'echeck');
INSERT INTO paypal_ipn_pending_reason VALUES (2, 1, 'multi-currency');
INSERT INTO paypal_ipn_pending_reason VALUES (2, 2, 'multi-currency');
INSERT INTO paypal_ipn_pending_reason VALUES (2, 3, 'multi-currency');
INSERT INTO paypal_ipn_pending_reason VALUES (3, 1, 'intl');
INSERT INTO paypal_ipn_pending_reason VALUES (3, 2, 'intl');
INSERT INTO paypal_ipn_pending_reason VALUES (3, 3, 'intl');
INSERT INTO paypal_ipn_pending_reason VALUES (4, 1, 'Verify');
INSERT INTO paypal_ipn_pending_reason VALUES (4, 2, 'Verify');
INSERT INTO paypal_ipn_pending_reason VALUES (4, 3, 'Verify');
INSERT INTO paypal_ipn_pending_reason VALUES (5, 1, 'address');
INSERT INTO paypal_ipn_pending_reason VALUES (5, 2, 'address');
INSERT INTO paypal_ipn_pending_reason VALUES (5, 3, 'address');
INSERT INTO paypal_ipn_pending_reason VALUES (6, 1, 'upgrade');
INSERT INTO paypal_ipn_pending_reason VALUES (6, 2, 'upgrade');
INSERT INTO paypal_ipn_pending_reason VALUES (6, 3, 'upgrade');
INSERT INTO paypal_ipn_pending_reason VALUES (7, 1, 'unilateral');
INSERT INTO paypal_ipn_pending_reason VALUES (7, 2, 'unilateral');
INSERT INTO paypal_ipn_pending_reason VALUES (7, 3, 'unilateral');
INSERT INTO paypal_ipn_pending_reason VALUES (8, 1, 'other');
INSERT INTO paypal_ipn_pending_reason VALUES (8, 2, 'other');
INSERT INTO paypal_ipn_pending_reason VALUES (8, 3, 'other');

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_reason_code
--



--
-- Sequences for table PAYPAL_IPN_REASON_CODE
--

CREATE SEQUENCE paypal_ipn_reason_code_reaso;

CREATE TABLE paypal_ipn_reason_code (
  reason_code_id INT4 DEFAULT nextval('paypal_ipn_reason_code_reaso'),
  language_id INT4 NOT NULL DEFAULT '1',
  reason_code_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (reason_code_id,language_id)

);

--
-- Dumping data for table paypal_ipn_reason_code
--

INSERT INTO paypal_ipn_reason_code VALUES (1, 1, 'chargeback');
INSERT INTO paypal_ipn_reason_code VALUES (1, 2, 'chargeback');
INSERT INTO paypal_ipn_reason_code VALUES (1, 3, 'chargeback');
INSERT INTO paypal_ipn_reason_code VALUES (2, 1, 'guarantee');
INSERT INTO paypal_ipn_reason_code VALUES (2, 2, 'guarantee');
INSERT INTO paypal_ipn_reason_code VALUES (2, 3, 'guarantee');
INSERT INTO paypal_ipn_reason_code VALUES (3, 1, 'buyer_complaint');
INSERT INTO paypal_ipn_reason_code VALUES (3, 2, 'buyer_complaint');
INSERT INTO paypal_ipn_reason_code VALUES (3, 3, 'buyer_complaint');
INSERT INTO paypal_ipn_reason_code VALUES (4, 1, 'other');
INSERT INTO paypal_ipn_reason_code VALUES (4, 2, 'other');
INSERT INTO paypal_ipn_reason_code VALUES (4, 3, 'other');

-- --------------------------------------------------------

--
-- Table structure for table paypal_ipn_txn_type
--



--
-- Sequences for table PAYPAL_IPN_TXN_TYPE
--

CREATE SEQUENCE paypal_ipn_txn_type_txn_type;

CREATE TABLE paypal_ipn_txn_type (
  txn_type_id INT4 DEFAULT nextval('paypal_ipn_txn_type_txn_type'),
  language_id INT4 NOT NULL DEFAULT '1',
  txn_type_name varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (txn_type_id,language_id)

);

--
-- Dumping data for table paypal_ipn_txn_type
--

INSERT INTO paypal_ipn_txn_type VALUES (1, 1, 'web_accept');
INSERT INTO paypal_ipn_txn_type VALUES (1, 2, 'web_accept');
INSERT INTO paypal_ipn_txn_type VALUES (1, 3, 'web_accept');
INSERT INTO paypal_ipn_txn_type VALUES (2, 1, 'cart');
INSERT INTO paypal_ipn_txn_type VALUES (2, 2, 'cart');
INSERT INTO paypal_ipn_txn_type VALUES (2, 3, 'cart');
INSERT INTO paypal_ipn_txn_type VALUES (3, 1, 'send_money');
INSERT INTO paypal_ipn_txn_type VALUES (3, 2, 'send_money');
INSERT INTO paypal_ipn_txn_type VALUES (3, 3, 'send_money');
INSERT INTO paypal_ipn_txn_type VALUES (4, 1, 'reversal');
INSERT INTO paypal_ipn_txn_type VALUES (4, 2, 'reversal');
INSERT INTO paypal_ipn_txn_type VALUES (4, 3, 'reversal');

--
-- Table structure for table configuration
--



--
-- Sequences for table PRODUCT_TYPE_LAYOUT
--

CREATE SEQUENCE product_type_layout_configur;

CREATE TABLE product_type_layout (
  configuration_id INT4 DEFAULT nextval('product_type_layout_configur'),
  configuration_title TEXT DEFAULT '' NOT NULL,
  configuration_key varchar(64) NOT NULL DEFAULT '',
  configuration_value TEXT DEFAULT '' NOT NULL,
  configuration_description TEXT DEFAULT '' NOT NULL,
  product_type_id INT4 NOT NULL DEFAULT '0',
  sort_order INT4 DEFAULT NULL,
  last_modified TIMESTAMP DEFAULT NULL,
  date_added TIMESTAMP NOT NULL DEFAULT '0001-01-01 00:00:00',
  use_function text DEFAULT NULL,
  set_function text DEFAULT NULL,
  PRIMARY KEY (configuration_id)

);

INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Model Number', 'SHOW_PRODUCT_INFO_MODEL', '1', 'Display Model Number on Product Info 0= off 1= on', '1', '1', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Weight', 'SHOW_PRODUCT_INFO_WEIGHT', '1', 'Display Weight on Product Info 0= off 1= on', '1', '2', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Attribute Weight', 'SHOW_PRODUCT_INFO_WEIGHT_ATTRIBUTES', '1', 'Display Attribute Weight on Product Info 0= off 1= on', '1', '3', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Manufacture', 'SHOW_PRODUCT_INFO_MANUFACTURER', '1', 'Display Manufacture Name on Product Info 0= off 1= on', '1', '4', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Quantity in Shopping Cart', 'SHOW_PRODUCT_INFO_IN_CART_QTY', '1', 'Display Quantity in Current Shopping Cart on Product Info 0= off 1= on', '1', '5', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Quantity in Stock', 'SHOW_PRODUCT_INFO_QUANTITY', '1', 'Display Quantity in Stock on Product Info 0= off 1= on', '1', '6', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Product Reviews Count', 'SHOW_PRODUCT_INFO_REVIEWS_COUNT', '1', 'Display Product Reviews Count on Product Info 0= off 1= on', '1', '7', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Product Reviews Button', 'SHOW_PRODUCT_INFO_REVIEWS', '1', 'Display Product Reviews Button on Product Info 0= off 1= on', '1', '8', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Date Available', 'SHOW_PRODUCT_INFO_DATE_AVAILABLE', '1', 'Display Date Available on Product Info 0= off 1= on', '1', '9', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Date Added', 'SHOW_PRODUCT_INFO_DATE_ADDED', '1', 'Display Date Added on Product Info 0= off 1= on', '1', '10', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Product URL', 'SHOW_PRODUCT_INFO_URL', '1', 'Display URL on Product Info 0= off 1= on', '1', '11', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Previous Next - Navigation Bar Position', 'PRODUCT_INFO_PREVIOUS_NEXT', '1', 'Location of Previous/Next Navigation Bar<br />0= off<br />1= Top of Page<br />2= Bottom of Page<br />3= Both Top and Bottom of Page', 1, 12, now(), now(), NULL, 'zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'Off\'), array(\'id\'=>\'1\', \'text\'=>\'Top of Page\'), array(\'id\'=>\'2\', \'text\'=>\'Bottom of Page\'), array(\'id\'=>\'3\', \'text\'=>\'Both Top & Bottom of Page\')),');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Previous Next - Sort Order', 'PRODUCT_INFO_PREVIOUS_NEXT_SORT', '1', 'Products Display Order by<br />0= Product ID<br />1= Product Name<br />2= Model<br />3= Price, Product Name<br />4= Price, Model<br />5= Product Name, Model', 1, 13, now(), now(), NULL, 'zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'Product ID\'), array(\'id\'=>\'1\', \'text\'=>\'Name\'), array(\'id\'=>\'2\', \'text\'=>\'Product Model\'), array(\'id\'=>\'3\', \'text\'=>\'Product Price - Name\'), array(\'id\'=>\'4\', \'text\'=>\'Product Price - Model\'), array(\'id\'=>\'5\', \'text\'=>\'Product Name - Model\')),');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, last_modified, date_added, use_function, set_function) VALUES ('Previous Next - Navigation Includes Category', 'PRODUCT_INFO_CATEGORIES', '1', 'Product\'s Category Image and Name Alignment Above Previous/Next Navigation Bar<br />0= off<br />1= Align Left<br />2= Align Center<br />3= Align Right', 1, 14, now(), now(), NULL, 'zen_cfg_select_drop_down(array(array(\'id\'=>\'0\', \'text\'=>\'Off\'), array(\'id\'=>\'1\', \'text\'=>\'Align Left\'), array(\'id\'=>\'2\', \'text\'=>\'Align Center\'), array(\'id\'=>\'3\', \'text\'=>\'Align Right\')),');
INSERT INTO product_type_layout (configuration_title, configuration_key, configuration_value, configuration_description, product_type_id, sort_order, set_function, date_added) VALUES ('Show Product Tell a Friend button', 'SHOW_PRODUCT_INFO_TELL_A_FRIEND', '1', 'Display the Tell a Friend button on Product Info<br /><br />Note: Turning this setting off does not affect the Tell a Friend box in the columns and turning off the Tell a Friend box does not affect the button<br />0= off 1= on', '1', '15', 'zen_cfg_select_drop_down(array(array(\'id\'=>\'1\', \'text\'=>\'True\'), array(\'id\'=>\'0\', \'text\'=>\'False\')), ', now());


--
-- Indexes for table PHPBB_FORUMS
--

CREATE INDEX forums_order_phpbb_forums_index ON phpbb_forums (forum_order);
CREATE INDEX cat_id_phpbb_forums_index ON phpbb_forums (cat_id);
CREATE INDEX forum_last_post_id_phpbb_forums_index ON phpbb_forums (forum_last_post_id);

--
-- Indexes for table MANUFACTURERS
--

CREATE INDEX IDX_MANUFACTURERS_NAME_manufacturers_index ON manufacturers (manufacturers_name);

--
-- Indexes for table PHPBB_PRIVMSGS
--

CREATE INDEX privmsgs_from_userid_phpbb_privmsgs_index ON phpbb_privmsgs (privmsgs_from_userid);
CREATE INDEX privmsgs_to_userid_phpbb_privmsgs_index ON phpbb_privmsgs (privmsgs_to_userid);

--
-- Indexes for table PHPBB_VOTE_RESULTS
--

CREATE INDEX vote_option_id_phpbb_vote_results_index ON phpbb_vote_results (vote_option_id);
CREATE INDEX vote_id_phpbb_vote_results_index ON phpbb_vote_results (vote_id);

--
-- Indexes for table CATEGORIES_DESCRIPTION
--

CREATE INDEX idx_categories_name_categories_description_index ON categories_description (categories_name);

--
-- Indexes for table COUPON_GV_CUSTOMER
--

CREATE INDEX customer_id_coupon_gv_customer_index ON coupon_gv_customer (customer_id);

--
-- Indexes for table COUPONS_DESCRIPTION
--

CREATE INDEX coupon_id_coupons_description_index ON coupons_description (coupon_id);

--
-- Indexes for table PHPBB_FORUM_PRUNE
--

CREATE INDEX forum_id_phpbb_forum_prune_index ON phpbb_forum_prune (forum_id);

--
-- Indexes for table COUNTRIES
--

CREATE INDEX IDX_COUNTRIES_NAME_countries_index ON countries (countries_name);

--
-- Indexes for table PRODUCTS
--

CREATE INDEX idx_products_date_added_products_index ON products (products_date_added);

--
-- Indexes for table ORDERS_TOTAL
--

CREATE INDEX idx_orders_total_orders_id_orders_total_index ON orders_total (orders_id);

--
-- Indexes for table PHPBB_SEARCH_RESULTS
--

CREATE INDEX session_id_phpbb_search_results_index ON phpbb_search_results (session_id);

--
-- Indexes for table PHPBB_USER_GROUP
--

CREATE INDEX group_id_phpbb_user_group_index ON phpbb_user_group (group_id);
CREATE INDEX user_id_phpbb_user_group_index ON phpbb_user_group (user_id);

--
-- Indexes for table ORDERS_STATUS
--

CREATE INDEX idx_orders_status_name_orders_status_index ON orders_status (orders_status_name);

--
-- Indexes for table ADDRESS_BOOK
--

CREATE INDEX idx_address_book_customers_id_address_book_index ON address_book (customers_id);

--
-- Indexes for table PHPBB_TOPICS_WATCH
--

CREATE INDEX topic_id_phpbb_topics_watch_index ON phpbb_topics_watch (topic_id);
CREATE INDEX user_id_phpbb_topics_watch_index ON phpbb_topics_watch (user_id);
CREATE INDEX notify_status_phpbb_topics_watch_index ON phpbb_topics_watch (notify_status);

--
-- Indexes for table PHPBB_VOTE_DESC
--

CREATE INDEX topic_id_phpbb_vote_desc_index ON phpbb_vote_desc (topic_id);

--
-- Indexes for table COUPON_GV_QUEUE
--

CREATE UNIQUE INDEX nextval_coupon_gv_queue_index ON coupon_gv_queue (unique_id);
CREATE INDEX uid_coupon_gv_queue_index ON coupon_gv_queue (unique_id,customer_id,order_id);

--
-- Indexes for table PHPBB_GROUPS
--

CREATE INDEX group_single_user_phpbb_groups_index ON phpbb_groups (group_single_user);

--
-- Indexes for table PHPBB_SEARCH_WORDLIST
--

CREATE INDEX word_id_phpbb_search_wordlist_index ON phpbb_search_wordlist (word_id);

--
-- Indexes for table PHPBB_BANLIST
--

CREATE INDEX ban_ip_user_id_phpbb_banlist_index ON phpbb_banlist (ban_ip,ban_userid);

--
-- Indexes for table PRODUCTS_DESCRIPTION
--

CREATE INDEX products_name_products_description_index ON products_description (products_name);

--
-- Indexes for table LANGUAGES
--

CREATE INDEX IDX_LANGUAGES_NAME_languages_index ON languages (name);

--
-- Indexes for table PHPBB_POSTS
--

CREATE INDEX forum_id_phpbb_posts_index ON phpbb_posts (forum_id);
CREATE INDEX topic_id_phpbb_posts_index ON phpbb_posts (topic_id);
CREATE INDEX poster_id_phpbb_posts_index ON phpbb_posts (poster_id);
CREATE INDEX post_time_phpbb_posts_index ON phpbb_posts (post_time);

--
-- Indexes for table PHPBB_VOTE_VOTERS
--

CREATE INDEX vote_id_phpbb_vote_voters_index ON phpbb_vote_voters (vote_id);
CREATE INDEX vote_user_id_phpbb_vote_voters_index ON phpbb_vote_voters (vote_user_id);
CREATE INDEX vote_user_ip_phpbb_vote_voters_index ON phpbb_vote_voters (vote_user_ip);

--
-- Indexes for table PHPBB_SESSIONS
--

CREATE INDEX session_user_id_phpbb_sessions_index ON phpbb_sessions (session_user_id);
CREATE INDEX session_id_ip_user_id_phpbb_sessions_index ON phpbb_sessions (session_id,session_ip,session_user_id);

--
-- Indexes for table PAYPAL_IPN
--

CREATE INDEX idx_paypal_ipn_paypal_ipn_id_paypal_ipn_index ON paypal_ipn (paypal_ipn_id);

--
-- Indexes for table PHPBB_SEARCH_WORDMATCH
--

CREATE INDEX post_id_phpbb_search_wordmatch_index ON phpbb_search_wordmatch (post_id);
CREATE INDEX word_id_phpbb_search_wordmatch_index ON phpbb_search_wordmatch (word_id);

--
-- Indexes for table CATEGORIES
--

CREATE INDEX idx_categories_parent_id_categories_index ON categories (parent_id);
CREATE INDEX idx_sort_order_categories_index ON categories (sort_order);

--
-- Indexes for table LAYOUT_BOXES
--

CREATE INDEX layout_box_status_layout_boxes_index ON layout_boxes (layout_box_status);

--
-- Indexes for table PHPBB_USERS
--

CREATE INDEX user_session_time_phpbb_users_index ON phpbb_users (user_session_time);

--
-- Indexes for table PHPBB_CATEGORIES
--

CREATE INDEX cat_order_phpbb_categories_index ON phpbb_categories (cat_order);

--
-- Indexes for table WHOS_ONLINE
--

CREATE INDEX ip_address_whos_online_index ON whos_online (ip_address);
CREATE INDEX session_id_whos_online_index ON whos_online (session_id);
CREATE INDEX customer_id_whos_online_index ON whos_online (customer_id);
CREATE INDEX time_entry_whos_online_index ON whos_online (time_entry);
CREATE INDEX time_last_click_whos_online_index ON whos_online (time_last_click);
CREATE INDEX last_page_url_whos_online_index ON whos_online (last_page_url);

--
-- Indexes for table PHPBB_AUTH_ACCESS
--

CREATE INDEX group_id_phpbb_auth_access_index ON phpbb_auth_access (group_id);
CREATE INDEX forum_id_phpbb_auth_access_index ON phpbb_auth_access (forum_id);

--
-- Indexes for table COUPON_EMAIL_TRACK
--

CREATE UNIQUE INDEX nextval_coupon_email_track_index ON coupon_email_track (unique_id);

--
-- Indexes for table COUPON_REDEEM_TRACK
--

CREATE UNIQUE INDEX nextval_coupon_redeem_track_index ON coupon_redeem_track (unique_id);

--
-- Indexes for table PHPBB_TOPICS
--

CREATE INDEX forum_id_phpbb_topics_index ON phpbb_topics (forum_id);
CREATE INDEX topic_moved_id_phpbb_topics_index ON phpbb_topics (topic_moved_id);
CREATE INDEX topic_status_phpbb_topics_index ON phpbb_topics (topic_status);
CREATE INDEX topic_type_phpbb_topics_index ON phpbb_topics (topic_type);

--
-- Sequences for table MANUFACTURERS
--

SELECT SETVAL('manufacturers_manufacturers_',(select case when max(manufacturers_id)>0 then max(manufacturers_id)+1 else 1 end from manufacturers));

--
-- Sequences for table PHPBB_PRIVMSGS
--

SELECT SETVAL('phpbb_privmsgs_privmsgs_id_s',(select case when max(privmsgs_id)>0 then max(privmsgs_id)+1 else 1 end from phpbb_privmsgs));

--
-- Sequences for table PHPBB_DISALLOW
--

SELECT SETVAL('phpbb_disallow_disallow_id_s',(select case when max(disallow_id)>0 then max(disallow_id)+1 else 1 end from phpbb_disallow));

--
-- Sequences for table PAYPAL_IPN_TXN_TYPE
--

SELECT SETVAL('paypal_ipn_txn_type_txn_type',(select case when max(txn_type_id)>0 then max(txn_type_id)+1 else 1 end from paypal_ipn_txn_type));

--
-- Sequences for table PAYPAL_IPN_REASON_CODE
--

SELECT SETVAL('paypal_ipn_reason_code_reaso',(select case when max(reason_code_id)>0 then max(reason_code_id)+1 else 1 end from paypal_ipn_reason_code));

--
-- Sequences for table PHPBB_THEMES
--

SELECT SETVAL('phpbb_themes_themes_id_seq',(select case when max(themes_id)>0 then max(themes_id)+1 else 1 end from phpbb_themes));

--
-- Sequences for table PRODUCT_TYPE_LAYOUT
--

SELECT SETVAL('product_type_layout_configur',(select case when max(configuration_id)>0 then max(configuration_id)+1 else 1 end from product_type_layout));

--
-- Sequences for table PRODUCTS_ATTRIBUTES
--

SELECT SETVAL('products_attributes_products',(select case when max(products_attributes_id)>0 then max(products_attributes_id)+1 else 1 end from products_attributes));

--
-- Sequences for table PHPBB_SMILIES
--

SELECT SETVAL('phpbb_smilies_smilies_id_seq',(select case when max(smilies_id)>0 then max(smilies_id)+1 else 1 end from phpbb_smilies));

--
-- Sequences for table PHPBB_FORUM_PRUNE
--

SELECT SETVAL('phpbb_forum_prune_prune_id_s',(select case when max(prune_id)>0 then max(prune_id)+1 else 1 end from phpbb_forum_prune));

--
-- Sequences for table CONFIGURATION
--

SELECT SETVAL('configuration_configuration_',(select case when max(configuration_id)>0 then max(configuration_id)+1 else 1 end from configuration));

--
-- Sequences for table PRODUCTS
--

SELECT SETVAL('products_products_id_seq',(select case when max(products_id)>0 then max(products_id)+1 else 1 end from products));

--
-- Sequences for table ORDERS_TOTAL
--

SELECT SETVAL('orders_total_orders_total_id',(select case when max(orders_total_id)>0 then max(orders_total_id)+1 else 1 end from orders_total));

--
-- Sequences for table REVIEWS
--

SELECT SETVAL('reviews_reviews_id_seq',(select case when max(reviews_id)>0 then max(reviews_id)+1 else 1 end from reviews));

--
-- Sequences for table GEO_ZONES
--

SELECT SETVAL('geo_zones_geo_zone_id_seq',(select case when max(geo_zone_id)>0 then max(geo_zone_id)+1 else 1 end from geo_zones));

--
-- Sequences for table BANNERS_HISTORY
--

SELECT SETVAL('banners_history_banners_hist',(select case when max(banners_history_id)>0 then max(banners_history_id)+1 else 1 end from banners_history));

--
-- Sequences for table ADDRESS_BOOK
--

SELECT SETVAL('address_book_address_book_id',(select case when max(address_book_id)>0 then max(address_book_id)+1 else 1 end from address_book));

--
-- Sequences for table CUSTOMERS_BASKET_ATTRIBUTES
--

SELECT SETVAL('customers_basket_attributes_',(select case when max(customers_basket_attributes_id)>0 then max(customers_basket_attributes_id)+1 else 1 end from customers_basket_attributes));

--
-- Sequences for table ADDRESS_FORMAT
--

SELECT SETVAL('address_format_address_forma',(select case when max(address_format_id)>0 then max(address_format_id)+1 else 1 end from address_format));

--
-- Sequences for table COUPON_RESTRICT
--

SELECT SETVAL('coupon_restrict_restrict_id_',(select case when max(restrict_id)>0 then max(restrict_id)+1 else 1 end from coupon_restrict));

--
-- Sequences for table CUSTOMERS
--

SELECT SETVAL('customers_customers_id_seq',(select case when max(customers_id)>0 then max(customers_id)+1 else 1 end from customers));

--
-- Sequences for table PHPBB_VOTE_DESC
--

SELECT SETVAL('phpbb_vote_desc_vote_id_seq',(select case when max(vote_id)>0 then max(vote_id)+1 else 1 end from phpbb_vote_desc));

--
-- Sequences for table ORDERS
--

SELECT SETVAL('orders_orders_id_seq',(select case when max(orders_id)>0 then max(orders_id)+1 else 1 end from orders));

--
-- Sequences for table PAYPAL_IPN_PENDING_REASON
--

SELECT SETVAL('paypal_ipn_pending_reason_pe',(select case when max(pending_reason_id)>0 then max(pending_reason_id)+1 else 1 end from paypal_ipn_pending_reason));

--
-- Sequences for table ORDERS_PRODUCTS_ATTRIBUTES
--

SELECT SETVAL('orders_products_attributes_o',(select case when max(orders_products_attributes_id)>0 then max(orders_products_attributes_id)+1 else 1 end from orders_products_attributes));

--
-- Sequences for table PHPBB_SEARCH_WORDLIST
--

SELECT SETVAL('phpbb_search_wordlist_word_i',(select case when max(word_id)>0 then max(word_id)+1 else 1 end from phpbb_search_wordlist));

--
-- Sequences for table FEATURED
--

SELECT SETVAL('featured_featured_id_seq',(select case when max(featured_id)>0 then max(featured_id)+1 else 1 end from featured));

--
-- Sequences for table PHPBB_BANLIST
--

SELECT SETVAL('phpbb_banlist_ban_id_seq',(select case when max(ban_id)>0 then max(ban_id)+1 else 1 end from phpbb_banlist));

--
-- Sequences for table PAYPAL_IPN
--

SELECT SETVAL('paypal_ipn_paypal_ipn_id_seq',(select case when max(paypal_ipn_id)>0 then max(paypal_ipn_id)+1 else 1 end from paypal_ipn));

--
-- Sequences for table PHPBB_RANKS
--

SELECT SETVAL('phpbb_ranks_rank_id_seq',(select case when max(rank_id)>0 then max(rank_id)+1 else 1 end from phpbb_ranks));

--
-- Sequences for table PAYPAL_IPN_ORDERS
--

SELECT SETVAL('paypal_ipn_orders_paypal_ipn',(select case when max(paypal_ipn_orders_id)>0 then max(paypal_ipn_orders_id)+1 else 1 end from paypal_ipn_orders));

--
-- Sequences for table ORDERS_PRODUCTS_DOWNLOAD
--

SELECT SETVAL('orders_products_download_ord',(select case when max(orders_products_download_id)>0 then max(orders_products_download_id)+1 else 1 end from orders_products_download));

--
-- Sequences for table CATEGORIES
--

SELECT SETVAL('categories_categories_id_seq',(select case when max(categories_id)>0 then max(categories_id)+1 else 1 end from categories));

--
-- Sequences for table CUSTOMERS_BASKET
--

SELECT SETVAL('customers_basket_customers_b',(select case when max(customers_basket_id)>0 then max(customers_basket_id)+1 else 1 end from customers_basket));

--
-- Sequences for table LAYOUT_BOXES
--

SELECT SETVAL('layout_boxes_layout_id_seq',(select case when max(layout_id)>0 then max(layout_id)+1 else 1 end from layout_boxes));

--
-- Sequences for table TAX_CLASS
--

SELECT SETVAL('tax_class_tax_class_id_seq',(select case when max(tax_class_id)>0 then max(tax_class_id)+1 else 1 end from tax_class));

--
-- Sequences for table PHPBB_CATEGORIES
--

SELECT SETVAL('phpbb_categories_cat_id_seq',(select case when max(cat_id)>0 then max(cat_id)+1 else 1 end from phpbb_categories));

--
-- Sequences for table COUPONS
--

SELECT SETVAL('coupons_coupon_id_seq',(select case when max(coupon_id)>0 then max(coupon_id)+1 else 1 end from coupons));

--
-- Sequences for table FILES_UPLOADED
--

SELECT SETVAL('files_uploaded_files_uploade',(select case when max(files_uploaded_id)>0 then max(files_uploaded_id)+1 else 1 end from files_uploaded));

--
-- Sequences for table ORDERS_STATUS_HISTORY
--

SELECT SETVAL('orders_status_history_orders',(select case when max(orders_status_history_id)>0 then max(orders_status_history_id)+1 else 1 end from orders_status_history));

--
-- Sequences for table PRODUCT_TYPES
--

SELECT SETVAL('product_types_type_id_seq',(select case when max(type_id)>0 then max(type_id)+1 else 1 end from product_types));

--
-- Sequences for table ZONES
--

SELECT SETVAL('zones_zone_id_seq',(select case when max(zone_id)>0 then max(zone_id)+1 else 1 end from zones));

--
-- Sequences for table PAYPAL_IPN_PAYMENT_STATUS
--

SELECT SETVAL('paypal_ipn_payment_status_pa',(select case when max(payment_status_id)>0 then max(payment_status_id)+1 else 1 end from paypal_ipn_payment_status));

--
-- Sequences for table COUNTRIES
--

SELECT SETVAL('countries_countries_id_seq',(select case when max(countries_id)>0 then max(countries_id)+1 else 1 end from countries));

--
-- Sequences for table ADMIN
--

SELECT SETVAL('admin_admin_id_seq',(select case when max(admin_id)>0 then max(admin_id)+1 else 1 end from admin));

--
-- Sequences for table SALEMAKER_SALES
--

SELECT SETVAL('salemaker_sales_sale_id_seq',(select case when max(sale_id)>0 then max(sale_id)+1 else 1 end from salemaker_sales));

--
-- Sequences for table PHPBB_WORDS
--

SELECT SETVAL('phpbb_words_word_id_seq',(select case when max(word_id)>0 then max(word_id)+1 else 1 end from phpbb_words));

--
-- Sequences for table BANNERS
--

SELECT SETVAL('banners_banners_id_seq',(select case when max(banners_id)>0 then max(banners_id)+1 else 1 end from banners));

--
-- Sequences for table PAYPAL_IPN_ORDERS_MEMO
--

SELECT SETVAL('paypal_ipn_orders_memo_order',(select case when max(orders_memo_id)>0 then max(orders_memo_id)+1 else 1 end from paypal_ipn_orders_memo));

--
-- Sequences for table ORDERS_PRODUCTS
--

SELECT SETVAL('orders_products_orders_produ',(select case when max(orders_products_id)>0 then max(orders_products_id)+1 else 1 end from orders_products));

--
-- Sequences for table ZONES_TO_GEO_ZONES
--

SELECT SETVAL('zones_to_geo_zones_associati',(select case when max(association_id)>0 then max(association_id)+1 else 1 end from zones_to_geo_zones));

--
-- Sequences for table COUPON_GV_QUEUE
--

SELECT SETVAL('coupon_gv_queue_unique_id_se',(select case when max(unique_id)>0 then max(unique_id)+1 else 1 end from coupon_gv_queue));

--
-- Sequences for table TEMPLATE_SELECT
--

SELECT SETVAL('template_select_template_id_',(select case when max(template_id)>0 then max(template_id)+1 else 1 end from template_select));

--
-- Sequences for table PAYPAL_IPN_PAYMENT_TYPE
--

SELECT SETVAL('paypal_ipn_payment_type_paym',(select case when max(payment_type_id)>0 then max(payment_type_id)+1 else 1 end from paypal_ipn_payment_type));

--
-- Sequences for table NEWSLETTERS
--

SELECT SETVAL('newsletters_newsletters_id_s',(select case when max(newsletters_id)>0 then max(newsletters_id)+1 else 1 end from newsletters));

--
-- Sequences for table PHPBB_GROUPS
--

SELECT SETVAL('phpbb_groups_group_id_seq',(select case when max(group_id)>0 then max(group_id)+1 else 1 end from phpbb_groups));

--
-- Sequences for table PAYPAL_IPN_ADDRESS_STATUS
--

SELECT SETVAL('paypal_ipn_address_status_ad',(select case when max(address_status_id)>0 then max(address_status_id)+1 else 1 end from paypal_ipn_address_status));

--
-- Sequences for table CONFIGURATION_GROUP
--

SELECT SETVAL('configuration_group_configur',(select case when max(configuration_group_id)>0 then max(configuration_group_id)+1 else 1 end from configuration_group));

--
-- Sequences for table PRODUCTS_DESCRIPTION
--

SELECT SETVAL('products_description_product',(select case when max(products_id)>0 then max(products_id)+1 else 1 end from products_description));

--
-- Sequences for table LANGUAGES
--

SELECT SETVAL('languages_languages_id_seq',(select case when max(languages_id)>0 then max(languages_id)+1 else 1 end from languages));

--
-- Sequences for table PAYPAL_IPN_MC_CURRENCY
--

SELECT SETVAL('paypal_ipn_mc_currency_mc_cu',(select case when max(mc_currency_id)>0 then max(mc_currency_id)+1 else 1 end from paypal_ipn_mc_currency));

--
-- Sequences for table PHPBB_POSTS
--

SELECT SETVAL('phpbb_posts_post_id_seq',(select case when max(post_id)>0 then max(post_id)+1 else 1 end from phpbb_posts));

--
-- Sequences for table PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS
--

SELECT SETVAL('products_options_values_to_p',(select case when max(products_options_values_to_products_options_id)>0 then max(products_options_values_to_products_options_id)+1 else 1 end from products_options_values_to_products_options));

--
-- Sequences for table SPECIALS
--

SELECT SETVAL('specials_specials_id_seq',(select case when max(specials_id)>0 then max(specials_id)+1 else 1 end from specials));

--
-- Sequences for table CURRENCIES
--

SELECT SETVAL('currencies_currencies_id_seq',(select case when max(currencies_id)>0 then max(currencies_id)+1 else 1 end from currencies));

--
-- Sequences for table TAX_RATES
--

SELECT SETVAL('tax_rates_tax_rates_id_seq',(select case when max(tax_rates_id)>0 then max(tax_rates_id)+1 else 1 end from tax_rates));

--
-- Sequences for table COUPON_EMAIL_TRACK
--

SELECT SETVAL('coupon_email_track_unique_id',(select case when max(unique_id)>0 then max(unique_id)+1 else 1 end from coupon_email_track));

--
-- Sequences for table COUPON_REDEEM_TRACK
--

SELECT SETVAL('coupon_redeem_track_unique_i',(select case when max(unique_id)>0 then max(unique_id)+1 else 1 end from coupon_redeem_track));

--
-- Sequences for table PHPBB_TOPICS
--

SELECT SETVAL('phpbb_topics_topic_id_seq',(select case when max(topic_id)>0 then max(topic_id)+1 else 1 end from phpbb_topics));


-- Function definitions first
create function to_days(timestamp) returns integer as '
select date_part('day', $1 -'0000-01-01')::int4 as result
' language 'sql';
create function to_days(timestamp with time zone) returns integer as '
select date_part('day', $1 -'0000-01-01')::int4 as result
' language 'sql';
create function if(boolean, numeric, numeric) returns numeric as '
SELECT CASE WHEN $1 THEN  $2 ELSE $3 END
' language 'sql';
-- End of function definitions
