<?php
/**
@breif 󥿥Ƹѥե饹
*/

define("CONTACT_TEXTFIELD_MAXSIZE",50);

class ContactEditForm extends AbstractContactTokenEditForm
{
	var $name_ =null;
	var $kana_ =null;
	var $email_ =null;
	var $zip_ =null;
	var $location_ = null;
	var $phone_ = null;
	var $body_ =null;
	var $generation_ =null;
	var $question1_ =null;
	var $question2_ =null;
	
	var $ts_;
	
	function ContactEditForm()
	{
		parent::AbstractContactTokenEditForm();
		$this->ts_ = MyTextSanitizer::getInstance();
	}
	// XML-RPC ˤ͹ֹ椫齻ؤѴ
	function zip2addr($zipcode)
	{
		global $IXR_client;
		if (!$IXR_client->query('zipaddr.zip2add',$zipcode)) {
		   die('An error occurred - '.$IXR_client->getErrorCode().":".$IXR_client->getErrorMessage());
		}
		return $IXR_client->getResponse();
	}
	function fetch(&$xoopsUser)
	{
		parent::fetch($xoopsUser);

		$this->name_ = $this->_check_string_maxsize('name',CONTACT_TEXTFIELD_MAXSIZE,_ZA_NAME);
		//$this->kana_ = $this->_check_string_maxsize('kana',CONTACT_TEXTFIELD_MAXSIZE,_ZA_KANA);
		$this->zip_ = $this->_check_string_maxsize('zip',CONTACT_TEXTFIELD_MAXSIZE,_ZA_ZIP);
		$this->location_ = $this->_check_string_maxsize('location',CONTACT_TEXTFIELD_MAXSIZE,_ZA_LOCATION);
		$this->phone_ = $this->_check_string_maxsize('phone',CONTACT_TEXTFIELD_MAXSIZE,_ZA_PHONE);
		$this->email_ = $this->_check_string_maxsize('email',CONTACT_TEXTFIELD_MAXSIZE,_ZA_EMAIL);
		$this->body_ = isset($_POST['body']) ? strip_tags($_POST['body']): NULL;
		$this->generation_ = $this->_check_string_maxsize('YourGeneration',CONTACT_TEXTFIELD_MAXSIZE,_ZA_GENERATION);
		$this->question1_ = $this->_check_string_maxsize('WhereDoYouKnow',CONTACT_TEXTFIELD_MAXSIZE,_ZA_QUESTION1);
		$this->question2_ = $this->_check_string_maxsize('InterestAbout',CONTACT_TEXTFIELD_MAXSIZE,_ZA_QUESTION2);
		// get location from zip code
		if (isset($_POST['zip2addr'])) {
			$this->location_ = $this->zip2addr( $this->zip_ );
			$this->addError(_ZA_INPUT_MORE_LOCATION);
		}else{
			if(!$this->name_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_NAME));
			//if(!$this->kana_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_KANA));
			if(!$this->zip_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_ZIP));
			if(!$this->location_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_LOCATION));
			if(!$this->phone_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_PHONE));
			if(!$this->email_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_EMAIL));
			if($this->phone_ && $this->_validatePhone($this->phone_)) $this->addError(_ZA_ERROR_PHONE_FORMAT);
			if($this->email_ && $this->_validateEmail($this->email_)) $this->addError(_ZA_ERROR_EMAIL_FORMAT);
			if(!$this->generation_) $this->addError(@sprintf(_ZA_ERROR_REQUIRE,_ZA_GENERATION));
		}
	}

	function load(&$xoopsUser)
	{
		parent::load($xoopsUser);

		if(is_object($xoopsUser)) {
			$this->name_ = $xoopsUser->getVar('name','E');
			$this->email_ = $xoopsUser->getVar('email','E');
			$this->location_ = $xoopsUser->getVar('user_from','E');
		}
		parent::load($xoopsUser);
	}

	function getArray()
	{
		$ret=array();
		$ret['name'] = $this->name_;
		//$ret['kana'] = $this->kana_;
		$ret['zip'] = $this->zip_;
		$ret['location'] = $this->location_;
		$ret['phone'] = $this->phone_;
		$ret['email'] = $this->email_;
		$ret['body'] = $this->body_;
		$ret['generation'] = $this->generation_;
		$ret['question1'] = $this->question1_;
		$ret['question2'] = $this->question2_;

		$ret['token_hidden'] = $this->token_->getHtml();
		
		$ret['err_msg'] = null;
		if($this->isError())
			$ret['err_msg'] = $this->getErrors();
			
		return $ret;
	}

	function _check_string_maxsize($keyname,$size,$name)
	{
		$str = $this->ts_->stripSlashesGPC(trim($_POST[$keyname]));
		if($str && !(count($str)<$size))
			$this->addError(@sprintf(_ZA_ERROR_SIZEOVER,$name,$size));
		return $str;
	}
}

?>