<?php
// $Id: pda.php,v 1.00 2009/02/17 15:45:11 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                         Zip Address Convert Module                        //
//                     Copyright (c) 2009 bluemooninc.biz                    //
//                       <http://www.bluemooninc.biz>                        //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
ini_set('error_reporting', E_ALL);
ini_set('display_errors', '1');
// ########## OUTPUT CHAR SET #############
$mobileCharset = 'Shift_JIS';
// ############## USER AGENT ##############
require_once('class/agent.php');
$agent = $_SERVER['HTTP_USER_AGENT'];
$phpfAgent = new phpfAgent($agent);
// ############### SESSION ################
ini_set('session.use_only_cookies',0);
if(isset($_POST['HTTP_REFERER'])) $_SERVER['HTTP_REFERER'] = htmlspecialchars($_POST['HTTP_REFERER'], ENT_QUOTES);
require_once('include/session.php');

$sid = isset($_GET[session_name()]) ? htmlspecialchars( $_GET[session_name()], ENT_QUOTES ) : "";
$sid = isset($_POST[session_name()]) ? htmlspecialchars( $_POST[session_name()], ENT_QUOTES ) : "";
if ($sid) session_id($sid);
checkSession( $phpfAgent->agent, $phpfAgent->subno );
// ####### XOOPS mainfile loading #########
if (!isset($mobileHeader)){
	require_once('../../mainfile.php');
	
	// إåܾ
	// add header for imode 
	if (preg_match("/^DoCoMo\/2.0.*\([^\)]+;W\d+H\d+/",$_SERVER['HTTP_USER_AGENT'],$matches)){
		header("Content-type: application/xhtml+xml; charset=" . $mobileCharset );
		$contentType = "application/xhtml+xml";
		$xmlHeader = '<?xml version="1.0" encoding="Shift_JIS"?>
	<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/2.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';
	}else{
		header("Content-type: text/html; charset=" . $mobileCharset );
		$contentType = "text/html";
		$xmlHeader = '';
	}
	echo $xmlHeader . '<html><head>';
	echo '<meta http-equiv="content-type" content="'.$contentType.'; charset='.$mobileCharset.'" />';
	echo "<title>". htmlspecialchars($xoopsConfig['sitename'])."</title></head><body>";
}
// ####### Extra CC mail address ##########
if ($xoopsModuleConfig['ext_mails']){
	$ext_mails = $xoopsConfig['adminmail'] .",". $xoopsModuleConfig['ext_mails'];
	$ContactAdminMailTo = explode(",", $ext_mails);
}else{
	$ContactAdminMailTo = $xoopsConfig['adminmail'];
}

// XML-RPC 饤֥ɤ߹
require_once "./include/IXR_Library.inc.php";

//APIΥɥ쥹򥻥å
$IXR_client =& new IXR_Client($xoopsModuleConfig['xml-rpc_server']);

require_once "./class/AbstractContactEditForm.class.php";
require_once "./class/ContactEditForm.class.php";
require_once "./class/ContactMailBuilder.class.php";

// ξǤƵŪ˽

function Filter_convert_encoding_sjis2euc($value){
    if(is_array($value)){
        return array_map('Filter_convert_encoding_sjis2euc', $value);
    }else{
        return mb_convert_encoding($value, 'EUC-JP', 'SJIS');
    }
}
if (strcmp(mb_internal_encoding() , _CHARSET)!=0){
	$_POST = Filter_convert_encoding_sjis2euc($_POST);
}

$editform = new ContactEditForm();
$ret = $editform->init($xoopsUser);

switch($ret) {
    case ZIPADDR_EDITFORM_INIT_FAIL:
    case ZIPADDR_EDITFORM_INIT_SUCCESS:
		$session_htm = '<input type="hidden" name="' . session_name() . '" value="' . session_id() . '">';
		$referer = empty( $_SERVER['HTTP_REFERER'] ) ? '' : $_SERVER['REQUEST_URI'] ;
		$referer_htm = '<input type="hidden" name="HTTP_REFERER" value="' . $referer . '" />';

		$editform->getArray();
		$body ="";
		$body .='<form method="POST" action="pda.php">'.$session_htm.$referer_htm;
		$body .=$editform->token_->getHtml();
		$body .='<h1>'._ZA_REQUESTFORM.'</h1>';
		$body .=_ZA_REQUEST_DESC.'<br /><p>';
		if ($editform->err_msg_){
			$body .='<div style="color:#ff0000;background-color:#e5ecf9;"><ul>';
			foreach ( $editform->err_msg_ as $msg){
				$body .='<li><font color=\'red\'>'.$msg.'</font></li>';
			}
			$body .='</ul></div>';
		}
		$body .='*'._ZA_NAME.'&nbsp;'._ZA_NAME_DESC;
		$body .='<br /><input type="text" name="name" size="40" maxlength="40" value="'.$editform->name_.'" />';
		//$body .='<br />*'._ZA_KANA.'&nbsp;'._ZA_KANA_DESC;
		//$body .='<br /><input type="text" name="kana" size="40" maxlength="40" value="'.$editform->kana_.'" />';
		$body .='<br />*'._ZA_ZIP.'&nbsp;'._ZA_ZIP_DESC;
		$body .='<br /><input type="text" name="zip" size="8" maxlength="8" value="'.$editform->zip_.'" />';
		$body .=' <INPUT type="submit" name="zip2addr" value="'._ZA_ZIPADDR.'.">';
		$body .='<br />*'._ZA_LOCATION.'&nbsp;'._ZA_LOCATION_DESC;
		$body .='<br /><input type="text" name="location" size="60" maxlength="80" value="'.$editform->location_.'" />';
		$body .='<br />*'._ZA_PHONE.'&nbsp;'._ZA_PHONE_DESC;
		$body .='<br /><input type="text" name="phone" size="15" maxlength="15" value="'.$editform->phone_.'" />';
		$body .='<br />*'._ZA_EMAIL.'&nbsp;'._ZA_EMAIL_DESC;
		$body .='<br /><input type="text" name="email" size="40" maxlength="80" value="'.$editform->email_.'" />';
		$body .='<br />*'._ZA_GENERATION.'&nbsp;';
		$options = preg_replace( '/"'.$editform->generation_ .'"/' , '"' . $editform->generation_ . '" selected="selected"', _ZA_GENERATION_DESC);
		$body .='<br />'.$options;
		$body .='<br />'._ZA_QUESTION1.'&nbsp;';
		$options = preg_replace( '/"'.$editform->question1_ .'"/' , '"' . $editform->question1_ . '" selected="selected"', _ZA_QUESTION1_DESC);
		$body .='<br />'.$options;
		$body .='<br />'._ZA_QUESTION2.'&nbsp;';
		$options = preg_replace( '/"'.$editform->question2_ .'"/' , '"' . $editform->question2_ . '" selected="selected"', _ZA_QUESTION2_DESC);
		$body .='<br />'.$options;
		//$body .='<br />'._ZA_COMMENTS.'&nbsp;'._ZA_COMMENTS_DESC;
		//$body .='<br /><textarea name="body" cols="40" rows="5">'.$editform->body_.'</textarea>';
		$body .='<br />&nbsp;';
		$body .='<br /><input type="hidden" name="charset" value="'.$mobileCharset.'" />';
		if (isset($_POST['confirm']) && !$editform->err_msg_)
			$body .='<br /><input type="submit" name="sendmail" value="'._ZA_SUBMIT.'">';
		else
			$body .='<br /><input type="submit" name="confirm" value="'._ZA_CONFIRM.'">';
		$body .='<br /></form></body></html>';
		echo mb_convert_encoding($body, $mobileCharset,'EUC-JP');
		break;
	case ZIPADDR_EDITFORM_PERFORM_SUCCESS:
    	// 
    	$builder = new ContactAdminMailBuilder();
		$mail=&$builder->createMail();
		$builder->writeMail($mail,$editform);
    	$mail->send(true);
    
    	$message = @sprintf(_ZA_MESSAGESENT,$xoopsConfig['sitename'])."<br/>"._ZA_THANKYOU;
    	
    	// 桼ˤϥȥȤϤ
    	$builder = new ContactUserMailBuilder();
		$mail=&$builder->createMail();
		$builder->writeMail($mail,$editform);
    	$mail->send(true);
    
    	$message .= @sprintf(_ZA_SENTASCONFIRM,$editform->email_);
    
    	echo mb_convert_encoding($message, $mobileCharset,'EUC-JP');

    	break;
}
?>