// diff_offset.c
// $Id: diff_offset.c,v 1.2 2007/07/13 06:51:18 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>

#include "almemsys.h"
#include "difference.h"



char * diff_offset(char * difference_data, char * old, char * new, int * ret, int len)
{
char * swap_data;
int count, count2, count3, count4;
int old_count, new_count;
private_data_diff *pd;

// バッファーのセット
* ret = 0;
count = 0, count2 = 0, count3 = 0, count4 = 0;

if((swap_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((pd = (private_data_diff *)malloc(sizeof(private_data_diff)))==NULL){exit(1);}


// 旧ファイルを一次元バッファから2次元バッファに書き換え
old_count = char_count(old, '\n');
diff_private_malloc_set_old(pd, old_count);
pd->old_data = data_aray(pd->old_data, old, old_count);


// 新ファイルを一次元バッファから2次元バッファに書き換え
new_count = char_count(new, '\n');
diff_private_malloc_set_new(pd, new_count);
pd->new_data = data_aray(pd->new_data, new, new_count);



// 比較ブロック
#ifdef OFF_DEBUG_1
printf("---比較 leng=%d leng=%d\n", new_count, old_count);
#endif

for(count = 0; count < new_count; count++){               // new
   for(count2 = count3; count2 < old_count; count2++){    // old

      // old == new が等しい場合
      if(0 == self_memcmp(pd->old_data[count2], pd->new_data[count])){
         count4 = (count2 - count3) - 1;
         for(; count4 > 0; count4--){
            #ifdef OFF_DEBUG_1
            // 削除行
            printf("Del( - )  old=%3d, new=%3d old=%s, new=%s\n",
               (count2 - count4), count, pd->old_data[(count2 - count4)], pd->new_data[count]);
            #endif

            #ifdef OFF_DEBUG_2
            printf("- %d %s\n", (count2 - count4), pd->old_data[(count2 - count4)]);
            #endif

            // Difference 値をバッファーに入力(-)
            swap_data = safe_sprintf(swap_data, MAX_BUFF_COUNT,"- %d\n", (count2 - count4));
            difference_data = safe_strncat(difference_data, swap_data, MAX_BUFF_COUNT);
            }
         count4 = 0;
         #ifdef OFF_DEBUG_1
         // 変更なし行 
         printf("Sam( = )  old=%3d new=%3d  old=%s new=%s\n",
            count2, count, pd->old_data[count2], pd->new_data[count]);
         #endif

         #ifdef OFF_DEBUG_2
         printf("= %d %s\n", count2, pd->old_data[count2]);
         #endif

         // Difference 値をバッファーに入力(=)
         if(count2 < (old_count - 1)){
            swap_data = safe_sprintf(swap_data, MAX_BUFF_COUNT,"= %d\n", count2);
            difference_data = safe_strncat(difference_data, swap_data, MAX_BUFF_COUNT);
            }
         count3 = count2 + 1;
         break;
         }


      // old　に new が存在しなかった場合は新規
      else if(count2 == (old_count - 1)){
         #ifdef OFF_DEBUG_1
         // 新規行
         printf("New( + )  old=%3d new=%3d old=%s new=%s\n",
            count2, count, pd->old_data[count2], pd->new_data[count]);
         #endif

         #ifdef OFF_DEBUG_2
         printf("+ %d %s\n", count, pd->new_data[count]);
         #endif

         // Difference 値をバッファーに入力(+)
         swap_data = safe_sprintf(swap_data, MAX_BUFF_COUNT,"+ %d %s\n",
           count, pd->new_data[count]);
         difference_data = safe_strncat(difference_data, swap_data, MAX_BUFF_COUNT);
         }
      else{
         }

      } // old

   } // new


// バッファーの開放
free(swap_data);
diff_private_malloc_free_old(pd, old_count);
diff_private_malloc_free_new(pd, new_count);
free(pd);

return difference_data;
}






