// diff_onset.c
// $Id: diff_onset.c,v 1.2 2007/07/13 06:51:29 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>

#include "almemsys.h"
#include "difference.h"



char * diff_onset(char * return_data, char * difference_data, char * data, int * ret, int len)
{
int count, old_len, new_len, math, num, splen, pointlen, inret;
char * plus_data;
char * swap_data;
private_data_diff *pd;

// バッファーのセット
* ret = 0;
count = 0, old_len = 0, new_len = 0, math = 0, num = 0, splen = 0, pointlen = 0, inret = 0;

if((plus_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((swap_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((pd = (private_data_diff *)malloc(sizeof(private_data_diff)))==NULL){exit(1);}


// 旧ファイルを一次元バッファから2次元バッファに書き換え
old_len = char_count(data, '\n');
diff_private_malloc_set_old(pd, old_len);
pd->old_data = data_aray(pd->old_data, data, old_len);



// 0x01が含まれないことを確認
if(char_count(difference_data, (char)0x01)){
   diff_private_malloc_free_old(pd, old_len);
   free(plus_data);
   free(swap_data);
   free(pd);
   return_data = safe_memcpy(return_data, "\n", MAX_BUFF_COUNT);
   return(return_data);
   }


// 差分データを小分け、配列に入れる
new_len = char_count(difference_data, '\n');
diff_private_malloc_set_new(pd, new_len);

for(count = 0; count < new_len; count++){
   swap_data = delim_get(difference_data, swap_data, '\n', &inret, count);

   splen = char_count(swap_data, ' ');
   if(splen == 1){
      pointlen = char_point(swap_data, ' ', 1);
      swap_data[pointlen] = (char)0x01;
      }
   else if(splen > 1){
      pointlen = char_point(swap_data, ' ', 1);
      swap_data[pointlen] = (char)0x01;
      pointlen = char_point(swap_data, ' ', 1);
      swap_data[pointlen] = (char)0x01;
      }
   else{
      swap_data = safe_memcpy(swap_data,"\n", MAX_BUFF_COUNT);
      }

   #ifdef ON_DEBUG_1
   printf("=%d=====%s\n", pointlen, swap_data);
   #endif

   plus_data = safe_memcpy(plus_data, "\n", BUF_MAX);
   plus_data = delim_get(swap_data, plus_data, (char)0x01, &inret, 0);

   if     (0 == self_memcmp(plus_data, "+")){ math = 1; }
   else if(0 == self_memcmp(plus_data, "-")){ math = 0; }
   else if(0 == self_memcmp(plus_data, "=")){ math = 2; }
   else{ math = 0; }

   plus_data = safe_memcpy(plus_data, "\n", BUF_MAX);
   plus_data = delim_get(swap_data, plus_data, (char)0x01, &inret, 1);

   num = strtol(plus_data, (char **)NULL, 10);

   if(math == 1){
      plus_data = safe_memcpy(plus_data, "\n", BUF_MAX);
      plus_data = delim_get(swap_data, plus_data, (char)0x01, &inret, 2);
      }

   pd->math[count] = math;
   math = 0;
   pd->num[count] = num;
   num = 0;
   pd->new_data[count] = safe_memcpy(pd->new_data[count], plus_data, MAX_BUFF_COUNT);

   #ifdef ON_DEBUG_1
   printf("math=%d num=%d data=%s\n", pd->math[count], pd->num[count], pd->new_data[count]);
   #endif
   }


//  差分をマージし戻りバッファに書き込む
return_data = safe_sprintf(return_data, MAX_BUFF_COUNT, "%c%c", (char)0x00, (char)0x00);
 
for(count = 0; count < new_len; count++){
   if(pd->math[count] == 1){
      #ifdef ON_DEBUG_1
      printf("---(+)---c=%d oc=%d nd=%s od=%s\n",
        count, pd->num[count], pd->new_data[count], pd->old_data[pd->num[count]]);
      #endif
      return_data = safe_strncat(return_data, pd->new_data[count], MAX_BUFF_COUNT);
      return_data = safe_strncat(return_data, "\n", MAX_BUFF_COUNT);
      }
   else if(pd->math[count] == 0){
      #ifdef ON_DEBUG_1
      printf("---(-)---c=%d oc=%d nd=%s od=%s\n",
        count, pd->num[count], pd->new_data[count], pd->old_data[pd->num[count]]);
      #endif
      }
   else if(pd->math[count] == 2){
      #ifdef ON_DEBUG_1
      printf("---(=)---c=%d oc=%d nd=%s od=%s\n",
        count, pd->num[count], pd->new_data[count], pd->old_data[pd->num[count]]);
      #endif
      return_data = safe_strncat(return_data, pd->old_data[pd->num[count]],MAX_BUFF_COUNT);
      return_data = safe_strncat(return_data, "\n", MAX_BUFF_COUNT);

      }
   else{
      #ifdef ON_DEBUG_1
      printf("=(other)=\n");
      #endif
      }

   }



// バッファーの開放
diff_private_malloc_free_new(pd, new_len);
diff_private_malloc_free_old(pd, old_len);

free(plus_data);
free(swap_data);
free(pd);

return(return_data);
}




