// diff_uncomp.c
// $Id: diff_uncomp.c,v 1.2 2007/07/13 06:51:39 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>

#include "almemsys.h"
#include "difference.h"



char * diff_uncomp(char * difference_data)
{
int count, new_len, math, num, num2, splen, pointlen, inret, num_count;
char * plus_data;
char * swap_data;
private_data_diff *pd;

// バッファーのセット
count = 0, new_len = 0, math = 0, num = 0, num2 = 0, splen = 0, pointlen = 0, inret = 0;

if((plus_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((swap_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((pd = (private_data_diff *)malloc(sizeof(private_data_diff)))==NULL){exit(1);}


// 0x01が含まれないことを確認
if(char_count(difference_data, (char)0x01)){
   free(plus_data);
   free(swap_data);
   free(pd);
   difference_data = safe_memcpy(difference_data, "\n", MAX_BUFF_COUNT);
   return(difference_data);
   }


// 差分データを小分け、配列に入れる
new_len = char_count(difference_data, '\n');
diff_private_malloc_set_new(pd, new_len);

for(count = 0; count < new_len; count++){
   swap_data = delim_get(difference_data, swap_data, '\n', &inret, count);

   splen = char_count(swap_data, ' ');
   if(splen == 1){
      pointlen = char_point(swap_data, ' ', 1);
      swap_data[pointlen] = (char)0x01;
      }
   else if(splen > 1){
      pointlen = char_point(swap_data, ' ', 1);
      swap_data[pointlen] = (char)0x01;
      pointlen = char_point(swap_data, ' ', 1);
      swap_data[pointlen] = (char)0x01;
      }
   else{
      swap_data = safe_memcpy(swap_data,"\n", MAX_BUFF_COUNT);
      }

   #ifdef COMP_DEBUG_1
   printf("=%d=====%s\n", pointlen, swap_data);
   #endif

   plus_data = safe_memcpy(plus_data, "\n", BUF_MAX);
   plus_data = delim_get(swap_data, plus_data, (char)0x01, &inret, 0);

   if     (0 == self_memcmp(plus_data, "+")){ math = 1; }
   else if(0 == self_memcmp(plus_data, "-")){ math = 0; }
   else if(0 == self_memcmp(plus_data, "=")){ math = 2; }
   else{ math = 0; }

   plus_data = safe_memcpy(plus_data, "\n", BUF_MAX);
   plus_data = delim_get(swap_data, plus_data, (char)0x01, &inret, 1);

   num = strtol(plus_data, (char **)NULL, 10);

   plus_data = safe_memcpy(plus_data, "\n", BUF_MAX);
   plus_data = delim_get(swap_data, plus_data, (char)0x01, &inret, 2);

   if(math == 0 || math == 2){
      num2 = strtol(plus_data, (char **)NULL, 10);
      }

   pd->math[count] = math;
   math = 0;
   pd->num[count] = num;
   num = 0;
   pd->num2[count] = num2;
   num2 = 0;
   pd->new_data[count] = safe_memcpy(pd->new_data[count], plus_data, MAX_BUFF_COUNT);
   plus_data = safe_memcpy(plus_data, "\n", MAX_BUFF_COUNT);

   #ifdef COMP_DEBUG_1
   printf("math=%d num=%d num2=%d data=%s\n",
      pd->math[count], pd->num[count], pd->num2[count], pd->new_data[count]);
   #endif
   }


// 圧縮データを展開 

difference_data = safe_sprintf(difference_data, MAX_BUFF_COUNT, "%c%c", (char)0x00, (char)0x00);
 
for(count = 0; count < (new_len - 1); count++){

   // (+) section
   if(pd->math[count] == 1){
      #ifdef COMP_DEBUG_1
      printf("=(+)==%d=%s\n", count, pd->new_data[count]);
      #endif
      swap_data = safe_sprintf(swap_data, MAX_BUFF_COUNT,"+ %d %s\n",
         pd->num[count], pd->new_data[count]);
      difference_data = safe_strncat(difference_data, swap_data, MAX_BUFF_COUNT);
      }

   // (-) section
   else if(pd->math[count] == 0){
      #ifdef COMP_DEBUG_1
      printf("=(-)==%d=\n", count);
      #endif
      for(num_count = pd->num[count]; num_count <= pd->num2[count]; num_count++){
         swap_data = safe_sprintf(swap_data, MAX_BUFF_COUNT,"- %d\n", num_count);
         difference_data = safe_strncat(difference_data, swap_data, MAX_BUFF_COUNT);
         }
      }

   // (=) section
   else if(pd->math[count] == 2){
      #ifdef ON_DEBUG_1
      printf("=(=)==%d=%s\n", count, pd->old_data[pd->num[count]]);
      #endif
      for(num_count = pd->num[count]; num_count <= pd->num2[count]; num_count++){
         swap_data = safe_sprintf(swap_data, MAX_BUFF_COUNT,"= %d\n", num_count);
         difference_data = safe_strncat(difference_data, swap_data, MAX_BUFF_COUNT);
         }
      }

   // (other) section
   else{
      #ifdef ON_DEBUG_1
      printf("=(other)=\n");
      #endif
      }

   }


// バッファーの開放
diff_private_malloc_free_new(pd, new_len);

free(plus_data);
free(swap_data);
free(pd);

return(difference_data);
}




