// difference_off.c
// $Id: difference_off.c,v 1.1.1.1 2007/06/26 07:58:40 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<stdlib.h>

#include "almemsys.h"
#include "difference.h"



char * difference_off(char * difference_data, char * old_filename, char * new_filename, int * ret, int len)
{
int old_stat, new_stat, old_count, new_count, count, top_count;
FILE * fp_new;
FILE * fp_old;
char * swap_data;
char * old_data;
char * new_data;

// バッファーのセット
* ret = 0;

if((swap_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((old_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}
if((new_data = (char *)calloc(2, sizeof(char)))==NULL){exit(1);}

old_stat = 0; old_count = 0; new_stat = 0; new_count = 0, top_count = 0, count = 0;



// 編集前ファイルをバッファーに入れる (OLD)
if((fp_old = fopen(old_filename, "r"))!=NULL){
   #ifdef OFF_DEBUG_1
   fprintf(stderr,"difference_off(1): open old filename <%s>:\n", old_filename);
   #endif
   for(old_count = 0; old_count < len && old_stat > -1; old_count++){
      swap_data = safe_fpcat(fp_old, swap_data, &old_stat, MAX_BUFF_COUNT);
      old_data = safe_strncat(old_data, swap_data, MAX_BUFF_COUNT);
      old_data = safe_strncat(old_data, "\n", MAX_BUFF_COUNT);
      }
   fclose(fp_old);
   old_count = old_count - 1;
   }
else{
   #ifdef OFF_DEBUG_1
   fprintf(stderr,"difference_off(2): old filename not open. <%s>:\n", old_filename);
   #endif
   free(swap_data);
   free(old_data);
   free(new_data);
   * ret = - 1;
   return difference_data;
   }


// 編集後ファイルをバッファーに入れる (NEW)
if((fp_new = fopen(new_filename, "r"))!=NULL){
   #ifdef OFF_DEBUG_1
   fprintf(stderr,"difference_off(3): open new filename <%s>:\n", new_filename);
   #endif
   for(new_count = 0; new_count < len && new_stat > -1; new_count++){
      swap_data = safe_fpcat(fp_new, swap_data, &new_stat, MAX_BUFF_COUNT);
      new_data = safe_strncat(new_data, swap_data, MAX_BUFF_COUNT);
      new_data = safe_strncat(new_data, "\n", MAX_BUFF_COUNT);
      }
   fclose(fp_new);
   new_count = new_count - 1;
   }
else{
   #ifdef OFF_DEBUG_1
   fprintf(stderr,"difference_off(4): new filename not open. <%s>:\n", new_filename);
   #endif
   free(old_data);
   free(new_data);
   free(swap_data);
   * ret = - 1;
   return difference_data;
   }


// 旧、新データの差分を抽出
difference_data = diff_offset(difference_data, old_data, new_data, ret, len);
// 差分データを圧縮

//printf("==%s==\n", difference_data);


difference_data = diff_comp(difference_data);

// バッファーの開放
free(old_data);
free(new_data);
free(swap_data);

return difference_data;
}






